/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.ui;

import com.sun.swup.client.ui.Application;
import com.sun.swup.client.ui.foundation.swing.GenericActionSet;
import com.sun.swup.client.ui.foundation.swing.GenericFrame;
import com.sun.swup.client.ui.foundation.swing.GenericMenuBar;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.text.JTextComponent;

final class MenuBarBuilder {
    private static MenuBarBuilder menuBarBuilder;

    private MenuBarBuilder() {
    }

    static MenuBarBuilder getInstance() {
        if (menuBarBuilder == null) {
            menuBarBuilder = new MenuBarBuilder();
        }
        return menuBarBuilder;
    }

    JMenuBar createMenuBar(GenericActionSet actionSet) {
        GenericMenuBar menuBar = new GenericMenuBar();
        menuBar.add(this.buildFileMenu(menuBar, actionSet));
        menuBar.add(this.buildEditMenu(menuBar, actionSet));
        menuBar.add(this.buildHelpMenu(menuBar, actionSet));
        return menuBar;
    }

    private JMenu buildFileMenu(GenericMenuBar menuBar, GenericActionSet actionSet) {
        JMenu menu = new JMenu(Application.I18N.getString("menu-file"));
        menu.setMnemonic(Application.I18N.getString("menu-file.mnemonic").charAt(0));
        menu.add(this.createMenuItem("subscription", menuBar, actionSet));
        menu.add(new JSeparator());
        menu.add(this.createMenuItem("enable-portal", menuBar, actionSet));
        menu.add(new JSeparator());
        menu.add(this.createMenuItem("preferences", menuBar, actionSet));
        menu.add(new JSeparator());
        menu.add(this.createMenuItem("quit", menuBar, actionSet));
        return menu;
    }

    private JMenu buildEditMenu(GenericMenuBar menuBar, GenericActionSet actionSet) {
        JMenu menu = new JMenu(Application.I18N.getString("menu-edit"));
        menu.addMenuListener(new EditMenuListener());
        menu.setMnemonic(Application.I18N.getString("menu-edit.mnemonic").charAt(0));
        menu.add(this.createMenuItem("cut-to-clipboard", menuBar, actionSet));
        menu.add(this.createMenuItem("copy-to-clipboard", menuBar, actionSet));
        menu.add(this.createMenuItem("paste-from-clipboard", menuBar, actionSet));
        menu.add(this.createMenuItem("select-all", menuBar, actionSet));
        return menu;
    }

    private JMenu buildHelpMenu(GenericMenuBar menuBar, GenericActionSet actionSet) {
        JMenu menu = new JMenu(Application.I18N.getString("menu-help"));
        menu.setMnemonic(Application.I18N.getString("menu-help.mnemonic").charAt(0));
        menu.add(this.createMenuItem("about", menuBar, actionSet));
        return menu;
    }

    private JMenuItem createMenuItem(String sKey, GenericMenuBar menuBar, GenericActionSet actionSet) {
        JMenuItem menuItem = new JMenuItem(actionSet.getAction(sKey));
        menuBar.putMenuItem(sKey, menuItem);
        return menuItem;
    }

    class EditMenuListener
    implements MenuListener {
        EditMenuListener() {
        }

        public void menuSelected(MenuEvent e) {
            Component c = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (c instanceof JComponent) {
                JComponent component = (JComponent)c;
                ActionMap actionMap = component.getActionMap();
                Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
                if (window instanceof GenericFrame) {
                    GenericFrame frame = (GenericFrame)window;
                    GenericActionSet actionSet = frame.getActionSet();
                    if (frame.getJMenuBar() instanceof GenericMenuBar) {
                        GenericMenuBar menuBar = (GenericMenuBar)frame.getJMenuBar();
                        if (component instanceof JTextComponent) {
                            menuBar.getMenuItem("cut-to-clipboard").setAction(this.getTextAction(actionMap, "cut-to-clipboard"));
                            menuBar.getMenuItem("copy-to-clipboard").setAction(this.getTextAction(actionMap, "copy-to-clipboard"));
                            menuBar.getMenuItem("paste-from-clipboard").setAction(this.getTextAction(actionMap, "paste-from-clipboard"));
                            menuBar.getMenuItem("select-all").setAction(this.getTextAction(actionMap, "select-all"));
                        }
                    }
                }
            }
        }

        private Action getTextAction(ActionMap actionMap, String sKey) {
            Action action = actionMap.get(sKey);
            if (sKey.equals("cut-to-clipboard")) {
                action.putValue("Name", Application.I18N.getString("menu-edit-cut"));
                String sAccelerator = Application.I18N.getString("menu-edit-cut.accelerator");
                action.putValue("AcceleratorKey", KeyStroke.getKeyStroke((int)sAccelerator.charAt(0), Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            } else if (sKey.equals("copy-to-clipboard")) {
                action.putValue("Name", Application.I18N.getString("menu-edit-copy"));
                String sAccelerator = Application.I18N.getString("menu-edit-copy.accelerator");
                action.putValue("AcceleratorKey", KeyStroke.getKeyStroke((int)sAccelerator.charAt(0), Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            } else if (sKey.equals("paste-from-clipboard")) {
                action.putValue("Name", Application.I18N.getString("menu-edit-paste"));
                String sAccelerator = Application.I18N.getString("menu-edit-paste.accelerator");
                action.putValue("AcceleratorKey", KeyStroke.getKeyStroke((int)sAccelerator.charAt(0), Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            } else if (sKey.equals("select-all")) {
                action.putValue("Name", Application.I18N.getString("menu-edit-select-all"));
                String sAccelerator = Application.I18N.getString("menu-edit-select-all.accelerator");
                action.putValue("AcceleratorKey", KeyStroke.getKeyStroke((int)sAccelerator.charAt(0), Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            }
            return action;
        }

        public void menuDeselected(MenuEvent e) {
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ EditMenuListener this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
                    if (window instanceof GenericFrame) {
                        GenericFrame frame = (GenericFrame)window;
                        GenericActionSet actionSet = frame.getActionSet();
                        if (frame.getJMenuBar() instanceof GenericMenuBar) {
                            GenericMenuBar menuBar = (GenericMenuBar)frame.getJMenuBar();
                            menuBar.getMenuItem("cut-to-clipboard").setAction(actionSet.getAction("cut-to-clipboard"));
                            menuBar.getMenuItem("copy-to-clipboard").setAction(actionSet.getAction("copy-to-clipboard"));
                            menuBar.getMenuItem("paste-from-clipboard").setAction(actionSet.getAction("paste-from-clipboard"));
                            menuBar.getMenuItem("select-all").setAction(actionSet.getAction("select-all"));
                        }
                    }
                }
            });
        }

        public void menuCanceled(MenuEvent e) {
        }
    }
}

