/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.ui;

import com.sun.cns.authentication.CMDExecutionException;
import com.sun.cns.authentication.NotAuthenticatedException;
import com.sun.cns.basicreg.BasicReg;
import com.sun.cns.basicreg.common.RegistrationListener;
import com.sun.swup.client.common.CCRUtils;
import com.sun.swup.client.common.NAUtils;
import com.sun.swup.client.common.UMData;
import com.sun.swup.client.common.UpdateMgrUtil;
import com.sun.swup.client.ui.Application;
import com.sun.swup.client.ui.AuthenticationManager;
import com.sun.swup.client.ui.AvailablePanel;
import com.sun.swup.client.ui.DataController;
import com.sun.swup.client.ui.PreferencesFrame;
import com.sun.swup.client.ui.UpdateFrame;
import com.sun.swup.client.ui.Utils;
import com.sun.swup.client.ui.WarningDialog;
import com.sun.swup.client.ui.foundation.Utility;
import com.sun.swup.client.wrapper.PatchProWrapper;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;

class RegistrationManager {
    private Document document;
    int runMode = 0;

    RegistrationManager() throws ClassNotFoundException {
    }

    void displaySubscription() throws ClassNotFoundException {
        this.displayRegistration(1);
    }

    void displayEnablePortal() throws ClassNotFoundException {
        this.displayRegistration(2);
    }

    void displayRegistration() throws ClassNotFoundException {
        this.displayRegistration(0);
    }

    void displayRegistration(int runMode) throws ClassNotFoundException {
        Object completedRegistrationListener;
        this.runMode = runMode;
        Utils.debug("RegistrationManager.displayRegistration() mode: " + runMode);
        BasicReg basicReg = new BasicReg();
        if (runMode == 100) {
            runMode = 0;
            completedRegistrationListener = new RegistrationCompletedForLpsToSunListener();
        } else {
            completedRegistrationListener = new RegistrationCompletedListener();
        }
        basicReg.setRegistrationListener((RegistrationListener)completedRegistrationListener);
        UpdateFrame parentFrame = Application.getInstance().getUpdateFrame();
        basicReg.runWizard(runMode, (Frame)parentFrame, true);
    }

    void processRegistrationDocument(Document document) {
        if (document != null) {
            this.storePatchProSettings(document);
            ElementFilter elementFilter = new ElementFilter("widget");
            Iterator iterator = document.getDescendants((Filter)elementFilter);
            Preferences preferences = Preferences.userRoot().node("com/sun/swup/client/registration");
            while (iterator.hasNext()) {
                try {
                    String sText;
                    Element element = (Element)iterator.next();
                    String sID = element.getAttributeValue("id");
                    if (sID == null || (sText = element.getChildText("response")) == null) continue;
                    preferences.put(sID, sText);
                }
                catch (NullPointerException npe) {
                    npe.printStackTrace();
                }
            }
        }
    }

    private void storePatchProSettings(Document document) {
        this.document = document;
        PatchProSettingsAction action = new PatchProSettingsAction();
        ActionEvent e = new ActionEvent(this, 1001, null);
        action.actionPerformed(e);
    }

    class PatchProSettingsAction
    extends AbstractAction {
        String[] asBasicReg = new String[]{"server", "port", "proxyUser", "proxyPass", "patchURL"};
        String[] asPatchPro = new String[]{"patchpro.proxy.host", "patchpro.proxy.port", "patchpro.proxy.user", "patchpro.proxy.passwd", "patchpro.patch.source"};

        PatchProSettingsAction() {
        }

        public void actionPerformed(ActionEvent e) {
            this.storePatchProSettings();
        }

        private void storePatchProSettings() {
            if (DataController.isLiveData()) {
                PatchProWrapper wrapper = PatchProWrapper.getInstance();
                for (int i = 0; i < this.asBasicReg.length; ++i) {
                    String sValue = this.getValueFromDocument(this.asBasicReg[i]);
                    if (sValue == null || sValue.equals("")) continue;
                    try {
                        wrapper.set(this.asPatchPro[i], sValue);
                        continue;
                    }
                    catch (NotAuthenticatedException ex) {
                        AuthenticationManager.getInstance().setAction(this);
                        AuthenticationManager.getInstance().authenticate();
                        continue;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }

        private String getValueFromDocument(String sString) {
            ElementFilter elementFilter = new ElementFilter("widget");
            Iterator iterator = RegistrationManager.this.document.getDescendants((Filter)elementFilter);
            while (iterator.hasNext()) {
                try {
                    Element element = (Element)iterator.next();
                    String sID = element.getAttributeValue("id");
                    if (sID == null || !sID.equals(sString)) continue;
                    return element.getChildText("response");
                }
                catch (NullPointerException e) {
                    return null;
                }
            }
            return null;
        }
    }

    class RegistrationCompletedForLpsToSunListener
    implements RegistrationListener {
        RegistrationCompletedForLpsToSunListener() {
        }

        public void registrationCompleted(Document document) {
            boolean isSystemRegistered;
            UMData.setLpsToSunBR((int)-1);
            String assetId = CCRUtils.getCCRValue((String)"cns.assetid");
            boolean bl = isSystemRegistered = assetId != null && !assetId.equals("");
            if (isSystemRegistered) {
                try {
                    CCRUtils.setCCRValueAuthenticated((String)"cns.swup.regRequired", (String)"true");
                    PatchProWrapper.getInstance().unset("patchpro.patch.source");
                    Utils.debug("System registered successfully for patch source LPS to Sun.");
                    AvailablePanel aPanel = Application.getInstance().getUpdateFrame().getAvailablePanel();
                    aPanel.gatherUpdates();
                    NAUtils.copyPidFromHost2AssetidDir((boolean)false);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    throw new RuntimeException(ex);
                }
            }
            Utils.debug("System registration failed for patch source LPS to Sun revert to LPS.");
            PatchProWrapper pproWrapper = PatchProWrapper.getInstance();
            try {
                pproWrapper.set("patchpro.patch.source", UMData.getLPSValue());
            }
            catch (Throwable tr) {
                tr.printStackTrace();
                throw new RuntimeException(tr);
            }
        }
    }

    class RegistrationCompletedListener
    implements RegistrationListener {
        RegistrationCompletedListener() {
        }

        public void registrationCompleted(Document document) {
            if (CCRUtils.isSystemRegistered()) {
                SwingUtilities.invokeLater(new Runnable(this, document){
                    private final /* synthetic */ Document val$document;
                    private final /* synthetic */ RegistrationCompletedListener this$1;
                    {
                        this.this$1 = this$1;
                        this.val$document = val$document;
                    }

                    public void run() {
                        try {
                            UpdateMgrUtil.enableAutoAnalysis();
                        }
                        catch (CMDExecutionException cee) {
                            WarningDialog warnDialog = new WarningDialog((Frame)Application.getInstance().getUpdateFrame(), PreferencesFrame.I18N.getString("prefs.cron.title"), PreferencesFrame.I18N.getString("prefs.cron.enable.error"));
                            Utility.centerOverFrame(warnDialog, (JFrame)Application.getInstance().getUpdateFrame());
                            warnDialog.setVisible(true);
                            cee.printStackTrace();
                        }
                        RegistrationCompletedListener.access$000(this.this$1).processRegistrationDocument(this.val$document);
                        Application.getInstance().getUpdateFrame().setVisible(true);
                        Application.getInstance().getUpdateFrame().gatherUpdateCollections();
                    }
                });
                NAUtils.copyPidFromHost2AssetidDir((boolean)false);
            } else {
                Utils.error("System registration failed; exiting application");
                System.exit(0);
            }
        }

        static /* synthetic */ RegistrationManager access$000(RegistrationCompletedListener x0) {
            return x0.RegistrationManager.this;
        }
    }
}

