/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.ui;

import com.sun.cns.authentication.CMDExecutionException;
import com.sun.cns.authentication.CSMAuthenticator;
import com.sun.cns.authentication.NotAuthenticatedException;
import com.sun.swup.client.common.I18NHelper;
import com.sun.swup.client.common.UpdateMgrUtil;
import com.sun.swup.client.common.environment.Environment;
import com.sun.swup.client.engine.solaris.CategoryFileException;
import com.sun.swup.client.engine.solaris.CollectionFileException;
import com.sun.swup.client.engine.solaris.ReadAnalysisDataException;
import com.sun.swup.client.interfaces.Update;
import com.sun.swup.client.interfaces.UpdateCollection;
import com.sun.swup.client.ui.Application;
import com.sun.swup.client.ui.AuthenticationManager;
import com.sun.swup.client.ui.AvailableComboBoxModel;
import com.sun.swup.client.ui.AvailablePanel;
import com.sun.swup.client.ui.CommonActionSet;
import com.sun.swup.client.ui.DataController;
import com.sun.swup.client.ui.GatherDialog;
import com.sun.swup.client.ui.HistoryPanel;
import com.sun.swup.client.ui.HistoryTableModel;
import com.sun.swup.client.ui.InstalledPanel;
import com.sun.swup.client.ui.MenuBarBuilder;
import com.sun.swup.client.ui.PreferencesManager;
import com.sun.swup.client.ui.UpdateDelegate;
import com.sun.swup.client.ui.UpdatePanel;
import com.sun.swup.client.ui.WarningDialog;
import com.sun.swup.client.ui.foundation.Utility;
import com.sun.swup.client.ui.foundation.Worker;
import com.sun.swup.client.ui.foundation.WorkerEvent;
import com.sun.swup.client.ui.foundation.WorkerListener;
import com.sun.swup.client.ui.foundation.swing.GenericFrame;
import com.sun.swup.client.ui.foundation.swing.InsetPanel;
import com.sun.swup.client.ui.foundation.swing.MessageTextArea;
import com.sun.swup.client.ui.foundation.swing.StateManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;

class UpdateFrame
extends GenericFrame {
    static I18NHelper I18N = new I18NHelper(class$com$sun$swup$client$ui$UpdateFrame == null ? (class$com$sun$swup$client$ui$UpdateFrame = UpdateFrame.class$("com.sun.swup.client.ui.UpdateFrame")) : class$com$sun$swup$client$ui$UpdateFrame, "resources/strings/update");
    private UpdateDelegate updateDelegate;
    private UpdatePanel updatePanel;
    private GatherDialog gatherDialog;
    static /* synthetic */ Class class$com$sun$swup$client$ui$UpdateFrame;

    UpdateFrame() {
        this.setName("update");
        String hostname = UpdateMgrUtil.getHostName();
        if (hostname.length() > 0) {
            hostname = hostname + ": ";
        }
        this.setTitle(hostname + I18N.getString("title"));
        this.setResizable(true);
        this.setActionSet(new CommonActionSet());
        JMenuBar menuBar = MenuBarBuilder.getInstance().createMenuBar(this.getActionSet());
        this.setJMenuBar(menuBar);
        this.createComponents();
        this.createLayout();
        StateManager stateManager = Application.getInstance().getStateManager();
        stateManager.restoreWindowSize(this, Environment.getDimension((String)"safe-frame"));
        Utility.centerOverScreen(this);
        stateManager.restoreWindowLocation(this, this.getLocation());
        this.updateDelegate = new UpdateDelegate(this);
        this.addComponentListener(Application.getInstance().getStateManager());
        this.setIconImage(Environment.getImageIcon((String)"update-manager-icon.png").getImage());
    }

    public void setVisible(boolean bVisible, boolean start) {
        boolean bAlreadyVisible = this.isVisible();
        super.setVisible(bVisible);
        if (!CSMAuthenticator.getInstance().isAuthenticated() && !AuthenticationManager.getInstance().authenticate()) {
            System.exit(-1);
        }
        if (bVisible && !bAlreadyVisible && start) {
            PreferencesManager.getInstance().syncAutoAnalysisSettings();
            this.gatherUpdateCollections();
        }
    }

    public void requestToClose() {
        Action action = this.getActionSet().getAction("quit");
        ActionEvent e = new ActionEvent(this, 1001, null);
        action.actionPerformed(e);
    }

    private void applyUpdateCollection() {
        AvailablePanel availablePanel = Application.getInstance().getUpdateFrame().getAvailablePanel();
        JComboBox comboBox = availablePanel.getComboBox();
        if (comboBox.getItemCount() > 0) {
            comboBox.setSelectedItem(null);
            comboBox.setSelectedItem(comboBox.getItemAt(0));
        }
    }

    UpdatePanel getUpdatePanel() {
        return this.updatePanel;
    }

    AvailablePanel getAvailablePanel() {
        return this.getUpdatePanel().getAvailablePanel();
    }

    InstalledPanel getInstalledPanel() {
        return this.getUpdatePanel().getInstalledPanel();
    }

    HistoryPanel getHistoryPanel() {
        return this.getUpdatePanel().getHistoryPanel();
    }

    UpdateDelegate getDelegate() {
        return this.updateDelegate;
    }

    GatherDialog getGatherDialog() {
        if (this.gatherDialog == null) {
            this.gatherDialog = new GatherDialog(this);
        }
        return this.gatherDialog;
    }

    void setGatherDialog(GatherDialog gatherDialog) {
        this.gatherDialog = gatherDialog;
    }

    void gatherUpdateCollections() {
        LoadDataAction action = new LoadDataAction();
        ActionEvent e = new ActionEvent(this, 1001, null);
        action.actionPerformed(e);
    }

    private void createComponents() {
        this.updatePanel = new UpdatePanel(this);
    }

    private void createLayout() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.updatePanel, "Center");
    }

    public void showWarningDialog(Throwable throwable, JDialog dialog) {
        String title = "";
        String errorMsg = "";
        boolean errorType = false;
        I18NHelper warnI18NHelper = new I18NHelper(class$com$sun$swup$client$ui$UpdateFrame == null ? (class$com$sun$swup$client$ui$UpdateFrame = UpdateFrame.class$("com.sun.swup.client.ui.UpdateFrame")) : class$com$sun$swup$client$ui$UpdateFrame, "resources/strings/warning");
        if (throwable instanceof CollectionFileException) {
            errorMsg = ((CollectionFileException)throwable).getExceptionMessage();
            title = ((CollectionFileException)throwable).getExceptionTitle();
        } else if (throwable instanceof CategoryFileException) {
            errorMsg = ((CategoryFileException)throwable).getExceptionMessage();
            title = ((CategoryFileException)throwable).getExceptionTitle();
        } else if (throwable instanceof CMDExecutionException) {
            errorMsg = ((CMDExecutionException)throwable).getErrorMessage();
            title = "";
        } else if (throwable instanceof ReadAnalysisDataException) {
            errorMsg = ((ReadAnalysisDataException)throwable).getExceptionMessage();
            title = ((ReadAnalysisDataException)throwable).getExceptionTitle();
        } else {
            errorMsg = warnI18NHelper.getString("unknown-error");
            title = "";
            throwable.printStackTrace();
        }
        this.disposeDialog(dialog);
        this.showWarningDialog(title, errorMsg);
    }

    public void showWarningDialog(String title, String message) {
        Cursor cursor = Application.getInstance().getUpdateFrame().getCursor();
        if (cursor.getType() == 3) {
            Application.getInstance().getUpdateFrame().setCursor(Cursor.getDefaultCursor());
        }
        WarningDialog warnDialog = new WarningDialog((Frame)this, title, message);
        Utility.centerOverFrame(warnDialog, (JFrame)this);
        warnDialog.setVisible(true);
    }

    private void disposeDialog(JDialog dialog) {
        if (dialog != null && dialog.isVisible()) {
            dialog.setVisible(false);
            dialog.dispose();
        }
    }

    public void createCancelDialogContentPanel(JDialog dialog) {
        if (dialog != null && dialog.isVisible()) {
            int iReferenceWidth = dialog.getSize().width;
            Container panel = dialog.getContentPane();
            if (panel != null) {
                panel.removeAll();
            } else {
                dialog.removeAll();
            }
            dialog.setTitle(I18N.getString("cancel-title"));
            JLabel titleLabel = new JLabel(I18N.getString("canceling"));
            MessageTextArea messageText = new MessageTextArea(I18N.getString("cancel-message"), iReferenceWidth);
            titleLabel.setHorizontalAlignment(2);
            titleLabel.setAlignmentX(0.0f);
            titleLabel.setFont(titleLabel.getFont().deriveFont(1));
            InsetPanel labelPanel = new InsetPanel();
            labelPanel.setInsets(new Insets(10, 10, 10, 10));
            labelPanel.setLayout(new BorderLayout());
            labelPanel.add((Component)titleLabel, "North");
            InsetPanel msgPanel = new InsetPanel(new Insets(6, 0, 6, 0), new BorderLayout());
            msgPanel.add((Component)messageText, "Center");
            labelPanel.add((Component)msgPanel, "Center");
            labelPanel.invalidate();
            labelPanel.validate();
            labelPanel.setOpaque(false);
            if (panel != null) {
                panel.setLayout(new BorderLayout());
                panel.add((Component)labelPanel, "Center");
                panel.invalidate();
                panel.validate();
                dialog.setContentPane(panel);
            }
            dialog.pack();
        }
    }

    public static final String formatDateString(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        String dateStr = sdf.format(date);
        Object[] toks = dateStr.split("/");
        String localizedDateString = I18N.format("international-date-format", toks);
        return localizedDateString;
    }

    public int showConfirmDialog(JDialog parent, String questionMsg, String title) {
        ImageIcon icon = Environment.getImageIcon((String)"help_medium.gif");
        return JOptionPane.showConfirmDialog(parent, questionMsg, title, 0, 3, icon);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class LoadDataWorker
    extends Worker
    implements WorkerListener {
        private boolean bAuthenticationNeeded = false;
        private UpdateCollection[] aUpdateCollection;
        private Update[] aHistoryUpdates;

        LoadDataWorker() {
            this.addWorkerListener(this);
        }

        public void workStarted(WorkerEvent e) {
            Application.getInstance().getUpdateFrame().setCursor(Cursor.getPredefinedCursor(3));
        }

        public void workFinished(WorkerEvent e) {
            if (this.bAuthenticationNeeded) {
                this.bAuthenticationNeeded = false;
                AuthenticationManager.getInstance().setAction(new LoadDataAction());
                AuthenticationManager.getInstance().authenticate();
            } else {
                Serializable model;
                if (this.aUpdateCollection != null) {
                    model = (AvailableComboBoxModel)UpdateFrame.this.getAvailablePanel().getComboBox().getModel();
                    ((AvailableComboBoxModel)model).setUpdateCollections(this.aUpdateCollection);
                    UpdateFrame.this.applyUpdateCollection();
                }
                if (this.aHistoryUpdates != null) {
                    model = (HistoryTableModel)UpdateFrame.this.getHistoryPanel().getTable().getModel();
                    ((HistoryTableModel)model).setUpdates(this.aHistoryUpdates);
                    ((AbstractTableModel)model).fireTableDataChanged();
                }
            }
        }

        public void workInterrupted(WorkerEvent e) {
        }

        void work() {
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ LoadDataWorker this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    LoadDataWorker.access$100(this.this$1, 0, this);
                }
            });
            this.start();
        }

        public Object construct() {
            if (this.aUpdateCollection == null) {
                try {
                    this.aUpdateCollection = DataController.getInstance().getAvailableUpdateCollections();
                }
                catch (NotAuthenticatedException e) {
                    this.aUpdateCollection = null;
                    this.bAuthenticationNeeded = true;
                }
                catch (Throwable throwable) {
                    this.aUpdateCollection = null;
                    UpdateFrame.this.showWarningDialog(throwable, UpdateFrame.this.getGatherDialog());
                }
            }
            if (this.aHistoryUpdates == null) {
                try {
                    this.aHistoryUpdates = DataController.getInstance().getHistoryUpdates();
                }
                catch (Throwable throwable) {
                    this.aHistoryUpdates = null;
                    UpdateFrame.this.showWarningDialog(throwable, UpdateFrame.this.getGatherDialog());
                }
            }
            try {
                if (!DataController.isLiveData()) {
                    Thread.sleep(1000L);
                }
            }
            catch (Exception e) {
                System.err.println("Exception calling Thread.sleep()");
            }
            return new Object();
        }

        public void finished() {
            this.fireWorkerEvent(1, this);
        }

        static /* synthetic */ void access$100(LoadDataWorker x0, int x1, Object x2) {
            x0.fireWorkerEvent(x1, x2);
        }
    }

    class LoadDataAction
    extends AbstractAction {
        LoadDataAction() {
        }

        public void actionPerformed(ActionEvent e) {
            LoadDataWorker worker = new LoadDataWorker();
            worker.work();
        }
    }
}

