/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.ui.foundation.swing;

import com.sun.swup.client.ui.foundation.swing.GenericTableCellRenderer;
import com.sun.swup.client.ui.foundation.swing.GenericTableColumn;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;

public class GenericTableColumnModel
extends DefaultTableColumnModel {
    private String sName;
    private GenericTableColumn column;

    public GenericTableColumnModel() {
        this.setColumnMargin(0);
    }

    public GenericTableColumnModel(String sName) {
        this();
        this.sName = sName;
    }

    public void addColumn(String sName) {
        this.column = new GenericTableColumn();
        this.column.setHeaderValue(sName);
        this.column.setModelIndex(this.getColumnCount());
        this.addColumn(this.column);
    }

    public void addColumn(String sName, int iAlignment) {
        this.addColumn(sName);
        if (iAlignment > -1) {
            GenericTableCellRenderer renderer = new GenericTableCellRenderer();
            renderer.getLabel().setHorizontalAlignment(iAlignment);
            this.column.setCellRenderer(renderer);
        }
    }

    public void addColumn(String sName, int iAlignment, int iWidth) {
        this.addColumn(sName, iAlignment);
        this.column.setDefaultWidth(iWidth);
    }

    public void fireColumnSelectionChange(ListSelectionEvent e) {
        this.fireColumnSelectionChanged(e);
    }

    public void setName(String sName) {
        this.sName = sName;
    }

    public String getName() {
        return this.sName;
    }

    public void applyColumnWidth(TableColumn tableColumn, int iWidth) {
        if (iWidth != -1) {
            tableColumn.setMinWidth(iWidth);
            tableColumn.setMaxWidth(iWidth);
            tableColumn.setPreferredWidth(iWidth);
            final TableColumn finalColumn = tableColumn;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    finalColumn.setMinWidth(0);
                    finalColumn.setMaxWidth(1000);
                }
            });
        }
    }
}

