/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.wrapper;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.StringTokenizer;
import java.util.Vector;

public class PatchProPreferences {
    public final String PATCHSET = "patchpro.patchset";
    public final String DOWNLOADDIR = "patchpro.download.directory";
    public final String BACKOUTDIR = "patchpro.backout.directory";
    public final String PATCHSOURCE = "patchpro.patch.source";
    public final String SUNUSER = "patchpro.sun.user";
    public final String SUNPASSWD = "patchpro.sun.passwd";
    public final String PROXYHOST = "patchpro.proxy.host";
    public final String PROXYPORT = "patchpro.proxy.port";
    public final String PROXYUSER = "patchpro.proxy.user";
    public final String PROXYPASSWD = "patchpro.proxy.passwd";
    public final String INSTALLTYPES = "patchpro.install.types";
    private Vector getPreferences;
    private Vector setPreferences;
    private String thePatchSet;
    private String theDownloadDir;
    private String theBackoutDir;
    private String thePatchSource;
    private String theSunUser;
    private String theSunPasswd;
    private String theProxyHost;
    private String theProxyPort;
    private String theProxyUser;
    private String theProxyPasswd;
    private String theInstallTypes;
    private boolean sourceDefault;

    public PatchProPreferences() {
        this.getPreferences = new Vector();
        this.setPreferences = new Vector();
    }

    public PatchProPreferences(String prefs) {
        this.sourceDefault = false;
        try {
            String line;
            BufferedReader in = new BufferedReader(new StringReader(prefs));
            while ((line = in.readLine()) != null) {
                String toSet;
                StringTokenizer st = new StringTokenizer(line, "\t");
                String pref = st.nextToken().trim();
                String userValue = st.nextToken().trim();
                String defaultValue = st.nextToken().trim();
                if (userValue.equals("-")) {
                    toSet = defaultValue;
                    if (pref.equals("patchpro.patch.source")) {
                        this.sourceDefault = true;
                    }
                } else {
                    toSet = userValue;
                }
                if (toSet.equals("\\-")) {
                    toSet = "-";
                } else if (toSet.equals("\"\"")) {
                    toSet = "";
                } else if (toSet.equals("\\\"\"")) {
                    toSet = "\"\"";
                }
                this.setPreference(pref, toSet);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isUpdateSourceDefault() {
        return this.sourceDefault;
    }

    public String getPreference(String parameter) {
        if (parameter.equals("patchpro.patchset")) {
            return this.thePatchSet;
        }
        if (parameter.equals("patchpro.download.directory")) {
            return this.theDownloadDir;
        }
        if (parameter.equals("patchpro.backout.directory")) {
            return this.theBackoutDir;
        }
        if (parameter.equals("patchpro.patch.source")) {
            return this.thePatchSource;
        }
        if (parameter.equals("patchpro.sun.user")) {
            return this.theSunUser;
        }
        if (parameter.equals("patchpro.sun.passwd")) {
            return this.theSunPasswd;
        }
        if (parameter.equals("patchpro.proxy.host")) {
            return this.theProxyHost;
        }
        if (parameter.equals("patchpro.proxy.port")) {
            return this.theProxyPort;
        }
        if (parameter.equals("patchpro.proxy.user")) {
            return this.theProxyUser;
        }
        if (parameter.equals("patchpro.proxy.passwd")) {
            return this.theProxyPasswd;
        }
        if (parameter.equals("patchpro.install.types")) {
            return this.theInstallTypes;
        }
        return null;
    }

    private void setPreference(String parameter, String value) {
        if (parameter.equals("patchpro.patchset")) {
            this.thePatchSet = value;
        } else if (parameter.equals("patchpro.download.directory")) {
            this.theDownloadDir = value;
        } else if (parameter.equals("patchpro.backout.directory")) {
            this.theBackoutDir = value;
        } else if (parameter.equals("patchpro.patch.source")) {
            this.thePatchSource = value;
        } else if (parameter.equals("patchpro.sun.user")) {
            this.theSunUser = value;
        } else if (parameter.equals("patchpro.sun.passwd")) {
            this.theSunPasswd = value;
        } else if (parameter.equals("patchpro.proxy.host")) {
            this.theProxyHost = value;
        } else if (parameter.equals("patchpro.proxy.port")) {
            this.theProxyPort = value;
        } else if (parameter.equals("patchpro.proxy.user")) {
            this.theProxyUser = value;
        } else if (parameter.equals("patchpro.proxy.passwd")) {
            this.theProxyPasswd = value;
        } else if (parameter.equals("patchpro.install.types")) {
            this.theInstallTypes = value;
        }
    }

    public void addPreferenceToSet(String parameter, String value) {
        String[] setValue = new String[]{parameter, value};
        this.setPreferences.add(setValue);
    }

    public void addPreferenceToGet(String parameter) {
        this.getPreferences.add(parameter);
    }

    public Vector getPreferencesToGet() {
        return this.getPreferences;
    }

    public Vector getPreferencesToSet() {
        return this.setPreferences;
    }
}

