/*
 * Decompiled with CFR 0.152.
 */
package java2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java2d.DemoImages;
import java2d.DemoInstVarsAccessor;
import java2d.DemoInstVarsAccessorImplBase;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public final class TextureChooser
extends JPanel {
    private final DemoInstVarsAccessor demoInstVars;
    public Object texture = TextureChooser.getGeomTexture();
    public int num;

    public TextureChooser(int n, DemoInstVarsAccessor demoInstVarsAccessor) {
        this.num = n;
        this.demoInstVars = demoInstVarsAccessor;
        this.setLayout(new GridLayout(0, 2, 5, 5));
        this.setBorder(new TitledBorder(new EtchedBorder(), "Texture Chooser"));
        this.add(new Surface(TextureChooser.getGeomTexture(), this, 0));
        this.add(new Surface(this.getImageTexture(), this, 1));
        this.add(new Surface(this.getTextTexture(), this, 2));
        this.add(new Surface(this.getGradientPaint(), this, 3));
    }

    public static TexturePaint getGeomTexture() {
        BufferedImage bufferedImage = new BufferedImage(5, 5, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setBackground(Color.WHITE);
        graphics2D.clearRect(0, 0, 5, 5);
        graphics2D.setColor(new Color(211, 211, 211, 200));
        graphics2D.fill(new Ellipse2D.Float(0.0f, 0.0f, 5.0f, 5.0f));
        Rectangle rectangle = new Rectangle(0, 0, 5, 5);
        return new TexturePaint(bufferedImage, rectangle);
    }

    public TexturePaint getImageTexture() {
        Image image = DemoImages.getImage("java-logo.gif", this);
        int n = image.getWidth(this);
        int n2 = image.getHeight(this);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, this);
        Rectangle rectangle = new Rectangle(0, 0, n, n2);
        return new TexturePaint(bufferedImage, rectangle);
    }

    public TexturePaint getTextTexture() {
        Font font = new Font("Times New Roman", 1, 10);
        TextLayout textLayout = new TextLayout("Java2D", font, new FontRenderContext(null, false, false));
        int n = (int)textLayout.getBounds().getWidth();
        int n2 = (int)(textLayout.getAscent() + textLayout.getDescent());
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setBackground(Color.WHITE);
        graphics2D.clearRect(0, 0, n, n2);
        graphics2D.setColor(Color.LIGHT_GRAY);
        textLayout.draw(graphics2D, 0.0f, textLayout.getAscent());
        Rectangle rectangle = new Rectangle(0, 0, n, n2);
        return new TexturePaint(bufferedImage, rectangle);
    }

    public GradientPaint getGradientPaint() {
        return new GradientPaint(0.0f, 0.0f, Color.WHITE, 80.0f, 0.0f, Color.GREEN);
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame("Java2D Demo - TextureChooser");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        frame.add("Center", new TextureChooser(0, new DemoInstVarsAccessorImplBase()));
        frame.pack();
        frame.setSize(new Dimension(400, 400));
        frame.setVisible(true);
    }

    public class Surface
    extends JPanel {
        public boolean clickedFrame;
        private int num;
        private TextureChooser tc;
        private boolean enterExitFrame = false;
        private Object t;

        public Surface(final Object object, final TextureChooser textureChooser2, int n) {
            this.setBackground(Color.WHITE);
            this.t = object;
            this.tc = textureChooser2;
            this.clickedFrame = n == textureChooser2.num;
            this.num = n;
            if (n == textureChooser2.num) {
                textureChooser2.texture = object;
            }
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    textureChooser2.texture = object;
                    Surface.this.clickedFrame = true;
                    for (Component component : textureChooser2.getComponents()) {
                        Surface surface;
                        if (!(component instanceof Surface) || (surface = (Surface)component).equals(Surface.this) || !surface.clickedFrame) continue;
                        surface.clickedFrame = false;
                        surface.repaint();
                    }
                    if (((TextureChooser)TextureChooser.this).demoInstVars.getControls().textureCB.isSelected()) {
                        ((TextureChooser)TextureChooser.this).demoInstVars.getControls().textureCB.doClick();
                        ((TextureChooser)TextureChooser.this).demoInstVars.getControls().textureCB.doClick();
                    }
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    Surface.this.enterExitFrame = true;
                    Surface.this.repaint();
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    Surface.this.enterExitFrame = false;
                    Surface.this.repaint();
                }
            });
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            int n = this.getSize().width;
            int n2 = this.getSize().height;
            if (this.t instanceof TexturePaint) {
                graphics2D.setPaint((TexturePaint)this.t);
            } else {
                graphics2D.setPaint((GradientPaint)this.t);
            }
            graphics2D.fill(new Rectangle(0, 0, n, n2));
            if (this.clickedFrame || this.enterExitFrame) {
                graphics2D.setColor(Color.GRAY);
                BasicStroke basicStroke = new BasicStroke(3.0f, 0, 0);
                graphics2D.setStroke(basicStroke);
                graphics2D.drawRect(0, 0, n - 1, n2 - 1);
                this.tc.num = this.num;
            }
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(30, 30);
        }
    }
}

