<?xml version="1.0" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" />
<xsl:template match="/" >
<html>
    <head><title>Asset Information</title></head>
<body>

<table border="0">

    <xsl:for-each select='computer.system/system.information/host.name'> 
            <tr>
                <td valign="top"><b><xsl:value-of select='name()'/></b></td>
                <td valign="top">
                    <xsl:if test="string(.)">
                        <xsl:value-of select='.'/>
                    </xsl:if>
            
                    <xsl:if test="not(string(.))">
                    not.applicable
                    </xsl:if>
                </td>
            </tr>            
    </xsl:for-each>

    <xsl:for-each select='computer.system/system.information/host.id'> 
            <tr>
                <td valign="top"><b><xsl:value-of select='name()'/></b></td>
                <td valign="top">
                    <xsl:if test="string(.)">
                        <xsl:value-of select='.'/>
                    </xsl:if>
            
                    <xsl:if test="not(string(.))">
                    not.applicable
                    </xsl:if>
                </td>
            </tr>            
    </xsl:for-each>

    <xsl:for-each select='computer.system/system.information/operating.system/name'> 
            <tr>
                <td valign="top"><b>os.name</b></td>
                <td valign="top">
                    <xsl:if test="string(.)">
                        <xsl:value-of select='.'/>
                    </xsl:if>
            
                    <xsl:if test="not(string(.))">
                    not.applicable
                    </xsl:if>
                </td>
            </tr>            
    </xsl:for-each>

    <xsl:for-each select='computer.system/system.information/operating.system/version'> 
            <tr>
                <td valign="top"><b>os.version</b></td>
                <td valign="top">
                    <xsl:if test="string(.)">
                        <xsl:value-of select='.'/>
                    </xsl:if>
            
                    <xsl:if test="not(string(.))">
                    not.applicable
                    </xsl:if>
                </td>
            </tr>            
    </xsl:for-each>

    <xsl:for-each select='computer.system/system.information/dns.domain'>
            <tr>
                <td valign="top"><b><xsl:value-of select='name()'/></b></td>
                <td valign="top">
                    <xsl:if test="string(.)">
                        <xsl:value-of select='.'/>
                    </xsl:if>

                    <xsl:if test="not(string(.))">
                    not.applicable
                    </xsl:if>
                </td>
            </tr>
    </xsl:for-each>

    <xsl:for-each select='computer.system/system.information/nis.domain'>
            <tr>
                <td valign="top"><b><xsl:value-of select='name()'/></b></td>
                <td valign="top">
                    <xsl:if test="string(.)">
                        <xsl:value-of select='.'/>
                    </xsl:if>

                    <xsl:if test="not(string(.))">
                    not.applicable
                    </xsl:if>
                </td>
            </tr>
    </xsl:for-each>

    <xsl:for-each select='computer.system/system.information/firmware.version'>
            <tr>
                <td valign="top"><b><xsl:value-of select='name()'/></b></td>
                <td valign="top">
                    <xsl:if test="string(.)">
                        <xsl:value-of select='.'/>
                    </xsl:if>

                    <xsl:if test="not(string(.))">
                    not.applicable
                    </xsl:if>
                </td>
            </tr>
    </xsl:for-each>

    <xsl:for-each select='computer.system/system.information/locale'>
            <tr>
                <td valign="top"><b><xsl:value-of select='name()'/></b></td>
                <td valign="top">
                    <xsl:if test="string(.)">
                        <xsl:value-of select='.'/>
                    </xsl:if>

                    <xsl:if test="not(string(.))">
                    not.applicable
                    </xsl:if>
                </td>
            </tr>
    </xsl:for-each>

    <xsl:for-each select='computer.system/system.information/last.boot.time'>
            <tr>
                <td valign="top"><b><xsl:value-of select='name()'/></b></td>
                <td valign="top">
                    <xsl:if test="string(.)">
                        <xsl:value-of select='.'/>
                    </xsl:if>

                    <xsl:if test="not(string(.))">
                    not.applicable
                    </xsl:if>
                </td>
            </tr>
    </xsl:for-each>

    <xsl:for-each select='computer.system/system.information/memory.size'>
            <tr>
                <td valign="top"><b><xsl:value-of select='name()'/></b></td>
                <td valign="top">
                    <xsl:if test="string(.)">
                        <xsl:value-of select='.'/>
                        <xsl:text> </xsl:text><xsl:value-of select='//memory.size/@units'/>
                    </xsl:if>

                    <xsl:if test="not(string(.))">
                    not.applicable
                    </xsl:if>
                </td>
            </tr>
    </xsl:for-each>

    <xsl:for-each select='computer.system/system.information/model'>
            <tr>
                <td valign="top"><b><xsl:value-of select='name()'/></b></td>
                <td valign="top">
                    <xsl:if test="string(.)">
                        <xsl:value-of select='.'/>
                    </xsl:if>

                    <xsl:if test="not(string(.))">
                    not.applicable
                    </xsl:if>
                </td>
            </tr>
    </xsl:for-each>

    <xsl:for-each select='computer.system/system.information/serial.number'>
            <tr>
                <td valign="top"><b><xsl:value-of select='name()'/></b></td>
                <td valign="top">
                    <xsl:if test="string(.)">
                        <xsl:value-of select='.'/>
                    </xsl:if>

                    <xsl:if test="not(string(.))">
                    not.applicable
                    </xsl:if>
                </td>
            </tr>
    </xsl:for-each>

    <xsl:for-each select='computer.system/system.information/cpu.list'> 
            <tr>
                <td valign="top"><b>number.cpus</b></td>
                <td valign="top">
                    <xsl:value-of select='//cpu.list/@populated'/>                        
                </td>
            </tr>            
    </xsl:for-each>

    <xsl:for-each select='computer.system/system.information/cpu.list'>
            <tr>
                <td valign="top"><b><xsl:value-of select='name()'/></b></td>
                <td valign="top">
                    <table padding="2">

                         <xsl:for-each select='cpu'> 
                         <xsl:sort select='@id'/>                                                  
                            <th align="left" colspan="2">cpu<xsl:value-of select='@id'/></th>                                                                                            
                            <tr>
                                <td align="right"><b>architecture</b></td>
                                <td align="right">
                                <xsl:if test="string(cpu.architecture)">
                                <xsl:value-of select='cpu.architecture'/>
                                </xsl:if>
                                <xsl:if test="not(string(cpu.architecture))">
                                    not.applicable
                                </xsl:if>
                                </td>
                           </tr>
                          
                           <tr>
                                <td align="right"><b>device.id</b></td>
                                <td align="right">
                                <xsl:if test="string(cpu.device.id)">
                                <xsl:value-of select='cpu.device.id'/>
                                </xsl:if>
                                <xsl:if test="not(string(cpu.device.id))">
                                    not.applicable
                                </xsl:if>
                                </td> 
                            </tr>  
                                                 
                            <tr>                               
                                <td align="right"><b>model</b></td>
                                <td align="right">
                                <xsl:if test="string(cpu.model)">
                                <xsl:value-of select='cpu.model'/>
                                </xsl:if>
                                <xsl:if test="not(string(cpu.model))">
                                    not.applicable
                                </xsl:if>                                
                                </td>
                            </tr>  
                                                     
                            <tr>                               
                                <td align="right"><b>speed</b></td>
                                <td align="right">
                                <xsl:if test="string(cpu.speed)">
                                <xsl:value-of select='cpu.speed'/>
                                <xsl:text> </xsl:text><xsl:value-of select='//cpu.speed/@units'/>
                                </xsl:if>
                                <xsl:if test="not(string(cpu.speed))">
                                    not.applicable
                                </xsl:if>
                                </td>
                            </tr>                          
                             <tr>                               
                                <td align="right"><b>status</b></td>
                                <td align="right">
                                <xsl:if test="string(cpu.status)">
                                <xsl:value-of select='cpu.status'/>
                                </xsl:if>
                                <xsl:if test="not(string(cpu.status))">
                                    not.applicable
                                </xsl:if>
                                </td>                                                                                               
                             </tr>                                                                          
                         </xsl:for-each> 
                    </table>
                </td>               
                
            </tr>       
    </xsl:for-each>

     <xsl:for-each select='computer.system/system.information/network.interface.config'>
            <tr>
                <td valign="top"><b><xsl:value-of select='name()'/></b></td>
                <td valign="top">
                    <table padding="2">

                        <xsl:for-each select='network.interface'>
                        <xsl:sort select='@name'/>

                            <th align="left"> <xsl:value-of select='@name'/></th><th align="right">address</th>

                            <tr>
                                <td align="right"><b>mac.address</b></td>
                                <td align="right">
                                <xsl:if test="string(mac.address)">
                                <xsl:value-of select='mac.address'/>
                                </xsl:if>
                                <xsl:if test="not(string(mac.address))">
                                    not.applicable
                                </xsl:if>
                                </td>
                            </tr>

                            <xsl:for-each select='ip'>
                              <tr>
                                <td align="right"><b>ip <xsl:value-of select='@protocol'/></b></td>
                                <td align="right">
                                <xsl:if test="string(.)">
                                <xsl:value-of select='.'/>
                                </xsl:if>
                                <xsl:if test="not(string(.))">
                                    not.applicable
                                </xsl:if>
                                </td>

                              </tr>
                            </xsl:for-each>

                        </xsl:for-each>
                    </table>
                </td>

            </tr>

    </xsl:for-each>

    <xsl:for-each select='computer.system/system.information/storage.inventory'> 
            <tr>
                <td valign="top"><b><xsl:value-of select='name()'/></b></td>
                <td valign="top">
                    <table padding="2">
                        <xsl:for-each select='storage.device'> 
                        <xsl:sort select='@name'/>                         
                            <th align="left" colspan="2"> <xsl:value-of select='@name'/></th>
                           
                            <tr>
                                <td align="right"><b>vendor</b></td>
                                <td align="right">
                                <xsl:if test="string(vendor)">
                                <xsl:value-of select='vendor'/>
                                </xsl:if>
                                <xsl:if test="not(string(vendor))">
                                    not.applicable
                                </xsl:if>
                                </td>
                            </tr>
                           
                            <tr>
                                <td align="right"><b>product</b></td>
                                <td align="right">
                                <xsl:if test="string(product)">
                                <xsl:value-of select='product'/>
                                </xsl:if>
                                <xsl:if test="not(string(product))">
                                    not.applicable
                                </xsl:if>
                                </td>
                            </tr>
                           
                            <tr>
                                <td align="right"><b>revision</b></td>
                                <td align="right">
                                <xsl:if test="string(revision)">
                                <xsl:value-of select='revision'/>
                                </xsl:if>
                                <xsl:if test="not(string(revision))">
                                    not.applicable
                                </xsl:if>
                                </td>
                            </tr>

                            <tr>
                                <td align="right"><b>drive.size</b></td>
                                <td align="right">
                                <xsl:if test="string(drive.size)">
                                <xsl:value-of select='drive.size'/>
                                <xsl:text> </xsl:text><xsl:value-of select='//drive.size/@units'/>
                                </xsl:if>
                                <xsl:if test="not(string(drive.size))">
                                    not.applicable
                                </xsl:if>
                                </td>
                            </tr>                            
                           
                            <tr>
                                <td align="right"><b>serial.number</b></td>
                                <td align="right">
                                <xsl:if test="string(serial.number)">
                                <xsl:value-of select='serial.number'/>
                                </xsl:if>
                                <xsl:if test="not(string(serial.number))">
                                    not.applicable
                                </xsl:if>
                                </td>
                            </tr>

                            <tr>
                                <td align="right"><b>bootprom.id</b></td>
                                <td align="right">
                                <xsl:if test="string(bootprom.id)">
                                <xsl:value-of select='bootprom.id'/>
                                </xsl:if>
                                <xsl:if test="not(string(bootprom.id))">
                                    not.applicable
                                </xsl:if>
                                </td>
                            </tr>
                           
                            <tr>
                                <td align="right"><b>firmware.version</b></td>
                                <td align="right">
                                <xsl:if test="string(firmware.version)">
                                <xsl:value-of select='firmware.version'/>
                                </xsl:if>
                                <xsl:if test="not(string(firmware.version))">
                                    not.applicable
                                </xsl:if>
                                </td>
                            </tr>                           
                        </xsl:for-each> 
                    </table>
                </td>               
                
            </tr>                        
    </xsl:for-each>


    <xsl:for-each select='computer.system/system.information/package.inventory'> 

            <tr>
                <td valign="top"><b><xsl:value-of select='name()'/></b></td>
                <td valign="top">
                    <table padding="2">

                         <xsl:for-each select='package'>

                            <th align="left" colspan="2"><xsl:text> </xsl:text><xsl:value-of select='@pkginst'/></th>

                            <tr>
                                <td align="right"><b>package.name</b></td>
                                <td align="right">
                                <xsl:if test="string(name)">
                                <xsl:value-of select='name'/>
                                </xsl:if>
                                <xsl:if test="not(string(name))">
                                    not.applicable
                                </xsl:if>
                                </td>
                            </tr>

                            <tr>
                                <td align="right"><b>package.category</b></td>
                                <td align="right">
                                <xsl:if test="string(category)">
                                <xsl:value-of select='category'/>
                                </xsl:if>
                                <xsl:if test="not(string(category))">
                                    not.applicable
                                </xsl:if>
                                </td>
                            </tr>

                            <tr>
                                <td align="right"><b>package.arch</b></td>
                                <td align="right">
                                <xsl:if test="string(arch)">
                                <xsl:value-of select='arch'/>
                                </xsl:if>
                                <xsl:if test="not(string(arch))">
                                    not.applicable
                                </xsl:if>
                                </td>
                            </tr>

                            <tr>
                                <td align="right"><b>package.version</b></td>
                                <td align="right">
                                <xsl:if test="string(version)">
                                <xsl:value-of select='version'/>
                                </xsl:if>
                                <xsl:if test="not(string(version))">
                                    not.applicable
                                </xsl:if>
                                </td>
                            </tr>

                            <tr>
                                <td align="right"><b>package.vend</b></td>
                                <td align="right">
                                <xsl:if test="string(vendor)">
                                <xsl:value-of select='vendor'/>
                                </xsl:if>
                                <xsl:if test="not(string(vendor))">
                                    not.applicable
                                </xsl:if>
                                </td>
                            </tr>

                            <tr>
                                <td align="right"><b>package.desc</b></td>
                                <td align="right">
                                <xsl:if test="string(desc)">
                                <xsl:value-of select='desc'/>
                                </xsl:if>
                                <xsl:if test="not(string(desc))">
                                    not.applicable
                                </xsl:if>
                                </td>
                            </tr>

                         </xsl:for-each>

                         <tr>
                             <td align="left"><b>show.more</b></td>
                         </tr>

                    </table>
                </td>

            </tr>

    </xsl:for-each>
    
    <xsl:for-each select='computer.system/system.information/patch.inventory'> 

            <tr>
                <td valign="top"><b><xsl:value-of select='name()'/></b></td>
                <td valign="top">
                    <table padding="2">

                         <xsl:for-each select='patch'>

                            <th align="left" colspan="2"><xsl:text> </xsl:text><xsl:value-of select='@id'/></th>

                            <tr>
                                <td align="right"><b>patch.obsoletes</b></td>
                                <td align="right">
                                <xsl:if test="string(obsoletes)">
                                <xsl:value-of select='obsoletes'/>
                                </xsl:if>
                                <xsl:if test="not(string(obsoletes))">
                                    not.applicable
                                </xsl:if>
                                </td>
                            </tr>

                            <tr>
                                <td align="right"><b>patch.requires</b></td>
                                <td align="right">
                                <xsl:if test="string(requires)">
                                <xsl:value-of select='requires'/>
                                </xsl:if>
                                <xsl:if test="not(string(requires))">
                                    not.applicable
                                </xsl:if>
                                </td>
                            </tr>

                            <tr>
                                <td align="right"><b>patch.incompatibles</b></td>
                                <td align="right">
                                <xsl:if test="string(incompatibles)">
                                <xsl:value-of select='incompatibles'/>
                                </xsl:if>
                                <xsl:if test="not(string(incompatibles))">
                                    not.applicable
                                </xsl:if>
                                </td>
                            </tr>

                            <tr>
                                <td align="right"><b>patch.packages</b></td>
                                <td align="right">
                                <xsl:if test="string(packages)">
                                <xsl:value-of select='packages'/>
                                </xsl:if>
                                <xsl:if test="not(string(packages))">
                                    not.applicable
                                </xsl:if>
                                </td>
                            </tr>

                         </xsl:for-each>

                         <tr>
                             <td align="left"><b>show.more</b></td>
                         </tr>

                    </table>
                </td>

            </tr>

    </xsl:for-each>

</table>
</body>
</html>
</xsl:template>
</xsl:stylesheet>
