package com.sun.cc.platform.user;

import java.io.PrintStream;

/** This class represents the Client factory.  It is a Singleton and 
 * it instantiated using the getInstance method. 
 */
public final class UserServiceClientFactory {
    
    private UserServiceClientFactory() { }

    /** Used to instantiate a single instance of this factory. */
    public static UserServiceClientFactory getInstance() {
        return new UserServiceClientFactory();
    }
    
    /** Creates a UserServiceClient for the given endpoint.
     * @param endpoint the URL of the UserInformationService
     * @return an implementation of the UserServiceClient interface
     */
    public UserServiceClient getClient(String endpoint) {
        return getClient(endpoint, null, true);
    }

    /** Creates a UserServiceClient for the given endpoint.
     * @param endpoint the URL of the UserInformationService
     * @param out a PrintStream to output the constructed XML to
     * @return an implementation of the UserServiceClient interface
     */
    public UserServiceClient getClient(String endpoint, PrintStream out) {
        return getClient(endpoint, out, true);
    }

    /** Creates a UserServiceClient for the given endpoint.
     * @param endpoint the URL of the UserInformationService
     * @param out a PrintStream to output the constructed XML to
     * @return an implementation of the UserServiceClient interface
     */
    public UserServiceClient getClient(String endpoint, 
                                       PrintStream out,
                                       boolean verifyEndpoint) {
        UserServiceClientImpl client = new UserServiceClientImpl(endpoint);
        client.setPrintStream(out);
        return (verifyEndpoint && !client.isEndpointCompatible()
                ? null :  client);
    }
}
