#! /bin/sh
#
# Copyright 2010 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#ident	"@(#)SUNWrmui_reg.sh	1.4	10/02/26 SMI"


# This script functions very much like a postinstall script
# but it does NOT get executed out of pkgadd.  Instead it
# is executed by the SMC server upon its next restart after
# the pkg is added.
#
# A few caviats about the execution environment:
#    - do not assume the normal pkg environment is available.
#    - PATH will be /usr/sbin:/usr/bin

SMCREG=${BASEDIR}/usr/sadm/bin/smcregister
TOOLBOXBASE=${BASEDIR}/var/sadm/smc/toolboxes
ADMIN_LIBDIR=${BASEDIR}/usr/sadm/lib
export BASEDIR


# Register tools and services
if [ -f ${SMCREG} ]; then

    ${SMCREG} tool -n com.sun.admin.perfmgr.client.VPerfMgr.jar \
	${ADMIN_LIBDIR}/perfmgr/VPerfMgr.jar \
	${ADMIN_LIBDIR}/perfmgr/VPerfMgr_classlist.txt \
	${ADMIN_LIBDIR}/perfmgr/VPerfMgrInfo.xml

    #################################################################
    #
    # HEADS UP!  Workaround for bug #4505795, whereby the registration
    # sometimes results in the tool NOT appearing in the desired
    # folder, but instead is placed at the root level and at the bottom.
    # The workaround is to insert a dummy folder, insert the tool,
    # and then remove the dummy folder.
    #
    # create a dir inside /tmp such that security vulnerability
    # for creating temp files cannot
    # be exploited.

    TBX_TEMP=`mktemp -d /tmp/.tbx.XXXXX`
    if [ -z "$TBX_TEMP" ]
    then
       print_error_and_exit "$(gettext "Unable to create tmp dir : %s")" $TBX_TEMP
    fi

    # trap ensure the auto-cleanup
    trap 'rm -rf $TBX_TEMP' 0 1 2 3 15
    SED_SH=$TBX_TEMP/dummy.$$

    cat << \SED_EOF > ${SED_SH}
/<\/Scope>/ {
n
i\
  <Folder TreeDisplay="false"> \
    <Name>SUNWrmui Bootstrap Folder</Name> \
    <Description>This a temporary folder to workaround a bug.  It should be deleted during install.  But if you do see it in the toolbox editor, do NOT delete it.</Description> \
    <Icon>status_16.gif</Icon> \
    <LargeIcon>status_32.gif</LargeIcon> \
  </Folder>
}
SED_EOF

    dummy=`/bin/grep "SUNWrmui Bootstrap Folder" ${TOOLBOXBASE}/this_computer/this_computer.tbx`
    if [ ! -n "$dummy" ]; then
	# create a dir inside /tmp such that security vulnerability
        # for creating temp files cannot
        # be exploited.
        CMP_TEMP=`mktemp -d /tmp/.cmp.XXXXX`
        if [ -z "$CMP_TEMP" ]
        then
            print_error_and_exit "$(gettext "Unable to create tmp dir : %s")" $CMP_TEMP
        fi
        # trap ensure the auto-cleanup
        trap 'rm -rf $CMP_TEMP' 0 1 2 3 15
        TBXTEMP=$CMP_TEMP/this_computer.$$

	/bin/sed -f ${SED_SH} ${TOOLBOXBASE}/this_computer/this_computer.tbx > ${TBXTEMP}
	/bin/cp ${TBXTEMP} ${TOOLBOXBASE}/this_computer/this_computer.tbx
	/bin/rm ${TBXTEMP}
    fi
    /bin/rm -f ${SED_SH}
    #
    #################################################################



    # Add the tool to the toolbox.
    # Using the -D option ensures that the VM is not started during postinstall;
    # rather the execution of the toolbox command will be deferred until the
    # SMC server is restarted.

    ${SMCREG} toolbox -D add tool com.sun.admin.perfmgr.client.VPerfMgr \
	-F "/System Status/"

    # Delete the workaround dummy folder
    ${SMCREG} toolbox -D remove folder "SUNWrmui Bootstrap Folder"

fi

exit 0
