<?xml version="1.0" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" />
<xsl:template match="/" >
<html>
    <head><title>Asset Information</title></head>
<body>
<table border="0">

    <xsl:for-each select='computer.system/system.information/dns.domain'> 
            <tr>
                <td valign="top"><b><xsl:value-of select='name()'/></b></td>
                <td valign="top">
                    <xsl:if test="string(.)">
                        <xsl:value-of select='.'/>
                    </xsl:if>
            
                    <xsl:if test="not(string(.))">
                    N/A
                    </xsl:if>
                </td>
            </tr>            
    </xsl:for-each>
     <xsl:for-each select='computer.system/system.information/nis.domain'> 
            <tr>
                <td valign="top"><b><xsl:value-of select='name()'/></b></td>
                <td valign="top">
                    <xsl:if test="string(.)">
                        <xsl:value-of select='.'/>
                    </xsl:if>
            
                    <xsl:if test="not(string(.))">
                    N/A
                    </xsl:if>
                </td>
            </tr>            
    </xsl:for-each>
     <xsl:for-each select='computer.system/system.information/firmware.version'> 
            <tr>
                <td valign="top"><b><xsl:value-of select='name()'/></b></td>
                <td valign="top">
                    <xsl:if test="string(.)">
                        <xsl:value-of select='.'/>
                    </xsl:if>
            
                    <xsl:if test="not(string(.))">
                    N/A
                    </xsl:if>
                </td>
            </tr>            
    </xsl:for-each>
     <xsl:for-each select='computer.system/system.information/host.id'> 
            <tr>
                <td valign="top"><b><xsl:value-of select='name()'/></b></td>
                <td valign="top">
                    <xsl:if test="string(.)">
                        <xsl:value-of select='.'/>
                    </xsl:if>
            
                    <xsl:if test="not(string(.))">
                    N/A
                    </xsl:if>
                </td>
            </tr>            
    </xsl:for-each>
     <xsl:for-each select='computer.system/system.information/host.name'> 
            <tr>
                <td valign="top"><b><xsl:value-of select='name()'/></b></td>
                <td valign="top">
                    <xsl:if test="string(.)">
                        <xsl:value-of select='.'/>
                    </xsl:if>
            
                    <xsl:if test="not(string(.))">
                    N/A
                    </xsl:if>
                </td>
            </tr>            
    </xsl:for-each>
     <xsl:for-each select='computer.system/system.information/operating.system'> 
            <tr>
                <td valign="top"><b><xsl:value-of select='name()'/></b></td>
                <td valign="top">
                    <xsl:if test="string(.)">
                        <xsl:value-of select='.'/>
                    </xsl:if>
            
                    <xsl:if test="not(string(.))">
                    N/A
                    </xsl:if>
                </td>
            </tr>            
    </xsl:for-each>
     <xsl:for-each select='computer.system/system.information/locale'> 
            <tr>
                <td valign="top"><b><xsl:value-of select='name()'/></b></td>
                <td valign="top">
                    <xsl:if test="string(.)">
                        <xsl:value-of select='.'/>
                    </xsl:if>
            
                    <xsl:if test="not(string(.))">
                    N/A
                    </xsl:if>
                </td>
            </tr>            
    </xsl:for-each>
     <xsl:for-each select='computer.system/system.information/memory.size'> 
            <tr>
                <td valign="top"><b><xsl:value-of select='name()'/></b></td>
                <td valign="top">
                    <xsl:if test="string(.)">
                        <xsl:value-of select='.'/>
                        <xsl:text> </xsl:text>
                        <xsl:value-of select='//memory.size/@units'/>                        
                    </xsl:if>
            
                    <xsl:if test="not(string(.))">
                    N/A
                    </xsl:if>
                </td>
            </tr>            
    </xsl:for-each>
     <xsl:for-each select='computer.system/system.information/model'> 
            <tr>
                <td valign="top"><b><xsl:value-of select='name()'/></b></td>
                <td valign="top">
                    <xsl:if test="string(.)">
                        <xsl:value-of select='.'/>
                    </xsl:if>
            
                    <xsl:if test="not(string(.))">
                    N/A
                    </xsl:if>
                </td>
            </tr>            
    </xsl:for-each>
     <xsl:for-each select='computer.system/system.information/serial.number'> 
            <tr>
                <td valign="top"><b><xsl:value-of select='name()'/></b></td>
                <td valign="top">
                    <xsl:if test="string(.)">
                        <xsl:value-of select='.'/>
                    </xsl:if>
            
                    <xsl:if test="not(string(.))">
                    N/A
                    </xsl:if>
                </td>
            </tr>            
    </xsl:for-each>
    <xsl:for-each select='computer.system/system.information/cpu.list'>
            <tr>
                <td valign="top"><b><xsl:value-of select='name()'/></b></td>
        
                <td valign="top">
                    <table padding="2">
                         <xsl:for-each select='cpu'> 
                         <xsl:sort select='@id'/>                                                  
                            <th align="left" colspan="2">cpu<xsl:value-of select='@id'/></th>                                                                                            
                            <tr>
                                <td align="right">architecture</td>
                                <td align="right">
                                <xsl:if test="string(cpu.architecture)">
                                <xsl:value-of select='cpu.architecture'/>
                                </xsl:if>
                                <xsl:if test="not(string(cpu.architecture))">
                                    N/A
                                </xsl:if>
                                </td>
                           </tr>
                          
                           <tr>
                                <td align="right">device.id</td>
                                <td align="right">
                                <xsl:if test="string(cpu.device.id)">
                                <xsl:value-of select='cpu.device.id'/>
                                </xsl:if>
                                <xsl:if test="not(string(cpu.device.id))">
                                    N/A
                                </xsl:if>
                                </td> 
                            </tr>  
                                                 
                            <tr>                               
                                <td align="right">model</td>
                                <td align="right">
                                <xsl:if test="string(cpu.model)">
                                <xsl:value-of select='cpu.model'/>
                                </xsl:if>
                                <xsl:if test="not(string(cpu.model))">
                                    N/A
                                </xsl:if>                                
                                </td>
                            </tr>  
                                                     
                            <tr>                               
                                <td align="right">speed</td>
                                <td align="right">
                                <xsl:if test="string(cpu.speed)">
                                <xsl:value-of select='cpu.speed'/>
                                </xsl:if>
                                <xsl:if test="not(string(cpu.speed))">
                                    N/A
                                </xsl:if>
                                <xsl:text> </xsl:text><xsl:value-of select='//cpu.speed/@units'/></td>
                            </tr>                          
                            <tr>                               
                                <td align="right">memory</td>
                                <td align="right">
                                <xsl:if test="string(cpu.memory)">
                                <xsl:value-of select='cpu.memory'/>
                                </xsl:if>
                                <xsl:if test="not(string(cpu.memory))">
                                    N/A
                                </xsl:if>
                                </td>
                             </tr>
                             <tr>                               
                                <td align="right">status</td>
                                <td align="right">
                                <xsl:if test="string(cpu.status)">
                                <xsl:value-of select='cpu.status'/>
                                </xsl:if>
                                <xsl:if test="not(string(cpu.status))">
                                    N/A
                                </xsl:if>
                                </td>                                                                                               
                             </tr>                                                                          
                         </xsl:for-each> 
                    </table>
                </td>               
                
            </tr>       
    </xsl:for-each>
    
     <xsl:for-each select='computer.system/system.information/network.interface.config'>           
            <tr>
                <td valign="top"><b><xsl:value-of select='name()'/></b></td>
        
                <td valign="top">
                    <table padding="2">
                         <xsl:for-each select='network.interface'> 
                         <xsl:sort select='@name'/>                                                  
                            <th align="left"> <xsl:value-of select='@name'/></th><th align="right">address</th>
                            
                            <tr>
                                <td align="right">mac.address</td>
                                <td align="right">
                                <xsl:if test="string(mac.address)">
                                <xsl:value-of select='mac.address'/>
                                </xsl:if>
                                <xsl:if test="not(string(mac.address))">
                                    N/A
                                </xsl:if>
                                </td>
                           </tr>
                          
                           <xsl:for-each select='ip'>
                             <tr>                               
                                <td align="right">ip <xsl:value-of select='@protocol'/></td>
                                <td align="right">
                                <xsl:if test="string(.)">
                                <xsl:value-of select='.'/>
                                </xsl:if>
                                <xsl:if test="not(string(.))">
                                    N/A
                                </xsl:if>
                                </td>                                                                                       
                             </tr> 
                             </xsl:for-each>                                                 
                         </xsl:for-each> 
                    </table>
                </td>               
                
            </tr> 
                     
    </xsl:for-each>
     <xsl:for-each select='computer.system/system.information/storage.inventory'> 
            <tr>
                <td valign="top"><b><xsl:value-of select='name()'/></b></td>
        
                <td valign="top">
                    <table padding="2">
                         <xsl:for-each select='storage.device'> 
                         <xsl:sort select='@name'/>                         
                            <th align="left" colspan="2"> <xsl:value-of select='@name'/></th>                   
                           
                            <tr>
                                <td align="right">vendor</td>
                                <td align="right">
                                <xsl:if test="string(vendor)">
                                <xsl:value-of select='vendor'/>
                                </xsl:if>
                                <xsl:if test="not(string(vendor))">
                                    N/A
                                </xsl:if>
                                </td>
                           </tr>
                           
                            <tr>
                                <td align="right">product</td>
                                <td align="right">
                                <xsl:if test="string(product)">
                                <xsl:value-of select='product'/>
                                </xsl:if>
                                <xsl:if test="not(string(product))">
                                    N/A
                                </xsl:if>
                                </td>
                           </tr>
                           
                            <tr>
                                <td align="right">drive.size</td>
                                <td align="right">
                                <xsl:if test="string(drive.size)">
                                <xsl:value-of select='drive.size'/>
                                </xsl:if>
                                <xsl:if test="not(string(drive.size))">
                                    N/A
                                </xsl:if>
                                <xsl:text> </xsl:text><xsl:value-of select='//drive.size/@units'/></td>
                           </tr>                            
                           
                            <tr>
                                <td align="right">serial.number</td>
                                <td align="right">
                                <xsl:if test="string(serial.number)">
                                <xsl:value-of select='serial.number'/>
                                </xsl:if>
                                <xsl:if test="not(string(serial.number))">
                                    N/A
                                </xsl:if>
                                </td>
                           </tr>
                            <tr>
                                <td align="right">bootprom.id</td>
                                <td align="right">
                                <xsl:if test="string(bootprom.id)">
                                <xsl:value-of select='bootprom.id'/>
                                </xsl:if>
                                <xsl:if test="not(string(bootprom.id))">
                                    N/A
                                </xsl:if>
                                </td>
                           </tr>
                           
                            <tr>
                                <td align="right">firmware.version</td>
                                <td align="right">
                                <xsl:if test="string(firmware.version)">
                                <xsl:value-of select='firmware.version'/>
                                </xsl:if>
                                <xsl:if test="not(string(firmware.version))">
                                    N/A
                                </xsl:if>
                                </td>
                           </tr>                           
                         </xsl:for-each> 
                    </table>
                </td>               
                
            </tr>                        
    </xsl:for-each>
   
     <xsl:for-each select='computer.system/system.information/package.inventory'> 
            <tr>
                <td valign="top"><b><xsl:value-of select='name()'/></b></td>
          
                <td valign="top">
                 <xsl:for-each select='package'> 
                     <xsl:value-of select='@pkginst'/><xsl:text> </xsl:text>
                  </xsl:for-each> 
                </td>
                
            </tr>       
    </xsl:for-each>
    
    <xsl:for-each select='computer.system/system.information/patch.inventory'> 
            <tr>
                <td valign="top"><b><xsl:value-of select='name()'/></b></td>
          
                <td valign="top">
                 <xsl:for-each select='patch'> 
                     <xsl:value-of select='@id'/><xsl:text> </xsl:text>
                  </xsl:for-each> 
                </td>
                
            </tr>            
    </xsl:for-each>
</table>
</body>
</html>
</xsl:template>
</xsl:stylesheet>
