/* BeOS io.c */

#include "ztypes.h"

#include <sys/types.h>
#include <sys/time.h>

#define DEBUG(x)	{ /*x*/ }

/*extern "C" {*/
extern int hist_buf_size;
extern void Be_display_char(int c);
extern void Be_scroll_line(void);
extern void Be_select_text_window(void);
extern void Be_select_status_window(void);
extern void Be_clear_screen(void);
extern int Be_input_line(int buflen, char *buffer, int timeout, int *read_size);
extern int Be_input_character(int timeout);
void Be_move_cursor(int row, int col);
/*}*/

void initialize_screen(void)
{
    if (screen_cols == 0)
        screen_cols = DEFAULT_COLS;

    if (screen_rows == 0)
        screen_rows = DEFAULT_ROWS;

	interp_initialized = 1;
}

void restart_screen(void)
{
	Be_clear_screen();
}

void reset_screen(void)
{
	DEBUG(puts("reset_screen");)
}

void clear_screen(void)
{
	Be_clear_screen();
}

void select_status_window(void)
{
	DEBUG(puts("select status");)
	Be_select_status_window();
}

void select_text_window(void)
{
	DEBUG(puts("select text");)
	Be_select_text_window();
}

void create_status_window(void)
{
}

void delete_status_window(void)
{
}

void clear_line(void)
{
//	puts("Clear line");
}

void clear_text_window(void)
{
	DEBUG(puts("Clear text window");)
}

void clear_status_window(void)
{
	DEBUG(puts("Clear status window");)
}

void move_cursor(int row, int col)
{
	DEBUG(printf("Move cursor to (%d, %d)\n", row, col);)
	Be_move_cursor(row, col);
}


void get_cursor_position(int *row, int *col)
{
	DEBUG(printf("Get cursor position\n");)
}

void save_cursor_position(void)
{
	DEBUG(puts(" Save cursor position");)
}

void restore_cursor_position(void)
{
	DEBUG(puts("Restore cursor position");)
}

void set_attribute(int attribute)
{


}

void display_char(int c)
{
	Be_display_char(c);
}

void scroll_line(void)
{
	Be_scroll_line();
}

int input_line(int buflen, char *buffer, int timeout, int *read_size)
{
	DEBUG(puts("input_line");)
	return Be_input_line(buflen, buffer, timeout, read_size);
}

int input_character(int timeout)
{
	DEBUG(puts("input character");)
	return Be_input_character(timeout);
}


