//
// my_window.h
//

#ifndef _MY_WINDOW_H_
#define _MY_WINDOW_H_


#include <iostream.h>
#include <FilePanel.h>
#include <ListView.h>
#include <Window.h>
#include <Font.h>
#include <Message.h>
#include <TextView.h>


const uint32 MSG_ABOUT		= 'abut';
const uint32 MSG_NEW		= 'newg';
const uint32 MSG_LOAD		= 'load';
const uint32 MSG_SAVE		= 'save';
const uint32 MSG_QUIT		= 'quit';
const uint32 MSG_FONT_FAMILY = 'ffam';
const uint32 MSG_FONT_SIZE	= 'fsiz';
const uint32 MSG_PICKED_FILE	= 'pick';
const uint32 MSG_PAUSE_ZIP	= 'pzip';
const uint32 MSG_RESUME_ZIP	= 'rzip';


class my_window : public BWindow
{
private:
	enum { MAX_LINES = 20 };		// Up to this many lines in list...

	BTextView *text_view;
	BStringView *status_view;
	thread_id the_thread;		// id of spawned thread

	BFont status_font;			// Font for status bar
	BFont text_font;			// Font for text output

	BFilePanel *file_requester;

	enum { MAX_INPUT_LEN = 256};
	char input_buffer[MAX_INPUT_LEN + 1];	// Input buffer
//	int input_offset;
	int input_count;				// Current position in input buffer
	enum enumSleepType {
		I_WANT_LINE,
		I_WANT_CHAR,
		I_WANT_NOWT
	} sleep_type;

	int x_pos, y_pos;			// Current cursor location

	// Routines used to spawn thread...
	static long thread_func(void *obj);
	void run_jzip(char *name);

	void do_new_game_requester(void);
	void handle_selected_file(BMessage *msg);
	void handle_key_pressed(BMessage *message);

public:
	my_window(BRect frame, char *title);
	virtual void MessageReceived(BMessage *message);
	virtual bool QuitRequested(void);
	int input_line(int buflen, char *buffer, int timeout, int *read_size);
	int input_character(int time_out);
	void move_cursor(int row, int col);

	// Add 'text' to bottom of display...
	void add_line(const char *text, bool replace = 0);
	void update_status(const char *text);
	void clear_text(void) {
		if (text_view) {
			Lock();
			//text_view->SetText("abc", 3);
			text_view->SetText(NULL);
			Unlock();
		}
	}
};


#endif	// _MY_WINDOW_H_
