//
// main.cc
//

#include "my_app.h"
#include "CMameDisplay.h"
#include "MessageConsts.h"
#include "../osdepend.h"
#include <stdio.h>
#include <Joystick.h>
#include <stdlib.h>

extern "C" {
	void beos_open_window(int width, int height,int color_depth);
	int  beos_key_pressed(int keycode);
	void beos_allocate_pen(int index, uchar r, uchar g, uchar b);
	void beos_pen_set(void);
	int  beos_joystick_poll(void);
	int  beos_joystick_digital(int nr, int what);
	void beos_get_mouse(int *deltax, int *deltay);
	extern int read_key(int keycode);
}

// variables
const bool		JOYDEBUG=false;
const int		MAX_JOYSTICKS=4;
BJoystick* 		GJoystick[MAX_JOYSTICKS];	// Array of used joysticks (global)
int				gWindowed;

//
// Main entry point
//
int main(int argv, char **argc)
{
	// Init/Run App
	my_app	*mameApp = new my_app();
	mameApp->Run();

	return 0;
}



//
// Access functions
//

void beos_open_window(int width, int height,int color_depth)
{
	BRect		frame(0, 0, width-1, height-1);
	status_t	err;
	
	CMameDisplay::CreateMameDisplay(&err, frame, color_depth, !gWindowed);
}

//
// Read key corresponding to key 'keycode'
//
int beos_key_pressed(int keycode)
{
	return CMameDisplay::ReadKey(keycode);
}



//
// Read mouse position within view
//
void beos_get_mouse(int *deltax, int *deltay)
{
	gDisplay->GetMouseDelta(deltax, deltay);
}



//
// Poll the joystick
//
int beos_joystick_poll(void)
{
	for (int i=0; i<MAX_JOYSTICKS; i++) {		// Update joysticks
		if (GJoystick[i] != NULL)  GJoystick[i]->Update();
	}
	if (JOYDEBUG)  printf("POLL JOYSTICK\n");
	return 0;
}



int beos_joystick_digital(int nr, int what)
{

return 0;


//	if (GJoystick[nr] != NULL) {
//
//		if (JOYDEBUG) {
//		printf("POLL JOYSTICK %i: ", nr);
//		switch (what) {
//			case OSD_JOY_LEFT:		printf("LEFT");		break;
//			case OSD_JOY_RIGHT:		printf("RIGHT");	break;
//			case OSD_JOY_UP: 		printf("UP");		break;
//			case OSD_JOY_DOWN:		printf("DOWN");		break;
//			case OSD_JOY_FIRE1: 	printf("FIRE1");	break;
//			case OSD_JOY_FIRE2: 	printf("FIRE2");	break;
//			case OSD_JOY_FIRE3: 	printf("FIRE3");	break;
//			case OSD_JOY_FIRE4: 	printf("FIRE4");	break;
//			case OSD_JOY_FIRE5: 	printf("FIRE5");	break;
//			case OSD_JOY_FIRE6:		printf("FIRE6");	break;
//			case OSD_JOY_FIRE7:		printf("FIRE7");	break;
//			case OSD_JOY_FIRE8:		printf("FIRE8");	break;
//			case OSD_JOY_FIRE9:		printf("FIRE9");	break;
//			case OSD_JOY_FIRE10:	printf("FIRE10");	break;
//			case OSD_JOY_FIRE:		printf("FIRE");		break;
//		}
//		}
//		if (what < OSD_JOY_FIRE1) {
//			if (JOYDEBUG)  printf(" (axes %i)", GJoystick[nr]->CountAxes());
////			if (GJoystick[nr]->CountAxes() >= 2)
//			{
//				int16* axes = new int16[GJoystick[nr]->CountAxes()];
//				GJoystick[nr]->GetAxisValues(axes);
//				if (JOYDEBUG)  printf(" [%li,%li] ", axes[0], axes[1]);
//				bool ret=false;
//				switch (what)
//				{
//					case OSD_JOY_LEFT:	ret = (axes[0]<-5000);		break;
//					case OSD_JOY_RIGHT:	ret = (axes[0]>+5000);		break;
//					case OSD_JOY_UP: 	ret = (axes[1]<-5000);		break;
//					case OSD_JOY_DOWN:	ret = (axes[1]>+5000);		break;
//				}
//				delete [] axes;
//				if (JOYDEBUG)  printf(" %i\n", ret);
//				return ret ? 1 : 0;
//			}
//			if (JOYDEBUG)  printf("\n");
//		} else {
//			uint32 but = GJoystick[nr]->ButtonValues();
//			uint32 mask = (what==OSD_JOY_FIRE) ? 0xFFFF : 1<<(what-OSD_JOY_FIRE1);
//			if (JOYDEBUG)  printf("  button %i: %i\n", what-OSD_JOY_FIRE1, (but & mask));
//			return (but & mask);
//		}
//	} else {
//		return 0;	// Function should return something ;^)
//	}
}



//
// Allocate a palette entry for specified rgb, and return
//  its pen number
//
void beos_allocate_pen(int index, uchar r, uchar g, uchar b)
{	
	//now build palettes for BDirectWindow blitting
	gDisplay->SetPenAtIdx(index, r, g, b);
}



void beos_pen_set(void)
{
	gDisplay->SetPalette();
}

