// LMenuBar.cpp
// A menu bar with an Icon menu item
// Casey Fleser
// July 21, 1997

#include <BeHeaders>

#include "LMenuBar.h"

unsigned char LMenuBar::sDefaultIcon[] =  { 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0xFA, 0xFA, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0xFA, 0xFA, 0xFA, 0xFA, 0xFA, 0x00, 0x00, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x1F, 0xFA, 0xFA, 0xFA, 0xFA, 0x1F, 0x5D, 0x00, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0xF9, 0x1F, 0x1F, 0xFA, 0x1F, 0x5D, 0x5D, 0x00, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0x00, 0x00, 0xF9, 0xF9, 0xF9, 0x1F, 0x5D, 0x5D, 0x5D, 0x00, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0x00, 0x60, 0x01, 0xF9, 0xF9, 0xF9, 0xF9, 0x5D, 0x5D, 0x5D, 0x00, 0x00, 0xFF, 0xFF,
	0xFF, 0x00, 0x60, 0x60, 0x01, 0xF9, 0xF9, 0xF9, 0xF9, 0x5D, 0x5D, 0x5D, 0x00, 0xA3, 0x00, 0x00,
	0x00, 0x1F, 0x60, 0x60, 0x60, 0x01, 0xF9, 0xF9, 0xF9, 0x5D, 0x5D, 0x00, 0xA3, 0x1F, 0x2D, 0x00,
	0x00, 0x86, 0x1F, 0x1F, 0x60, 0x1F, 0x00, 0x00, 0xF9, 0x5D, 0x00, 0xA3, 0x1F, 0x2D, 0x2D, 0x00,
	0x00, 0x86, 0x86, 0x86, 0x1F, 0xD5, 0x27, 0x00, 0x00, 0x00, 0xA3, 0x1F, 0x2D, 0x2D, 0x2E, 0x00,
	0x00, 0x86, 0x86, 0x86, 0x86, 0xD5, 0x28, 0x01, 0xCA, 0xCA, 0xA3, 0xA3, 0x2D, 0x2D, 0x2E, 0x00,
	0x00, 0x86, 0x86, 0x86, 0x86, 0xD5, 0xD5, 0x00, 0xCA, 0xA3, 0xA3, 0xA3, 0x2D, 0x2D, 0x2D, 0x00,
	0x00, 0x86, 0x86, 0x86, 0x86, 0xD5, 0xD5, 0x00, 0xA3, 0xA3, 0xA3, 0xA3, 0x2D, 0x2D, 0x2E, 0x01,
	0xFF, 0x00, 0x00, 0x86, 0x86, 0xD5, 0xD5, 0x01, 0x00, 0x00, 0xA3, 0xA3, 0x2D, 0x2E, 0x00, 0x11, 
	0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11,
};

LMenuBar::LMenuBar(
	BRect		inFrame,
	const char	*inTitle,
	uint32		inMask,
	menu_layout	inLayout,
	bool 		inFit) : BMenuBar(inFrame, inTitle, inMask, inLayout, inFit)
{
	BFile		appFile;
	app_info		appInfo;
	BAppFileInfo	appFileInfo;
	
	mMainMenu = new BMenu(" ");
	AddItem(mMainMenu);
	
	// fix this later
	mIcon = new BBitmap(BRect(0,0,15,15), B_COLOR_8_BIT, false, true);
	
	be_app->GetAppInfo(&appInfo);
	if (appFile.SetTo(&appInfo.ref, B_READ_ONLY) == B_NO_ERROR) {
		if (appFileInfo.SetTo(&appFile) == B_NO_ERROR) {
			if (appFileInfo.GetIcon(mIcon, B_MINI_ICON) != B_NO_ERROR)
				mIcon->SetBits(sDefaultIcon, 16*16, 0, B_COLOR_8_BIT);
		}
		else
			mIcon->SetBits(sDefaultIcon, 16*16, 0, B_COLOR_8_BIT);
	}
	else
		mIcon->SetBits(sDefaultIcon, 16*16, 0, B_COLOR_8_BIT);
}

LMenuBar::~LMenuBar()
{
}

void
LMenuBar::Draw(
	BRect	inRect)
{
#pragma unused (inRect)

	BMenuBar::Draw(inRect);

	SetDrawingMode(B_OP_OVER);
	DrawBitmap(mIcon, BPoint(1, 1));
	SetDrawingMode(B_OP_COPY);
}
