#include "Common.h"
//------------------------------------------------------------------------------
TAppPrivacy	*gxAppPrivacy;
TCustomSet	*gxCustomSet;
TExitState	*gxExitState;
TLLMsg		*gxLLMsg;
//------------------------------------------------------------------------------
TAppPrivacy::TAppPrivacy()
{
	mbGoing = false;
	mbNewFile = true;
	mxSelectedField.Set(0,0,0,0);
}
//------------------------------------------------------------------------------
TAppPrivacy::~TAppPrivacy()
{
}
//------------------------------------------------------------------------------
TCustomSet::TCustomSet()
{
	miInterval = 500;
	miLang = 1;
	miXBlockSize = 10;
	miYBlockSize = 10;
	miXBlocks = 20;
	miYBlocks = 20;
	mxCtrlViewColor.red = 0xFF;
	mxCtrlViewColor.green = 0xFF;
	mxCtrlViewColor.blue = 0xCC;
	mxCtrlViewColor.alpha = 0;
	mxEmptyColor.red = 0xCC;
	mxEmptyColor.green = 0xCC;
	mxEmptyColor.blue = 0xFF;
	mxEmptyColor.alpha = 0;
	mxLifeColor.red = 0xFF;
	mxLifeColor.green = 0x99;
	mxLifeColor.blue = 0x99;
	mxLifeColor.alpha = 0;
}
//------------------------------------------------------------------------------
TCustomSet::~TCustomSet()
{
}
//------------------------------------------------------------------------------
TExitState::TExitState()
{
	mxFrame.Set(100,100,500,400);
	mszOPanelPath[0] = '\0';
	mszSPanelPath[0] = '\0';
}
//------------------------------------------------------------------------------
TExitState::~TExitState()
{
}
//------------------------------------------------------------------------------
TLLMsg::TLLMsg()
{
}
//------------------------------------------------------------------------------
TLLMsg::~TLLMsg()
{
}
//------------------------------------------------------------------------------
char*	AlertCaption()
{
	static bool	bMade = false;
	static char	szCaption[256];
	
	if ( !bMade ) {
		strcpy(szCaption,gxLLMsg->mxAlertCaption[0].String());
		strcat(szCaption,gxLLMsg->mxAppInfo[0].String());
		strcat(szCaption,gxLLMsg->mxAlertCaption[1].String());
		bMade = true;
	}
	return szCaption;
}
//------------------------------------------------------------------------------
void	AlertErr(/*const */BString &xErr)
{
	BAlert	*xAlert;
	BString	xMsg;

	xMsg << AlertCaption() << xErr;
	xAlert = new BAlert("Title",xMsg.String(),gxLLMsg->mxButtonOK.String(),NULL,NULL
			,B_WIDTH_AS_USUAL,B_OFFSET_SPACING,B_WARNING_ALERT);
	xAlert->Go();
}
//------------------------------------------------------------------------------
bool	ClipHasData()
{
	bool		bResult = false;
	const char	*cTmp;
	BMessage	*xClipData;
	
	if ( be_clipboard->Lock() ) {
		xClipData = be_clipboard->Data();
		if ( xClipData->FindString(BLFData,&cTmp) == B_OK )
			bResult = true;
		else
			bResult = false;
		be_clipboard->Unlock();
   }
   return bResult;
}
//------------------------------------------------------------------------------
float	Max(float a,float b)
{
	return (a > b ? a : b);
}
//------------------------------------------------------------------------------
void	ShowHelp()
{
	app_info	xAppInfo;
	entry_ref	xRef;
	status_t	xResult;
	BDirectory	xDirTmp;
	BEntry		xEntry;
	BEntry		xEntryTmp;
	BString		xMsg;
	
	be_app->GetAppInfo(&xAppInfo);
	xEntryTmp.SetTo(&xAppInfo.ref);
	xEntryTmp.GetParent(&xDirTmp);
	xEntry.SetTo(&xDirTmp,HelpFName);
	xEntry.GetRef(&xRef);
	xResult = be_roster->Launch(&xRef);
	if ( xResult != B_OK && xResult != B_ALREADY_RUNNING ) {
		xMsg << AlertCaption() << gxLLMsg->mxHelpErr[0] << HelpFName << gxLLMsg->mxHelpErr[0];
		AlertErr(xMsg);
	}
/*
	switch ( be_roster->Launch(&xRef) ) {
	case B_OK:
		strcpy(szTmp,"B_OK");
		break;
	case B_BAD_VALUE:
		strcpy(szTmp,"bad val");
		break;
	case B_ALREADY_RUNNING:
		strcpy(szTmp,"already run");
		break;
	case B_LAUNCH_FAILED:
		strcpy(szTmp,"launch failed");
		break;
	default:
		strcpy(szTmp,"other");
	}
		xAlert = new BAlert("Title",szTmp,"ＯＫ",NULL,NULL,B_WIDTH_AS_USUAL
				,B_OFFSET_SPACING,B_WARNING_ALERT);
		xAlert->Go();
*/
}
//------------------------------------------------------------------------------
int		StrToInt(const char *szStr,int iMaxFig)
{
	char	*cTmp;
	int		iResult;
	
	cTmp = new char [iMaxFig+1];
	strncpy(cTmp,szStr,iMaxFig);
	cTmp[iMaxFig] = '\0';
	iResult = atoi(cTmp);
	delete cTmp;
	return iResult;
}
//------------------------------------------------------------------------------
void	Swap(float &a,float &b)
{
	float	fTmp;
	
	fTmp = a;
	a = b;
	b = fTmp;
}
//------------------------------------------------------------------------------
