/*********************************************************************
HyperTTT - Tic tac toe in higher dimensions
Copyright (c) 1998 Brian Nenninger

This program is free software; you can redistribute it and/or modify it under 
the terms of the GNU General Public License as published by the Free Software
Foundation; either version 2 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with 
this program; if not, write to the Free Software Foundation, Inc., 675 Mass 
Ave., Cambridge, MA 02139, USA.

You may contact me at bwn@kreative.net
************************************************************************/

#include "BeScoreView.h"
#include "BeTTTWindow.h"
#include "BeTTTGame.h"
#include "4dBoard.h"

#include "BeTTTView.h"

BeScoreView::BeScoreView(BRect rect, char *name)
	   	   : BView(rect, name, B_FOLLOW_ALL, B_WILL_DRAW | B_FRAME_EVENTS |
	   	                                     (0*B_FULL_UPDATE_ON_RESIZE) | (0*B_PULSE_NEEDED))
{
  //SetFontName("Courier New");
  SetFontSize(18);
  m_lastP1Wins = m_lastP2Wins = m_lastTies = -1;
}

BeScoreView::~BeScoreView()
{
  m_parent->ScoreWindowClosed();
}

void BeScoreView::SetParent(BeTTTWindow *w)
{
  m_parent = w;
}

void BeScoreView::SetGame(BeTTTGame *g)
{
  m_game = g;
}


void BeScoreView::Draw(BRect r)
{
  int ties = m_game->GetPlayerWins(0);
  int p1Wins = m_game->GetPlayerWins(1);
  int p2Wins = m_game->GetPlayerWins(2);

  // Player 1  
  MovePenTo(45, 25);
  DrawString("Player 1:");
  if (p1Wins!=m_lastP1Wins)
  {
    sprintf(m_p1str, "%d", p1Wins);
    m_lastP1Wins = p1Wins;
    m_p1Width = StringWidth(m_p1str);
  }
  MovePenTo(180-m_p1Width, 25);
  DrawString(m_p1str);
  
  // Player 2
  MovePenTo(45, 55);
  DrawString("Player 2:");
  if (p2Wins!=m_lastP2Wins)
  {
    sprintf(m_p2str, "%d", p2Wins);
    m_lastP2Wins = p2Wins;
    m_p2Width = StringWidth(m_p2str);
  }
  MovePenTo(180-m_p2Width, 55);
  DrawString(m_p2str);
  
  // Ties  
  MovePenTo(45, 85);
  DrawString("Ties:");
  if (ties!=m_lastTies)
  {
    sprintf(m_tiestr, "%d", ties);
    m_lastTies = ties;
    m_tiesWidth = StringWidth(m_tiestr);
  }
  MovePenTo(180-m_tiesWidth, 85);
  DrawString(m_tiestr);
  
  int style = m_game->GetStyle();
  BRect pr;
  
  pr.Set(10, 10, 30, 30);
  DrawPiece(pr, this, 1, style);
  pr.Set(10, 40, 30, 60);
  DrawPiece(pr, this, 2, style);
}