/*********************************************************************
HyperTTT - Tic tac toe in higher dimensions
Copyright (c) 1998 Brian Nenninger

This program is free software; you can redistribute it and/or modify it under 
the terms of the GNU General Public License as published by the Free Software
Foundation; either version 2 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with 
this program; if not, write to the Free Software Foundation, Inc., 675 Mass 
Ave., Cambridge, MA 02139, USA.

You may contact me at bwn@kreative.net
************************************************************************/

#ifndef BeTTT_GAME_H
#define BeTTT_GAME_H


class BeTTTApp;
class BeTTTWindow;
class BeTTTView;
class Vector;
class Player;
class Board;
class ThreatLine;

class BeTTTGame
{
protected:
  BeTTTApp *m_app;
  BeTTTWindow *m_wind;
  BeTTTView *m_view;
  Board *boardPtr;
	ThreatLine *m_flashLine;
  
  thread_id m_GameThread, m_flashThread;
  
  sem_id m_boardSem;
  
  
public:  
	Player *players;
	short m_InGame, m_okForHuman, m_numMoves;
	short m_numPlayers, m_curPlayer;
	short m_pieceStyle; 
	short m_fastplay;

  // inline accessors
	short FastplayOn() {return m_fastplay;};
	
	int SoundOn() {return m_soundOn;};
	
	Board *GetBoard() {return boardPtr;};
	
	int DoHumanMove(Vector &v);
	
	Player *GetCurrentPlayer();
	Player *GetPlayer(int i);
	
	void LockWindow();
	void UnlockWindow();
	
	void AcquireBoardSem();
	void ReleaseBoardSem();
	
	int InGame() {return m_InGame;};
	int OKForHuman() {return m_InGame && m_okForHuman;};
	
	void ResetGame();
	void SetStrategy(int, int);
	void SetStyle(int);
	int  GetStyle();
	
	void ToggleFastplay();
	void SetN(int);
	void SetD(int);
	
	int GetPlayerWins(int);
	void DoWin(int);
	void DoTie();
	void ResetScore();
	void UpdateStatsWindow();
	
	void StartGame();
	void StartFlashing();
	
  // thread stuff
	static long StaticGameEntryFunc(void *);
	long GameEntryFunc();
	
	static long StaticFlashEntryFunc(void *);
	long FlashEntryFunc();
	
	void KillThread();
	
	// constructor
	BeTTTGame(BeTTTApp *, BeTTTWindow *, BeTTTView *, int, int);

protected:
	
	short *m_pWinList;
	int m_numTies;
	int m_scoreVisible;
	int m_statsVisible;
	int m_soundOn;
	int m_winnerNum;
	int m_flashOn;
	
	Vector *m_playerMove;

};

#endif
