/*********************************************************************
HyperTTT - Tic tac toe in higher dimensions
Copyright (c) 1998 Brian Nenninger

This program is free software; you can redistribute it and/or modify it under 
the terms of the GNU General Public License as published by the Free Software
Foundation; either version 2 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with 
this program; if not, write to the Free Software Foundation, Inc., 675 Mass 
Ave., Cambridge, MA 02139, USA.

You may contact me at bwn@kreative.net
************************************************************************/


#include "BeTTTWindow.h"
#include "BeTTTGame.h"

#ifndef _APPLICATION_H
#include <Application.h>
#endif

#include "BeScoreView.h"
#include "BeAboutView.h"


//void set_palette_entry(long i,rgb_color c);

BeTTTWindow::BeTTTWindow(BRect frame)
				: BWindow(frame, "BeTTT", B_TITLED_WINDOW, NULL)
{
  SetTitle("HyperTTT");
  
  frame.OffsetTo(B_ORIGIN);
  BRect barRect=frame;
  barRect.bottom = barRect.top + 20; // ???
  BMenuBar *bar = new BMenuBar(barRect, "menu 1");
  
  BMenu *fileMenu = new BMenu("File", B_ITEMS_IN_COLUMN);
  BMenuItem *newItem  = new BMenuItem("New Game", new BMessage(kNewGameMsg), 'N');
  BMenuItem *quitItem = new BMenuItem("Quit", new BMessage(kQuitMsg), 'Q');
  fileMenu->AddItem(newItem);
  fileMenu->AddSeparatorItem();
  fileMenu->AddItem(quitItem);
  bar->AddItem(fileMenu);
  
  BMenu *p1Menu = new BMenu("Player 1", B_ITEMS_IN_COLUMN);
  BMenuItem *p1Human = new BMenuItem("Human", new BMessage(kP1HumanMsg));
  BMenuItem *p1Attack = new BMenuItem("Offensive", new BMessage(kP1AttackMsg));
  BMenuItem *p1Balanced = new BMenuItem("Balanced", new BMessage(kP1BalancedMsg));
  BMenuItem *p1Defense = new BMenuItem("Defensive", new BMessage(kP1DefendMsg));
  p1Human->SetMarked(true);
  p1Menu->AddItem(p1Human);
  p1Menu->AddItem(p1Attack);
  p1Menu->AddItem(p1Balanced);
  p1Menu->AddItem(p1Defense);
  p1Menu->SetRadioMode(true);
  bar->AddItem(p1Menu);
  
  BMenu *p2Menu = new BMenu("Player 2", B_ITEMS_IN_COLUMN);
  BMenuItem *p2Human = new BMenuItem("Human", new BMessage(kP2HumanMsg));
  BMenuItem *p2Attack = new BMenuItem("Offensive", new BMessage(kP2AttackMsg));
  BMenuItem *p2Balanced = new BMenuItem("Balanced", new BMessage(kP2BalancedMsg));
  BMenuItem *p2Defense = new BMenuItem("Defensive", new BMessage(kP2DefendMsg));
  p2Balanced->SetMarked(true);
  p2Menu->AddItem(p2Human);
  p2Menu->AddItem(p2Attack);
  p2Menu->AddItem(p2Balanced);
  p2Menu->AddItem(p2Defense);
  p2Menu->SetRadioMode(true);
  bar->AddItem(p2Menu);
    
  BMenu *sizeMenu = new BMenu("Size", B_ITEMS_IN_COLUMN);
  BMenuItem *size3 = new BMenuItem("3", new BMessage(kSizeBaseMsg+3), '3');
  BMenuItem *size4 = new BMenuItem("4", new BMessage(kSizeBaseMsg+4), '4');
  BMenuItem *size5 = new BMenuItem("5", new BMessage(kSizeBaseMsg+5), '5');
  BMenuItem *size6 = new BMenuItem("6", new BMessage(kSizeBaseMsg+6), '6');
  size4->SetMarked(true);
  sizeMenu->AddItem(size3);
  sizeMenu->AddItem(size4);
  sizeMenu->AddItem(size5);
  sizeMenu->AddItem(size6);
  sizeMenu->SetRadioMode(true);
  
  BMenu *dimMenu = new BMenu("Dimensions", B_ITEMS_IN_COLUMN);
  BMenuItem *dim2 = new BMenuItem("2", new BMessage(kDimBaseMsg+2), '2', B_OPTION_KEY);
  BMenuItem *dim3 = new BMenuItem("3", new BMessage(kDimBaseMsg+3), '3', B_OPTION_KEY);
  BMenuItem *dim4 = new BMenuItem("4", new BMessage(kDimBaseMsg+4), '4', B_OPTION_KEY);
  BMenuItem *dim5 = new BMenuItem("5", new BMessage(kDimBaseMsg+5), '5', B_OPTION_KEY);
  BMenuItem *dim6 = new BMenuItem("6", new BMessage(kDimBaseMsg+6), '6', B_OPTION_KEY);
  dim4->SetMarked(true);
  dimMenu->AddItem(dim2);
  dimMenu->AddItem(dim3);
  dimMenu->AddItem(dim4);
  dimMenu->AddItem(dim5);
  dimMenu->AddItem(dim6);
  dimMenu->SetRadioMode(true);
  
  BMenu *optMenu  = new BMenu("Options", B_ITEMS_IN_COLUMN);
  m_fastplayItem  = new BMenuItem("Fastplay", new BMessage(kFastplayMsg), 'F');
  BMenuItem *scoreWindItem = new BMenuItem("Show Score Window", new BMessage(kShowScoreMsg));
  BMenuItem *resetItem = new BMenuItem("Reset Scores", new BMessage(kResetScoreMsg));
  optMenu->AddItem(m_fastplayItem);
  optMenu->AddItem(scoreWindItem);
  optMenu->AddItem(resetItem);
  optMenu->AddItem(sizeMenu);
  optMenu->AddItem(dimMenu);

  BMenu *cellMenu = new BMenu("Cells", B_ITEMS_IN_COLUMN);
  BMenuItem *solidCell = new BMenuItem("Solid", new BMessage(kSolidCellMsg));
  BMenuItem *XOCell = new BMenuItem("X and O", new BMessage(kXOCellMsg));  
  solidCell->SetMarked(true);
  cellMenu->AddItem(solidCell);
  cellMenu->AddItem(XOCell);
  cellMenu->SetRadioMode(true);
  optMenu->AddItem(cellMenu);
  
  optMenu->AddSeparatorItem();
  optMenu->AddItem(new BMenuItem("About Hyper TTT", new BMessage(kShowAboutMsg)));
  
  bar->AddItem(optMenu);

  AddChild(bar);
  SetKeyMenuBar(bar);
  SetSizeLimits(100,4000,100,4000);
  
  m_InGame = 0;
  m_scoreWindOpen = 0;
  m_aboutWindOpen = 0;

}

void BeTTTWindow::SetGame(BeTTTGame *game)
{
  m_game = game;
}


void BeTTTWindow::DoNewGame()
{
  //if (!m_game->InGame())
  {
    m_game->StartGame();
  }
}

/*
void BeTTTWindow::SetApp(BeTTTApp *app)
{
  m_app = app;
}
*/

void BeTTTWindow::ShowScoreWindow()
{
  if (!m_scoreWindOpen)
  {
	BRect aRect;
	
	aRect.Set(415, 100, 610, 200);
	m_scoreWindow = new BWindow(aRect, "Hyper TTT Score", B_TITLED_WINDOW, B_NOT_RESIZABLE);
	
	aRect.OffsetTo(B_ORIGIN);
	m_scoreView = new BeScoreView(aRect, "Score Window");
    m_scoreView->SetParent(this);
    m_scoreView->SetGame(m_game);
    m_scoreWindow->AddChild(m_scoreView);
    
    m_scoreWindow->Show();
    
    m_scoreWindOpen = 1;
  }
  else
  {
    m_scoreWindow->Activate();
  }
}

void BeTTTWindow::ShowAboutWindow()
{
  if (!m_aboutWindOpen)
  {
	BRect aRect;
	
	aRect.OffsetTo(B_ORIGIN);
	m_aboutView = new BeAboutView(aRect, "About Window");
	m_aboutView->SetParent(this);

    aRect = m_aboutView->Bounds();
    aRect.OffsetTo(150, 150);
	m_aboutWindow = new BWindow(aRect, "About Hyper TTT", B_TITLED_WINDOW, B_NOT_RESIZABLE);
    
    m_aboutWindow->AddChild(m_aboutView);
    
    m_aboutWindow->Show();
    
    m_aboutWindOpen = 1;
  }
  else
  {
    m_aboutWindow->Activate();
  }
}

void BeTTTWindow::UpdateScore()
{
  if (m_scoreWindOpen)
  {
    m_scoreWindow->Lock();
    m_scoreView->Invalidate();
    m_scoreWindow->Unlock();
  }
}

void BeTTTWindow::ScoreWindowClosed()
{
  m_scoreWindOpen = 0;
}

void BeTTTWindow::AboutWindowClosed()
{
  m_aboutWindOpen = 0;
}

void BeTTTWindow::DChanged(int oldD, int newD, int n)
{
  //BRect b=Bounds();
  if (oldD%2==0 && newD%2==1)
  { // even to odd
    ResizeTo(325, 325/n);
  }
  else if (oldD%2==1 && newD%2==0)
  { // odd to even
    ResizeTo(325, 325);
  }
}

void BeTTTWindow::MessageReceived(BMessage *msg)
{
  switch (msg->what)
  {
    case kNewGameMsg :
      DoNewGame();
      break;
      
    case kQuitMsg :
      QuitRequested();
      break;
    
    case kP1HumanMsg : case kP1AttackMsg : 
    case kP1BalancedMsg : case kP1DefendMsg :
      m_game->SetStrategy(0, msg->what - kP1BaseMsg);
      break;
    
    case kP2HumanMsg : case kP2AttackMsg : 
    case kP2BalancedMsg : case kP2DefendMsg :
      m_game->SetStrategy(1, msg->what - kP2BaseMsg);
      break;
    
    case kSolidCellMsg :
      m_game->SetStyle(kSolidStyle);
      UpdateScore();
      break;
      
    case kXOCellMsg :
      m_game->SetStyle(kXOStyle);
      UpdateScore();
      break;
      
    case kFastplayMsg : 
      m_game->ToggleFastplay();
      m_fastplayItem->SetMarked(!m_fastplayItem->IsMarked());
      break;
      
    case kShowScoreMsg :
      ShowScoreWindow();
      break;
      
    case kResetScoreMsg :
      m_game->ResetScore();
      UpdateScore();
      break;
      
    case kShowAboutMsg :
      ShowAboutWindow();
      break;
      
    default:
      ulong msgval = msg->what;
      if ((msgval > kSizeBaseMsg) && (msgval < kSizeBaseMsg+10))
      {
        m_game->SetN(msgval - kSizeBaseMsg);
      }
      else if ((msgval > kDimBaseMsg) && (msgval < kDimBaseMsg+10))
      {
        m_game->SetD(msgval - kDimBaseMsg);
      }
  }
}



bool BeTTTWindow::QuitRequested()
{
  if (m_scoreWindOpen)
  {
    m_scoreWindow->PostMessage(B_QUIT_REQUESTED);
  }
  if (m_aboutWindOpen)
  {
    m_aboutWindow->PostMessage(B_QUIT_REQUESTED);
  }
  
  m_game->KillThread();

  be_app->PostMessage(B_QUIT_REQUESTED);
  return(TRUE);
}
