/*****************************************************************************

	Projet	: Droids

	Fichier	:	bCSound.h
	Partie	: Sons

	Auteur	: RM
	Date		: 210297 -- release today !! yeah !
	Format	: tabs==2

	Liste des sons dans "Nerdkill/nerdkill_sound":



*****************************************************************************/

#include "machine.h"
#include "bCSound.h"
#include "gCSem.h"

#ifdef B_BEOS_VERSION_3
	#include <AudioStream.h>		// from /boot/develop/headers/be/media
	#include <Subscriber.h>
#endif


//---------------------------------------------------------------------------
//---------------------------------------------------------------------------


//***************************************************************************
CSound::CSound(void)
//***************************************************************************
{
	#ifdef B_BEOS_VERSION_3
		mAudioSub = NULL;
		mAudioStream = NULL;
	#elif B_BEOS_VERSION_4
		mSoundPlayer = NULL;
	#endif

	mNbLoadRepeat = 0;
	mNbLoadSingle = 0;

	mNbRepeat = 0;
	mNbSingle = 0;

	mSingle = NULL;
	mRepeat = NULL;

} // end of constructor for CSound


//***************************************************************************
CSound::~CSound(void)
//***************************************************************************
{
	printf("CSound::~CSound\n");

	stop();

	if (mRepeat) delete [] mRepeat;
	if (mSingle) delete [] mSingle;
} // end of destructor for CSound


//---------------------------------------------------------------------------


//***************************************************************************
BOOL CSound::init(void)
//***************************************************************************
{
	printf("CSound::init\n");
	// return FALSE; // -- debug to disable all sound

	#ifdef B_BEOS_VERSION_3
		mAudioStream = new BDACStream();
		printf("mBDACStream AudioStream %p\n", mAudioStream);
		mAudioStream->SetSamplingRate(44100);
		mAudioSub = new BSubscriber("bCSound");
		printf("BSubscriber mAudioSub %p\n", mAudioStream);
		if (!mAudioSub || !mAudioStream) return FALSE;
	#elif B_BEOS_VERSION_4
		//media_raw_audio_format format = {44100.0, 2, media_raw_audio_format::B_AUDIO_SHORT,
		//																 B_MEDIA_LITTLE_ENDIAN, 4*1024};

		mSoundPlayer = new BSoundPlayer(/*&format,*/ "MerdkillMixer", CSound::sPlayBuffer, NULL, (void *)this);
		if (!mSoundPlayer) return FALSE;
	#endif

	if (!mSingleSem.init()) return FALSE;
	if (!mRepeatSem.init()) return FALSE;

	mSingle = new SSound[K_MAX_SINGLE];
	mRepeat = new SSound[K_MAX_REPEAT];
	if (!mRepeat || !mSingle) return FALSE;

	app_info info;
	BEntry fichier,dummy;
	BDirectory parent;
	status_t result;

	be_app->GetAppInfo(&info);
	result=fichier.SetTo(&info.ref);
	if (!result) result=fichier.GetParent(&parent);
	//if (!result) result=parent.GetDirectory(K_SOUND_DIR_NAME, &mDirSon);
	if (!result) result=parent.FindEntry(K_SOUND_DIR_NAME, &dummy);
	if (!result) result=mDirSon.SetTo(&dummy);
	if (result) return FALSE;

	// subscribe to out stream
	// stream is NOT reconfigured.
	// stream is expected to be 44100 Hz, 16 bits, stereo, LINEAR, BIG ENDIAN.
	//if (mAudio->Subscribe(B_DAC_STREAM, B_INVISIBLE_SUBSCRIBER_ID, false)
	//		!= B_NO_ERROR) return FALSE;
	#ifdef B_BEOS_VERSION_3
		if (mAudioSub->Subscribe(mAudioStream) != B_NO_ERROR) return FALSE;
	#elif B_BEOS_VERSION_4
	#endif

	return TRUE;
} // end of init for CSound


//***************************************************************************
void CSound::start(void)
//***************************************************************************
{
	printf("CSound::start\n");

	#ifdef B_BEOS_VERSION_3
		if (mAudioSub)
			mAudioSub->EnterStream(NULL, FALSE, (void *)this, CSound::streamEntry, NULL, TRUE);
	#elif B_BEOS_VERSION_4
		if (mSoundPlayer)
		{
			mSoundPlayer->Start();
			mSoundPlayer->SetHasData(true);
		}
	#endif

} // end of start for CSound


//***************************************************************************
void CSound::stop(void)
//***************************************************************************
{
	printf("CSound::stop\n");

	#ifdef B_BEOS_VERSION_3
		if (mAudioSub)
		{
			mAudioSub->ExitStream(TRUE);
			//mAudio->Unsubscribe();
			delete mAudioSub;
			delete mAudioStream;
			mAudioSub = NULL;
			mAudioStream = NULL;
		}
	#elif B_BEOS_VERSION_4
		if (mSoundPlayer)
		{
			mSoundPlayer->Stop();
			delete mSoundPlayer;
			mSoundPlayer = NULL;
		}
	#endif

} // end of stop for CSound


//---------------------------------------------------------------------------
//---------------------------------------------------------------------------


#ifdef B_BEOS_VERSION_3

	//***************************************************************************
	bool CSound::streamEntry(void *user, char *buffer, size_t size, void * /*header*/)
	//***************************************************************************
	{
		if (!user || !buffer || !size) return TRUE;
		CSound *elThis = (CSound *)user;
		elThis->process(buffer, size);
		return TRUE;
	} // end of streamEntry for CSound

#elif B_BEOS_VERSION_4

	//*************************************************************
	void CSound::sPlayBuffer(void *user, void *buffer, size_t size,
													 const media_raw_audio_format &format)
	//*************************************************************
	{
		if (!user || !buffer || !size) return;

		CSound *elThis = (CSound *)user;
		if (format.format == media_raw_audio_format::B_AUDIO_SHORT)
			elThis->process((char *)buffer, (long)size);

		// we asked for SHORT format when creating the BSoundPlayer class.
		// Nevertheless, R4 Media Kit doesn't care and will ask for FLOATs here
		// so we nethertheless need to implement this if we want sound :(
		if (format.format == media_raw_audio_format::B_AUDIO_FLOAT)
			elThis->processFloat((float *)buffer, (long)size); 
		
	} // end of sPlayBuffer for CSound

#endif


//***************************************************************************
void CSound::process(char *buffer, long size)
//***************************************************************************
/*
	stream is expected to be 44100 Hz, 16 bits, stereo, LINEAR, BIG ENDIAN.
	sound buffers are 22050 Hz, 16 bits, mono.

	A buffer is size bytes long.
	Stream sample (one sample is 16 bits stereo) is 4 bytes.
	Expected buffer size is 4096 = 4kb.
	Thus a buffer is expected to be 1k samples.

	Sound buffer sample is 16 bits mono thus 2 bytes -- dived by 2.
	Sound buffers are 22050 Hz -- divided by 2.
	So a stream buffer is 1k samples and must be filled with 256 sound buffer samples.

	Algo : 
	- read sound buffer sample
	- it's a 16 bit word
	- duplicate it to make it stereo
	- write two words
	- (change words to linearly interpolate / optional)
	- write to more words since stream buffer is 44100 Hz. 

	Reminder : reads 2 bytes, writes 8.

*/
{
WORD *buf;
ULONG size2;
ULONG nbTotal = mNbRepeat+mNbSingle;
ULONG i;

	if (!nbTotal) return;

	size2 = size/sizeof(WORD);

	// add singles
	//mSingleSem.acquire();
	for(i=0; i<mNbLoadSingle; i++)
		if (mSingle[i].play)
		{
			ULONG offset = mSingle[i].offset;	// current sound buf start offset in bytes
			ULONG count;		// number of sound sample bytes to transfer : size/4
			ULONG count2;
										// since reads 2, writes 8 -> ratio is 4.
			// must not get over sound buffer realsize
			count = min((ULONG)size/4, mSingle[i].realSize-offset);
			count /= 2;	// count is now number of sound samples to transfer

			WORD *source = mSingle[i].data + (offset/sizeof(WORD));
			buf = (WORD *)buffer;

			for(count2 = count; count>0; count--)
			{
				long s;
				// read first sound sample -- signed
				s = *(source++);

				#if 1 	// ifdef B_BEOS_VERSION_3
					// in BeOS R3, output sound is mixed with incoming one
					
					long a, b;

					// write it down two times -- make it stereo
					b = *buf;
					a = b+(s /* / 2 */);
					if (a > 32767) a = 32767;
					else if (a < -32767) a = -32767;
					*(buf++) = a;
	
					b = *buf;
					a = b+(s /* / 2 */);
					if (a > 32767) a = 32767;
					else if (a < -32767) a = -32767;
					*(buf++) = a;
	
					// interpolate with next sample if needed
					// thus transforming 22050 into 44100
	
					// write it down two times -- stero + 44100
					b = *buf;
					a = b+(s /* / 2 */);
					if (a > 32767) a = 32767;
					else if (a < -32767) a = -32767;
					*(buf++) = a;
	
					b = *buf;
					a = b+(s /* / 2 */);
					if (a > 32767) a = 32767;
					else if (a < -32767) a = -32767;
					*(buf++) = a;

				#elif B_BEOS_VERSION_4
					// in BeOS R4, like in most usable systems, the buffers here are just
					// for outputing sound that will get mixed by a real system level mixer.

					#if 1
						// simple code that justs do it
						*(buf++) = s;
						*(buf++) = s;
						*(buf++) = s;
						*(buf++) = s;
					#else
						// typicall I-just-read-the-Intel-sheet Pentium optim
						// i.e. better read-comp-write than force a write through the cache
						WORD b;
						b = buf[0];	if (b != s) buf[0] = s;
						b = buf[1];	if (b != s) buf[1] = s;
						b = buf[2];	if (b != s) buf[2] = s;
						b = buf[3];	if (b != s) buf[3] = s;
						buf += 4;
					#endif
				#endif

			}
			// remind offset for next play
			offset += count2 * sizeof(WORD);
			mSingle[i].offset = offset;
			mSingle[i].play = (offset < mSingle[i].realSize);
			if (!mSingle[i].play && mSingle[i].count > 0)
			{
				mSingle[i].play = true;
				mSingle[i].count--;
			}
			if (!mSingle[i].play)
				mNbSingle = (mNbSingle > 0 ? mNbSingle-- : 0);
		}
	//mSingleSem.release();

	//mRepeatSem.acquire();
	//mRepeatSem.release();
} // end of process for CSound


//***************************************************************************
void CSound::processFloat(float *buffer, long size)
//***************************************************************************
/*
	Same comments than the previous process() function.

	Fucking workaround for R4.
	We asked for SHORT format when creating the BSoundPlayer class.
	Nevertheless, R4 Media Kit doesn't care and will ask for FLOATs here
	so we nethertheless need to implement this if we want sound :(
*/
{
float *buf;
ULONG size2;
ULONG nbTotal = mNbRepeat+mNbSingle;
float *maxpos = buffer;
ULONG i;

	if (!nbTotal) return;

	size2 = size/sizeof(float);

	//printf("CSound::processFloat -- buffer %p, size %d -- size2 %d\n", buffer, size, size2);

	float *end = (float *)((char *)buffer+size);
	for(;maxpos < end;) *(maxpos++) = 0.f;
	//maxpos = buffer;

	for(i=0; i<mNbLoadSingle; i++)
		if (mSingle[i].play)
		{
			ULONG offset = mSingle[i].offset;	// current sound buf start offset in bytes
			ULONG count;		// number of sound sample bytes to transfer : size/4
			ULONG count2;

			// since reads 1 word, writes 4 float.
			// must not get over sound buffer realsize
			// count is now number of sound samples to transfer
			count = min((ULONG)size2/4, (mSingle[i].realSize-offset)/sizeof(WORD));

			WORD *source = mSingle[i].data + (offset/sizeof(WORD));
			buf = buffer;

			//printf("  sample [%02ld] -- size2 %ld -- realsize %ld -- offset %ld -- count %ld\n", i, size2, mSingle[i].realSize, offset, count);

			// TBDL optim if nbTotal==1 just overwrite buffer
			for(count2 = count; count>0; count--)
			{
				WORD s;
				float f,a;

				// read first sound sample -- signed
				s = *(source++);

				// make it a float
				f = (float)s/(float)32768.0;

				// TBDL optim needed here to divide float N+1 when writing float N
				a = buf[0]+f; if (a>1.0) a=1.0; else if (a<-1.0) a=-1.0;	buf[0]=a;
				a = buf[1]+f; if (a>1.0) a=1.0; else if (a<-1.0) a=-1.0;	buf[1]=a;
				a = buf[2]+f; if (a>1.0) a=1.0; else if (a<-1.0) a=-1.0;	buf[2]=a;
				a = buf[3]+f; if (a>1.0) a=1.0; else if (a<-1.0) a=-1.0;	buf[3]=a;
				buf += 4;
			}
			
			// get maxpos
			//if (buf > maxpos) maxpos = buf;

			// remind offset for next play
			offset += count2 * sizeof(WORD);
			mSingle[i].offset = offset;
			mSingle[i].play = (offset < mSingle[i].realSize);
			if (!mSingle[i].play && mSingle[i].count > 0)
			{
				mSingle[i].play = true;
				mSingle[i].count--;
			}
			if (!mSingle[i].play)
				mNbSingle = (mNbSingle > 0 ? mNbSingle-- : 0);
		}


} // end of process for CSound



//---------------------------------------------------------------------------


//***************************************************************************
BOOL CSound::loadAllSound(void)
//***************************************************************************
{
long i;
WORD *buf;
ULONG size;

#define K_NB_SINGLE 23
char single[K_NB_SINGLE][256] =
{
	"nerd_in.22m",
	"nerd_out.22m",
	"n_gun.22m",
	"n_elec1.22m",
	"n_select.22m",
	"n_explos.22m",
	"n_mine.22m",
	"nerdfun1.22m",
	"nerdfun2.22m",
	"nerdfun3.22m",
	"nerdfun4.22m",
	"nerdfun5.22m",
	"n_ah1.22m",
	"n_ah2.22m",
	"n_ah3.22m",
	"n_ah4.22m",
	"n_ah5.22m",
	"n_ah6.22m",
	"n_ah7.22m",
	"n_ah8.22m",
	"n_ah9.22m",
	"n_ah10.22m",
	"n_roul2.22m"
};

#define K_NB_REPEAT 2
char repeat[K_NB_REPEAT][256] =
{
 "n_gun.22m",
	"n_roul1.22m"
};

	for(i=0; i<K_NB_SINGLE; i++)
	{
		// ---- load old sounds at 22kHz,mono,8 bits --
		BFile fichier;
		struct stat file_st;
		char st[256];
		sprintf(st,"%s_8", single[i]);
		//if (mDirSon.GetFile(st, &fichier) < B_NO_ERROR) return FALSE;
		//if (fichier.Open(B_READ_ONLY) < B_NO_ERROR) return FALSE;
		//size = fichier.Size();

		printf("Loading sound %s\n", st);

		BEntry dummy;
		if (mDirSon.FindEntry(st, &dummy) < B_NO_ERROR) return FALSE;
		if (fichier.SetTo(&dummy, B_READ_ONLY) < B_NO_ERROR) return FALSE;
		if (fichier.GetStat(&file_st) < B_NO_ERROR) return FALSE;
		size = file_st.st_size;

		BYTE *buf1 = new BYTE[size];
		if (!buf1) return FALSE;
		ULONG nb = fichier.Read(buf1, size);
		if (nb != size) return FALSE;
		// -- and converts to 16 bits by adding a zero
		buf = new WORD[size];
		if (!buf) return FALSE;
		BYTE *b=buf1;
		WORD *w=buf;
		for(long i=size; i>0; i--, b++, w++) *w = (*b)<<8;
		delete buf1;

		SSound *p = mSingle;
		p+=mNbLoadSingle;
		mSingle[mNbLoadSingle].repeat = false;
		p->repeat = false;
		if (!loadSound(&(mSingle[mNbLoadSingle]), buf, size*sizeof(WORD))) return FALSE;
		mNbLoadSingle++;

		/* -- load old sounds at 22kHz,mono,16 bits --
		if(0)
		{
		BFile fichier;
		if (mDirSon.GetFile(single[i], &fichier) < B_NO_ERROR) return FALSE;
		if (fichier.Open(B_READ_ONLY) < B_NO_ERROR) return FALSE;
		size = fichier.Size();
		buf = new WORD[size / sizeof(WORD) +1];
		if (!buf) return FALSE;
		long nb = fichier.Read(buf, size);
		if (nb != size) return FALSE;
		SSound *p = mSingle;
		p+=mNbLoadSingle;
		mSingle[mNbLoadSingle].repeat = false;
		p->repeat = false;
		if (!loadSound(&(mSingle[mNbLoadSingle]), buf, size)) return FALSE;
		mNbLoadSingle++;

		if (1) -- and saves them as 22kHz,mono,8 bits
		{
			BFile fichier2;
			long sz = (size/2);
			char s[512];
			sprintf(s,"%s_8",single[i]);
			mDirSon.Create(s, &fichier2);
			BYTE *buf2 = new BYTE[sz];
			BYTE *b=buf2;
			BYTE *w=(BYTE *)buf;
			for(long i=sz; i>0; i--, b++, w+=2) *b = *w;
			fichier2.Open(B_READ_WRITE);
			fichier2.Write(buf2,sz);
			fichier2.Close();
			delete buf2;
		}
		}
		*/

		delete buf;
		//if (fichier.Close() < B_NO_ERROR) return FALSE;
	}

	for(i=0; i<K_NB_REPEAT; i++)
	{
		BFile fichier;
		//if (mDirSon.GetFile(repeat[i], &fichier) < B_NO_ERROR) return FALSE;
		//if (fichier.Open(B_READ_ONLY) < B_NO_ERROR) return FALSE;
		//size = fichier.Size();

		BEntry dummy;
		struct stat file_st;
		if (mDirSon.FindEntry(repeat[i], &dummy) < B_NO_ERROR) return FALSE;
		if (fichier.SetTo(&dummy, B_READ_ONLY) < B_NO_ERROR) return FALSE;
		if (fichier.GetStat(&file_st) < B_NO_ERROR) return FALSE;
		size = file_st.st_size;

		buf = new WORD[size / sizeof(WORD) +1];
		if (!buf) return FALSE;
		if (fichier.Read(buf, size) < B_NO_ERROR) return FALSE;
		mRepeat[mNbLoadRepeat].repeat = TRUE;
		if (!loadSound(&(mRepeat[mNbLoadRepeat]), buf, size)) return FALSE;
		mNbLoadRepeat++;
		delete buf;
		//if (fichier.Close() < B_NO_ERROR) return FALSE;
	}

	return TRUE;

} // end of loadAllSound for CSound



//***************************************************************************
BOOL CSound::loadSound(SSound *sound, WORD *buf, ULONG realsize)
//***************************************************************************
{
ULONG alloc, diff;
WORD *p;

	alloc = (realsize+4095) & 0x7FFFf000;
	diff = alloc-realsize;

	sound->realSize = realsize;
	sound->allocSize = alloc;
	sound->data = new WORD[alloc/sizeof(WORD)+1];
	if (!sound->data) return FALSE;

	memcpy(sound->data, buf, realsize);

	p = sound->data + (realsize/sizeof(WORD));
	if (sound->repeat)
		memcpy(p, buf, diff);
	else
		memset(p, 0, diff);

	sound->play = FALSE;
	sound->offset = 0;

	return TRUE;

} // end of loadSound for CSound


//---------------------------------------------------------------------------


//***************************************************************************
void CSound::addSingle(ULONG index)
//***************************************************************************
{
	if (index >= mNbLoadSingle) return;
//	mSingleSem.acquire();
//	if (mSingle[index].play)
//		mSingle[index].count++;
//	else
	{
		mSingle[index].play = true;
		mSingle[index].offset = 0;
		mSingle[index].count = 0;
		mNbSingle++;
	}
//	mSingleSem.release();
} // end of addSingle for CSound


//***************************************************************************
BOOL CSound::hasSingle(ULONG index)
//***************************************************************************
{
	if (index >= mNbLoadSingle) return FALSE;
	return (mSingle[index].play || (mSingle[index].count>0));
} // end of hasSingle for CSound


//***************************************************************************
void CSound::addRepeat(ULONG index)
//***************************************************************************
{
	if (index >= mNbLoadRepeat) return;
	mRepeatSem.acquire();
	if (!mRepeat[index].play)
	{
		mRepeat[index].play = true;
		mRepeat[index].offset = 0;
		mNbRepeat++;
	}
	mRepeatSem.release();
} // end of addRepeat for CSound


//***************************************************************************
void CSound::removeRepeat(ULONG index)
//***************************************************************************
{
	if (index >= mNbLoadRepeat) return;
	mRepeatSem.acquire();
	if (mRepeat[index].play)
	{
		mRepeat[index].play = false;
		mNbRepeat--;
	}
	mRepeatSem.release();
} // end of removeRepeat for CSound


//***************************************************************************
void CSound::toggleRepeat(ULONG index)
//***************************************************************************
{
	if (index >= mNbLoadRepeat) return;
	mRepeatSem.acquire();
	if (mRepeat[index].play)
	{
		mRepeat[index].play = false;
		mNbRepeat--;
	}
	else
	{
		mRepeat[index].play = true;
		mRepeat[index].offset = 0;
		mNbRepeat++;
	}
	mRepeatSem.release();
} // end of toggleRepeat for CSound


//***************************************************************************
BOOL CSound::hasRepeat(ULONG index)
//***************************************************************************
{
	if (index >= mNbLoadRepeat) return FALSE;
	return mRepeat[index].play;
} // end of hasRepeat for CSound


//---------------------------------------------------------------------------

// eoc
