/*****************************************************************************

	Projet	: Droids

	Fichier	:	bCVideo.cpp
	Partie	: Video

	Auteur	: RM
	Date		: 110297
	Format	: tabs==2

*****************************************************************************/

#include "machine.h"
#include "gCVideo.h"
#include "bCWinEcran.h"
#include "bCGifReader.h"
#include "gCMoteur.h"

//---------------------------------------------------------------------------


//***************************************************************************
CVideo::CVideo(void)
//***************************************************************************
{
	mNbSprite = 0;
	mSprite = NULL;
	mWinEcran = NULL;
	mEcran[0] = NULL;
	mLenEcran[0] = 0;
	mBprEcran[0] = 0;
	mEcran[1] = NULL;
	mLenEcran[1] = 0;
	mBprEcran[1] = 0;
	mSpriteFond = -2;
	mSpriteFullFond = -3;
	mScrollX = 0;
	mScrollY = 0;
	mSpriteMode=0;
	mScoreBitmap = NULL;
	mScoreView = NULL;
	mScoreNerd = 0;
	mScoreAction = 0;
} // end of constructor for CVideo


//***************************************************************************
CVideo::~CVideo(void)
//***************************************************************************
{
	printf("CVideo::~CVideo -- destructor\n");
	// HINT : special case for background pict : the same is used twice, allocated once.
	if (mSprite && mSpriteFond<mNbSprite) mSprite[mSpriteFond].data[1] = NULL;
	if (mSprite && mSpriteFullFond<mNbSprite) mSprite[mSpriteFullFond].data[1] = NULL;
	// now safely erase picts
	if (mSprite) delete [] mSprite;
	mSprite = NULL;
} // end of destructor for CVideo


//---------------------------------------------------------------------------


//***************************************************************************
BOOL CVideo::init(void)
//***************************************************************************
{
app_info info;
BEntry fichier,dummy;
BDirectory parent;
status_t result;

	printf("CVideo::init\n");

	be_app->GetAppInfo(&info);
	result=fichier.SetTo(&info.ref);
	if (!result) result=fichier.GetParent(&parent);
	if (!result) result=parent.FindEntry("nerdkill_img", &dummy);
	if (!result) result=mDirImg.SetTo(&dummy);
	if (result) return FALSE;

	if(!loadSprite("sph4_nerdkill.gif", "pulco_nerdkill.gif", "pulco_nerdfond.gif"))
	{
		printf("Can't load sprites\n");
		return FALSE;
	}

	// ouvre fenetres
	mWinEcran 	 = new CWinEcran(BRect(100,30,100+640-1,30+480-1), "Nerdkill");
	if (!mWinEcran) return FALSE;
	if (!mWinEcran->init()) return FALSE;
	if (!mWinEcran->ecran1()->getVideoBase(mEcran[0], mLenEcran[0], mBprEcran[0])) return FALSE;
	if (!mWinEcran->ecran2()->getVideoBase(mEcran[1], mLenEcran[1], mBprEcran[1])) return FALSE;

	#define K_SCORE_RECT BRect(0,0,3*32-1,1*32-1)
	mScoreBitmap = new BBitmap(K_SCORE_RECT, B_COLOR_8_BIT, TRUE);
	if (!mScoreBitmap) return FALSE;
	mScoreView = new BView(K_SCORE_RECT, "score font renderer", B_FOLLOW_NONE, 0L);
	if (!mScoreView) return FALSE;
	if (mScoreBitmap->Lock())
	{
/*
		mScoreBitmap->AddChild(mScoreView);
		mScoreView->SetFontName("Emily");
		mScoreView->SetHighColor(255,255,255);
		mScoreView->SetLowColor(0,0,0);
		mScoreView->FillRect(K_SCORE_RECT);
		mScoreView->DrawString("Select grafx in\nmain menu !", BPoint(1,10));
*/
		mScoreBitmap->Unlock();
	}

	return TRUE;

} // end of init for CVideo


//---------------------------------------------------------------------------


//***************************************************************************
void CVideo::setScroll(ULONG x, ULONG y)
//***************************************************************************
{
	mScrollX = x;
	mScrollY = y;
	mWinEcran->setScroll(x,y);
} // end of setScroll for CVideo


//***************************************************************************
void CVideo::redraw(ULONG mask)
//***************************************************************************
{
	//BStopWatch toto("  CVideo::redraw");
	if (mask & 0x1)	mWinEcran->ecran1()->redraw();
	if (mask & 0x2) mWinEcran->ecran2()->redraw();
} // end of redraw for CVideo


//***************************************************************************
void CVideo::clearScreen(ULONG mask)
//***************************************************************************
{
	//BStopWatch toto("  CVideo::clearScreen");
	if (mask & 0x1)
	{
		//memset(mEcran[0], 0, mLenEcran[0]);

/*
		long x,y;
		long x1,y1,x2,y2,x3,y3;

		x1 = mScrollX;
		y1 = mScrollY;
		x2 = x1+640;
		y2 = y1+480-128;
		for(y=0, y3=0; y<2; y++, y3+=480)
			if ((y1 >= y3 && y1 < y3+480) || (y2 >= y3 && y2 < y3+480))
				for(x=0, x3=0; x<3; x++, x3+=640)
					if ((x1 >= x3 && x1 < x3+640) || (x2 >= x3 && x2 < x3+640))
						blitSpriteNoMask(x3,y3,mSpriteFond,0);
*/
		//blitSpriteNoMask(0,0,mSpriteFullFond,0);
		blitSpriteFull(mSpriteFullFond,0);
	}
	if (mask & 0x2) memset(mEcran[1], 0, mLenEcran[1]);
} // end of clearScreen for CVideo


//***************************************************************************
void CVideo::blitSpriteFull(ULONG sprite, ULONG ecran)
//***************************************************************************
{
SbSprite *sp;
UBYTE *dest;
long bpr;
UBYTE *data;
long sx;
long sy;

	sp = &mSprite[sprite];

	bpr = mBprEcran[ecran];
	dest = mEcran[ecran];
	data = sp->data[mSpriteMode];
	sx = sp->sx;
	sy = sp->sy;

//printf("bpr %ld -- sx %ld -- sx*sy %ld\n", bpr, sx, sx*sy);
	if (bpr == sx)
	{
		//BStopWatch toto("blitSpriteFull");
		memcpy(dest, data, sx*sy);
	}
	else
	{
		for(long i=0; i<sy; i++, dest+=bpr, data+=sx)
			memcpy(dest, data, sx);
	}
} // end of blitSpriteFull for CVideo


//***************************************************************************
void CVideo::blitSpriteNoMask(long x, long y, ULONG sprite, ULONG ecran)
//***************************************************************************
{
SbSprite *sp;
UBYTE *dest;
long bpr;
UBYTE *data;
long sx;
long sy;

	sp = &mSprite[sprite];

	bpr = mBprEcran[ecran];
	dest = mEcran[ecran]+x+bpr*y;
	data = sp->data[mSpriteMode];
	sx = sp->sx;
	sy = sp->sy;
	
	// copie rapide sans masque
	for(; sy>0; sy--, dest+=bpr, data+=sx)
		memcpy(dest, data, sx);
} // end of blitSpriteNoMask for CVideo


//***************************************************************************
void CVideo::blitSpriteMask(long x, long y, ULONG sprite, ULONG ecran)
//***************************************************************************
{
SbSprite *sp;
UBYTE *dest, *dest2;
long bpr;
UBYTE *data;
long sx;
long sy;

	sp = &mSprite[sprite];

	bpr = mBprEcran[ecran];
	dest = mEcran[ecran]+x+bpr*y;
	data = sp->data[mSpriteMode];
	sx = sp->sx;
	sy = sp->sy;

//if (ecran)
//	printf("CVideo::blitSpriteMask <x y sp ec> %3d %3d %2d %d -- <sx sy> %3d %3d -- <bpr data mask> %3d %p %p\n",
//		x,y,sprite,ecran, sx, sy, bpr, data, mask);

	// copie (moins) rapide avec masque
	for(; sy>0; sy--, dest+=bpr)
	{
		dest2 = dest;
		for(x=0; x<sx; x++, dest2++, data++)
		{
			register UBYTE b = *data;
			if (b) *dest2 = b;
		}
	}


} // end of blitSpriteMask for CVideo


//***************************************************************************
void CVideo::blitSpriteFond(long x, long y, ULONG sprite)
//***************************************************************************
{
SbSprite *spFond = &mSprite[mSpriteFullFond];
SbSprite *sp;
UBYTE *dest, *dest2;
long bpr;
UBYTE *data;
long sx;
long sy;

	sp = &mSprite[sprite];

	bpr = spFond->sx;
	dest = spFond->data[mSpriteMode]+x+bpr*y;
	data = sp->data[mSpriteMode];
	sx = sp->sx;
	sy = sp->sy;

	// copie (moins) rapide avec masque
	for(; sy>0; sy--, dest+=bpr)
	{
		dest2 = dest;
		for(x=0; x<sx; x++, dest2++, data++)
		{
			register UBYTE b = *data;
			if (b) *dest2 = b;
		}
	}


} // end of blitSpriteFond for CVideo



//***************************************************************************
void CVideo::setScore(UWORD scoreNerd, UWORD scoreAction)
//***************************************************************************
{
	mScoreNerd = scoreNerd;
	mScoreAction = scoreAction;

} // end of setScore for CVideo


//***************************************************************************
void CVideo::drawScore(void)
//***************************************************************************
{
/*
char st[30];
	if (!mScoreBitmap->Lock()) return;
	mScoreView->SetHighColor(0,0,0);
	mScoreView->SetLowColor(255,255,255);
	mScoreView->SetDrawingMode(B_OP_COPY);
	mScoreView->FillRect(K_SCORE_RECT);
	mScoreView->SetDrawingMode(B_OP_INVERT);
	mScoreView->DrawString("Nerds alive", BPoint(0,15));
	mScoreView->DrawString("Shoots", BPoint(0,30));
	sprintf(st, ": %d", mScoreNerd);
	mScoreView->DrawString(st, BPoint(68,15));
	sprintf(st, ": %d", mScoreAction);
	mScoreView->DrawString(st, BPoint(68,30));
	mScoreView->Sync();

	long lpr = mBprEcran[1];
	UBYTE *p = mEcran[1]+4*64+10+10*lpr;
	UBYTE *s = (UBYTE *)mScoreBitmap->Bits();
	long bpr = mScoreBitmap->BytesPerRow();
	lpr-=bpr;
	long x,y;
	for(y=31; y>0; y--, p+=lpr)
	{
		for(x=bpr; x>0; x--, p++)
		{
			UBYTE a=*(s++);
			if (a>=63) *p = 63;
		}
	}
	mScoreBitmap->Unlock();
*/
} // end of drawScrore for CVideo


//---------------------------------------------------------------------------


//***************************************************************************
BOOL CVideo::loadSprite(CHAR *sprite1, CHAR *sprite2, CHAR *fondname)
//***************************************************************************
/*
*/
{
BFile fichier1,fichier2,fichier3;
UBYTE *packedImage[2], *packedFond, *unpackedImage[2];
long packedImgLength[2], packedFondLength, unpackedLength[2];
CGifReader gifDecoder1, gifDecoder2, gifDecoder3;
long i;
long nb;
BEntry dummy;
struct stat file_st;

	// --- chargement table des sprites ---
	try
	{
		printf("loadSprite \"%s\"\n", sprite1);
		if (mDirImg.FindEntry(sprite1, &dummy) < B_NO_ERROR) return FALSE;
		if (fichier1.SetTo(&dummy, B_READ_ONLY) < B_NO_ERROR) return FALSE;
		if (fichier1.GetStat(&file_st) < B_NO_ERROR) return FALSE;
		packedImgLength[0] = file_st.st_size;
	
		packedImage[0] = new UBYTE[packedImgLength[0]];
		if (!packedImage[0]) return FALSE;
		nb = fichier1.Read(packedImage[0], packedImgLength[0]);
		if (nb != packedImgLength[0]) return FALSE;
	
		//---
/*	
		printf("loadSprite \"%s\"\n", sprite2);
		if (mDirImg.FindEntry(sprite2, &dummy) < B_NO_ERROR) return FALSE;
		if (fichier2.SetTo(&dummy, B_READ_ONLY) < B_NO_ERROR) return FALSE;
		if (fichier2.GetStat(&file_st) < B_NO_ERROR) return FALSE;
		packedImgLength[1] = file_st.st_size;
	
		packedImage[1] = new UBYTE[packedImgLength[1]];
		if (!packedImage[1]) return FALSE;
		nb = fichier2.Read(packedImage[1], packedImgLength[1]);
		if (nb != packedImgLength[1]) return FALSE;
*/	
		//---
	
		if (!gifDecoder1.decoder(packedImage[0],		packedImgLength[0],
													 unpackedImage[0], unpackedLength[0], sph_palette))
													 return FALSE;
		sph_index_noir = unpackedImage[0][638];
/*	
		if (!gifDecoder3.decoder(packedImage[1],		packedImgLength[1],
													 unpackedImage[1], unpackedLength[1])) return FALSE;
*/	
		// image must be 640x480x8 bits
		if (unpackedLength[0] < 640*480) return FALSE;
//		if (unpackedLength[1] < 640*480) return FALSE;
	
		mNbAllocSprite = 50;
		mSprite = new SbSprite[mNbAllocSprite];
		if (!mSprite) return FALSE;
		mNbSprite = 0;
	
		// extract sprites from image
		// 0:immobile, 2:droite, 4:haut, 6:gauche, 8:bas
		for(i=0; i<2; i++)	extractSprite(unpackedImage, unpackedLength, i+0,0, 1,1);
		for(i=0; i<2; i++)	extractSprite(unpackedImage, unpackedLength, i+2,0, 1,1);
		for(i=0; i<2; i++)	extractSprite(unpackedImage, unpackedLength, i+0,2, 1,1);
		for(i=0; i<2; i++)	extractSprite(unpackedImage, unpackedLength, i+2,1, 1,1);
		for(i=0; i<2; i++)	extractSprite(unpackedImage, unpackedLength, i+0,1, 1,1);
		// 10:electrise
		for(i=0; i<2; i++)	extractSprite(unpackedImage, unpackedLength, i+6,0, 1,1);
		// 12:mort par electrocution
		extractSprite(unpackedImage, unpackedLength, 8,0, 1,1);
		// 13:mire de tir
		extractSprite(unpackedImage, unpackedLength, 9,0, 1,1);
		// 14:rouleau
		for(i=0; i<2; i++)	extractSprite(unpackedImage, unpackedLength, i*2,5, 2,2);
		// 16:coke
		extractSprite(unpackedImage, unpackedLength, 2,9, 2,2);
		extractSprite(unpackedImage, unpackedLength, 10,9, 2,2);
		// 18-19-20 : trois morts violentes
		extractSprite(unpackedImage, unpackedLength, 6,1, 1,1);
		extractSprite(unpackedImage, unpackedLength, 7,1, 1,1);
		extractSprite(unpackedImage, unpackedLength, 8,1, 1,1);
		// hack : no pulco image for this -- don't worry, menu is broken
		if(0)
		{
			memcpy(mSprite[18].data[1], mSprite[18].data[1],32*32*sizeof(UBYTE));
			memcpy(mSprite[19].data[1], mSprite[19].data[1],32*32*sizeof(UBYTE));
			memcpy(mSprite[20].data[1], mSprite[20].data[1],32*32*sizeof(UBYTE));
		}

		// 21:fond pannel bas
		extractSprite(unpackedImage, unpackedLength, 0,11, 20,4);
	
		// 22:8 outils "inactifs"
		for(i=0; i<4; i++) extractSprite(unpackedImage, unpackedLength, i*2,7, 2,2);
		for(i=0; i<4; i++) extractSprite(unpackedImage, unpackedLength, i*2,9, 2,2);
	
		// 30:7 outils "actifs"
		for(i=0; i<4; i++) extractSprite(unpackedImage, unpackedLength, 8+i*2,7, 2,2);
		for(i=0; i<3; i++) extractSprite(unpackedImage, unpackedLength, 8+i*2,9, 2,2);
	
		delete unpackedImage[0];
//		delete unpackedImage[1];
		delete packedImage[0];
//		delete packedImage[1];
	
		// --- chargement pict de fond ---
		//---

		printf("loadSprite \"%s\"\n", fondname);
		if (mDirImg.FindEntry(fondname, &dummy) < B_NO_ERROR) return FALSE;
		if (fichier3.SetTo(&dummy, B_READ_ONLY) < B_NO_ERROR) return FALSE;
		if (fichier3.GetStat(&file_st) < B_NO_ERROR) return FALSE;
		packedFondLength = file_st.st_size;
		//printf("file size %d\n", packedFondLength);

		packedFond = new UBYTE[packedFondLength];
		if (!packedFond) return FALSE;
		nb = fichier3.Read(packedFond, packedFondLength);
		//printf("fichier read %d\n", nb);
		if (nb != packedFondLength) return FALSE;
	
		if (!gifDecoder2.decoder(packedFond,		packedFondLength,
													 unpackedImage[0], unpackedLength[0])) return FALSE;
		unpackedImage[1]=NULL;
		unpackedLength[1]=0;
		//printf("file decode ok\n");	
		// image must be 640x480x8 bits
		if (unpackedLength[0] != 640*480) return FALSE;
	
		// special case for background pict : the same is used twice, allocated once.
		mSpriteFond = mNbSprite;
		extractSprite(unpackedImage, unpackedLength, 0,0, 640/32,480/32);
		//printf("extract sprite ok\n");

		// special case for full background pict, created from the mSpriteFond
		// as the mSpriteFond, it is allocated once, used twice
		// (note that reservation of sprite is done here, not in create function)
		mSpriteFullFond = mNbSprite++;	
		createFullFond(mSpriteFullFond, mSpriteFond);
		//printf("create full fond ok\n");
	
		delete unpackedImage[0];
		delete packedFond;
		return TRUE;
	}
	catch(...)
	{
		BAlert *box = new BAlert("Nerdkill Exception",
														 "Exception catched"
														 "\nProbably a file-related error.",
														 "   OK   ");
		if(box) box->Go();
		return FALSE;
	}
} // end of loadSprite for CVideo


//***************************************************************************
void CVideo::extractSprite(UBYTE *image[2], long len[2], long x, long y, long sx, long sy)
//***************************************************************************
/*
	x, y, sx et sy sont donnes en packets de 32 octets
*/
{
SbSprite *sp = &(mSprite[mNbSprite++]);	// reserve un nouveau sprite
long sxy;
long bpr = 640;	// bpr of image source (expected 640x480 !! Revenge of the death define !)
UBYTE *dest, *source;
long cy;
long index;

	x *= 32;
	y *= 32;
	sx *= 32;
	sy *= 32;

	sp->sx = sx;
	sp->sy = sy;

	sxy = sx*sy;
	//for(index=0; index<2; index++)
	for(index=0; index<1; index++)
	{
		if (!image[index] || !len[index])
		{
			// special case for background pict : the same is used twice, allocated once.
			if (index == 1 && mSpriteFond == mNbSprite-1)
				sp->data[index] = sp->data[0];
			else
				sp->data[index] = NULL;
			continue;
		}

		sp->data[index] = new UBYTE[sxy];

		if (!sp->data[index]) return;	// gloups ! free trip to debugger at first frame

		// extract data of sprite
		dest = sp->data[index];
		source = image[index]+y*bpr+x;
		for(cy=sy; cy>0; cy--, dest+=sx, source+=bpr) memcpy(dest, source, sx);
	
		// extract mask from sprite : 0 and 255 are transparent, others are opaque
		// there is no more separate mask.
		// mask data is the same as data itself : pixel 0 is transparent, others are
		// opaque.
		// an exception : first point may be equal to 63d (white) wich is used as
		// a grid on the picture. Pixel must be set to black.
		// Also values 255 are mapped to white in my photoshop palette, thus put them at 63d.
	
		if (index == 0 && mSpriteFond != mNbSprite-1)
		{
			// extract step for SpH image : 
			// build 24 bit pixmap buffer, fill it
			UBYTE *buf24 = new UBYTE[3*sxy];
			if (!buf24) return;	// trash display but don't crash

			source = sp->data[index];
			UBYTE *p;
			for(p=buf24, cy=sxy; cy>0; cy--, source++)
			{
				UBYTE a=(*source)*3;
				*(p++) = sph_palette[a+0];
				*(p++) = sph_palette[a+1];
				*(p++) = sph_palette[a+2];
			}

			// build a 8 bit bitmap, copy from 24 bit buffer (dithering done by BeOS)
			BRect rect(0,0,sx-1,sy-1);
			BBitmap *bmap = new BBitmap(rect, B_COLOR_8_BIT);
			if (!bmap) return;	// trash display but don't crash
			int bpr = bmap->BytesPerRow();
			int of7;
			for(p=buf24, of7=0, cy=sy; cy>0; cy--, of7+=bpr, p+=3*sx)
				bmap->SetBits(p, 3*sx, of7, B_RGB_32_BIT);

			// recopy 8 bit bitmap in sprite
			p=(UBYTE *)bmap->Bits();
			source = sp->data[index];
			for(cy=sy; cy>0; cy--, p+=bpr-sx)
			{
				for(of7=sx; of7>0; of7--, p++, source++)
				{
					UBYTE a = *source;
					if (a != sph_index_noir)
					{
						UBYTE b=*p;
						if (b) *source = b;
						else *source = 1;
					}
					else *source = 0;
				}
			}
			sp->data[index][0] = 0;
			sp->data[index][sx] = 0;
		}
		else
		{
			source = sp->data[index];
			for(cy=sxy; cy>0; cy--, source++)
			{
				UBYTE a = *source;
		
				if ((a == 63 || a == 255) && cy==sxy) // 255)
					*source = 0;
				else if (a == 255)
					*source = 63;
			}
		}

	}

} // end of extractSprite for CVideo


//***************************************************************************
void CVideo::createFullFond(long idfull, long idfond)
//***************************************************************************
/*
	Tile the "fond" sprite (640*480) into "full" sprite (KSX*KSY)
*/
{
SbSprite *spFond = &(mSprite[idfond]);
SbSprite *spFull = &(mSprite[idfull]);
UBYTE *dest, *source;
long sxy;
long cy,dy;
long sx,sy;

	//printf("idfond %d, idfull %d, nbsprite %d\n", idfond, idfull, mNbSprite);
	sx = spFond->sx;
	sy = spFond->sy;
	spFull->sx = KSX;
	spFull->sy = KSY;
	sxy = KSX*KSY;

	spFull->data[0] = new UBYTE[sxy];
	spFull->data[1] = spFull->data[0];		// specific case for sprite allocation
	if (!spFull->data[0]) return;	// gloups ! free trip to debugger at first frame
	//printf("alloc ok -- %p\n", spFull->data[0]);

	source = spFond->data[0];
	dest   = spFull->data[0];

	//printf("from %p - <%3d,%3d>\n", source, sx,sy);
	//printf("to   %p - <%3d,%3d>\n", dest  , KSX,KSY);

	for(dy = KSY, cy = sy; dy>0; dy--)
	{
		// specific case : dest width is twice source width !!
		memcpy(dest, source, sx);	
		dest += sx;
		memcpy(dest, source, sx);
		// if (KSX > 2*sx) ... beam me up ...
		dest += sx;
		source+=sx;
		cy--;
		if (cy < 0) { source = spFond->data[0]; cy = sy; }
	}

} // end of createFullFond


//---------------------------------------------------------------------------

// eoc
