/*****************************************************************************

	Projet	: Droids

	Fichier	:	gCMoteur.h
	Partie	: Moteur

	Auteur	: RM
	Date		: 130297
	Format	: tabs==2

*****************************************************************************/

#ifndef _H_GCMOTEUR_
#define _H_GCMOTEUR_

#include "machine.h"
#include "gCSem.h"
#include "bCSound.h"

//---------------------------------------------------------------------------
// defs shared with bCVideo.cpp

#define KSX (640*2)
#define KSY (480/2*3)

//---------------------------------------------------------------------------

#define K_PI	3.141592654
#define K_2PI	(2.0*K_PI)
#define K_PI2	(K_PI/2.0)


//---------------------------------------------------------------------------

//************
struct STortue
//************
{
	ULONG		x,y;
	ULONG		vivante;
	BOOL		elec;			// electrocution
	double	dir;			// en radians. 0=a droite
	double	vit;
	ULONG		spriteMort;	// offset du sprite mort
	BOOL		draw;
};




//********
enum EArme
//********
{
	kFusil,
	kUzi,
	kCoca,
	kRouleau,
	kMine,
	kExplose,
	kElectrocution
};


//***********
class CMoteur
//***********
{
public:
	CMoteur(void);
	virtual ~CMoteur(void);

	BOOL init(void);
	
	void arreter(void)	{ mVivant = FALSE; }

	static void threadEntryPoint(void);

	void mouseDown(long x, long y);
	void mouseUp(void);
	void mouseMoved(long x, long y, ULONG code);
	void keyDown(ULONG beKeyCode);

	void redrawArme(void);

//----
protected:

	void boucleMoteur(void);
	void oneFrame(void);
	void bougeTortues(ULONG offset);
	void tirFusil(long x, long y);
	void tirExplose(long x, long y);
	void electrocuter(long x, long y);
	void tryScroll(void);
	void changementArme(long code);
	void avanceRouleau(void);
	void avanceCoca(void);
	void hackSound(ULONG code);
	void makeAhSound(void);
	void makeFunSound(void);

	// utilities

	double rand_double(double maxval, double minval=0.);
	float  rand_float (float maxval , float  minval=0.f)	{ return (float)rand_double((double) maxval, (double) minval); }
	long   rand_long  (long maxval  , long   minval=0) 		{ return (long )rand_double((double) maxval, (double) minval); }


	// members

	BOOL mVivant;	// metre a FALSE quand le thread doit se saborder
	ULONG mSpriteOffset;

	ULONG	mSpriteDir[4];	// droite, haut, gauche, bas

	STortue *mTortue;
	ULONG		mNbTortue;

	EArme		mArme;

	long mScrollX, mScrollY;
	long mCocaX, mCocaY;
	long mRouleauX, mRouleauY;
	long mMouseX, mMouseY, mMouseCode;
	bool mMouseButton;
	bool mMouseUpReceived;

	bool	mUseSound;
	CSound mSound;

	long	mSoundAhFlag;		// bits 0 through 9
	long	mSoundFunFlag;	// bits 0 through 4

	ULONG mNbNerd;
	ULONG mNbAction;
	bool mRedrawPanel;

}; // end of class defs for CMoteur


//---------------------------------------------------------------------------

#endif // of _H_GCMOTEUR_

// eoh
