//Name:		NumberAndBlockViews.h
//Author:	Brian Tietz
//Copyright 1999
//Conventions:
//	Global constants (declared with const) and #defines - begin with "c_" followed by lowercase
//		words separated by underscores.
//		(E.G., #define c_my_constant 5).
//		(E.G., const int c_my_constant = 5;).
//	Global variables - begin with "g_" followed by lowercase words separated by underscores.
//		(E.G., int g_my_global;).
//	New data types (classes, structs, typedefs, etc.) - begin with an uppercase letter followed by
//		lowercase words separated by uppercase letters.  Enumerated constants contain a prefix
//		associating them with a particular enumerated set.
//		(E.G., typedef int MyTypedef;).
//		(E.G., enum MyEnumConst {c_mec_one, c_mec_two};)
//	Private member variables - begin with "m_" followed by lowercase words separated by underscores.
//		(E.G., int m_my_member;).
//	Public or friend-accessible member variables - all lowercase words separated by underscores.
//		(E.G., int public_member;).
//	Argument and local variables - begin with a lowercase letter followed by
//		lowercase words separated by underscores.  If the name is already taken by a public member
//		variable, prefix with a_ or l_
//		(E.G., int my_local; int a_my_arg, int l_my_local).
//	Functions (member or global) - begin with an uppercase letter followed by lowercase words
//		separated by uppercase letters.
//		(E.G., void MyFunction(void);).
//License:
//  Obviously, the idea for Tetris isn't mine, so I hold no copyright on the idea.  I do, however,
//  reserve all rights with regard to the source code for this BeOS version of Tetris.  The executable,
//  is freely distributable.  The source code is likewise freely distributable, provided that the
//  license and copyright are retained in these source code files and in the about box of the
//  executable.


#ifndef _NUMBER_AND_BLOCKS_VIEWS_H_
#define _NUMBER_AND_BLOCKS_VIEWS_H_


//******************************************************************************************************
//**** Project header files
//******************************************************************************************************
#include "DeepBevelView.h"


//******************************************************************************************************
//**** NumberView
//******************************************************************************************************
class NumberView : public DeepBevelView
{
	public:
		NumberView(BRect frame, const BFont* font);
		void SetNumber(int32 number);

		//BView overrides
		virtual void Draw(BRect update_rect);

	private:
		int32 m_number;
		float m_font_ascent;
};


//******************************************************************************************************
//**** NextBlockView
//******************************************************************************************************
class NextBlockView : public DeepBevelView
{
	public:
		NextBlockView(BRect frame);
		~NextBlockView();
		void SetType(uint8 type);

		//BView overrides
		virtual void Draw(BRect update_rect);

	private:
		BBitmap* m_bitmap;
		uint32* m_bitmap_data;
		BRect m_bitmap_rect;
};


#endif //_NUMBER_AND_BLOCKS_VIEWS_H_
