//Name:		Tetris.h
//Author:	Brian Tietz
//Copyright 1999
//Conventions:
//	Global constants (declared with const) and #defines - begin with "c_" followed by lowercase
//		words separated by underscores.
//		(E.G., #define c_my_constant 5).
//		(E.G., const int c_my_constant = 5;).
//	Global variables - begin with "g_" followed by lowercase words separated by underscores.
//		(E.G., int g_my_global;).
//	New data types (classes, structs, typedefs, etc.) - begin with an uppercase letter followed by
//		lowercase words separated by uppercase letters.  Enumerated constants contain a prefix
//		associating them with a particular enumerated set.
//		(E.G., typedef int MyTypedef;).
//		(E.G., enum MyEnumConst {c_mec_one, c_mec_two};)
//	Private member variables - begin with "m_" followed by lowercase words separated by underscores.
//		(E.G., int m_my_member;).
//	Public or friend-accessible member variables - all lowercase words separated by underscores.
//		(E.G., int public_member;).
//	Argument and local variables - begin with a lowercase letter followed by
//		lowercase words separated by underscores.  If the name is already taken by a public member
//		variable, prefix with a_ or l_
//		(E.G., int my_local; int a_my_arg, int l_my_local).
//	Functions (member or global) - begin with an uppercase letter followed by lowercase words
//		separated by uppercase letters.
//		(E.G., void MyFunction(void);).
//License:
//  Obviously, the idea for Tetris isn't mine, so I hold no copyright on the idea.  I do, however,
//  reserve all rights with regard to the source code for this BeOS version of Tetris.  The executable,
//  is freely distributable.  The source code is likewise freely distributable, provided that the
//  license and copyright are retained in these source code files and in the about box of the
//  executable.


#ifndef _TETRIS_H_
#define _TETRIS_H_


//******************************************************************************************************
//**** System header files
//******************************************************************************************************
#include <Application.h>


//******************************************************************************************************
//**** Project header files
//******************************************************************************************************
#include "TetrisPrefs.h"
#include "TetrisResources.h"


//******************************************************************************************************
//**** Constants
//******************************************************************************************************
extern const char* c_tetris_sig;
enum
{
	c_begin_new_game = 0,
	c_pause_game,
	c_resume_game,
	c_edit_preferences,
	c_down_block
};


//******************************************************************************************************
//**** TetrisApplication
//******************************************************************************************************
class TetrisApplication : public BApplication
{
	public:
		TetrisApplication();
		~TetrisApplication();
		inline TetrisPrefs* Prefs() {return m_prefs;}
		void AboutRequested();

	private:
		TetrisResources* m_resources;
		TetrisPrefs* m_prefs;
		BMessenger m_about_window_messenger;
};


#endif //_TETRIS_H_
