//Name:		TetrisResources.cpp
//Author:	Brian Tietz
//Copyright 1999
//Conventions:
//	Global constants (declared with const) and #defines - begin with "c_" followed by lowercase
//		words separated by underscores.
//		(E.G., #define c_my_constant 5).
//		(E.G., const int c_my_constant = 5;).
//	Global variables - begin with "g_" followed by lowercase words separated by underscores.
//		(E.G., int g_my_global;).
//	New data types (classes, structs, typedefs, etc.) - begin with an uppercase letter followed by
//		lowercase words separated by uppercase letters.  Enumerated constants contain a prefix
//		associating them with a particular enumerated set.
//		(E.G., typedef int MyTypedef;).
//		(E.G., enum MyEnumConst {c_mec_one, c_mec_two};)
//	Private member variables - begin with "m_" followed by lowercase words separated by underscores.
//		(E.G., int m_my_member;).
//	Public or friend-accessible member variables - all lowercase words separated by underscores.
//		(E.G., int public_member;).
//	Argument and local variables - begin with a lowercase letter followed by
//		lowercase words separated by underscores.  If the name is already taken by a public member
//		variable, prefix with a_ or l_
//		(E.G., int my_local; int a_my_arg, int l_my_local).
//	Functions (member or global) - begin with an uppercase letter followed by lowercase words
//		separated by uppercase letters.
//		(E.G., void MyFunction(void);).
//License:
//  Obviously, the idea for Tetris isn't mine, so I hold no copyright on the idea.  I do, however,
//  reserve all rights with regard to the source code for this BeOS version of Tetris.  The executable,
//  is freely distributable.  The source code is likewise freely distributable, provided that the
//  license and copyright are retained in these source code files and in the about box of the
//  executable.


//******************************************************************************************************
//**** System header files
//******************************************************************************************************
#include <Application.h>
#include <Resources.h>
#include <TranslationUtils.h>
#include <Bitmap.h>


//******************************************************************************************************
//**** Project header files
//******************************************************************************************************
#include "TetrisResources.h"
#include "NewStrings.h"


//******************************************************************************************************
//**** Global variables
//******************************************************************************************************
char* g_init_prefs_fail_string = NULL;
char* g_save_prefs_fail_string = NULL;
char* g_tetris_string = NULL;
char* g_quit_string = NULL;
char* g_file_string = NULL;
char* g_begin_new_game_string = NULL;
char* g_pause_string = NULL;
char* g_resume_string = NULL;
char* g_preferences_string = NULL;
char* g_about_string = NULL;
char* g_score_label = NULL;
char* g_lines_label = NULL;
char* g_next_block_label = NULL;
char* g_game_over_string = NULL;
char* g_about_text = NULL;


//******************************************************************************************************
//**** TetrisResources
//******************************************************************************************************
TetrisResources::TetrisResources()
{
	BResources* resources = be_app->AppResources();
	size_t size;
	const char* string;
	m_init_ok = ((string = (const char*)resources->LoadResource('CSTR',"InitPrefsFail",
		&size)) != NULL);
	if(m_init_ok)
		g_init_prefs_fail_string = Strdup_new(string);
	m_init_ok = m_init_ok && ((string = (const char*)resources->LoadResource('CSTR',"SavePrefsFail",
		&size)) != NULL);
	if(m_init_ok)
		g_save_prefs_fail_string = Strdup_new(string);
	m_init_ok = m_init_ok && ((string = (const char*)resources->LoadResource('CSTR',"Tetris",&size)) !=
		NULL);
	if(m_init_ok)
		g_tetris_string = Strdup_new(string);
	m_init_ok = m_init_ok && ((string = (const char*)resources->LoadResource('CSTR',"Quit",&size)) !=
		NULL);
	if(m_init_ok)
		g_quit_string = Strdup_new(string);
	m_init_ok = m_init_ok && ((string = (const char*)resources->LoadResource('CSTR',"File",&size)) !=
		NULL);
	if(m_init_ok)
		g_file_string = Strdup_new(string);
	m_init_ok = m_init_ok && ((string = (const char*)resources->LoadResource('CSTR',"BeginNew",&size)) !=
		NULL);
	if(m_init_ok)
		g_begin_new_game_string = Strdup_new(string);
	m_init_ok = m_init_ok && ((string = (const char*)resources->LoadResource('CSTR',"Pause",&size)) !=
		NULL);
	if(m_init_ok)
		g_pause_string = Strdup_new(string);
	m_init_ok = m_init_ok && ((string = (const char*)resources->LoadResource('CSTR',"Resume",&size)) !=
		NULL);
	if(m_init_ok)
		g_resume_string = Strdup_new(string);
	m_init_ok = m_init_ok && ((string = (const char*)resources->LoadResource('CSTR',"PreferencesMenu",&size)) !=
		NULL);
	if(m_init_ok)
		g_preferences_string = Strdup_new(string);
	m_init_ok = m_init_ok && ((string = (const char*)resources->LoadResource('CSTR',"AboutMenu",
		&size)) != NULL);
	if(m_init_ok)
		g_about_string = Strdup_new(string);
	m_init_ok = m_init_ok && ((string = (const char*)resources->LoadResource('CSTR',"ScoreLabel",
		&size)) != NULL);
	if(m_init_ok)
		g_score_label = Strdup_new(string);
	m_init_ok = m_init_ok && ((string = (const char*)resources->LoadResource('CSTR',"LinesLabel",
		&size)) != NULL);
	if(m_init_ok)
		g_lines_label = Strdup_new(string);
	m_init_ok = m_init_ok && ((string = (const char*)resources->LoadResource('CSTR',"NextBlockLabel",
		&size)) != NULL);
	if(m_init_ok)
		g_next_block_label = Strdup_new(string);
	m_init_ok = m_init_ok && ((string = (const char*)resources->LoadResource('CSTR',"GameOver",
		&size)) != NULL);
	if(m_init_ok)
		g_game_over_string = Strdup_new(string);
	m_init_ok = m_init_ok && ((string = (const char*)resources->LoadResource('CSTR',"AboutText",
		&size)) != NULL);
	if(m_init_ok)
		g_about_text = Strdup_new(string);

	char bitmap_name[] = "brickN.png";
	for(int i=0; i<7; i++)
	{
		bitmap_name[5] = i+'1';
		BBitmap* bitmap = BTranslationUtils::GetBitmap(bitmap_name);
		if(bitmap == NULL)
		{
			m_init_ok = false;
			return;
		}
		else if(bitmap->ColorSpace() != B_RGB32)
		{
			BBitmap* bitmap_32 = new BBitmap(bitmap->Bounds(),B_RGB32,true);
			bitmap_32->Lock();
			BView* drawing_view = new BView(bitmap_32->Bounds(),NULL,0,0);
			bitmap_32->AddChild(drawing_view);
			drawing_view->DrawBitmap(bitmap,drawing_view->Bounds());
			delete bitmap;
			bitmap = bitmap_32;
		}
		uint32* data = (uint32*)bitmap->Bits();
		for(int8 x=0; x<16; x++)
			for(int8 y=0; y<16; y++)
				g_blocks[i].bitmap_data[x][y] = data[y*16+x];
		delete bitmap;
	}
}


TetrisResources::~TetrisResources()
{
	if(g_init_prefs_fail_string)			delete[] g_init_prefs_fail_string;
	if(g_save_prefs_fail_string)			delete[] g_save_prefs_fail_string;
	if(g_tetris_string)						delete[] g_tetris_string;
	if(g_quit_string)						delete[] g_quit_string;
	if(g_file_string)						delete[] g_file_string;
	if(g_begin_new_game_string)				delete[] g_begin_new_game_string;
	if(g_pause_string)						delete[] g_pause_string;
	if(g_resume_string)						delete[] g_resume_string;
	if(g_preferences_string)				delete[] g_preferences_string;
	if(g_about_string)						delete[] g_about_string;
	if(g_score_label)						delete[] g_score_label;
	if(g_lines_label)						delete[] g_lines_label;
	if(g_next_block_label)					delete[] g_next_block_label;
	if(g_game_over_string)					delete[] g_game_over_string;
	if(g_about_text)						delete[] g_about_text;
}


//******************************************************************************************************
//**** Blocks
//******************************************************************************************************
Block g_blocks[7] =
{
	{{{{0,0,0,0},
	   {0,0,0,0},
	   {1,1,1,1},
	   {0,0,0,0}},
	  {{0,0,1,0},
	   {0,0,1,0},
	   {0,0,1,0},
	   {0,0,1,0}},
	  {{0,0,0,0},
	   {0,0,0,0},
	   {1,1,1,1},
	   {0,0,0,0}},
	  {{0,0,1,0},
	   {0,0,1,0},
	   {0,0,1,0},
	   {0,0,1,0}}},{0}},

	{{{{0,0,0,0},
	   {0,1,1,0},
	   {0,1,1,0},
	   {0,0,0,0}},
	  {{0,0,0,0},
	   {0,1,1,0},
	   {0,1,1,0},
	   {0,0,0,0}},
	  {{0,0,0,0},
	   {0,1,1,0},
	   {0,1,1,0},
	   {0,0,0,0}},
	  {{0,0,0,0},
	   {0,1,1,0},
	   {0,1,1,0},
	   {0,0,0,0}}},{0}},

	{{{{0,0,0,0},
	   {0,0,1,0},
	   {0,1,1,0},
	   {0,0,1,0}},
	  {{0,0,0,0},
	   {0,0,1,0},
	   {0,1,1,1},
	   {0,0,0,0}},
	  {{0,0,0,0},
	   {0,0,1,0},
	   {0,0,1,1},
	   {0,0,1,0}},
	  {{0,0,0,0},
	   {0,0,0,0},
	   {0,1,1,1},
	   {0,0,1,0}}},{0}},

	{{{{0,0,0,0},
	   {0,0,0,0},
	   {0,0,1,1},
	   {0,1,1,0}},
	  {{0,0,0,0},
	   {0,0,1,0},
	   {0,0,1,1},
	   {0,0,0,1}},
	  {{0,0,0,0},
	   {0,0,0,0},
	   {0,0,1,1},
	   {0,1,1,0}},
	  {{0,0,0,0},
	   {0,0,1,0},
	   {0,0,1,1},
	   {0,0,0,1}}},{0}},

	{{{{0,0,0,0},
	   {0,1,1,0},
	   {0,0,1,1},
	   {0,0,0,0}},
	  {{0,0,0,0},
	   {0,0,0,1},
	   {0,0,1,1},
	   {0,0,1,0}},
	  {{0,0,0,0},
	   {0,1,1,0},
	   {0,0,1,1},
	   {0,0,0,0}},
	  {{0,0,0,0},
	   {0,0,0,1},
	   {0,0,1,1},
	   {0,0,1,0}}},{0}},

	{{{{0,0,0,0},
	   {0,0,0,0},
	   {0,1,1,1},
	   {0,0,0,1}},
	  {{0,0,0,0},
	   {0,0,1,0},
	   {0,0,1,0},
	   {0,1,1,0}},
	  {{0,0,0,0},
	   {0,1,0,0},
	   {0,1,1,1},
	   {0,0,0,0}},
	  {{0,0,0,0},
	   {0,0,1,1},
	   {0,0,1,0},
	   {0,0,1,0}}},{0}},

	{{{{0,0,0,0},
	   {0,0,0,1},
	   {0,1,1,1},
	   {0,0,0,0}},
	  {{0,0,0,0},
	   {0,0,1,0},
	   {0,0,1,0},
	   {0,0,1,1}},
	  {{0,0,0,0},
	   {0,0,0,0},
	   {0,1,1,1},
	   {0,1,0,0}},
	  {{0,0,0,0},
	   {0,1,1,0},
	   {0,0,1,0},
	   {0,0,1,0}}},{0}}
};

