//Name:		TetrisResources.h
//Author:	Brian Tietz
//Copyright 1999
//Conventions:
//	Global constants (declared with const) and #defines - begin with "c_" followed by lowercase
//		words separated by underscores.
//		(E.G., #define c_my_constant 5).
//		(E.G., const int c_my_constant = 5;).
//	Global variables - begin with "g_" followed by lowercase words separated by underscores.
//		(E.G., int g_my_global;).
//	New data types (classes, structs, typedefs, etc.) - begin with an uppercase letter followed by
//		lowercase words separated by uppercase letters.  Enumerated constants contain a prefix
//		associating them with a particular enumerated set.
//		(E.G., typedef int MyTypedef;).
//		(E.G., enum MyEnumConst {c_mec_one, c_mec_two};)
//	Private member variables - begin with "m_" followed by lowercase words separated by underscores.
//		(E.G., int m_my_member;).
//	Public or friend-accessible member variables - all lowercase words separated by underscores.
//		(E.G., int public_member;).
//	Argument and local variables - begin with a lowercase letter followed by
//		lowercase words separated by underscores.  If the name is already taken by a public member
//		variable, prefix with a_ or l_
//		(E.G., int my_local; int a_my_arg, int l_my_local).
//	Functions (member or global) - begin with an uppercase letter followed by lowercase words
//		separated by uppercase letters.
//		(E.G., void MyFunction(void);).
//License:
//  Obviously, the idea for Tetris isn't mine, so I hold no copyright on the idea.  I do, however,
//  reserve all rights with regard to the source code for this BeOS version of Tetris.  The executable,
//  is freely distributable.  The source code is likewise freely distributable, provided that the
//  license and copyright are retained in these source code files and in the about box of the
//  executable.


#ifndef _TETRIS_RESOURCES_H_
#define _TETRIS_RESOURCES_H_


//******************************************************************************************************
//**** Block
//******************************************************************************************************
struct Block
{
	int8 data[4][4][4];		//rotation,X,Y; center is at 2,2
	uint32 bitmap_data[16][16]; //X,Y
};


//******************************************************************************************************
//**** Global variables
//******************************************************************************************************
extern char* g_init_prefs_fail_string;
extern char* g_save_prefs_fail_string;
extern char* g_tetris_string;
extern char* g_quit_string;
extern char* g_file_string;
extern char* g_begin_new_game_string;
extern char* g_pause_string;
extern char* g_resume_string;
extern char* g_preferences_string;
extern char* g_about_string;
extern char* g_score_label;
extern char* g_lines_label;
extern char* g_next_block_label;
extern char* g_game_over_string;
extern char* g_about_text;
extern Block g_blocks[7];


//******************************************************************************************************
//**** TetrisResources
//******************************************************************************************************
class TetrisResources
{
	public:
		TetrisResources();
		~TetrisResources();
		inline bool InitCheck() {return m_init_ok;}

	private:
		bool m_init_ok;
};


#endif //_TETRIS_RESOURCES_H_