//Name:		TetrisWindow.h
//Author:	Brian Tietz
//Copyright 1999
//Conventions:
//	Global constants (declared with const) and #defines - begin with "c_" followed by lowercase
//		words separated by underscores.
//		(E.G., #define c_my_constant 5).
//		(E.G., const int c_my_constant = 5;).
//	Global variables - begin with "g_" followed by lowercase words separated by underscores.
//		(E.G., int g_my_global;).
//	New data types (classes, structs, typedefs, etc.) - begin with an uppercase letter followed by
//		lowercase words separated by uppercase letters.  Enumerated constants contain a prefix
//		associating them with a particular enumerated set.
//		(E.G., typedef int MyTypedef;).
//		(E.G., enum MyEnumConst {c_mec_one, c_mec_two};)
//	Private member variables - begin with "m_" followed by lowercase words separated by underscores.
//		(E.G., int m_my_member;).
//	Public or friend-accessible member variables - all lowercase words separated by underscores.
//		(E.G., int public_member;).
//	Argument and local variables - begin with a lowercase letter followed by
//		lowercase words separated by underscores.  If the name is already taken by a public member
//		variable, prefix with a_ or l_
//		(E.G., int my_local; int a_my_arg, int l_my_local).
//	Functions (member or global) - begin with an uppercase letter followed by lowercase words
//		separated by uppercase letters.
//		(E.G., void MyFunction(void);).
//License:
//  Obviously, the idea for Tetris isn't mine, so I hold no copyright on the idea.  I do, however,
//  reserve all rights with regard to the source code for this BeOS version of Tetris.  The executable,
//  is freely distributable.  The source code is likewise freely distributable, provided that the
//  license and copyright are retained in these source code files and in the about box of the
//  executable.


#ifndef _TETRIS_WINDOW_H_
#define _TETRIS_WINDOW_H_


//******************************************************************************************************
//**** System header files
//******************************************************************************************************
#include <stdlib.h>
#include <Window.h>
#include <MessageFilter.h>


//******************************************************************************************************
//**** Project header files
//******************************************************************************************************
#include "TetrisView.h"
#include "NumberAndBlockViews.h"


//******************************************************************************************************
//**** Constants
//******************************************************************************************************
const int8 c_lines_between_speedups = 12;
const bigtime_t c_initial_down_interval = 700000;
const bigtime_t c_user_down_interval = 50000;
const float c_speedup = 0.18;


//******************************************************************************************************
//**** TetrisWindow
//******************************************************************************************************
class TetrisWindow : public BWindow
{
	public:
		TetrisWindow();
		~TetrisWindow();

		void DrawContent(BView* view, BRect update_rect);

		//BWindow overrides
		virtual void MessageReceived(BMessage* message);

		static filter_result KeyFilterStatic(BMessage* message, BHandler** target,
			BMessageFilter* filter);
		filter_result KeyFilter(BMessage* message);
		bool BlockDown();		//Returns true if the block went down a line

	private:
		BMenuBar* GenerateMenuBar();
		inline int8 GetRandomBlock() {return (rand()%7)+1;}

		TetrisView* m_tetris_view;
		BView* m_window_background_view;
		BRect m_tetris_view_rect;
		BRect m_score_label_rect;
		NumberView* m_score_view;
		BRect m_lines_label_rect;
		NumberView* m_lines_view;
		BRect m_next_block_label_rect;
		NextBlockView* m_next_block_view;
		float m_font_ascent;
		rgb_color m_background_color;
		rgb_color m_dark_1_color;
		rgb_color m_dark_2_color;
		uint32 m_score;
		uint32 m_lines;
		uint8 m_next_block_type;
		BMenuItem* m_pause_item;
		bigtime_t m_down_interval;
		int8 m_lines_until_next_speed_up;
		BMessageRunner* m_down_timer;
		BMessageRunner* m_user_down_timer;
		BMessenger m_self_messenger;
		bool m_ignore_downs;
		char m_key_left;
		char m_key_right;
		char m_key_rotate;
		char m_key_down;
		char m_key_drop;
		bool m_game_over;
};


//******************************************************************************************************
//**** TetrisWindowView
//******************************************************************************************************
class TetrisWindowView : public BView
{
	private:
		TetrisWindowView(BRect rect, TetrisWindow* parent);

		TetrisWindow* m_parent;
		friend TetrisWindow;

	public:
		//BView override
		void Draw(BRect update_rect);
};


#endif //_TETRIS_WINDOW_H_
