#ifndef DVIEW_H
#define DVIEW_H
#include <View.h>
#include <Bitmap.h>
#include <Point.h>
#include <list> //list from Standard Template Library
#include "beunit.h"
#include "effect.h"
#include "animation.h"
#include "convert.h"
//---------------------------------------------------------------------
typedef	list<Item>::iterator ITER;
typedef	list<Item>::reverse_iterator RITER;
enum BUTTONMODE{Option, Unit};
//---------------------------------------------------------------------
class DView : public BView
{
 private:
	BBitmap* Background; //the board background (448x448)
	BBitmap* OffscreenBitmap; //to avoid flicker while drawing
	BView* OffscreenView; //used by the offscreen bitmap
	
	list<Item> Liste; //All units are in this list
	ITER Active; //iterator to active unit
	ITER Passive; //iterator to current target (passive unit)
	BUTTONMODE Mode; //current button set
	BRect Target; //destination coordinate
	bool Animating; //true if we are currently animating something
	int CurrentAction;
	rgb_color SpotColor;
		
	void Ini(int group); //Initialisation before the game begins
	void GetNext(); //Next turn (active the next unit in the list)
	void RedrawBackground(BView*); //redraw the entire background
	ITER FindClickedOn(BPoint where); //find what the user clicked on
	void RedSpot();
	void GreenSpot();
	
 public:
	TAnimation* Animation; //the animations (available to everyone)
	Effect* SEffect; //the special fx (available to everyone)

	DView(); 
	void Restart();
	virtual void Draw(BRect where);
	virtual void MessageReceived(BMessage* message);
	virtual void MouseDown(BPoint where);
	virtual void MouseMoved(BPoint where, uint32 transit, const BMessage *message);
};

#endif