#include "portrait.h"
#include <TranslationUtils.h>
#include "convert.h"
//----------------------------------------------------------------------
Portrait::Portrait(BRect dest) 
	: BView(dest, "Image", B_FOLLOW_NONE, B_WILL_DRAW)
{
	//load les portraits
	AllPortrait = BTranslationUtils::GetBitmap("bmp/misc/portrait.png"); 
	MakeTransparent(AllPortrait);

	Portrait[0] = Fetch(0);
	Portrait[1] = Fetch(1);
	Portrait[2] = Fetch(2);
	Portrait[3] = Fetch(3);
	Portrait[4] = Fetch(4);
	Portrait[5] = Fetch(5);
	Portrait[6] = Fetch(6);
	Portrait[7] = Fetch(7);
	ChangePortrait(0); //image par default
}
//----------------------------------------------------------------------
BBitmap* Portrait::Fetch(int index)
{
	index *= 64;
	BBitmap* Target = new BBitmap(BRect(0,0,63,63), B_RGB32);

	int width = (int)AllPortrait->Bounds().right+1;

	for(int row = 0; row < 64; row++)
		for(int col = 0; col < 64; col++)
		{
			((rgb_color *)Target->Bits())[(row*64 + col)] = 
			((rgb_color *)AllPortrait->Bits())[(row*width + col+index)];
		}			

	return Target;
}
//----------------------------------------------------------------------
void Portrait::Draw(BRect R)
{
	DrawBitmap(Image);
}
//----------------------------------------------------------------------
void Portrait::ChangePortrait(int i)
{
	Image = Portrait[i]; //nouvelle image
	Invalidate();
}
//----------------------------------------------------------------------
