#include <stdio.h>
#include <SupportDefs.h>
#include <OS.h>

#define NUM_LOOPS 500LL
#define WIDTH 320
#define HEIGHT 240

extern void stretchby2( uint32 *src, uint32 src_width, uint32 src_height, uint32 src_skip,
				 uint32 *dest, uint32 dest_skip);
extern void stretchby2_mmx( uint32 *src, uint32 src_width, uint32 src_height, uint32 src_skip,
				 uint32 *dest, uint32 dest_skip);

char f1[WIDTH*HEIGHT];
char f2[WIDTH*HEIGHT*4];

int main()
{
	bigtime_t i;
	bigtime_t start, zeit;

	set_thread_priority(find_thread(NULL), 120);

	start = system_time();
	for(i=0; i < NUM_LOOPS; i++)
		stretchby2_mmx( (uint32*)f1, WIDTH, HEIGHT, 0, (uint32*)f2, 0 );
	zeit = system_time() - start;
	printf("time = %Ld for %Ld calls.. %Ld fps\n", zeit, NUM_LOOPS, ((NUM_LOOPS*1000000)/zeit));
	return 0;
}
