/*********************************************************************
	VuKitten.h
	
	This file contains the class declaration for the neko kitten
	view.
	
	Who		When		What
	GJW		971022	Initial design and coding
	GJW		971024	Slight functional rearrangements
*********************************************************************/

#pragma once

#pragma export on

class VuKitten : public BView {
public:
	//	Instantiation
	static VuKitten* Instantiate(BMessage* inArchive);
	
	//	Construction
	VuKitten(BRect inRect);
	VuKitten(BMessage* inArchive);
	virtual ~VuKitten(void);
	
	//	Overrides
	virtual status_t Archive(BMessage* inMessage, bool inDeep =true) const;
	virtual void Draw(BRect inUpdate);
	virtual void MessageReceived(BMessage* inMessage);
	virtual void MouseMoved(BPoint inPoint, uint32 inTransit, const BMessage* inMessage);

private:
	//	Constants
	enum OutsidePos {kPosInside, kPosAbove, kPosBelow, kPosLeft, kPosRight};
	enum CatFace {kNorth1, kNorth2, kNorthEast1, kNorthEast2, kEast1, kEast2,
		kSouthEast1, kSouthEast2, kSouth1, kSouth2, kSouthWest1, kSouthWest2,
		kWest1, kWest2, kNorthWest1, kNorthWest2, kAbove1, kAbove2, kRight1, kRight2,
		kBelow1, kBelow2, kLeft1, kLeft2, kSitting, kYawning, kScratch1, kScratch2,
		kSleep1, kSleep2, kBathing, kSurprise};
	static const bigtime_t kShortDelay;
	static const bigtime_t kLongDelay;
	static const double kSmallAngle;

	//	Data
	bool mMouseMoved;
	bool mMouseOutside;
	bool mRunning;
	int mEdgeCount;
	int mScratchCount;
	double mDistance;
	double mTheta;
	bigtime_t mSleepTime;
	thread_id mThread;
	OutsidePos mOutsidePos;
	BBitmap* mKittens;
	BPoint mCatLoc;
	BPoint mMouseLoc;
	BRect mCatBox;
	CatFace mCatFace;

	//	Utilities
	void CalcVector(BPoint inPoint);
	void DoPaste(BMessage* inMessage);
	void InitKitten(void);
	int32 ThreadProc(void);
	
	//	Statics
	static int32 thread_proc(void* inData);
};

#pragma export reset
