//
// Implementation of HistoryWindow Classes
//
// this belongs to the 'Tower of Benoi' Project
// Copyright 1998
//
// Written by: Marco Zinn
//

#include "HistoryWindow.h"
//#include <Application.h>

// The constructor adds the counter (a BStringView) and the list with a scrollbar to the window and 
// show it. Of course, the data is reset ;-)
HistoryWindow::HistoryWindow(BRect frame, const char* name)
			: BWindow(frame, name,B_TITLED_WINDOW,B_NOT_CLOSABLE|B_NOT_H_RESIZABLE) {

	// Create and add Move Counter
	BRect r(10,10,Bounds().Width()-10,20);
	MoveCounter=new BStringView(r,"movecounter","Moves: 0");
	AddChild(MoveCounter);
	
	// Create the ListView for the move list
	r=Bounds();	// Take the whole window
	r.InsetBy(10,10); // Inset by 10 on all sides
	r.top=25; // set top to 25, because there's the MoveCounter
	r.right-=B_V_SCROLL_BAR_WIDTH; // leave some space for the Scrollbar!
	
	// Now create the ListView, but don't add it
	Moves=new BListView(r,"history", B_SINGLE_SELECTION_LIST, B_FOLLOW_ALL_SIDES, B_WILL_DRAW | B_NAVIGABLE | B_FRAME_EVENTS);

	// Instead, create a BScrollView, which will 'wrap around' the BListView
	// That BScrollView will create and add a Scrollbar for us and connect the scrollbar to the ListView
	// Add that ScrollView, which adds the rest in place.
	AddChild(new BScrollView("scroll_history", Moves, B_FOLLOW_ALL_SIDES, B_FRAME_EVENTS, false, true));

	// Reset everything
	Reset();
	
	// And show the beauty to the public
	Show();
}

// ShowMoveCounter converts the Counter (an integer) to a string and puts it on screen
void HistoryWindow::ShowMoveCounter() {
	char temp[20];
	sprintf(temp,"Moves: %i",MoveCount); // format and 'print' the value into the string
	//	printf("String: %s\n",temp); // Debug
	Lock(); // Lock the Window. This seems to be necessary before changing the Text (AFAIK)
	MoveCounter->SetText(temp); // change the text of the existing view
	Unlock(); // well.... unlock
}


// Reset the Counter and clear the list
void HistoryWindow::Reset() {
	MoveCount=0;
	ShowMoveCounter();
	Lock();
	Moves->MakeEmpty(); // again, when you call MakeEmpty, lock the window
						// for details, see DiscTowerView::ResetDiscs()
	Unlock();
}

// Add a Move to the History
void HistoryWindow::AddMove(char FromTower, char ToTower, int DiscSize) {
	char temp[20];
	sprintf(temp,"Disc %i from %c to %c",DiscSize,FromTower,ToTower); // create String for the list
	//	printf(temp); // Debug
	Lock();
	Moves->AddItem(new BStringItem(temp)); // Add string to list
	Unlock();
	MoveCount++;
	ShowMoveCounter(); // Increase and Show the counter
}
