//
// Implementation of Disc, DiscTowerView and TowerWindow classes
//
// this belongs to the 'Tower of Benoi' Project
// Copyright 1998
//
// Written by: Marco Zinn
//

#include "TowerWindow.h"
#include "HistoryWindow.h"
#include "Towers.h"

// Implementation of Disc class

// The constructor save the size and color and initializes the string
// according to the size
Disc::Disc(int newSize, rgb_color newColor)
		: size(newSize), color(newColor), BStringItem("") {
	char name[10];
	sprintf (name,"%i", size);
	//	printf("New Disc: %i\n",size); // Debug
	BStringItem::SetText(name);
}

// DrawItem
//  Draws the disc, that means the colored bar and the label in white ('1'...'10')
//  DummyDiscs are not drawn. If you want to see them, comment out the first line.
void Disc::DrawItem(BView *owner, BRect frame, bool complete) { 
	if (this==DummyDisc) return; // Don't draw the Dummy-Discs. (Comment out for DEBUGing)

	// printf("Disc %i draws\n",size); // Debug
	
	// If complete drawing is required, erase the whole background
	//  Note that we don't care, if the item is selected. This would be the place to do that
	if (complete) {
		owner->SetHighColor(owner->ViewColor());
    	owner->FillRect(frame); 
    	}   	
 
	// Do same calculations about the position of the bar:
	//  Take the frame rectangle (which is the area for the whole Item to draw in),
	//  calc the middle (average x) and center the disc around that
	BRect original;
	original=frame;
	frame.left=((original.left+original.right)/2)-size*10;
	frame.right=((original.left+original.right)/2)+size*10;

	owner->SetHighColor(color);	// Select the Disc's color
    owner->FillRect(frame);		// Draw the Disc

	owner->SetLowColor(color);	// Treat the color as LowColor (AKA Background color!)
	owner->SetHighColor(255,255,255); // Set Drawing color to white
	owner->MovePenTo((frame.left+frame.right)/2-3, frame.bottom-2); // Position pen somewhere near the center of the disc 
	owner->DrawString(Text()); // Draw text (label)
	// Note: While drawing a text, be sure the Low color is set to the background color
	//       This is important, because the text is anti-aliased using the High- and Low-
	//       Color, not the actual background on screen! (again: AFAIK!)
}

// Implementation of DiscTowerView class


// The constructor essantially saves the necessary data and Resets the Tower
DiscTowerView::DiscTowerView(BRect frame, TowerKind kind, char Name, HistoryWindow *History)
			: BListView(frame, "DiscTowerView",B_SINGLE_SELECTION_LIST, B_FOLLOW_ALL_SIDES, B_WILL_DRAW ) {
	//	printf("New DiscTowerView\n"); // Debug
	theHistoryWindow=History; // Save Pointer to History Window
	myKind=kind; // Save Type
	myName[0]=Name; // Save Name (one character)
	myName[1]=0; // Terminate with 0, so we can use it as a String
	ResetDiscs(); // Initialize Tower
}


// InitiateDrag is called, when a drag-and-drop action is started, ie when the
// user drags something 'off' the Tower. This builds the nice little outline
// rectangle and contructs the OFFER_DISC message.
bool DiscTowerView::InitiateDrag(BPoint a, int32 index, bool wasSelected) {
	// printf("InitiateDrag: FirstDisc=%i\n",FirstDisc); // Debug
	if (TowerEmpty()) return false; // ERROR-Check
	
	// printf("Doing Drag\n"); // Debug
	
	// Construct outline Box:
	int DS=FirstDiscPtr()->size; 
		// Fetch the size of the uppermost disc, as only the uppermost disc will move at all!

	BPoint b=a; // a is the Point where the user klicked
	a.x-=DS*20; a.y-=12; // This creates a rect, where the mouse pointer is at the lower right corner

	BMessage messy(OFFER_DISC); // Contruct a message
	messy.AddPointer("DiscPtr",FirstDiscPtr()); // Add a Ptr to the uppermost Disc. That's the disc we want to offer (move)
	DragMessage(&messy,BRect(a,b)); // Start Drag operation.
	return true; // Say: 'It's ok. keep dragging away....'
	// Note: I never had to do such a thing in Windooze.
	// But I guess, you have to love the concept. Dragging in three lines!
	// The app_server does the rest for us (except dealing the incoming messages. see below)
	// Also note, that the app_server (or some other wizard in the depth of the system)
	// makes a copy of the message we pass to DragMessage(). The message we created
	// is just a 'model message', which can be deleted after the call to Dragmessage.
	// [I didn't wanna explain the whole messaging system...]
}


// ResetDiscs clear the Tower, if it is a GOAL (Towers B and C),
// and stacks it full of Discs, if it's a START.
// The Locking is important. (AFAIK, but it costs a lot of crashed, if you don't lock!)
void DiscTowerView::ResetDiscs() {
	if (Window()) Window()->Lock(); // If the View is attached to a Window, Lock that
	MakeEmpty(); // Clear the List

	if (myKind==START){ // For Tower 'A'
		for (int DiscCount=0;DiscCount<NumberOfDiscs;DiscCount++)
				AddItem(Discs[DiscCount],DiscCount); // Stack the Discs
		FirstDisc=0; 
			// And mark the Tower as full. The First Disc is the uppermost (index 0)
		}
	else { // For the other Towers
		for (int DiscCount=0;DiscCount<NumberOfDiscs;DiscCount++)
				AddItem(DummyDisc,DiscCount); // Stack DummyDiscs !
		FirstDisc=NumberOfDiscs; 
			// Declare the Tower as empty. Note that you shouldn't look, what is at
			// index 'FirstDisc', as this will be NULL.
		}

	if (Window()) Window()->Unlock(); // Unlock the Window, if the View is attached.
	// Note to Locking: 
	//  AFAIK (but you may look at the BeBook, if you like), you have to lock the window,
	//  as soon as you change the view hierarchie. By adding and removing Items (this 
	//  absolutely includes MakeEmpty()! ), you do exactly this, as the seperate Items in
	//  the list are Views that are children of the BListView.
	//  [Anybody correct me, if I'm wrong!]
}		

// MessageReceived does, what it alway does: it reacts to the messages it knows
// and passed the other 'up' to BListView
void DiscTowerView::MessageReceived(BMessage *message){
	switch(message->what) {
		case OFFER_DISC: // Somebody offers a disc to us.
			{
			// printf("Disc has been offered.\n"); // Debug
			
			// First check, if it's from another application. This is just a 
			// play-around-feature. ;-)
			if (message->IsSourceRemote()) {
			   	BAlert *alert = new BAlert("Warning!","No Cheating Please!","All right"); 
				alert->Go(); // Oh, by the way: Never delete the BAlert object!
				break;
				}

			// For further examination, find out, what the other has to offer.
			Disc *DiscPtr;
			message->FindPointer("DiscPtr",&DiscPtr); // get the Pointer out of the incoming message

			if (HasItem(DiscPtr)) { // We already have that disc. So return
				// Note: This happens, when you drop on the same tower where you dragged from
				// ... or, it's a bug ;-)
				//	printf("Disc is already here.\n"); // Debug
				break;
				}

			bool accept = FALSE; // Decision flag. Do we accept the disc?

			if (TowerEmpty()) // An empty Tower gladly accepts everthing
				{
				// printf("Tower ist empty. Accepted.\n"); // Debug
				accept = TRUE;
				}
			else // Tower is not empty. Compare the sizes of the discs.
				if ((FirstDiscPtr()->size) > DiscPtr->size)
					{
					// Accept, if the offered (dragged) disc is smaller than the one on top
					// printf("Other Disc is bigger. Accepted.\n"); // Debug
					accept = TRUE;
					}

			if (accept) {
				(FirstDisc)--; // We'll soon have one more disc, so move upward
				//	printf("FirstDisc here is now %i\n",FirstDisc); // Debug
				if (FirstDisc<0) { printf("ERROR: FirstDisc<0!!!!\n"); break; }; // Error-Check!

				// Make up a DISC_ACCEPTED reply for the offering Tower
				//  Include 'myName', because the offering Tower will have to
				//  make the report to the history window.
				BMessage myReply(DISC_ACCEPTED);
				myReply.AddString("RecTower",myName);
				message->SendReply(&myReply); // Send it back to where it came from
						
				// After the message has gone, put the offered disc on top.
				ReplaceItem(FirstDisc,DiscPtr);
				// Note: FirstDisc points to the 'empty' place on top of the tower
				// Although this place seems empty, it contained a DummyDisc.
				// Through the ReplaceItem call, that DummyDisc is removed and the offered
				// disc is placed at it's position.
						
				// Check, if the user has won
				if ((myKind == GOAL) && (TowerFull())) {
				   	BAlert *alert = new BAlert("Info","You did it !","Really?"); 
					alert->Go(NULL); 
						// Go(NULL) opens an asnychronous Alert Box. 
						// We can't wait here, cause that would cause an ugly effect:
						// The last disc exists twice right now, because the offering
						// tower has not yet deleted it. And we don't want the user
						// to see that, do we?
						// Anyway, we don't care, when he presses the button of the Alert
						// Box. He will do it.... some time.
					}
				}
			else { // that means: accepted=false
				// Deny the offer. Probably the move is not allowed.
				// printf("Other Disc is smaller. DENIED.\n"); // Debug
				BMessage myreply(DISC_DENIED); // Make up a simple reply.
				message->SendReply(&myreply); // send it back.
				}
			}
		break;

		case DISC_ACCEPTED: 
		// We get a reply message: we offered a disc to some other tower, and that
		// tower accepted:
			{
			char *RecTower; 
			// printf("Original Tower: Offered Disc has been accepted.\n"); // Debug
			message->FindString("RecTower",&RecTower); // gets the Pointer to the String!
			// Note: I have no clue, where the string is stored. Probably, it's stored
			//  in the message object, which is not valid for a long time.
			//  The (holy) BeBook tells me to copy the string.... It works without that,
			//  'cause I only need a character for about one millisecond ;-)
			
			int DS=FirstDiscPtr()->size; 
			// Save the size of the uppermost Disc. Needed for the History display
			
			ReplaceItem(FirstDisc,DummyDisc);
			// Replace the uppermost Disc with a DummyDisc
			//  This 'removes' the Disc on top. For more, see above.

			FirstDisc++; // The tower is a bit smaller now, so the uppermost disc is one position 'deeper'
			// printf("Original Tower: Disc has been removed.\n"); // Debug
			// printf("Original Tower: FirstDisc here is now %i\n",FirstDisc); // Debug

			// As the move is done now, show it:
			theHistoryWindow->AddMove(myName[0],RecTower[0],DS);
			// This sends the two labels of the participating towers and the size of
			// the Disc to the HistoryWindow. That will inc the counter and display
			// the move.
			}
		break;
		case DISC_DENIED:
		// We get an other reply message: we offered a disc to some other tower,
		// but that tower didn't like it. Inform the user about the desaster
			{
		   	BAlert *alert = new BAlert("Info!","You can't play a Disc\n on a smaller one!","Too bad..."); 
			alert->Go();
			}
		break;
	default: // all other messages are passed to BListView
		BListView::MessageReceived(message);
		break;
	}
}


// Implementation of TowerWindow class

// The Contructor sets of the Window (uh....)
//  That one constructs the menu (with the submenu, thus it's a bit lengthy),
//  and adds the three towers and their labels as children.
TowerWindow::TowerWindow(BRect frame, const char* name, HistoryWindow* History)
			: BWindow(frame, name, B_TITLED_WINDOW,B_NOT_ZOOMABLE|B_NOT_RESIZABLE|B_WILL_ACCEPT_FIRST_CLICK) {

	// printf("New TowerWindow\n"); // Debug
	
	// The whole stuff below constructs a menu with submenu
	BMenuBar* mb = new BMenuBar(BRect(0,0,frame.right,15), "menubar"); // the menu bar
	BMenu* menu = new BMenu("Game");  // the game menu (the only one up as of now)
	BMenu* rMenu = new BMenu("Reset"); // the Reset submenu
	
	// Contruction of the submenu including construction of the model messages:
	// Contruct model message for resetting the game with 2 discs
	BMessage* ResetMessy2 = new BMessage(RESET_GAME);
	ResetMessy2->AddInt32("Discs",2);
	rMenu->AddItem(new BMenuItem("2 Discs", ResetMessy2,'2'));
	// Contruct model message for resetting the game with 3 discs
	BMessage* ResetMessy3 = new BMessage(RESET_GAME);
	ResetMessy3->AddInt32("Discs",3);
	rMenu->AddItem(new BMenuItem("3 Discs", ResetMessy3,'3'));
	// Contruct model message for resetting the game with 4 discs
	BMessage* ResetMessy4 = new BMessage(RESET_GAME);
	ResetMessy4->AddInt32("Discs",4);
	rMenu->AddItem(new BMenuItem("4 Discs", ResetMessy4,'4'));
	// Contruct model message for resetting the game with 5 discs
	BMessage* ResetMessy5 = new BMessage(RESET_GAME);
	ResetMessy5->AddInt32("Discs",5);
	rMenu->AddItem(new BMenuItem("5 Discs", ResetMessy5,'5'));
	// Contruct model message for resetting the game with 6 discs
	BMessage* ResetMessy6 = new BMessage(RESET_GAME);
	ResetMessy6->AddInt32("Discs",6);
	rMenu->AddItem(new BMenuItem("6 Discs", ResetMessy6,'6'));
	// Contruct model message for resetting the game with 7 discs
	BMessage* ResetMessy7 = new BMessage(RESET_GAME);
	ResetMessy7->AddInt32("Discs",7);
	rMenu->AddItem(new BMenuItem("7 Discs", ResetMessy7,'7'));
	// Contruct model message for resetting the game with 8 discs
	BMessage* ResetMessy8 = new BMessage(RESET_GAME);
	ResetMessy8->AddInt32("Discs",8);
	rMenu->AddItem(new BMenuItem("8 Discs", ResetMessy8,'8'));
	// Contruct model message for resetting the game with 9 discs
	BMessage* ResetMessy9 = new BMessage(RESET_GAME);
	ResetMessy9->AddInt32("Discs",9);
	rMenu->AddItem(new BMenuItem("9 Discs", ResetMessy9,'9'));
	// Contruct model message for resetting the game with 10 discs
	BMessage* ResetMessy10 = new BMessage(RESET_GAME);
	ResetMessy10->AddInt32("Discs",10);
	rMenu->AddItem(new BMenuItem("10 Discs", ResetMessy10,'0'));
	// (uh.oh. done with the submenu)

	menu->AddItem(rMenu); // add the whole submenu to the menu
	menu->AddItem(new BMenuItem("Start Auto Solve", new BMessage(SOLVE_GAME),'S'));
	menu->AddSeparatorItem();
	menu->AddItem(new BMenuItem("About", new BMessage(B_ABOUT_REQUESTED),'A'));
	menu->AddItem(new BMenuItem("Quit", new BMessage(B_QUIT_REQUESTED),'Q'));

	// all messages should directly go to out app instead of the window
	menu->SetTargetForItems(be_app);
	rMenu->SetTargetForItems(be_app);
	mb->AddItem(menu); // add menu to bar

	AddChild(mb); // add the menu bar to the window
	
	// Add the Towers and their labels above them
	BRect r(0,0,200,150); // this will be used by the towers
	BRect r1(0,0,200,15); // and that by the labels

	r.OffsetBy(5,35); // adjust the position
	r1.OffsetBy(99,18); // that one, too
	TowerA=new DiscTowerView(r,START,'A',History); // Create Start Tower
	AddChild(TowerA); // add it
	AddChild(new BStringView(r1,"label","A")); // add label
	// Note: we won't need the labels anymore, so we can forget about them at once
	// The towers (TowerA, TowerB, TowerC) are important to us. So, they are constructed
	// another way and the pointers are saved.
	// Also note, that (AFAIK) you don't have to bother about deleting the whole stuff,
	// this will be done, when the window is deleted, which is done, when the app
	// is deleted (or somewhen around that time)

	// allright, the whole stuff again for Towers B and C
	r.OffsetBy(200,0);
	r1.OffsetBy(200,0);
	TowerB=new DiscTowerView(r,GOAL,'B',History);
	AddChild(TowerB);
	AddChild(new BStringView(r1,"label","B"));

	r.OffsetBy(200,0);
	r1.OffsetBy(200,0);
	TowerC=new DiscTowerView(r,GOAL,'C',History);
	AddChild(TowerC);
	AddChild(new BStringView(r1,"label","C"));

	Show(); // Show the Window
	// Note that we still are in the constructor of the application!
	// This might not be the best time to show() a window, but it works and the
	// others (other tutorials) do it the same way.
	// It might be better to show the windows when the app is READY_TO_RUN.
	// Try that is your app crashed at start ;-)
}



// ResetTowers does what it should.
//  Only note, that the Window-Locking-Part is done in ResetDiscs(), that means
//  that the Window is locked and unlocked three times altogether. Not perfect, but it works
void TowerWindow::Reset() {
	TowerA->ResetDiscs();
	TowerB->ResetDiscs();
	TowerC->ResetDiscs();
}


// QuitRequested is called, when the user wants to close the window.
//  Notifiy the application of that (so it may close down the rest) and allow the closing
bool TowerWindow::QuitRequested() {
	// printf("*** TowerWin::QuitReq\n"); // Debug
	be_app->PostMessage(B_QUIT_REQUESTED);
	// Note: ahem. Read the readme. ;-)
	// Well, in fact, under certain circumstances, this message arrives at the app
	// very late. To late to do something cool.
	// This happens, when the application thread unmotivatetly falls asleep.
	// I don't know why this happens, but hey, I'm not a kernel hacker :-(
	return true;
}

 