//
// Towers of Hanoi
//
// Copyright 1998
//
// Written by: Marco Zinn
//
// If you're about to read this source code, read Tower.h before, please....

#include "Towers.h" // defines the TowerApp class
#include "TowerWindow.h" // defines the Disc, DiscTowerView and TowerWindow classes
#include "ControlWindow.h" // defines the ControlWindow class
#include "HistoryWindow.h" // defines the HistoryWindow class

//
// Implementation of TowerApp class 
//
// This one is derived from BApplication. It will be our application.
// Note, that you won't see that class on screen. What you'll see are just the window
//

// The constructor does all the stuff that happens, when you start the app.
TowerApp::TowerApp()
			: BApplication("application/x-vnd.MarcoZ-Towers") { 
		// Note: If you're using a ressource file (as I do here), make sure,
		// the application signature here is the same as the one in the ressource file!

	NumberOfDiscs=4; // Height of the Start-Tower; is equal to the total number of discs in play
	
	// Create the Discs:
	//  At starttime, all (10) discs are created. How many get shown, is not relevant here.
	// 	By doing this, I do not have to creatd and destroy the discs every time the game
	//  will be reset by the user.
	rgb_color discColor; // Prepare the color the Discs will get:
	discColor.green=0;   // green, blue and alpha are the same for all discs (red will change)
	discColor.blue=0;
	discColor.alpha=128;

	// Loop and create all (10) discs now:
	for (int DiscCount=0;DiscCount<MAX_DISCS;DiscCount++) {
		discColor.red=(255-DiscCount*20); // red value changes. Run the app, you'll see it!
		Discs[DiscCount]= new Disc(DiscCount+1, discColor); // size, color
		}	

	// Create a single Dummy-Discs. They have color, but are NOT drawn. See disc::draw()
	discColor.red=0;discColor.green=0;discColor.blue=100; // color was for debugging, of course
	DummyDisc = new Disc (1,discColor); // 'size' of the Disc is 1. That's in case, you want to draw it.

	
	
	// We'll set up the windows now....
	// For a deeper explanation of the windows, see the appropriate header file!
	
	BRect windowRect; // That's the BRect we will (re-)use for the windows.

	// Control Window for auto-solving (invisible until solving started)
	windowRect.Set(20,280,200,400);	
	Controls = new ControlWindow(windowRect,"Controls");

	// History Window for showing the moves made
	windowRect.Set(650,40,780,340);	
	History = new HistoryWindow(windowRect,"History");

	// Tower Window for showing the towers (and the menu).
	windowRect.Set(0,0,610,170); // Another way to place the window: This line is the size
	windowRect.OffsetTo(20,40);  // and that line is the position of the window. Easier to play around with ;-)
	Towers = new TowerWindow(windowRect,"Towers",History);
}

// ResetGame resets the game (indeed!):
// it might set a new number of discs before doing that
// then it stacks up Tower A and clears the move history.
void TowerApp::ResetGame(int NewNumberOfDiscs) {
	if (NewNumberOfDiscs>MAX_DISCS) NewNumberOfDiscs=MAX_DISCS; // Error-Check.
	NumberOfDiscs=NewNumberOfDiscs;
	//	printf("App::Reset: NumberOfDiscs=%i\n",NumberOfDiscs); // Debug
	History->Reset(); // Sets the Counter to 0 and clears the history list
	Towers->Reset(); // resets the Towers (A will be full, B and C empty)
	//	printf("App::Reset: done\n",NumberOfDiscs); // Debug
	}

// The destructor destructs the discs (Discs Array and DummyDisc)
// Note, that you shouldn't destroy the windows. AFAIK they are destroyed by some
// other magical mechanism!
TowerApp::~TowerApp() {
	for (int DiscCount=0;DiscCount<MAX_DISCS;DiscCount++)
		delete Discs[DiscCount]; // Destroys the array..
	delete DummyDisc; // ...and the highly important DummyDisc
}

// AboutRequested is called when the About window is asked for. It brings up...
// ... the About-Box (believe it or not!)
//  see TowerWindow.c for how the menu works.
void TowerApp::AboutRequested()
{
	(new BAlert("About...",
		"Towers of Benoi V1.5\n\n"
		"The first thing I can publish without getting completely red...\n"
		"Marco Zinn, 1998 (marco.zinn@gmx.de)",
		"Very Cool!"))->Go();
	// .... well, I copied that from somewhere, but it works and it's short...
}


// The application only gets the messages concerning the application itself (ie. the game)
//  In detail, these are RESET_GAME and SOLVE_GAME requests from the menu.
void TowerApp::MessageReceived(BMessage *message){
	switch(message->what) {
		case RESET_GAME: // application got a request to reset the game
			// printf("Towers=%p\n",Towers); // Debug
			// printf("Towers->TowerA->Window()=%p\n",Towers->TowerA->Window()); // Debug

		    // If the main window (=TowerWindow) has been deleted, get out of here.
		    // This will happen, if the message arrives 'too late'. See 'known issues' in the readme.
			if (Towers->TowerA->Window()==NULL) break;
//			Controls->StopSolving();
			int i=message->FindInt32("Discs"); // retrieve number of discs to reset the game to
			// printf("Reset to %i discs.\n",i); // Debug again
			if ((i>1) && (i<=10)) ResetGame(i);	 // Error-Check and reset.
			break;
		case SOLVE_GAME: // application got a request to solve the game
			ResetGame(); // ahem. we need to reset te game first. Sorry 'bout that
			Controls->SolveGame(Towers->TowerA, Towers->TowerC, Towers->TowerB);
			// The we call the full-automatic-all-in-one-do-it-all-by-yourself solving function.
			//  The call means: Solve the game!
			//  ... okay, to be more specific, it means: Move Tower A to Tower C and use Tower B as a buffer;
			//      do the whole thing with all the discs currently in play.
			// That's all. If you wanna know about the magic way the function does it's job,
			// see ControlWindow.c
			break;
		default: // Any other messages are passed to BApplication. DO NOT FORGET THIS!
			BApplication::MessageReceived(message);
			break;
	}
}

//
// main
//

// Uh. oh. Well, that's the main programm. guess, you've seen something like that before...
void main(void) {
	TowerApp theApp;
	theApp.Run();
}
 