/******************************************************************************/
/* APlayer global header file.                                                */
/******************************************************************************/
/* This is part of the APlayer Programming Package (APPP).                    */
/* Copyright (C) 1998-1999 by The APlayer-Team.                               */
/* All rights reserved.                                                       */
/*                                                                            */
/* This source, or parts thereof, may only be used in APlayer related         */
/* software. If you want to use it elsewhere, please contact the author for a */
/* permission.                                                                */
/******************************************************************************/


#ifndef __APlayer_h
#define __APlayer_h

// PolyKit headers
#include "POS.h"
#include "PString.h"
#include "PRegistry.h"
#include "PSynchronize.h"

// APlayer headers
#include "APList.h"
#include "APChannel.h"
#include "APAddOns.h"
#include "APlayerClasses_Import.h"


// Constants for the layout
#define HSPACE		4.0
#define VSPACE		4.0

#define PICHSIZE	16.0
#define PICVSIZE	16.0


// Private functions
typedef APAddOnConverter *(*AllocateConverterFunc)(void *converter);



/******************************************************************************/
/* Class given to the player and agents constructor.                          */
/* Remember to call Lock() and Unlock() when you accessing the data.          */
/******************************************************************************/
class APAddOnPlayer;
class APModuleList;

#if __p_os == __p_beos && __POWERPC__
#pragma export on
#endif

class _IMPEXP_APLIB APGlobalData : public PMutex
{
public:
	APGlobalData(void);
	virtual ~APGlobalData(void);

	void InstallModType(PString type, PString extension, PString lDescription, PString sDescription, void *smallIcon, void *largeIcon);

	void CallModuleInfoChangePlugins(uint32 line, ap_infoType type, PString newString);
	void CallAfterAddingFilesPlugins(void);
	void CallAfterRemovingFilesPlugins(void);

	void GetLoaderConverterNames(PList<PString> &names);
	void GetSaverConverterNames(PList<PString> &names);
	APAddOnConverter *GetConverterInstance(PString name);
	void DeleteConverterInstance(APAddOnConverter *converter);

	PRegistry *		useReg;				// Read and write your config data to this one
	PRegistry *		saveReg;			// Write only your config data to this one

	APModuleList *	moduleList;			// Use this class to work on module lists

	APAddOnPlayer *	player;				// A pointer to the player in use
	uint32			playerIndex;		// Is the index number in the player add-on
	PString			playerName;			// The name of the player

	PString			fileName;			// This is the filename with full path
	uint32			moduleLen;			// The length of the module in bytes

	PString			author;				// The author of the module

	PList<APInstInfo *> instruments;	// Read only from this list. It contains the instrument data of the current playing module
	PList<APSampleInfo *> samples;		// Read only from this list. It contains the sample data of the current playing module

protected:
	APList<APAddOnAgent *> afterAddingFilesAgents;
	APList<APAddOnAgent *> afterRemovingFilesAgents;

	PList<void *> converterLoaders;
	PList<void *> converterSavers;
	AllocateConverterFunc allocateConverter;
};

#if __p_os == __p_beos && __POWERPC__
#pragma export off
#endif

#endif
