/******************************************************************************/
/* MIListItem header file.                                                    */
/******************************************************************************/
/* This is part of the APlayer Programming Package (APPP).                    */
/* Copyright (C) 1998-1999 by The APlayer-Team.                               */
/* All rights reserved.                                                       */
/*                                                                            */
/* This source, or parts thereof, may only be used in APlayer related         */
/* software. If you want to use it elsewhere, please contact the author for a */
/* permission.                                                                */
/******************************************************************************/


#ifndef __MIListItem_h
#define __MIListItem_h

// PolyKit headers
#include "PString.h"


/******************************************************************************/
/* MIListItem class                                                           */
/******************************************************************************/
class MIListItem : public CLVListItem
{
public:
	MIListItem(float minHeight, const PString description, const PString value);
	virtual ~MIListItem(void);

	bool ChangeColumn(PString string, int16 columnIndex);

protected:
	void DrawItemColumn(BView *owner, BRect itemColumnRect, int32 columnIndex, bool complete);
	void Update(BView *owner, const BFont *font);

	PString columnText[2];
	float textOffset;
};

#endif
