/******************************************************************************/
/* MikMod header file.                                                        */
/******************************************************************************/
/* This is part of the APlayer Programming Package (APPP).                    */
/* Copyright (C) 1998-1999 by The APlayer-Team.                               */
/* All rights reserved.                                                       */
/*                                                                            */
/* This source, or parts thereof, may only be used in APlayer related         */
/* software. If you want to use it elsewhere, please contact the author for a */
/* permission.                                                                */
/******************************************************************************/


#ifndef __MikMod_h
#define __MikMod_h

// PolyKit headers
#include "PString.h"
#include "PFile.h"
#include "PSynchronize.h"

// APlayer headers
#include "APAddOns.h"

// Needed headers
#include "MikMod_Internals.h"
#include "MUniTrk.h"


/******************************************************************************/
/* ITPACK structure                                                           */
/******************************************************************************/
typedef struct ITPACK
{
	uint16	bits;				// Current number of bits
	uint16	bufBits;			// Bits in buffer
	int16	last;				// Last output
	uint8	buf;				// Bit buffer
} ITPACK;



/******************************************************************************/
/* MikMod class                                                               */
/******************************************************************************/
#define BUFPAGE			128			// Smallest unibuffer size
#define TRESHOLD		16

class MikMod : public APAddOnPlayer
{
public:
	MikMod(APGlobalData *global);
	virtual ~MikMod(void);

	float GetVersion(void);
	uint32 GetSupportFlags(void);

	PString GetName(uint32 number);
	PString GetDescription(uint32 number);
	PString GetModTypeString(uint32 index);

	ap_result ModuleCheck(uint32 index, PFile *file);
	ap_result LoadModule(uint32 index, PFile *file);

	bool InitPlayer(void);
	void EndPlayer(void);
	void InitSound(uint16 songNum);
	void EndSound(void);
	void Play(void);

	PString GetModuleName(void);
	uint16 GetVirtualChannels(void);
	uint16 GetModuleChannels(void);
	int16 GetSongLength(void);
	int16 GetSongPosition(void);
	void SetSongPosition(int16 pos);

	uint32 GetInfoCount(void);
	PString GetInfoString(uint32 line, ap_infoType type);

	uint32 GetInstrumentCount(void);
	void GetInstrumentInfo(uint32 num, APInstInfo *info);

	uint32 GetSampleCount(void);
	void GetSampleInfo(uint32 num, APSampleInfo *info);

protected:
	ap_result CreateUniStructs(PFile *file);
	uint8 *TrkRead(PFile *file);
	ap_result FindSamples(PFile *file);
	bool DecompressIT8(ITPACK *status, PFile *file, int8 *dest, uint32 length, uint16 *inCnt);
	bool DecompressIT16(ITPACK *status, PFile *file, int16 *dest, uint32 length, uint16 *inCnt);
	void ShowError(uint32 id);
	void SetTempo(uint16 tempo);

	// Player functions
	void Player_HandleTick(void);
	void PT_UpdateVoices(int32 max_Volume);
	void PT_Notes(void);
	void PT_EffectsPass1(void);
	void PT_EffectsPass2(void);
	void PT_NNA(void);
	void PT_SetupVoices(void);

	int32 GetRandom(int32 ceil);
	uint16 GetPeriod(uint16 note, uint32 speed);
	uint16 GetOldPeriod(uint16 note, uint32 speed);
	uint16 GetLinearPeriod(uint16 note, uint32 fine);
	uint16 GetLogPeriod(uint16 note, uint32 fine);
	uint32 GetFrequency(uint8 flags, uint32 period);

	int16 Interpolate(int16 p, int16 p1, int16 p2, int16 v1, int16 v2);
	int16 InterpolateEnv(int16 p, ENVPT *a, ENVPT *b);
	int16 DoPan(int16 envPan, int16 pan);

	void StartEnvelope(ENVPR *t, uint8 flg, uint8 pts, uint8 susBeg, uint8 susEnd, uint8 beg, uint8 end, ENVPT *p, uint8 keyOff);
	int16 ProcessEnvelope(ENVPR *t, int16 v, uint8 keyOff);
	int32 FindEmptyChannel(void);

	// Effect functions
	void PT_PlayEffects(void);
	void DoEEffects(uint8 dat);
	void DoArpeggio(uint8 dat);
	void DoToneSlide(void);
	void DoVibrato(void);
	void DoTremolo(void);
	void DoVolSlide(uint8 dat);

	// S3M effect functions
	void DoS3MSpeed(uint8 speed);
	void DoS3MVolSlide(uint8 inf);
	void DoS3MSlideDn(uint8 inf);
	void DoS3MSlideUp(uint8 inf);
	void DoS3MTremor(uint8 inf);
	void DoS3MRetrig(uint8 inf);
	void DoS3MTremolo(void);
	void DoS3MTempo(uint8 tempo);
	void DoS3MFineVibrato(void);

	// XM effect functions
	void DoXMVolSlide(uint8 inf);
	void DoXMGlobalSlide(uint8 inf);
	void DoXMPanSlide(uint8 inf);
	void DoXMExtraFineSlideUp(uint8 inf);
	void DoXMExtraFineSlideDown(uint8 inf);

	// IT effect functions
	void DoVolEffects(uint8 c);
	void DoITToneSlide(void);
	void DoITVibrato(void);
	void DoITTremor(uint8 inf);
	void DoITChanVolSlide(uint8 inf);
	void DoITPanSlide(uint8 inf);
	void DoSSEffects(uint8 dat);
	void DoNNAEffects(uint8 dat);
	void DoITTempo(uint8 tempo);
	void DoITFineVibrato(void);
	void DoITGlobalSlide(uint8 inf);
	void DoITPanbrello(void);

	// ULT effect functions
	void DoULTSampleOffset(void);

	// Voice specific functions
	void VoicePlay(int8 voice, SAMPLE *s, uint32 start);
	void VoiceSetVolume(int8 voice, uint16 vol);
	void VoiceSetPanning(int8 voice, uint32 pan);
	void VoiceSetFrequency(int8 voice, uint32 frq);
	void VoiceStop(int8 voice);
	bool VoiceStopped(int8 voice);

	// Memory functions
	bool AllocPositions(int32 total);
	bool AllocPatterns(void);
	bool AllocTracks(void);
	bool AllocSamples(void);
	bool AllocInstruments(void);
	void FreeAll(void);

	// Variables
	uint32 strings;
	PMutex *readyToPlay;

	uint8 *module;
	uint32 modLength;
	bool eof;

	MODULE of;
	uint8 explicitSlides;
	int16 mp_Channel;			// Channel we're working on
	MP_CONTROL *a;				// Current AUDTMP we're working on
	MUniTrk uniTrk;

	// Voice variables
	uint8 md_sngChn;
};

#endif
