/******************************************************************************/
/* TestPlayer header file.                                                    */
/******************************************************************************/
/* This is part of the APlayer Programming Package (APPP).                    */
/* Copyright (C) 1998-1999 by The APlayer-Team.                               */
/* All rights reserved.                                                       */
/*                                                                            */
/* This source, or parts thereof, may only be used in APlayer related         */
/* software. If you want to use it elsewhere, please contact the author for a */
/* permission.                                                                */
/******************************************************************************/


#ifndef __TestPlayer_h
#define __TestPlayer_h

// PolyKit headers
#include "PString.h"
#include "PFile.h"

// APlayer headers
#include "APlayer.h"


/******************************************************************************/
/* TestPlayer class                                                           */
/******************************************************************************/
class TestPlayer : public APAddOnPlayer
{
public:
	TestPlayer(APGlobalData *global);
	virtual ~TestPlayer(void);

	float GetVersion(void);

	uint32 GetCount(void);
	PString GetName(uint32 index);
	PString GetDescription(uint32 index);

	uint32 GetSupportFlags(void);

	PString GetModTypeString(uint32 index);

	ap_result ModuleCheck(uint32 index, PFile *file);
	ap_result LoadModule(uint32 index, PFile *file);
	ap_result ExtraLoad(PString fileName);

	bool InitPlayer(void);
	void EndPlayer(void);
	void InitSound(uint16 songNum);
	void EndSound(void);
	void Play(void);

	void GetSamplePlayerInfo(SamplePlayerInfo *sampInfo);
	PString GetModuleName(void);
	PString GetAuthor(void);
	uint16 GetVirtualChannels(void);
	uint16 GetModuleChannels(void);
	uint16 *GetSubSongs(void);

	int16 GetSongLength(void);
	int16 GetSongPosition(void);
	void SetSongPosition(int16 pos);

	uint32 GetInfoCount(void);
	PString GetInfoString(uint32 line, ap_infoType type);

protected:
	bool writePlay;

	uint16 noteCount;
	uint16 index;
	int16 position;

	uint16 subSongs[2];
};

#endif
