//functions of EditShipWindow soi0.1

#include "windowGuts.h"
#include "editShipWindow.h"
#include "def.h"
#include "showSomeThings.h"
#include "getSomeThings.h"
#include "getFromList.h"
#include "saveLoadUniverse.h"
#include "titleWindow.h"
#include "designButtons.h"

void EditShipWindow::SaveRequested(const char * fileName) 
{

SaveShips(fileName);
}//end


EditShipWindow::EditShipWindow(BRect area, const char *title) : BWindow(area, title, B_TITLED_WINDOW, B_NOT_RESIZABLE|B_NOT_ZOOMABLE) 
{

err = NO_ERR;
orderButton = NULL;
bb = new BottomButtons;
if (bb) 
{
	if (editUniverseWindow) 
	{
		editUniverseWindow->Lock();
		editUniverseWindow->buttons[DSN_SHIP]->SetEnabled(false);
		editUniverseWindow->Unlock();
	}
	db = new DoableButtons();
	if (db) 
	{
		maint = new DoableButtons();
		if (maint) 
		{
			scg = new SmallConstantsGadgets();
			if (scg) 
			{
				bld = new DoableButtons();
				if (!bld) err = CREATEDNOTADDED;
			}
			else err = CREATEDNOTADDED;
		}
		else err = CREATEDNOTADDED;
	}
	else err = CREATEDNOTADDED;
}
else err = CREATEDNOTADDED;
editShipWindow = this;
if (!shipCurrent) if (dataListGlobal[SHIP_TYPE]->list->CountItems()) shipCurrent = (Ship *)((DataNode *)dataListGlobal[SHIP_TYPE]->list->ItemAt(0))->data;
}//end


EditShipWindow::~EditShipWindow() 
{

if (bb) 
{
	if (editUniverseWindow) 
	{
		editUniverseWindow->Lock();
		editUniverseWindow->buttons[DSN_SHIP]->SetEnabled(true);
		editUniverseWindow->Unlock();
	}
	delete bb;
}
if (bld) delete bld;
if (db) delete db;
if (maint) delete maint;
if (scg) delete scg;
if (orderButton) 
{
	orderButton->RemoveSelf();
	delete orderButton;
}
//if (kindButton) 
//{
//	kindButton->RemoveSelf();
//	delete kindButton;
//}
editShipWindow = NULL;
}//end


void EditShipWindow::AddShip(void) 
{

Ship * item = new Ship(ship, scg->nameStrGadget->Text(), dataListGlobal[SHIP_TYPE]);
if (item) 
{
	if (err != CREATED) 
	{
		delete item;
		return;
	}
}
else err = NO_SHIP;
}//end


void EditShipWindow::MessageReceived(BMessage *message) 
{

bool validate = true;
int32 shipSize = sizeof shipCurrent;
if (!strcmp(scg->nameStrGadget->Text(), "")) validate = false;

switch (message->what) 
{
	case SOI_NAME:
	case SOI_VOLUME:
	case SOI_VPER:
	
	break;
	case SOI_MAINTAINABLEBUTTONLABEL:
		if (maint->showing) 
		{
			maint->label->SetLabel(selectMaintValue);
			maint->showing = false;
		}
		else {
			maint->label->SetLabel(showMaintValue);
			maint->showing = true;
		}
		maint->ResetMsg(message->what);
	break;
	case SOI_BUILDABLEBUTTONLABEL:
		if (bld->showing) 
		{
			bld->label->SetLabel(selectProdValue);
			bld->showing = false;
		}
		else {
			bld->label->SetLabel(showProdValue);
			bld->showing = true;
		}
		bld->ResetMsg(message->what);
	break;
	case SOI_DOABLEBUTTONLABEL:
		if (db->showing) 
		{
			db->label->SetLabel(selectConsumeValue);
			db->showing = false;
		}
		else {
			db->label->SetLabel(showConsumeValue);
			db->showing = true;
		}
		db->ResetMsg(message->what);
	break;
	case SOI_GETPOSSORDERS:
	
	break;
	case SOI_BUILDABLEBUTTONPRIMALELEMENTS:
		GetSomeThings(ship->buildable->elementPrimal->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ELEMENT_TYPE], SHIP_TYPE);
	break;
	case SOI_BUILDABLEBUTTONPRIMALCOMPOUNDS:
		GetSomeThings(ship->buildable->compoundPrimal->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[COMPOUND_TYPE], SHIP_TYPE);
	break;
	case SOI_BUILDABLEBUTTONELEMENTS:
		GetSomeThings(ship->buildable->elementManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ELEMENT_TYPE], SHIP_TYPE);
	break;
	case SOI_BUILDABLEBUTTONCOMPOUNDS:
		GetSomeThings(ship->buildable->compoundManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[COMPOUND_TYPE], SHIP_TYPE);
	break;
	case SOI_BUILDABLEBUTTONMINES:
		GetSomeThings(ship->buildable->mineManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[MINE_TYPE], SHIP_TYPE);
	break;
	case SOI_BUILDABLEBUTTONFACTORYS:
		GetSomeThings(ship->buildable->factoryManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[FACTORY_TYPE], SHIP_TYPE);
	break;
	case SOI_BUILDABLEBUTTONENGINES:
		GetSomeThings(ship->buildable->engineManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ENGINE_TYPE], SHIP_TYPE);
	break;
	case SOI_BUILDABLEBUTTONSHIPS:
		GetSomeThings(ship->buildable->shipManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SHIP_TYPE], SHIP_TYPE);
	break;
	case SOI_BUILDABLEBUTTONSSHIELDS:
		GetSomeThings(ship->buildable->shipShieldManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SSHIELD_TYPE], SHIP_TYPE);
	break;
	case SOI_BUILDABLEBUTTONSHIPWEAPONS:
		GetSomeThings(ship->buildable->shipWeaponManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SHIPWEAPON_TYPE], SHIP_TYPE);
	break;
	case SOI_BUILDABLEBUTTONPLANETSHIELDS:
		GetSomeThings(ship->buildable->planetShieldManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[PLANETSHIELD_TYPE], SHIP_TYPE);
	break;
	case SOI_BUILDABLEBUTTONPLANETWEAPONS:
		GetSomeThings(ship->buildable->planetWeaponManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[PLANETWEAPON_TYPE], SHIP_TYPE);
	break;
	case SOI_DOABLEBUTTONPRIMALELEMENTS:
		GetSomeThings(ship->doable->elementPrimal->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ELEMENT_TYPE], SHIP_TYPE);
	break;
	case SOI_DOABLEBUTTONPRIMALCOMPOUNDS:
		GetSomeThings(ship->doable->compoundPrimal->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[COMPOUND_TYPE], SHIP_TYPE);
	break;
	case SOI_DOABLEBUTTONELEMENTS:
		GetSomeThings(ship->doable->elementManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ELEMENT_TYPE], SHIP_TYPE);
	break;
	case SOI_DOABLEBUTTONCOMPOUNDS:
		GetSomeThings(ship->doable->compoundManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[COMPOUND_TYPE], SHIP_TYPE);
	break;
	case SOI_DOABLEBUTTONMINES:
		GetSomeThings(ship->doable->mineManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[MINE_TYPE], SHIP_TYPE);
	break;
	case SOI_DOABLEBUTTONFACTORYS:
		GetSomeThings(ship->doable->factoryManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[FACTORY_TYPE], SHIP_TYPE);
	break;
	case SOI_DOABLEBUTTONENGINES:
		GetSomeThings(ship->doable->engineManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ENGINE_TYPE], SHIP_TYPE);
	break;
	case SOI_DOABLEBUTTONSHIPS:
		GetSomeThings(ship->doable->shipManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SHIP_TYPE], SHIP_TYPE);
	break;
	case SOI_DOABLEBUTTONSSHIELDS:
		GetSomeThings(ship->doable->shipShieldManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SSHIELD_TYPE], SHIP_TYPE);
	break;
	case SOI_DOABLEBUTTONSHIPWEAPONS:
		GetSomeThings(ship->doable->shipWeaponManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SHIPWEAPON_TYPE], SHIP_TYPE);
	break;
	case SOI_DOABLEBUTTONPLANETSHIELDS:
		GetSomeThings(ship->doable->planetShieldManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[PLANETSHIELD_TYPE], SHIP_TYPE);
	break;
	case SOI_DOABLEBUTTONPLANETWEAPONS:
		GetSomeThings(ship->doable->planetWeaponManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[PLANETWEAPON_TYPE], SHIP_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONPRIMALELEMENTS:
		GetSomeThings(ship->maintainable->elementPrimal->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ELEMENT_TYPE], SHIP_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONPRIMALCOMPOUNDS:
		GetSomeThings(ship->maintainable->compoundPrimal->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[COMPOUND_TYPE], SHIP_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONELEMENTS:
		GetSomeThings(ship->maintainable->elementManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ELEMENT_TYPE], SHIP_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONCOMPOUNDS:
		GetSomeThings(ship->maintainable->compoundManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[COMPOUND_TYPE], SHIP_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONMINES:
		GetSomeThings(ship->maintainable->mineManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[MINE_TYPE], SHIP_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONFACTORYS:
		GetSomeThings(ship->maintainable->factoryManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[FACTORY_TYPE], SHIP_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONENGINES:
		GetSomeThings(ship->maintainable->engineManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[ENGINE_TYPE], SHIP_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONSHIPS:
		GetSomeThings(ship->maintainable->shipManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SHIP_TYPE], SHIP_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONSSHIELDS:
		GetSomeThings(ship->maintainable->shipShieldManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SSHIELD_TYPE], SHIP_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONSHIPWEAPONS:
		GetSomeThings(ship->maintainable->shipWeaponManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[SHIPWEAPON_TYPE], SHIP_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONPLANETSHIELDS:
		GetSomeThings(ship->maintainable->planetShieldManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[PLANETSHIELD_TYPE], SHIP_TYPE);
	break;
	case SOI_MAINTAINABLEBUTTONPLANETWEAPONS:
		GetSomeThings(ship->maintainable->planetWeaponManufactured->list, scg->nameStrGadget->Text(), (void *)this, dataListGlobal[PLANETWEAPON_TYPE], SHIP_TYPE);
	break;
	case SOI_SHOWBUILDPRIMALELEMENTS:
		ShowSomeThings((const void *)&ship, shipSize, shipCurrent->name, SHIP_TYPE, ship->buildable->elementPrimal, scg->nameStrGadget->Text(), editShipWindow, dataListGlobal[ELEMENT_TYPE]);
	break;
	case SOI_SHOWBUILDPRIMALCOMPOUNDS:
		ShowSomeThings((const void *)&ship, shipSize, shipCurrent->name, SHIP_TYPE, ship->buildable->compoundPrimal, scg->nameStrGadget->Text(), editShipWindow, dataListGlobal[COMPOUND_TYPE]);
	break;
	case SOI_SHOWBUILDELEMENTS:
		ShowSomeThings((const void *)&ship, shipSize, shipCurrent->name, SHIP_TYPE, ship->buildable->elementManufactured, scg->nameStrGadget->Text(), editShipWindow, dataListGlobal[ELEMENT_TYPE]);
	break;
	case SOI_SHOWBUILDCOMPOUNDS:
		ShowSomeThings((const void *)&ship, shipSize, shipCurrent->name, SHIP_TYPE, ship->buildable->compoundManufactured, scg->nameStrGadget->Text(), editShipWindow, dataListGlobal[COMPOUND_TYPE]);
	break;
	case SOI_SHOWBUILDMINES:
		ShowSomeThings((const void *)&ship, shipSize, shipCurrent->name, SHIP_TYPE, ship->buildable->mineManufactured, scg->nameStrGadget->Text(), editShipWindow, dataListGlobal[MINE_TYPE]);
	break;
	case SOI_SHOWBUILDFACTORYS:
		ShowSomeThings((const void *)&ship, shipSize, shipCurrent->name, SHIP_TYPE, ship->buildable->factoryManufactured, scg->nameStrGadget->Text(), editShipWindow, dataListGlobal[FACTORY_TYPE]);
	break;
	case SOI_SHOWBUILDENGINES:
		ShowSomeThings((const void *)&ship, shipSize, shipCurrent->name, SHIP_TYPE, ship->buildable->engineManufactured, scg->nameStrGadget->Text(), editShipWindow, dataListGlobal[ENGINE_TYPE]);
	break;
	case SOI_SHOWBUILDSHIPS:
		ShowSomeThings((const void *)&ship, shipSize, shipCurrent->name, SHIP_TYPE, ship->buildable->shipManufactured, scg->nameStrGadget->Text(), editShipWindow, dataListGlobal[SHIP_TYPE]);
	break;
	case SOI_SHOWBUILDSSHIELDS:
		ShowSomeThings((const void *)&ship, shipSize, shipCurrent->name, SHIP_TYPE, ship->buildable->shipShieldManufactured, scg->nameStrGadget->Text(), editShipWindow, dataListGlobal[SSHIELD_TYPE]);
	break;
	case SOI_SHOWBUILDSHIPWEAPONS:
		ShowSomeThings((const void *)&ship, shipSize, shipCurrent->name, SHIP_TYPE, ship->buildable->shipWeaponManufactured, scg->nameStrGadget->Text(), editShipWindow, dataListGlobal[SHIPWEAPON_TYPE]);
	break;
	case SOI_SHOWBUILDPLANETSHIELDS:
		ShowSomeThings((const void *)&ship, shipSize, shipCurrent->name, SHIP_TYPE, ship->buildable->planetShieldManufactured, scg->nameStrGadget->Text(), editShipWindow, dataListGlobal[PLANETSHIELD_TYPE]);
	break;
	case SOI_SHOWBUILDPLANETWEAPONS:
		ShowSomeThings((const void *)&ship, shipSize, shipCurrent->name, SHIP_TYPE, ship->buildable->planetWeaponManufactured, scg->nameStrGadget->Text(), editShipWindow, dataListGlobal[PLANETWEAPON_TYPE]);
	break;
	case SOI_SHOWDOPRIMALELEMENTS:
		ShowSomeThings((const void *)&ship, shipSize, shipCurrent->name, SHIP_TYPE, ship->doable->elementPrimal, scg->nameStrGadget->Text(), editShipWindow, dataListGlobal[ELEMENT_TYPE]);
	break;
	case SOI_SHOWDOPRIMALCOMPOUNDS:
		ShowSomeThings((const void *)&ship, shipSize, shipCurrent->name, SHIP_TYPE, ship->doable->compoundPrimal, scg->nameStrGadget->Text(), editShipWindow, dataListGlobal[COMPOUND_TYPE]);
	break;
	case SOI_SHOWDOELEMENTS:
		ShowSomeThings((const void *)&ship, shipSize, shipCurrent->name, SHIP_TYPE, ship->doable->elementManufactured, scg->nameStrGadget->Text(), editShipWindow, dataListGlobal[ELEMENT_TYPE]);
	break;
	case SOI_SHOWDOCOMPOUNDS:
		ShowSomeThings((const void *)&ship, shipSize, shipCurrent->name, SHIP_TYPE, ship->doable->compoundManufactured, scg->nameStrGadget->Text(), editShipWindow, dataListGlobal[COMPOUND_TYPE]);
	break;
	case SOI_SHOWDOMINES:
		ShowSomeThings((const void *)&ship, shipSize, shipCurrent->name, SHIP_TYPE, ship->doable->mineManufactured, scg->nameStrGadget->Text(), editShipWindow, dataListGlobal[MINE_TYPE]);
	break;
	case SOI_SHOWDOFACTORYS:
		ShowSomeThings((const void *)&ship, shipSize, shipCurrent->name, SHIP_TYPE, ship->doable->factoryManufactured, scg->nameStrGadget->Text(), editShipWindow, dataListGlobal[FACTORY_TYPE]);
	break;
	case SOI_SHOWDOENGINES:
		ShowSomeThings((const void *)&ship, shipSize, shipCurrent->name, SHIP_TYPE, ship->doable->engineManufactured, scg->nameStrGadget->Text(), editShipWindow, dataListGlobal[ENGINE_TYPE]);
	break;
	case SOI_SHOWDOSHIPS:
		ShowSomeThings((const void *)&ship, shipSize, shipCurrent->name, SHIP_TYPE, ship->doable->shipManufactured, scg->nameStrGadget->Text(), editShipWindow, dataListGlobal[SHIP_TYPE]);
	break;
	case SOI_SHOWDOSSHIELDS:
		ShowSomeThings((const void *)&ship, shipSize, shipCurrent->name, SHIP_TYPE, ship->doable->shipShieldManufactured, scg->nameStrGadget->Text(), editShipWindow, dataListGlobal[SSHIELD_TYPE]);
	break;
	case SOI_SHOWDOSHIPWEAPONS:
		ShowSomeThings((const void *)&ship, shipSize, shipCurrent->name, SHIP_TYPE, ship->doable->shipWeaponManufactured, scg->nameStrGadget->Text(), editShipWindow, dataListGlobal[SHIPWEAPON_TYPE]);
	break;
	case SOI_SHOWDOPLANETSHIELDS:
		ShowSomeThings((const void *)&ship, shipSize, shipCurrent->name, SHIP_TYPE, ship->doable->planetShieldManufactured, scg->nameStrGadget->Text(), editShipWindow, dataListGlobal[PLANETSHIELD_TYPE]);
	break;
	case SOI_SHOWDOPLANETWEAPONS:
		ShowSomeThings((const void *)&ship, shipSize, shipCurrent->name, SHIP_TYPE, ship->doable->planetWeaponManufactured, scg->nameStrGadget->Text(), editShipWindow, dataListGlobal[PLANETWEAPON_TYPE]);
	break;
	case SOI_SHOWMAINTPRIMALELEMENTS:
		ShowSomeThings((const void *)&ship, shipSize, shipCurrent->name, SHIP_TYPE, ship->maintainable->elementPrimal, scg->nameStrGadget->Text(), editShipWindow, dataListGlobal[ELEMENT_TYPE]);
	break;
	case SOI_SHOWMAINTPRIMALCOMPOUNDS:
		ShowSomeThings((const void *)&ship, shipSize, shipCurrent->name, SHIP_TYPE, ship->maintainable->compoundPrimal, scg->nameStrGadget->Text(), editShipWindow, dataListGlobal[COMPOUND_TYPE]);
	break;
	case SOI_SHOWMAINTELEMENTS:
		ShowSomeThings((const void *)&ship, shipSize, shipCurrent->name, SHIP_TYPE, ship->maintainable->elementManufactured, scg->nameStrGadget->Text(), editShipWindow, dataListGlobal[ELEMENT_TYPE]);
	break;
	case SOI_SHOWMAINTCOMPOUNDS:
		ShowSomeThings((const void *)&ship, shipSize, shipCurrent->name, SHIP_TYPE, ship->maintainable->compoundManufactured, scg->nameStrGadget->Text(), editShipWindow, dataListGlobal[COMPOUND_TYPE]);
	break;
	case SOI_SHOWMAINTMINES:
		ShowSomeThings((const void *)&ship, shipSize, shipCurrent->name, SHIP_TYPE, ship->maintainable->mineManufactured, scg->nameStrGadget->Text(), editShipWindow, dataListGlobal[MINE_TYPE]);
	break;
	case SOI_SHOWMAINTFACTORYS:
		ShowSomeThings((const void *)&ship, shipSize, shipCurrent->name, SHIP_TYPE, ship->maintainable->factoryManufactured, scg->nameStrGadget->Text(), editShipWindow, dataListGlobal[FACTORY_TYPE]);
	break;
	case SOI_SHOWMAINTENGINES:
		ShowSomeThings((const void *)&ship, shipSize, shipCurrent->name, SHIP_TYPE, ship->maintainable->engineManufactured, scg->nameStrGadget->Text(), editShipWindow, dataListGlobal[ENGINE_TYPE]);
	break;
	case SOI_SHOWMAINTSHIPS:
		ShowSomeThings((const void *)&ship, shipSize, shipCurrent->name, SHIP_TYPE, ship->maintainable->shipManufactured, scg->nameStrGadget->Text(), editShipWindow, dataListGlobal[SHIP_TYPE]);
	break;
	case SOI_SHOWMAINTSSHIELDS:
		ShowSomeThings((const void *)&ship, shipSize, shipCurrent->name, SHIP_TYPE, ship->maintainable->shipShieldManufactured, scg->nameStrGadget->Text(), editShipWindow, dataListGlobal[SSHIELD_TYPE]);
	break;
	case SOI_SHOWMAINTSHIPWEAPONS:
		ShowSomeThings((const void *)&ship, shipSize, shipCurrent->name, SHIP_TYPE, ship->maintainable->shipWeaponManufactured, scg->nameStrGadget->Text(), editShipWindow, dataListGlobal[SHIPWEAPON_TYPE]);
	break;
	case SOI_SHOWMAINTPLANETSHIELDS:
		ShowSomeThings((const void *)&ship, shipSize, shipCurrent->name, SHIP_TYPE, ship->maintainable->planetShieldManufactured, scg->nameStrGadget->Text(), editShipWindow, dataListGlobal[PLANETSHIELD_TYPE]);
	break;
	case SOI_SHOWMAINTPLANETWEAPONS:
		ShowSomeThings((const void *)&ship, shipSize, shipCurrent->name, SHIP_TYPE, ship->maintainable->planetWeaponManufactured, scg->nameStrGadget->Text(), editShipWindow, dataListGlobal[PLANETWEAPON_TYPE]);
	break;
	case SOI_BLREMOVE:
		dataListGlobal[SHIP_TYPE]->Remove();
		Quit();
	break;
	case SOI_BLLIST:
		GetFromList((void *)editShipWindow, dataListGlobal[SHIP_TYPE], scg->nameStrGadget->Text());
	break;
	case SOI_BLLISTGOT:
		if (validate) ValidateShip();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateShip();
			shipCurrent = shipNewCurrent;
			ship->maintainable->Copy(shipCurrent->maintainable);
			ship->buildable->Copy(shipCurrent->buildable);
			ship->doable->Copy(shipCurrent->doable);
			ship->possibleOrders = shipCurrent->possibleOrders;
			scg->nameStrGadget->SetText(shipCurrent->name);
			thisDNPtr = dataListGlobal[SHIP_TYPE]->NextPrevItems((void *)shipCurrent, &nextDNPtr, &prevDNPtr, bb);
			if (!bb->gnu) 
			{
				BRect gnuRect(154,bottom, 189,34);
				bb->gnu = new BButton(gnuRect, "", newStr, new BMessage(SOI_BLGNU));
				AddChild(bb->gnu);
				bb->gnu->SetTarget(this);
				bb->add->SetLabel(removeStr);
				bb->add->SetMessage(new BMessage(SOI_BLREMOVE));
			}
		}
	break;
	case SOI_BLPREV:
		Ship * prevShip = (Ship *)((DataNode *)prevDNPtr)->data;
		if (validate) ValidateShip();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateShip();
			shipCurrent = prevShip;
			ship->maintainable->Copy(shipCurrent->maintainable);
			ship->buildable->Copy(shipCurrent->buildable);
			ship->doable->Copy(shipCurrent->doable);
			ship->possibleOrders = shipCurrent->possibleOrders;
			scg->nameStrGadget->SetText(shipCurrent->name);
			thisDNPtr = dataListGlobal[SHIP_TYPE]->NextPrevItems((void *)shipCurrent, &nextDNPtr, &prevDNPtr, bb);
		}
	break;
	case SOI_BLDONE:
		if (!validate) 
		{
			Quit();
		}
		if (!strcmp(removeStr, bb->add->Label())) 
		{
			ValidateShip();
			if (err == NO_ERR) 
			{
				UpdateShip();
			}
		}
		if (err == NO_ERR) 
		{
			Quit();
		}
	break;
	case SOI_BLGNU:
		if (validate) ValidateShip();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateShip();
			shipCurrent = NULL;
			RemoveChild(bb->gnu);
			delete bb->gnu;
			bb->gnu = NULL;
			bb->add->SetLabel(addStr);
			bb->add->SetMessage(new BMessage(SOI_BLADD));
			scg->nameStrGadget->SetText("");
			scg->nameStrGadget->MakeFocus();
		}
	break;
	case SOI_BLADD:
		if (validate) ValidateShip();
		else {
			err = NO_NAME;
			warning(everythingNamed);
		}//for add don't update
		if (err == NO_ERR) 
		{
			AddShip();
			if (err) 
			{
				if (err != CREATEDNOTADDED) 
				{
					Quit();
				}
			}
			else {
				if (editUniverseWindow) 
				{
					editUniverseWindow->Lock();
					editUniverseWindow->buttons[DSN_SHIP]->SetLabel(editThe[SHIP_TYPE]);
					editUniverseWindow->bb->save->SetEnabled(true);
					editUniverseWindow->Unlock();
				}
				scg->nameStrGadget->SetText("");
				scg->nameStrGadget->MakeFocus();
				bb->save->SetEnabled(true);
				if (openingWindow) 
				{
					openingWindow->Lock();
					openingWindow->universeButton->SetLabel(editThe[UNIVERSE_TYPE]);
					openingWindow->createUniverseButton->SetEnabled(true);
					openingWindow->realUniverseButton->SetEnabled(true);
					openingWindow->Unlock();
				}
				ship->maintainable->EmptyList();
				ship->buildable->EmptyList();
				ship->doable->EmptyList();
			}
		}
	break;
	case SOI_BLSAVE:
		if (validate) ValidateShip();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateShip();
			//RunSavePanel("universe", saveThe[UNIVERSE_TYPE], saveStr, cancelStr);
		}
	break;
	case SOI_BLPIC:
	
	break;
	case SOI_LOADUNIVERSEFROMPANEL:
		LoadShips("universe");//debug
		Quit();
	break;
	case SOI_BLLOAD:
		BMessage * bm = new BMessage(SOI_LOADUNIVERSEFROMPANEL);
		if (bm) break;//debug break;//debug be_app->RunFilePanel(loadThe[UNIVERSE_TYPE], loadStr, cancelStr, false, bm);
		else warning(failMemory);
	break;
	case SOI_BLNEXT:
		Ship * nextShip = (Ship *)((DataNode *)nextDNPtr)->data;
		if (validate) ValidateShip();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateShip();
			shipCurrent = nextShip;
			ship->maintainable->Copy(shipCurrent->maintainable);
			ship->buildable->Copy(shipCurrent->buildable);
			ship->doable->Copy(shipCurrent->doable);
			ship->possibleOrders = shipCurrent->possibleOrders;
			scg->nameStrGadget->SetText(shipCurrent->name);
			thisDNPtr = dataListGlobal[SHIP_TYPE]->NextPrevItems((void *)shipCurrent, &nextDNPtr, &prevDNPtr, bb);
		}
	break;
	default:
		BWindow::MessageReceived(message);
	break;
}
}//end

bool EditShipWindow::QuitRequested(void) 
{

if (strcmp(scg->nameStrGadget->Text(), "")) 
{
	if (shipCurrent) 
	{
		ValidateShip();
		if (err == NO_ERR) 
		{
			UpdateShip();
			if (err == NO_ERR) 
			{
				Quit();
				return(BWindow::QuitRequested());
			}
			else return false;
		}
		else return false;
	}
}
Quit();
return(BWindow::QuitRequested());
}//end


void EditShipWindow::ValidateShip(void) 
{

UniqueName(dataListGlobal[SHIP_TYPE], scg->nameStrGadget->Text());
if (NO_UNIQUE == err) 
{
	warning(failNameUnique[SHIP_TYPE]);
	return;
}
uint32 v, vp;

v = s2uint32(scg->vIntGadget->Text());
if (S2UIERR == err) 
{
	warning(SCGVolumeErr);
	return;
}
vp = s2uint32(scg->vperIntGadget->Text());
if (S2UIERR == err) 
{
	warning(SCGVolumePerErr);
	return;
}
ship->volume = v;
ship->vper = vp;
}//end


void EditShipWindow::UpdateShip(void) 
{

err = NO_ERR;
ship->mass = 0;
UIntPtrNode * node;
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)ship->buildable->elementPrimal->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	ship->mass += ((Element *)(node->data))->mass;
	ship->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)ship->buildable->compoundPrimal->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	ship->mass += ((Compound *)(node->data))->mass;
	ship->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)ship->buildable->elementManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	ship->mass += ((Element *)(node->data))->mass;
	ship->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)ship->buildable->compoundManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	ship->mass += ((Compound *)(node->data))->mass;
	ship->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)ship->buildable->shipManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	ship->mass += ((Ship *)(node->data))->mass;
	ship->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)ship->buildable->factoryManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	ship->mass += ((Factory *)(node->data))->mass;
	ship->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)ship->buildable->engineManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	ship->mass += ((Engine *)(node->data))->mass;
	ship->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)ship->buildable->shipManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	ship->mass += ((Ship *)(node->data))->mass;
	ship->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)ship->buildable->shipShieldManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	ship->mass += ((ShipShield *)(node->data))->mass;
	ship->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)ship->buildable->shipWeaponManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	ship->mass += ((ShipWeapon *)(node->data))->mass;
	ship->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)ship->buildable->planetShieldManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	ship->mass += ((PlanetShield *)(node->data))->mass;
	ship->mass *= node->number;
}
#pragma warn_possunwant off
for (int32 i = 0; node = (UIntPtrNode *)ship->buildable->planetWeaponManufactured->list->ItemAt(i); i++) 
{
#pragma warn_possunwant reset
	ship->mass += ((PlanetWeapon *)(node->data))->mass;
	ship->mass *= node->number;
}
if (shipCurrent) 
{
	if (strcmp(shipCurrent->name, scg->nameStrGadget->Text())) 
	{
		if (shipCurrent->name) free(shipCurrent->name);
		shipCurrent->name = (char *)malloc(strlen(scg->nameStrGadget->Text()) + 1);
		if (shipCurrent->name) strcpy(shipCurrent->name, scg->nameStrGadget->Text());
		else {
			err = NO_NAME;
			warning(failName);
		}
	}
	shipCurrent->doable->Copy(ship->doable);
	shipCurrent->maintainable->Copy(ship->maintainable);
	shipCurrent->buildable->Copy(ship->buildable);
	shipCurrent->possibleOrders = ship->possibleOrders;
	//debug must do object as well
	shipCurrent->mass = ship->mass;
	shipCurrent->volume = ship->volume;
	shipCurrent->vper = ship->vper;
}
}//end


void EditShipWindow::SaveShips(const char * fileName) 
{

SaveUniverse(fileName);
}//end


void EditShipWindow::LoadShips(const char * fileName) 
{

LoadUniverse(fileName);
}//end
