//functions of EditWormholeWindow soi0.1

#include "windowGuts.h"
#include "editWormholeWindow.h"
#include "getFromList.h"
#include "saveLoadUniverse.h"
#include "titleWindow.h"
#include "designButtons.h"

void EditWormholeWindow::SaveRequested(const char * fileName) 
{

SaveWormholes(fileName);
}//end


EditWormholeWindow::EditWormholeWindow(BRect area, const char *title) : BWindow(area, title, B_TITLED_WINDOW, B_NOT_RESIZABLE|B_NOT_ZOOMABLE) 
{

editWormholeWindow = this;
bb = new BottomButtons;
if (bb) 
{
	if (editUniverseWindow) 
	{
		editUniverseWindow->Lock();
		editUniverseWindow->buttons[DSN_WORMHOLE]->SetEnabled(false);
		editUniverseWindow->Unlock();
	}
	BMessage * bmOrder = new BMessage(SOI_WORMHOLEGETPOSSAFFECTS);
	if (bmOrder) 
	{
		BRect orderRect(210,355, 390,389);
		affectButton = new BButton(orderRect, "", getPossAffectStr, bmOrder);
	}
	else err = CREATEDNOTADDED;
}
else err = CREATEDNOTADDED;
if (!wormholeCurrent) if (dataListGlobal[WORMHOLE_TYPE]->list->CountItems()) wormholeCurrent = (Wormhole *)((DataNode *)dataListGlobal[WORMHOLE_TYPE]->list->ItemAt(0))->data;
}//end


EditWormholeWindow::~EditWormholeWindow() 
{

if (bb) 
{
	if (editUniverseWindow) 
	{
		editUniverseWindow->Lock();
		editUniverseWindow->buttons[DSN_WORMHOLE]->SetEnabled(true);
		editUniverseWindow->Unlock();
	}
	delete bb;
}
if (affectButton) 
{
	affectButton->RemoveSelf();
	delete affectButton;
}
editWormholeWindow = NULL;
}//end


void EditWormholeWindow::AddWormhole(void) 
{

Wormhole * g = new Wormhole(wormhole, nameStrGadget->Text(), dataListGlobal[WORMHOLE_TYPE]);
if (g) 
{
	if (err != CREATED) 
	{
		delete g;
		return;
	}
}
else err = NO_WORMHOLE;
}//end


void EditWormholeWindow::MessageReceived(BMessage *message) 
{

bool validate = true;
if (!strcmp(nameStrGadget->Text(), "")) validate = false;

switch (message->what) 
{
	case SOI_NAME:
	
	break;
	case SOI_WORMHOLEGETPOSSAFFECTS:
	
	break;
	case SOI_BLREMOVE:
		dataListGlobal[WORMHOLE_TYPE]->Remove();
		Quit();
	break;
	case SOI_BLLIST:
		GetFromList((void *)editWormholeWindow, dataListGlobal[WORMHOLE_TYPE], nameStrGadget->Text());
	break;
	case SOI_BLLISTGOT:
		if (validate) ValidateWormhole();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateWormhole();
			wormholeCurrent = wormholeNewCurrent;
			nameStrGadget->SetText(wormholeCurrent->name);
			thisDNPtr = dataListGlobal[WORMHOLE_TYPE]->NextPrevItems((void *)wormholeCurrent, &nextDNPtr, &prevDNPtr, bb);
			if (!bb->gnu) 
			{
				BRect gnuRect(154,bottom, 189,34);
				bb->gnu = new BButton(gnuRect, "", newStr, new BMessage(SOI_BLGNU));
				if (!bb->gnu) 
				{
					warning(failMemory);
					return;
				}
				AddChild(bb->gnu);
				bb->gnu->SetTarget(this);
				bb->add->SetLabel(removeStr);
				bb->add->SetMessage(new BMessage(SOI_BLREMOVE));
			}
		}
	break;
	case SOI_BLPREV:
		Wormhole * prevWormhole = (Wormhole *)((DataNode *)prevDNPtr)->data;
		if (validate) ValidateWormhole();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateWormhole();
			wormholeCurrent = prevWormhole;
			nameStrGadget->SetText(wormholeCurrent->name);
			thisDNPtr = dataListGlobal[WORMHOLE_TYPE]->NextPrevItems((void *)wormholeCurrent, &nextDNPtr, &prevDNPtr, bb);
		}
	break;
	case SOI_BLDONE:
		if (!validate) 
		{
			Quit();
		}
		if (!strcmp(removeStr, bb->add->Label())) 
		{
			ValidateWormhole();
			if (err == NO_ERR) 
			{
				UpdateWormhole();
			}
		}
		if (err == NO_ERR) 
		{
			Quit();
		}
	break;
	case SOI_BLGNU:
		if (validate) ValidateWormhole();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateWormhole();
			wormholeCurrent = NULL;
			RemoveChild(bb->gnu);
			delete bb->gnu;
			bb->gnu = NULL;
			bb->add->SetLabel(addStr);
			bb->add->SetMessage(new BMessage(SOI_BLADD));
			nameStrGadget->SetText("");
			nameStrGadget->MakeFocus();
		}
	break;
	case SOI_BLADD:
		if (validate) ValidateWormhole();
		else {
			err = NO_NAME;
			warning(everythingNamed);
		}//for add don't update
		if (err == NO_ERR) 
		{
			AddWormhole();
			if (err) 
			{
				if (err != CREATEDNOTADDED) 
				{
					Quit();
				}
			}
			else {
				if (editUniverseWindow) 
				{
					editUniverseWindow->Lock();
					editUniverseWindow->buttons[DSN_WORMHOLE]->SetLabel(editThe[WORMHOLE_TYPE]);
					editUniverseWindow->bb->save->SetEnabled(true);
					editUniverseWindow->Unlock();
				}
				nameStrGadget->SetText("");
				nameStrGadget->MakeFocus();
				bb->save->SetEnabled(true);
				if (openingWindow) 
				{
					openingWindow->Lock();
					openingWindow->universeButton->SetLabel(editThe[UNIVERSE_TYPE]);
					openingWindow->createUniverseButton->SetEnabled(true);
					openingWindow->realUniverseButton->SetEnabled(true);
					openingWindow->Unlock();
				}
			}
		}
	break;
	case SOI_BLSAVE:
		if (validate) ValidateWormhole();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateWormhole();
			//RunSavePanel("universe", saveThe[UNIVERSE_TYPE], saveStr, cancelStr);
		}
	break;
	case SOI_BLPIC:
	
	break;
	case SOI_LOADUNIVERSEFROMPANEL:
		LoadWormholes("universe");//debug
		Quit();
	break;
	case SOI_BLLOAD:
		BMessage * bm = new BMessage(SOI_LOADUNIVERSEFROMPANEL);
		if (bm) break;//debug break;//debug be_app->RunFilePanel(loadThe[UNIVERSE_TYPE], loadStr, cancelStr, false, bm);
		else warning(failMemory);
	break;
	case SOI_BLNEXT:
		Wormhole * nextWormhole = (Wormhole *)((DataNode *)nextDNPtr)->data;
		if (validate) ValidateWormhole();
		else err = NO_ERR;
		if (err == NO_ERR) 
		{
			if (validate) UpdateWormhole();
			wormholeCurrent = nextWormhole;
			nameStrGadget->SetText(wormholeCurrent->name);
			thisDNPtr = dataListGlobal[WORMHOLE_TYPE]->NextPrevItems((void *)wormholeCurrent, &nextDNPtr, &prevDNPtr, bb);
		}
	break;
	default:
		BWindow::MessageReceived(message);
	break;
}
}//end


bool EditWormholeWindow::QuitRequested(void) 
{

if (strcmp(nameStrGadget->Text(), "")) 
{
	if (wormholeCurrent) 
	{
		ValidateWormhole();
		if (err == NO_ERR) 
		{
			UpdateWormhole();
			if (err == NO_ERR) 
			{
				Quit();
				return(BWindow::QuitRequested());
			}
			else return false;
		}
		else return false;
	}
}
Quit();
return(BWindow::QuitRequested());
}//end


void EditWormholeWindow::ValidateWormhole(void) 
{

UniqueName(dataListGlobal[WORMHOLE_TYPE], nameStrGadget->Text());
if (NO_UNIQUE == err) 
{
	warning(failNameUnique[WORMHOLE_TYPE]);
	return;
}
if (wormhole->name) 
{
	if (strcmp(wormhole->name, nameStrGadget->Text())) 
	{
		free(wormhole->name);
		wormhole->name = (char *)malloc(strlen(nameStrGadget->Text()) + 1);
		if (wormhole->name) strcpy(wormhole->name, nameStrGadget->Text());
		else {
			err = NO_NAME;
			warning(failName);
		}
	}
}
//debug must do object as well
}//end


void EditWormholeWindow::UpdateWormhole(void) 
{

err = NO_ERR;
if (wormholeCurrent) 
{
	if (strcmp(wormholeCurrent->name, nameStrGadget->Text())) 
	{
		if (wormholeCurrent->name) free(wormholeCurrent->name);
		wormholeCurrent->name = (char *)malloc(strlen(nameStrGadget->Text()) + 1);
		if (wormholeCurrent->name) strcpy(wormholeCurrent->name, nameStrGadget->Text());
		else {
			err = NO_NAME;
			warning(failName);
		}
	}
	//debug must do object as well
}
}//end


void EditWormholeWindow::SaveWormholes(const char * fileName) 
{

SaveUniverse(fileName);
}//end


void EditWormholeWindow::LoadWormholes(const char * fileName) 
{

LoadUniverse(fileName);
}//end
