//editUniverseWindow.cpp

#include "XeditUniverseWindow.h"
#include "XlayoutMatrixItem.h"
#include "XfileHeaders.h"
#include "DlayoutMatrix.h"
#include "DlistViewWindow.h"
#include "DmenuMsg.h"
#include "Xthings.h"
#include "windowGuts.h"
#include <memory>
#include <string>
#include "layoutMatrixItem.h"
#include "layoutMatrix.h"
#include "myButton.h"
#include "myCheckBox.h"
#include "textItem.h"
#include "myStringDrawer.h"
#include "myPopUpMenu.h"
#include "myPictureButton.h"
#include "myColorControl.h"
#include "myStatusBar.h"
#include "myRadioView.h"
#include "myTextView.h"
#include "stringGadget.h"
#include "bottomLine.h"
#include "bottomButtons.h"
#include "designButtons.h"
#include "constants.h"
#include "listViewWindow.h"
#include "editUniverseWindow.h"
#include "editUniversalConstantsWindow.h"
#include "Xwarning.h"
#include "preferences.h"
#include "myPreferences.h"
#include "myroColour.h"
#include "myApp.h"
#include "getFromList.h"
#include "dataNode.h"
#include "dataList.h"
#include "universalConstants.h"
#include "universe.h"
#include "Xunique.h"
#include "error.h"
#include "titleWindow.h"
#include "Xverify.h"
#include "species.h"
#include "element.h"
#include "compound.h"
#include "editSpeciesWindow.h"
#include "truncateString.h"

//ctor
EditUniverseWindow	::	EditUniverseWindow(	BRect paramBound,
											const char * paramWindowTitle,
											const char * paramScrollViewName,
											const char * paramNamePrefFrame)
			: 
				WindowGuts(	paramBound, 
							paramWindowTitle, 
							paramScrollViewName,
							paramNamePrefFrame),
				saveUniversePanel(NULL), 
				saveUniverseMessenger(NULL), 
				loadUniversePanel(NULL), 
				loadUniverseMessenger(NULL),
				loadUniversalConstantsPanel(NULL), 
				loadUniversalConstantsMessenger(NULL),
				loadElementPanel(NULL), 
				loadElementMessenger(NULL),
				loadCompoundPanel(NULL), 
				loadCompoundMessenger(NULL),
				loadSpeciesPanel(NULL), 
				loadSpeciesMessenger(NULL),
				pBottomButtons(new BottomButtons)
{
	myApp->pEditUniverseWindow = this;
	sem_id calc_sem;
	if ((calc_sem = create_sem(1, "calc_sem")) < B_NO_ERROR)
	{
		warning(FailCreateSemaphore);
		return;
	}
	acquire_sem(calc_sem);
	try 
	{
		LayoutMatrix *	pNameLayoutMatrix = new LayoutMatrix(BESTSIZE, 1, 1, this);//rows,columns
/////////////////////////////////////////////////////////////////////////////////////////////
		char * prelimName;
		if (universeCurrent) 
		{
			prelimName = universeCurrent->name;
		}
		else 
		{
			prelimName = NULL;
		}
		mpNameStrGadget = new StringGadget(	"stringGadgetName", 
											NameUniverseStrGadgetLable, 
											prelimName, 
											NAMEUNIVERSEMSG, 
											B_FOLLOW_NONE, 
											B_WILL_DRAW | B_NAVIGABLE,
											0,
											pNameLayoutMatrix,
											true);
		auto_ptr<LayoutMatrixItem> apNameLayoutMatrixItem(new LayoutMatrixItem(	(void *)mpNameStrGadget, 
																				pNameLayoutMatrix->itemsList,
																				KIND_STRINGGADG));
																				
///////////////
		LayoutMatrix *	pDefaultLayoutMatrix = new LayoutMatrix(SAMESIZE, 4, 1, this);//rows,columns
/////////////////////////////////////////////////////////////////////////
		buttons[NUM_DFLT_UNIVERSALCONSTANTS] = new MyButton(	"DefaultUnivConstButton", 
																DfltUCButtonLable, 
																DFLT_UNIVCONST, 
																B_FOLLOW_NONE, 
																B_WILL_DRAW,
																pDefaultLayoutMatrix);
		auto_ptr<LayoutMatrixItem> apDefaultUnivConstButtonLayoutMatrixItem(new LayoutMatrixItem(	(void *)buttons[NUM_DFLT_UNIVERSALCONSTANTS], 
																									pDefaultLayoutMatrix->itemsList,
																									KIND_MYBUTTON));

/////////////////////////////////////////////////////////
		buttons[NUM_DFLT_SPECIES] = new MyButton(	"DefaultSpeciesButton", 
													DfltSpeciesButtonLable, 
													DFLT_SPECIES, 
													B_FOLLOW_NONE, 
													B_WILL_DRAW,
													pDefaultLayoutMatrix);
		auto_ptr<LayoutMatrixItem> apDefaultSpeciesButtonLayoutMatrixItem(new LayoutMatrixItem(	(void *)buttons[NUM_DFLT_SPECIES], 
																								pDefaultLayoutMatrix->itemsList,
																								KIND_MYBUTTON));

/////////////////////////////////////////////////////////
		buttons[NUM_DFLT_ELEMENT] = new MyButton(	"DefaultElementButton", 
													DfltElementsButtonLable, 
													DFLT_ELEMENT, 
													B_FOLLOW_NONE, 
													B_WILL_DRAW,
													pDefaultLayoutMatrix);
		auto_ptr<LayoutMatrixItem> apDefaultElementButtonLayoutMatrixItem(new LayoutMatrixItem(	(void *)buttons[NUM_DFLT_ELEMENT], 
																								pDefaultLayoutMatrix->itemsList,
																								KIND_MYBUTTON));

/////////////////////////////////////////////////////////
		buttons[NUM_DFLT_COMPOUND] = new MyButton(	"DefaultCompoundButton", 
													DfltCompoundsButtonLable, 
													DFLT_COMPOUND, 
													B_FOLLOW_NONE, 
													B_WILL_DRAW,
													pDefaultLayoutMatrix);
		auto_ptr<LayoutMatrixItem> apDefaultCompoundButtonLayoutMatrixItem(new LayoutMatrixItem(	(void *)buttons[NUM_DFLT_COMPOUND], 
																									pDefaultLayoutMatrix->itemsList,
																									KIND_MYBUTTON));

///////////////////////////////////////////////////////
		LayoutMatrix *	pDesignLayoutMatrix = new LayoutMatrix(SAMESIZE, 7, 1, this);//rows,columns
/////////////////////////////////////////////////////////////////////////
		if (dataListGlobal[UNIVERSALCONSTANTS_TYPE]->list->CountItems()) 
		{
			prelimName = universalConstantsCurrent->name;
		}
		else 
		{
			prelimName = NULL;
		}
		string designName;
		if (prelimName)
		{
			designName = editThe[UNIVERSALCONSTANTS_TYPE];
			designName += prelimName;
		}
		else
		{
			designName = DsgnUCButtonLable;
		}
		buttons[NUM_DSN_UNIVERSALCONSTANTS] = new MyButton(	"DesignUnivConstButton", 
															designName.c_str(), 
															DSGN_UNIVCONST, 
															B_FOLLOW_NONE, 
															B_WILL_DRAW,
															pDesignLayoutMatrix);
		auto_ptr<LayoutMatrixItem> apDesignUnivConstButtonLayoutMatrixItem(new LayoutMatrixItem(	(void *)buttons[NUM_DSN_UNIVERSALCONSTANTS], 
																									pDesignLayoutMatrix->itemsList,
																									KIND_MYBUTTON));

/////////////////////////////////////////////////////////
		buttons[NUM_DSN_SPECIES] = new MyButton(	"DesignSpeciesButton", 
													DsgnSpeciesButtonLable, 
													DSGN_SPECIES, 
													B_FOLLOW_NONE, 
													B_WILL_DRAW,
													pDesignLayoutMatrix);
		buttons[NUM_DSN_SPECIES]->SetFont(myPrefs->GetPreferredFont());
		auto_ptr<LayoutMatrixItem> apDesignSpeciesButtonLayoutMatrixItem(new LayoutMatrixItem(	(void *)buttons[NUM_DSN_SPECIES], 
																								pDesignLayoutMatrix->itemsList,
																								KIND_MYBUTTON));

/////////////////////////////////////////////////////////
		buttons[NUM_DSN_ELEMENT] = new MyButton(	"DesignElementButton", 
													DsgnElementsButtonLable, 
													DSGN_ELEMENT, 
													B_FOLLOW_NONE, 
													B_WILL_DRAW,
													pDesignLayoutMatrix);
		auto_ptr<LayoutMatrixItem> apDesignElementButtonLayoutMatrixItem(new LayoutMatrixItem(	(void *)buttons[NUM_DSN_ELEMENT], 
																								pDesignLayoutMatrix->itemsList,
																								KIND_MYBUTTON));

/////////////////////////////////////////////////////////
		buttons[NUM_DSN_COMPOUND] = new MyButton(	"DesignCompoundButton", 
													DsgnCompoundsButtonLable, 
													DSGN_COMPOUND, 
													B_FOLLOW_NONE, 
													B_WILL_DRAW,
													pDesignLayoutMatrix);
		auto_ptr<LayoutMatrixItem> apDesignCompoundButtonLayoutMatrixItem(new LayoutMatrixItem(	(void *)buttons[NUM_DSN_COMPOUND], 
																								pDesignLayoutMatrix->itemsList,
																								KIND_MYBUTTON));

///////////////////////////////////
		buttons[NUM_DSN_MINE] = new MyButton(	"DesignMineButton", 
												DsgnMinesButtonLable, 
												DSGN_MINE, 
												B_FOLLOW_NONE, 
												B_WILL_DRAW,
												pDesignLayoutMatrix);
		auto_ptr<LayoutMatrixItem> apDesignMineButtonLayoutMatrixItem(new LayoutMatrixItem(	(void *)buttons[NUM_DSN_MINE], 
																							pDesignLayoutMatrix->itemsList,
																							KIND_MYBUTTON));

///////////////////////////////////////////////////////////////////////////////
		buttons[NUM_DSN_FACTORY] = new MyButton(	"DesignFactoryButton", 
													DsgnFactoriesButtonLable, 
													DSGN_FACTORY, 
													B_FOLLOW_NONE, 
													B_WILL_DRAW,
													pDesignLayoutMatrix);
		auto_ptr<LayoutMatrixItem> apDesignFactoryButtonLayoutMatrixItem(new LayoutMatrixItem(	(void *)buttons[NUM_DSN_FACTORY], 
																								pDesignLayoutMatrix->itemsList,
																								KIND_MYBUTTON));

/////////////////////////////////////////////////////////
		buttons[NUM_DSN_ENGINE] = new MyButton(	"DesignEngineButton", 
												DsgnEnginesButtonLable, 
												DSGN_ENGINE, 
												B_FOLLOW_NONE, 
												B_WILL_DRAW,
												pDesignLayoutMatrix);
		auto_ptr<LayoutMatrixItem> apDesignEngineButtonLayoutMatrixItem(new LayoutMatrixItem(	(void *)buttons[NUM_DSN_ENGINE], 
																								pDesignLayoutMatrix->itemsList,
																								KIND_MYBUTTON));

////////////////////////////////////////////////////////////
		LayoutMatrix *	pDesignShipLayoutMatrix = new LayoutMatrix(SAMESIZE, 2, 3, this);//rows,columns
/////////////////////////////////////////////////////////////////////////
		buttons[NUM_DSN_SHIPWEAPON] = new MyButton(	"DesignShipWeaponButton", 
													DsgnShipWeaponsButtonLable, 
													DSGN_SHIPWEAPON, 
													B_FOLLOW_NONE, 
													B_WILL_DRAW,
													pDesignShipLayoutMatrix);
		auto_ptr<LayoutMatrixItem> apDesignShipWeaponButtonLayoutMatrixItem(new LayoutMatrixItem(	(void *)buttons[NUM_DSN_SHIPWEAPON], 
																									pDesignShipLayoutMatrix->itemsList,
																									KIND_MYBUTTON));

/////////////////////////////////////////////////////////
		buttons[NUM_DSN_SHIPSHIELD] = new MyButton(	"DesignShipShieldButton", 
													DsgnShipShieldsButtonLable, 
													DSGN_SHIPSHIELD, 
													B_FOLLOW_NONE, 
													B_WILL_DRAW,
													pDesignShipLayoutMatrix);
		auto_ptr<LayoutMatrixItem> apDesignShipShieldButtonLayoutMatrixItem(new LayoutMatrixItem(	(void *)buttons[NUM_DSN_SHIPSHIELD], 
																									pDesignShipLayoutMatrix->itemsList,
																									KIND_MYBUTTON));

/////////////////////////////////////////////////////////
		buttons[NUM_DSN_SHIP] = new MyButton(	"DesignShipButton", 
												DsgnShipsButtonLable, 
												DSGN_SHIP, 
												B_FOLLOW_NONE, 
												B_WILL_DRAW,
													pDesignShipLayoutMatrix);
		auto_ptr<LayoutMatrixItem> apDesignShipButtonLayoutMatrixItem(new LayoutMatrixItem(	(void *)buttons[NUM_DSN_SHIP], 
																							pDesignShipLayoutMatrix->itemsList,
																							KIND_MYBUTTON));

/////////////////////////////////////////////////////////////////
		buttons[NUM_DSN_PLANETWEAPON] = new MyButton(	"DesignPlanetWeaponButton", 
														DsgnPlanetWeaponsButtonLable, 
														DSGN_PLANETWEAPON, 
														B_FOLLOW_NONE, 
														B_WILL_DRAW,
														pDesignShipLayoutMatrix);
		auto_ptr<LayoutMatrixItem> apDesignPlanetWeaponButtonLayoutMatrixItem(new LayoutMatrixItem(	(void *)buttons[NUM_DSN_PLANETWEAPON], 
																									pDesignShipLayoutMatrix->itemsList,
																									KIND_MYBUTTON));

/////////////////////////////////////////////////////////
		buttons[NUM_DSN_PLANETSHIELD] = new MyButton(	"DesignPlanetShieldButton", 
														DsgnPlanetShieldsButtonLable, 
														DSGN_PLANETSHIELD, 
														B_FOLLOW_NONE, 
														B_WILL_DRAW,
													pDesignShipLayoutMatrix);
		buttons[NUM_DSN_PLANETSHIELD]->SetFont(myPrefs->GetPreferredFont());
		auto_ptr<LayoutMatrixItem> apDesignPlanetShieldButtonLayoutMatrixItem(new LayoutMatrixItem(	(void *)buttons[NUM_DSN_PLANETSHIELD], 
																									pDesignShipLayoutMatrix->itemsList,
																									KIND_MYBUTTON));

/////////////////////////////////////////////////////////
		buttons[NUM_DSN_PLANET] = new MyButton(	"DesignPlanetButton", 
												DsgnPlanetsButtonLable, 
												DSGN_PLANET, 
												B_FOLLOW_NONE, 
												B_WILL_DRAW,
												pDesignShipLayoutMatrix);
		auto_ptr<LayoutMatrixItem> apDesignPlanetButtonLayoutMatrixItem(new LayoutMatrixItem(	(void *)buttons[NUM_DSN_PLANET], 
																								pDesignShipLayoutMatrix->itemsList,
																								KIND_MYBUTTON));

/////////////////////////////////////////////////////////////
		LayoutMatrix *	pDesignOther2LayoutMatrix = new LayoutMatrix(SAMESIZE, 4, 1, this);//rows,columns
///////////////////////////////////////////////////
		buttons[NUM_DSN_STAR] = new MyButton(	"DesignStarButton", 
												DsgnStarsButtonLable, 
												DSGN_STAR, 
												B_FOLLOW_NONE, 
												B_WILL_DRAW,
												pDesignOther2LayoutMatrix);
		auto_ptr<LayoutMatrixItem> apDesignStarButtonLayoutMatrixItem(new LayoutMatrixItem(	(void *)buttons[NUM_DSN_STAR], 
																							pDesignOther2LayoutMatrix->itemsList,
																							KIND_MYBUTTON));

/////////////////////////////////////////////////////////
		buttons[NUM_DSN_WORMHOLE] = new MyButton(	"DesignWormholeButton", 
													DsgnWormholesButtonLable, 
													DSGN_WORMHOLE, 
													B_FOLLOW_NONE, 
													B_WILL_DRAW,
													pDesignOther2LayoutMatrix);
		auto_ptr<LayoutMatrixItem> apDesignWormholeButtonLayoutMatrixItem(new LayoutMatrixItem(	(void *)buttons[NUM_DSN_WORMHOLE], 
																								pDesignOther2LayoutMatrix->itemsList,
																								KIND_MYBUTTON));

/////////////////////////////////////////////////////////
		buttons[NUM_DSN_BLACKHOLE] = new MyButton(	"DesignBlackholeButton", 
													DsgnBlackholesButtonLable, 
													DSGN_BLACKHOLE, 
													B_FOLLOW_NONE, 
													B_WILL_DRAW,
													pDesignOther2LayoutMatrix);
		auto_ptr<LayoutMatrixItem> apDesignBlackholeButtonLayoutMatrixItem(new LayoutMatrixItem(	(void *)buttons[NUM_DSN_BLACKHOLE], 
																									pDesignOther2LayoutMatrix->itemsList,
																									KIND_MYBUTTON));

/////////////////////////////////////////////////////////
		buttons[NUM_DSN_GALAXY] = new MyButton(	"DesignGalaxyButton", 
												DsgnGalaxiesButtonLable, 
												DSGN_GALAXY, 
												B_FOLLOW_NONE, 
												B_WILL_DRAW,
												pDesignOther2LayoutMatrix);
		auto_ptr<LayoutMatrixItem> apDesignGalaxyButtonLayoutMatrixItem(new LayoutMatrixItem(	(void *)buttons[NUM_DSN_GALAXY], 
																								pDesignOther2LayoutMatrix->itemsList,
																								KIND_MYBUTTON));
//////////////////////////////////////////////////////////////////
		LayoutMatrix *	pLoadLayoutMatrix = new LayoutMatrix(SAMESIZE, 4, 1, this);//rows,columns
/////////////////////////////////////////////////////////////////////////
		buttons[NUM_LOAD_UNIVERSALCONSTANTS] = new MyButton(	"LoadUnivConstButton", 
																LoadUCButtonLable, 
																LOAD_UNIVCONST, 
																B_FOLLOW_NONE, 
																B_WILL_DRAW,
																pLoadLayoutMatrix);
		auto_ptr<LayoutMatrixItem> apLoadUnivConstButtonLayoutMatrixItem(new LayoutMatrixItem(	(void *)buttons[NUM_LOAD_UNIVERSALCONSTANTS], 
																								pLoadLayoutMatrix->itemsList,
																								KIND_MYBUTTON));

/////////////////////////////////////////////////////////
		buttons[NUM_LOAD_SPECIES] = new MyButton(	"LoadSpeciesButton", 
													LoadSpeciesButtonLable, 
													LOAD_SPECIES, 
													B_FOLLOW_NONE, 
													B_WILL_DRAW,
													pLoadLayoutMatrix);
		auto_ptr<LayoutMatrixItem> apLoadSpeciesButtonLayoutMatrixItem(new LayoutMatrixItem(	(void *)buttons[NUM_LOAD_SPECIES], 
																								pLoadLayoutMatrix->itemsList,
																								KIND_MYBUTTON));

/////////////////////////////////////////////////////////
		buttons[NUM_LOAD_ELEMENT] = new MyButton(	"LoadElementButton", 
													LoadElementsButtonLable, 
													LOAD_ELEMENT, 
													B_FOLLOW_NONE, 
													B_WILL_DRAW,
													pLoadLayoutMatrix);
		auto_ptr<LayoutMatrixItem> apLoadElementButtonLayoutMatrixItem(new LayoutMatrixItem(	(void *)buttons[NUM_LOAD_ELEMENT], 
																								pLoadLayoutMatrix->itemsList,
																								KIND_MYBUTTON));

/////////////////////////////////////////////////////////
		buttons[NUM_LOAD_COMPOUND] = new MyButton(	"LoadCompoundButton", 
													LoadCompoundsButtonLable, 
													LOAD_COMPOUND, 
													B_FOLLOW_NONE, 
													B_WILL_DRAW,
													pLoadLayoutMatrix);
		auto_ptr<LayoutMatrixItem> apLoadCompoundButtonLayoutMatrixItem(new LayoutMatrixItem(	(void *)buttons[NUM_LOAD_COMPOUND], 
																								pLoadLayoutMatrix->itemsList,
																								KIND_MYBUTTON));
//////////////////////////////////////////////////////
		uint32 picKind = UNIVERSEPICKIND;
#include "bottomLine.source"
////////////////////////////////////////////////////
		thisDNPtr = dataListGlobal[UNIVERSE_TYPE]->NextPrevItems(	(void *)universeCurrent, 
																			&nextDNPtr, 
																			&prevDNPtr, 
																			pBottomButtons);
		if (!prevDNPtr)
		{
			pBottomButtons->prev->SetEnabled(false);
		}
		if (!nextDNPtr)
		{
			pBottomButtons->next->SetEnabled(false);
		}
		if (!prevDNPtr && !nextDNPtr)
		{
			pBottomButtons->list->SetEnabled(false);
		}
		if (!dataListGlobal[UNIVERSE_TYPE]->list->CountItems()) 
		{
			pBottomButtons->remove->SetEnabled(false);
		}
/////////////////////////////////////////////////////////////////////////
		release_sem(calc_sem);
		pNameLayoutMatrix->Calc(MATRIXHORIZONTALOFFSET, MATRIXVERTICALOFFSET, calc_sem);
		pDefaultLayoutMatrix->Calc(MATRIXHORIZONTALOFFSET, pNameLayoutMatrix->bottom, calc_sem);
		pDesignLayoutMatrix->Calc(pDefaultLayoutMatrix->right, pNameLayoutMatrix->bottom, calc_sem);
		pDesignShipLayoutMatrix->Calc(MATRIXHORIZONTALOFFSET, pDesignLayoutMatrix->bottom, calc_sem);
		pDesignOther2LayoutMatrix->Calc(pDefaultLayoutMatrix->right, pDesignShipLayoutMatrix->bottom, calc_sem);
		pLoadLayoutMatrix->Calc(pDesignLayoutMatrix->right, pNameLayoutMatrix->bottom, calc_sem);
		pBottomLineLayoutMatrix->Calc(MATRIXHORIZONTALOFFSET, pDesignOther2LayoutMatrix->bottom, calc_sem);
	}
	catch (...)
	{
		warning(CaughtEditUniverseWindowCTOR);
		release_sem(calc_sem);
		throw;
	}
	try 
	{
		BMenuItem *	menuItem;
		BMenu * APPMenu = new BMenu(AppMenuLable);
		menuItem = new BMenuItem(	AboutMenuLable, 
									new BMessage(ABOUT_EDITUNIVERSEWINDOW));
		APPMenu->AddItem(menuItem);
		menuItem = new BMenuItem(	PreferenceMenuLable, 
									new BMessage(PREFSMSG));
		APPMenu->AddItem(menuItem);
		menuItem = new BMenuItem(	QuitMenuLable, 
									new BMessage(QUIT_APP));
		APPMenu->AddItem(menuItem);
		pMenuBar->AddItem(APPMenu);
		BMenu * fileMenu = new BMenu(FileMenuLable);
		menuItem = new BMenuItem(	LoadPreviousLable, 
									new BMessage(BLLOAD));
		fileMenu->AddItem(menuItem);
		menuItem = new BMenuItem(	SaveLable, 
									new BMessage(BLSAVE));
		fileMenu->AddItem(menuItem);
		pMenuBar->AddItem(fileMenu);
	}
	catch(...) 
	{
		throw;
	}
}//end


//dtor
EditUniverseWindow	::	~EditUniverseWindow() 
{
	delete saveUniversePanel;
	delete saveUniverseMessenger;
	delete loadUniversePanel;
	delete loadUniverseMessenger;
	if (pBottomButtons)
	{
		delete pBottomButtons;
	}
	myApp->pEditUniverseWindow = NULL;
	myApp->bEditingUniverse = false;
}//end


void
EditUniverseWindow	::	MessageReceived(	BMessage * pparamMessage) 
{
	bool validate = strcmp(mpNameStrGadget->Text(), "");
	BWindow * panelWindow;
	switch(pparamMessage->what) 
	{
		case ABOUT_EDITUNIVERSEWINDOW:	
		{
			warning(AboutEditUniverseWindowMsg);
		break;
		}
		case LOADUNIVERSALCONSTANTFROMPANEL:	
		{
			entry_ref ref;
			int32 numUniversalConstants;
			if (pparamMessage->FindRef("refs", &ref) >= B_OK) 
			{
				BFile file(&ref, B_READ_ONLY);
				status_t fileStatus;
				if ((fileStatus = file.InitCheck()) == B_NO_ERROR) 
				{
					if (!StripFileHeaderPre(&file)) 
					{
						warning(noLoad);
						return;
					}
					if (!StripFileHeader(	UNIVERSALCONSTANTS_TYPE, 
											&file, 
											&numUniversalConstants)) 
					{
						warning(noLoad);
						return;
					}
					if (!(universalConstants->Load(&file))) 
					{
						warning(noLoad);
					}
					else 
					{
						universalConstantsCurrent = universalConstants;
						if (universalConstantsCurrent->name)
						{
							string newLabel = editThe[UNIVERSALCONSTANTS_TYPE];
							newLabel += universalConstantsCurrent->name;
							char abuf[256];
							BFont * font = myPrefs->GetPreferredFont();
							bool ts = TruncateString(	newLabel.c_str(),
														&abuf[0],
														myApp->pEditUniverseWindow->buttons[NUM_DSN_UNIVERSALCONSTANTS]->Frame().Width(),
														font);
							if (ts)
							{
								newLabel = abuf;
							}
							buttons[NUM_DSN_UNIVERSALCONSTANTS]->SetLabel(newLabel.c_str());
							pBottomButtons->save->SetEnabled(true);
							if (myApp->pTitleWindow->LockLooper())
							{
								myApp->pTitleWindow->pSaveButton->SetEnabled(true);
								myApp->pTitleWindow->pRealButton->SetEnabled(true);
								myApp->pTitleWindow->UnlockLooper();
							}
							else
							{
								warning(FailLockLooper);
							}
						}
						universe->MinWidth = universalConstants->MinWidth;
						universe->MinHeight = universalConstants->MinHeight;
						universe->MinDepth = universalConstants->MinDepth;
						universe->MinSofL = universalConstants->MinSofL;
						universe->MinPropFuelUse = universalConstants->MinPropFuelUse;
						universe->MinFTLFuelUse = universalConstants->MinFTLFuelUse;
						universe->MinInstFuelUse = universalConstants->MinInstFuelUse;
						universe->MinElectronMass = universalConstants->MinElectronMass;
						universe->MinNeutronMass = universalConstants->MinNeutronMass;
						universe->MinProtonMass = universalConstants->MinProtonMass;
						universe->MinPropAccel = universalConstants->MinPropAccel;
						universe->MinFTLAccel = universalConstants->MinFTLAccel;
						universe->MinNumGalaxy = universalConstants->MinNumGalaxy;
						universe->MaxWidth = universalConstants->MaxWidth;
						universe->MaxHeight = universalConstants->MaxHeight;
						universe->MaxDepth = universalConstants->MaxDepth;
						universe->MaxSofL = universalConstants->MaxSofL;
						universe->MaxPropFuelUse = universalConstants->MaxPropFuelUse;
						universe->MaxFTLFuelUse = universalConstants->MaxFTLFuelUse;
						universe->MaxInstFuelUse = universalConstants->MaxInstFuelUse;
						universe->MaxElectronMass = universalConstants->MaxElectronMass;
						universe->MaxNeutronMass = universalConstants->MaxNeutronMass;
						universe->MaxProtonMass = universalConstants->MaxProtonMass;
						universe->MaxPropAccel = universalConstants->MaxPropAccel;
						universe->MaxFTLAccel = universalConstants->MaxFTLAccel;
						universe->MaxNumGalaxy = universalConstants->MaxNumGalaxy;
					}
				}
				else 
				{
					warning(FailFileInitCheck);
				}
			}
			else 
			{
				warning(FailFileFindRef);
			}
		break;
		}
		case LOADSPECIESFROMPANEL:	
		{
			entry_ref ref;
			int32 numSpecies;
			if (pparamMessage->FindRef("refs", &ref) >= B_OK) 
			{
				BFile file(&ref, B_READ_ONLY);
				status_t fileStatus;
				if ((fileStatus = file.InitCheck()) == B_NO_ERROR) 
				{
					if (!StripFileHeaderPre(&file)) 
					{
						warning(noLoad);
						return;
					}
					if (!StripFileHeader(	SPECIES_TYPE, 
											&file, 
											&numSpecies)) 
					{
						warning(noLoad);
						return;
					}
					if (!(species->Load(&file))) 
					{
						warning(noLoad);
					}
					else 
					{
						speciesCurrent = species;
						//debug change button label
					}
				}
				else 
				{
					warning(FailFileInitCheck);
				}
			}
			else 
			{
				warning(FailFileFindRef);
			}
		break;
		}
		case LOADELEMENTFROMPANEL:	
		{
			entry_ref ref;
			int32 numElement;
			if (pparamMessage->FindRef("refs", &ref) >= B_OK) 
			{
				BFile file(&ref, B_READ_ONLY);
				status_t fileStatus;
				if ((fileStatus = file.InitCheck()) == B_NO_ERROR) 
				{
					if (!StripFileHeaderPre(&file)) 
					{
						warning(noLoad);
						return;
					}
					if (!StripFileHeader(	ELEMENT_TYPE, 
											&file, 
											&numElement)) 
					{
						warning(noLoad);
						return;
					}
					if (!(element->Load(&file))) 
					{
						warning(noLoad);
					}
					else 
					{
						elementCurrent = element;
						//debug change button label
					}
				}
				else 
				{
					warning(FailFileInitCheck);
				}
			}
			else 
			{
				warning(FailFileFindRef);
			}
		break;
		}
		case LOADCOMPOUNDFROMPANEL:	
		{
			entry_ref ref;
			int32 numCompound;
			if (pparamMessage->FindRef("refs", &ref) >= B_OK) 
			{
				BFile file(&ref, B_READ_ONLY);
				status_t fileStatus;
				if ((fileStatus = file.InitCheck()) == B_NO_ERROR) 
				{
					if (!StripFileHeaderPre(&file)) 
					{
						warning(noLoad);
						return;
					}
					if (!StripFileHeader(	COMPOUND_TYPE, 
											&file, 
											&numCompound)) 
					{
						warning(noLoad);
						return;
					}
					if (!(compound->Load(&file))) 
					{
						warning(noLoad);
					}
					else 
					{
						compoundCurrent = compound;
						//debug change button label
					}
				}
				else 
				{
					warning(FailFileInitCheck);
				}
			}
			else 
			{
				warning(FailFileFindRef);
			}
		break;
		}
		case DFLT_UNIVCONST:	
		{
			warning("debug loading dflt UC\n");
		break;
		}
		case DFLT_SPECIES:	
		{
			warning("debug loading dflt spec\n");
		break;
		}
		case DFLT_ELEMENT:	
		{
			warning("debug loading dflt elem\n");
		break;
		}
		case DFLT_COMPOUND:	
		{
			warning("debug loading dflt comp\n");
		break;
		}
		case DSGN_UNIVCONST:	
		{
			EditUniversalConstants();
		break;
		}
		case DSGN_SPECIES:	
		{
			EditSpeciesList();
		break;
		}
		case DSGN_ELEMENT:	
		{
			EditElementList();
		break;
		}
		case DSGN_COMPOUND:	
		{
			EditCompoundList();
		break;
		}
		case DSGN_MINE:	
		{
			EditMineList();
		break;
		}
		case DSGN_FACTORY:	
		{
			EditFactoryList();
		break;
		}
		case DSGN_ENGINE:	
		{
			EditEngineList();
		break;
		}
		case DSGN_SHIPWEAPON:	
		{
			EditShipWeaponList();
		break;
		}
		case DSGN_SHIPSHIELD:	
		{
			EditShipShieldList();
		break;
		}
		case DSGN_SHIP:	
		{
			EditShipList();
		break;
		}
		case DSGN_PLANETWEAPON:	
		{
			EditPlanetWeaponList();
		break;
		}
		case DSGN_PLANETSHIELD:	
		{
			EditPlanetShieldList();
		break;
		}
		case DSGN_PLANET:	
		{
			EditPlanetList();
		break;
		}
		case DSGN_STAR:	
		{
			EditStarList();
		break;
		}
		case DSGN_WORMHOLE:	
		{
			EditWormholeList();
		break;
		}
		case DSGN_BLACKHOLE:	
		{
			EditBlackholeList();
		break;
		}
		case DSGN_GALAXY:	
		{
			EditGalaxyList();
		break;
		}
		case QUIT_APP:
		{
			if (Verify(ReallyQuitApp))
			{
				myApp->PostMessage(B_QUIT_REQUESTED);
			}
		break;
		}
		case BLSAVE:
			if (validate)
			{
				if (!saveUniversePanel) 
				{
					try 
					{
						saveUniverseMessenger = new BMessenger(this);
					}
					catch (...) 
					{
						warning(FailMemory);
						saveUniverseMessenger = NULL;
						return;
					}
					try 
					{
						saveUniversePanel = new BFilePanel(	B_SAVE_PANEL, 
													saveUniverseMessenger, 
													NULL, 
													B_FILE_NODE, 
													false, 
													new BMessage(SAVEFROMPANEL), 
													NULL, 
													false, 
													true);
						saveUniversePanel->Show();
					}
					catch (...) 
					{
						warning(FailMemory);
						saveUniversePanel = NULL;
						return;
					}
				}
				else 
				{
					saveUniversePanel->Show();
				}
			}
			else
			{
				warning(NeedNameToKeep);
			}
		break;
		case BLLOAD:
		{
			if (!loadUniversePanel) 
			{
				try 
				{
					loadUniverseMessenger = new BMessenger(this);
				}
				catch (...) 
				{
					warning(FailMemory);
					loadUniverseMessenger = NULL;
					return;
				}
				try 
				{
					loadUniversePanel = new BFilePanel(	B_OPEN_PANEL, 
														loadUniverseMessenger, 
														NULL, 
														B_FILE_NODE, 
														false, 
														new BMessage(LOADUNIVERSEFROMPANEL), 
														NULL, 
														false, 
														true);
					panelWindow = loadUniversePanel->Window();
					panelWindow->SetTitle(OpenUniverse);
					loadUniversePanel->Show();
				}
				catch (...) 
				{
					warning(FailMemory);
					loadUniversePanel = NULL;
					return;
				}
			}
			else 
			{
				loadUniversePanel->Show();
			}
		break;
		}
		case LOADUNIVERSEFROMPANEL:	
		{
			entry_ref ref;
			int32 numUniverse;
			if (pparamMessage->FindRef("refs", &ref) >= B_OK) 
			{
				BFile file(&ref, B_READ_ONLY);
				status_t fileStatus;
				if ((fileStatus = file.InitCheck()) == B_NO_ERROR) 
				{
					if (!StripFileHeaderPre(&file)) 
					{
						warning(noLoad);
						return;
					}
					if (!StripFileHeader(	UNIVERSE_TYPE, 
											&file, 
											&numUniverse)) 
					{
						warning(noLoad);
						return;
					}
					if (!(universe->Load(&file))) 
					{
						warning(noLoad);
					}
					else 
					{
						universeCurrent = universe;
						mpNameStrGadget->SetText(universeCurrent->name);
						thisDNPtr = dataListGlobal[UNIVERSE_TYPE]->NextPrevItems(	(void *)universeCurrent, 
																						&nextDNPtr, 
																						&prevDNPtr, 
																						pBottomButtons);
					}
				}
				else 
				{
					warning(FailFileInitCheck);
				}
			}
			else 
			{
				warning(FailFileFindRef);
			}
		break;
		}
		case LOAD_UNIVCONST:
		{
			if (!loadUniversalConstantsPanel) 
			{
				try 
				{
					loadUniversalConstantsMessenger = new BMessenger(this);
				}
				catch (...) 
				{
					warning(FailMemory);
					loadUniversalConstantsMessenger = NULL;
					return;
				}
				try 
				{
					loadUniversalConstantsPanel = new BFilePanel(	B_OPEN_PANEL, 
																	loadUniversalConstantsMessenger, 
																	NULL, 
																	B_FILE_NODE, 
																	false, 
																	new BMessage(LOADUNIVERSALCONSTANTFROMPANEL), 
																	NULL, 
																	false, 
																	true);
					panelWindow = loadUniversalConstantsPanel->Window();
					panelWindow->SetTitle(OpenUC);
					loadUniversalConstantsPanel->Show();
				}
				catch (...) 
				{
					warning(FailMemory);
					loadUniversalConstantsPanel = NULL;
					return;
				}
			}
			else 
			{
				loadUniversalConstantsPanel->Show();
			}
		break;
		}
		case LOAD_SPECIES:
		{
			if (!loadSpeciesPanel) 
			{
				try 
				{
					loadSpeciesMessenger = new BMessenger(this);
				}
				catch (...) 
				{
					warning(FailMemory);
					loadSpeciesMessenger = NULL;
					return;
				}
				try 
				{
					loadSpeciesPanel = new BFilePanel(	B_OPEN_PANEL, 
														loadSpeciesMessenger, 
														NULL, 
														B_FILE_NODE, 
														false, 
														new BMessage(LOADSPECIESFROMPANEL), 
														NULL, 
														false, 
														true);
					panelWindow = loadSpeciesPanel->Window();
					panelWindow->SetTitle(OpenSpecies);
					loadSpeciesPanel->Show();
				}
				catch (...) 
				{
					warning(FailMemory);
					loadSpeciesPanel = NULL;
					return;
				}
			}
			else 
			{
				loadSpeciesPanel->Show();
			}
		break;
		}
		case LOAD_ELEMENT:
		{
			if (!loadElementPanel) 
			{
				try 
				{
					loadElementMessenger = new BMessenger(this);
				}
				catch (...) 
				{
					warning(FailMemory);
					loadElementMessenger = NULL;
					return;
				}
				try 
				{
					loadElementPanel = new BFilePanel(	B_OPEN_PANEL, 
														loadElementMessenger, 
														NULL, 
														B_FILE_NODE, 
														false, 
														new BMessage(LOADELEMENTFROMPANEL), 
														NULL, 
														false, 
														true);
					panelWindow = loadElementPanel->Window();
					panelWindow->SetTitle(OpenElement);
					loadElementPanel->Show();
				}
				catch (...) 
				{
					warning(FailMemory);
					loadElementPanel = NULL;
					return;
				}
			}
			else 
			{
				loadElementPanel->Show();
			}
		break;
		}
		case LOAD_COMPOUND:
		{
			if (!loadCompoundPanel) 
			{
				try 
				{
					loadCompoundMessenger = new BMessenger(this);
				}
				catch (...) 
				{
					warning(FailMemory);
					loadCompoundMessenger = NULL;
					return;
				}
				try 
				{
					loadCompoundPanel = new BFilePanel(	B_OPEN_PANEL, 
														loadCompoundMessenger, 
														NULL, 
														B_FILE_NODE, 
														false, 
														new BMessage(LOADCOMPOUNDFROMPANEL), 
														NULL, 
														false, 
														true);
					panelWindow = loadCompoundPanel->Window();
					panelWindow->SetTitle(OpenCompound);
					loadCompoundPanel->Show();
				}
				catch (...) 
				{
					warning(FailMemory);
					loadCompoundPanel = NULL;
					return;
				}
			}
			else 
			{
				loadCompoundPanel->Show();
			}
		break;
		}
		case PREFSMSG:
		{
			myPrefs->OpenPreferencesPanel();
		break;
		}
		case BLREMOVE:
			dataListGlobal[UNIVERSE_TYPE]->Remove();
			Quit();
		break;
		case BLLIST:
			try 
			{
				BRect holdRect;
				myPrefs->GetPreferredListViewWindowRect(&holdRect);
				mpListViewWindow = new ListViewWindow(	holdRect,
														lvwts[UNIVERSE_TYPE],
														"ListViewView",
														"ListViewWindowFrame",
														NULL,
														dataListGlobal[UNIVERSE_TYPE], 
														mpNameStrGadget->Text(),
														this,
														LISTVIEWSELECTONE);
				if (err == NO_ERR)
				{
					mpListViewWindow->Initialize();
					pBottomButtons->list->SetEnabled(false);
				}
			}
			catch (...) 
			{
				warning(FailListViewWindow);
				myApp->PostMessage(B_QUIT_REQUESTED);
				throw;
			}
		break;
		case BLLISTGOT:
			if (validate) 
			{
				if (UniqueName(dataListGlobal[UNIVERSE_TYPE], mpNameStrGadget->Text()))
				{
					validate = false;
					if (ValidateUniverse())
					{
						if (AddUniverse()) 
						{
							validate = true;
						}
					}
				}
				else
				{
					if (strcmp(mpNameStrGadget->Text(), universeCurrent->name))
					{
						validate = false;
						if (ValidateUniverse())
						{
							if (UpdateUniverse()) 
							{
								validate = true;
							}
						}
					}
				}
			}
			else
			{
				validate = true;
			}
			if (validate)
			{
				universeCurrent = universeNewCurrent;
				mpNameStrGadget->SetText(universeCurrent->name);
				thisDNPtr = dataListGlobal[UNIVERSE_TYPE]->NextPrevItems(	(void *)universeCurrent, 
																			&nextDNPtr, 
																			&prevDNPtr, 
																			pBottomButtons);
			}
			pBottomButtons->list->SetEnabled(true);
		break;
		case BLPREVIOUS:
		{
			if (validate) 
			{
				if (UniqueName(dataListGlobal[UNIVERSE_TYPE], mpNameStrGadget->Text()))
				{
					validate = false;
					if (ValidateUniverse())
					{
						if (AddUniverse()) 
						{
							validate = true;
						}
					}
				}
				else
				{
					if (strcmp(mpNameStrGadget->Text(), universeCurrent->name))
					{
						validate = false;
						if (ValidateUniverse())
						{
							if (UpdateUniverse()) 
							{
								validate = true;
							}
						}
					}
				}
			}
			else
			{
				validate = true;
			}
			if (validate)
			{
				Universe * prevUniverse = (Universe *)((DataNode *)prevDNPtr)->data;
				universeCurrent = prevUniverse;
				mpNameStrGadget->SetText(universeCurrent->name);
				thisDNPtr = dataListGlobal[UNIVERSE_TYPE]->NextPrevItems(	(void *)universeCurrent, 
																			&nextDNPtr, 
																			&prevDNPtr, 
																			pBottomButtons);
				if (dataListGlobal[UNIVERSE_TYPE]->list->CountItems() > 1) 
				{
					pBottomButtons->list->SetEnabled(true);
				}
				else
				{
					pBottomButtons->list->SetEnabled(false);
				}
			}
		break;
		}
		case BLDONE:
			if (validate) 
			{
				if (UniqueName(dataListGlobal[UNIVERSE_TYPE], mpNameStrGadget->Text()))
				{
					validate = false;
					if (ValidateUniverse())
					{
						if (AddUniverse()) 
						{
							validate = true;
						}
					}
				}
				else
				{
					if (strcmp(mpNameStrGadget->Text(), universeCurrent->name))
					{
						validate = false;
						warning(WrongName);
						mpNameStrGadget->SetText(universeCurrent->name);
					}
					else
					{
						validate = false;
						if (ValidateUniverse())
						{
							if (UpdateUniverse())
							{
								validate = true;
							}
						}
					}
				}
				if (validate)
				{
					pBottomButtons->save->SetEnabled(true);
					if (myApp->pTitleWindow->LockLooper())
					{
						myApp->pTitleWindow->pSaveButton->SetEnabled(true);
						myApp->pTitleWindow->pRealButton->SetEnabled(true);
						myApp->pTitleWindow->UnlockLooper();
					}
					else
					{
						warning(FailLockLooper);
					}
					Quit();
				}
			}
			else
			{
				Quit();
			}
		break;
		case BLNEW:
			if (validate) 
			{
				if (UniqueName(dataListGlobal[UNIVERSE_TYPE], mpNameStrGadget->Text()))
				{
					if (ValidateUniverse())
					{
						if (AddUniverse()) 
						{
							pBottomButtons->save->SetEnabled(true);
							if (myApp->pTitleWindow->LockLooper())
							{
								myApp->pTitleWindow->pSaveButton->SetEnabled(true);
								myApp->pTitleWindow->pRealButton->SetEnabled(true);
								myApp->pTitleWindow->UnlockLooper();
							}
							else
							{
								warning(FailLockLooper);
							}
							mpNameStrGadget->SetText("");
							mpNameStrGadget->MakeFocus();
							pBottomButtons->prev->SetEnabled(true);
							if (dataListGlobal[UNIVERSE_TYPE]->list->CountItems() > 1) 
							{
								pBottomButtons->list->SetEnabled(true);
							}
							else
							{
								pBottomButtons->list->SetEnabled(false);
							}
						}
					}
				}
				else
				{
					if (UpdateUniverse())
					{
						mpNameStrGadget->SetText("");
						mpNameStrGadget->MakeFocus();
						pBottomButtons->prev->SetEnabled(false);
						pBottomButtons->next->SetEnabled(false);
					}
				}
			}
		break;
		case BLADD:
			if (validate) 
			{
				if (UniqueName(dataListGlobal[UNIVERSE_TYPE], mpNameStrGadget->Text()))
				{
					if (ValidateUniverse())
					{
						if (AddUniverse()) 
						{
							pBottomButtons->save->SetEnabled(true);
							if (myApp->pTitleWindow->LockLooper())
							{
								myApp->pTitleWindow->pSaveButton->SetEnabled(true);
								myApp->pTitleWindow->pRealButton->SetEnabled(true);
								myApp->pTitleWindow->UnlockLooper();
							}
							else
							{
								warning(FailLockLooper);
							}
							mpNameStrGadget->SetText("");
							mpNameStrGadget->MakeFocus();
							pBottomButtons->prev->SetEnabled(false);
							pBottomButtons->gnu->SetEnabled(false);
							if (dataListGlobal[UNIVERSE_TYPE]->list->CountItems() > 1) 
							{
								pBottomButtons->list->SetEnabled(true);
							}
							else
							{
								pBottomButtons->list->SetEnabled(false);
							}
						}
					}
				}
				else
				{
					warning(FailNameUnique[UNIVERSE_TYPE]);
				}
			}
			else 
			{
				warning(everythingNamed);
			}
		break;
		case BLPICTURE:
			warning("debug no pictures yet\n");
		break;
		case BLNEXT:
		{
			if (validate) 
			{
				if (UniqueName(dataListGlobal[UNIVERSE_TYPE], mpNameStrGadget->Text()))
				{
					validate = false;
					if (ValidateUniverse())
					{
						if (AddUniverse()) 
						{
							validate = true;
						}
					}
				}
				else
				{
					if (strcmp(mpNameStrGadget->Text(), universeCurrent->name))
					{
						validate = false;
						if (ValidateUniverse())
						{
							if (UpdateUniverse()) 
							{
								validate = true;
							}
						}
					}
				}
			}
			else
			{
				validate = true;
			}
			if (validate)
			{
				Universe * nextUniverse = (Universe *)((DataNode *)nextDNPtr)->data;
				universeCurrent = nextUniverse;
				mpNameStrGadget->SetText(universeCurrent->name);
				thisDNPtr = dataListGlobal[UNIVERSE_TYPE]->NextPrevItems(	(void *)universeCurrent, 
																			&nextDNPtr, 
																			&prevDNPtr, 
																			pBottomButtons);
				if (dataListGlobal[UNIVERSE_TYPE]->list->CountItems() > 1) 
				{
					pBottomButtons->list->SetEnabled(true);
				}
				else
				{
					pBottomButtons->list->SetEnabled(false);
				}
			}
		break;
		}
		default:
			WindowGuts::MessageReceived(pparamMessage);
		break;
	}
}//end


bool
EditUniverseWindow	::	QuitRequested(	void) 
{
	BRect frame = Frame();
	myApp->SetPreferredEditUniverseWindowRect(frame);
	if (strcmp(mpNameStrGadget->Text(), "")) 
	{
		if (universeCurrent) 
		{
			if (ValidateUniverse()) 
			{
				if (UpdateUniverse()) 
				{
					return(WindowGuts::QuitRequested());
				}
				else 
				{
					return false;
				}
			}
			else 
			{
				return false;
			}
		}
	}
	return(WindowGuts::QuitRequested());
}//end


bool 
EditUniverseWindow	::	ValidateUniverse(	void) 
{
	return UniqueName(dataListGlobal[UNIVERSE_TYPE], mpNameStrGadget->Text());
}//end


bool 
EditUniverseWindow	::	AddUniverse(	void) 
{
	Universe * thang;
	try
	{
		thang = new Universe(	universe, 
								(char *)mpNameStrGadget->Text());
	}
	catch (...)
	{
		warning(FailMemory);
		return false;
	}
	if (err != CREATED)
	{
		delete thang;
		return false;
	}
	return true;
}//end


bool 
EditUniverseWindow	::	UpdateUniverse(	void) 
{
	if (universeCurrent) 
	{
		if (!universeCurrent->Copy(universe))
		{
			return false;
		}
		return true;
	}
	return false;
}//end


void
EditUniverseWindow	::	EditElementList(	void)
{
warning("debug DSGN_ELEMENT\n");
}//end


void
EditUniverseWindow	::	EditCompoundList(	void)
{
warning("debug DSGN_COMPOUND\n");
}//end


void
EditUniverseWindow	::	EditMineList(	void)
{
warning("debug DSGN_MINE\n");
}//end


void
EditUniverseWindow	::	EditFactoryList(	void)
{
warning("debug DSGN_FACTORY\n");
}//end


void
EditUniverseWindow	::	EditEngineList(	void)
{
warning("debug DSGN_ENGINE\n");
}//end


void
EditUniverseWindow	::	EditShipList(	void)
{
warning("debug DSGN_SHIP\n");
}//end


void
EditUniverseWindow	::	EditShipShieldList(	void)
{
warning("debug DSGN_SHIPSHIELD\n");
}//end


void
EditUniverseWindow	::	EditShipWeaponList(	void)
{
warning("debug DSGN_SHIPWEAPON\n");
}//end


void
EditUniverseWindow	::	EditPlanetList(	void)
{
warning("debug DSGN_PLANET\n");
}//end


void
EditUniverseWindow	::	EditPlanetShieldList(	void)
{
warning("debug DSGN_PLANETSHIELD\n");
}//end


void
EditUniverseWindow	::	EditPlanetWeaponList(	void)
{
warning("debug DSGN_PLANETWEAPON\n");
}//end


void
EditUniverseWindow	::	EditStarList(	void)
{
warning("debug DSGN_STAR\n");
}//end


void
EditUniverseWindow	::	EditWormholeList(	void)
{
warning("debug DSGN_WORMHOLE\n");
}//end


void
EditUniverseWindow	::	EditBlackholeList(	void)
{
warning("debug DSGN_BLACKHOLE\n");
}//end


void
EditUniverseWindow	::	EditSpeciesList(	void)
{
	try 
	{
		BRect holdRect;
		myApp->GetPreferredEditSpeciesWindowRect(&holdRect);
		myApp->pEditSpeciesWindow = new EditSpeciesWindow(	holdRect,
															EditSpeciesWindowTitle,
															"SpeciesView",
															"SpeciesFrame");
		myApp->pEditSpeciesWindow->Initialize();
	}
	catch (...) 
	{
		warning(FailEditSpeciesWindow);
		myApp->PostMessage(B_QUIT_REQUESTED);
		throw;
	}
}//end


void
EditUniverseWindow	::	EditGalaxyList(	void)
{
warning("debug DSGN_GALAXY\n");
}//end


void
EditUniverseWindow	::	EditUniversalConstants(	void)
{
	try 
	{
		BRect holdRect;
		myApp->GetPreferredEditUniversalConstantsWindowRect(&holdRect);
		myApp->pEditUniversalConstantsWindow = new EditUniversalConstantsWindow(	holdRect,
																					EditUniversalConstantsWindowTitle,
																					"UniversalConstantsView",
																					"UniversalConstantsFrame");
		myApp->pEditUniversalConstantsWindow->Initialize();
	}
	catch (...) 
	{
		warning(FailEditUniversalConstantsWindow);
		myApp->PostMessage(B_QUIT_REQUESTED);
		throw;
	}
}//end
