//editorWormhole.cpp

#include "windowGuts.h"
#include "myButton.h"
#include "designButtons.h"
#include "editUniverseWindow.h"
#include "bottomLine.h"
#include "editWormholeWindow.h"

void EditUniverseWindow::EditWormholeList(void) {

float biggestX = 632;
float biggestY = 475;
BRect editWindowRect(40,21, biggestX,biggestY);
editWormholeWindow = new EditWormholeWindow(editWindowRect, editThe[WORMHOLE_TYPE]);
if (!editWormholeWindow) {
	warning(failEditWindow);
	return;
}
editWormholeWindow->Lock();

char * prelimName;
int32 mode;
if (wormholeCurrent) {
	prelimName = wormholeCurrent->name;
	mode = SOI_BLREMOVE;
}
else {
	prelimName = NULL;
	mode = SOI_BLADD;
}

int32 left = 10;
int32 width = 235;
int32 height = 18;
int32 vgap = 23;//height + Vspacing
float divider = 160.0;
int32 top = 24;

BRect nameRect(10,2, 580,18);
BMessage * bmName = new BMessage(SOI_NAMEWORMHOLE);
if (!bmName) {
	warning(failMemory);
	return;
}
editWormholeWindow->nameStrGadget = new StringGadget(nameRect, nameGadgetStr, nameOf[WORMHOLE_TYPE], prelimName, bmName, B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW | B_NAVIGABLE);
if (!editWormholeWindow->nameStrGadget) {
	warning(failStringGadget);
	return;
}
editWormholeWindow->nameStrGadget->SetAlignment(B_ALIGN_RIGHT, B_ALIGN_LEFT);
editWormholeWindow->nameStrGadget->SetDivider(200.0);
if (mode == SOI_BLADD) editWormholeWindow->nameStrGadget->makeFocus = true;
editWormholeWindow->AddChild(editWormholeWindow->nameStrGadget);

if (editWormholeWindow->affectButton) editWormholeWindow->AddChild(editWormholeWindow->affectButton);

bool save = false;
if (dataListGlobal[WORMHOLE_TYPE]->list->CountItems()) save = true;
editWormholeWindow->bottom = 405;
BottomLine(WORMHOLE_TYPE, (EditUniverseWindow * )editWormholeWindow, editWormholeWindow->bottom, editWormholeWindow->bb, mode, save);
editWormholeWindow->thisDNPtr = dataListGlobal[WORMHOLE_TYPE]->NextPrevItems((void *)wormholeCurrent, &editWormholeWindow->nextDNPtr, &editWormholeWindow->prevDNPtr, editWormholeWindow->bb);

editWormholeWindow->Unlock();
editWormholeWindow->Show();
}//end