//putFileHeader.cpp

#include "XfileHeaders.h"
#include "def.h"
#include "versionID.h"
#include "Xwarning.h"

bool 
PutFileHeaderPre(	BFile * file) 
{
	BMessage msg;
	status_t success = msg.AddString("cIDMsg", "SoIEditor");
	if (success == B_OK)
	{
		msg.Flatten(file);
		return true;
	}
	warning(BMsgAddXFailPutFileHeaderPre);
	return false;
}//end


bool 
StripFileHeaderPre(	BFile * file) 
{
	BMessage msg;
	char * strPtr;
	status_t success = msg.Unflatten(file);
	if (success == B_OK)
	{
		success = msg.FindString("cIDMsg", &strPtr);
		if (success == B_OK)
		{
			if (!strcmp("SoIEditor", strPtr))
			{
				return true;
			}
		}
		warning(BMsgFindXFailStripFileHeaderPre);
	}
	warning(BMsgFailUnflatten);
	return false;
}//end


bool 
PutFileHeader(	int32 kind, 
				int32 num, 
				BFile * file) 
{
	BMessage msg;
	status_t success = msg.AddString("kindStr", kindStr[kind]);
	if (success == B_OK)
	{
		success = msg.AddInt32("kindVersion0", (int32)kindVersion[kind][0]);
		if (success == B_OK)
		{
			success = msg.AddInt32("kindVersion1", (int32)kindVersion[kind][1]);
			if (success == B_OK)
			{
				success = msg.AddInt32("numPFH", num);
				if (success == B_OK)
				{
					msg.Flatten(file);
					return true;
				}
			}
		}
	}
	warning(BMsgAddXFailPutFileHeader);
	return false;
}//end


bool 
StripFileHeader(	int32 kind, 
					BFile * file, 
					int32 * num) 
{
	BMessage msg;
	char * strPtr;
	status_t success = msg.Unflatten(file);
	if (success == B_OK)
	{
		success = msg.FindString("kindStr", &strPtr);
		if (success == B_OK)
		{
			if (!strcmp(strPtr, kindStr[kind]))
			{
				uint32 vers;
				success = msg.FindInt32("kindVersion0", (int32 *)&vers);
				if (success == B_OK)
				{
					if (vers == kindVersion[kind][0])
					{
						success = msg.FindInt32("kindVersion1", (int32 *)&vers);
						if (success == B_OK)
						{
							if (vers == kindVersion[kind][1])
							{
								success = msg.FindInt32("numPFH", num);
								if (success == B_OK)
								{
									return true;
								}
							}
						}
					}
				}
			}
		}
		warning(BMsgFindXFailStripFileHeader);
	}
	warning(BMsgFailUnflatten);
	return false;
}//end
