//universeSaveLoad.cpp

#include "Dstar.h"
#include "XfileHeaders.h"
#include "Xthings.h"
#include "windowGuts.h"
#include "themAll.h"
#include "dataNode.h"
#include "dataList.h"
#include "ptrList.h"
#include "mergeHow.h"
#include "mergeNode.h"
#include "mergeList.h"
#include "mPtrNode.h"
#include "XuIntPtrNode.h"
#include "uIntPtrNode.h"
#include "Xunique.h"
#include "mergeListAll.h"
#include "doable.h"
#include "designButtons.h"
#include "constants.h"
#include "myButton.h"
#include "bottomButtons.h"
#include "listViewWindow.h"
#include "editUniverseWindow.h"
#include "titleWindow.h"
#include "Xwarning.h"
#include "preferences.h"
#include "myPreferences.h"
#include "myroColour.h"
#include "myApp.h"
#include "error.h"

//bool 
//DoableItem(	int32 item)
//{
//	switch (item)
//	{
//		case MINE_TYPE:
//		case FACTORY_TYPE:
//		case ENGINE_TYPE:
//		case SHIP_TYPE:
//		case SHIPSHIELD_TYPE:
//		case SHIPWEAPON_TYPE:
//		case PLANETSHIELD_TYPE:
//		case PLANETWEAPON_TYPE:
//			return true;
//		break;
//		default:
//			return false;
//		break;
//	}
//	return false;
//}//end


bool 
Universe	::	SaveUniverse(		BFile * file)
{
	DataNode * node;
	Universe * saveUniverse;
	int32 thingNum[NUMTHINGS];
	for (	int32 i = 0;
			i < NUMTHINGS;
			i++)
	{
		thingNum[i] = dataListGlobal[i]->list->CountItems();
	}
	if (thingNum[UNIVERSE_TYPE])
	{
		Element * saveElement;
		if (!PutFileHeader(ELEMENT_TYPE, thingNum[ELEMENT_TYPE], file))
		{
			warning(noSave);
			return false;
		}
		if (thingNum[ELEMENT_TYPE])
		{
			for (	int32 i = 0;
					#pragma warn_possunwant off
					node = (DataNode *)dataListGlobal[ELEMENT_TYPE]->list->ItemAt(i);
					#pragma warn_possunwant reset
					i++)
			{
				saveElement = (Element *)node->data;
				if (!(saveElement->Save(file)))
				{
					warning(noSave);
					return false;
				}
			}
		}
		else {
			warning(nothingToSave[ELEMENT_TYPE]);
		}
		Compound * saveCompound;
		if (!PutFileHeader(COMPOUND_TYPE, thingNum[COMPOUND_TYPE], file))
		{
			warning(noSave);
			return false;
		}
		if (thingNum[COMPOUND_TYPE])
		{
			for (	int32 i = 0;
					#pragma warn_possunwant off
					node = (DataNode *)dataListGlobal[COMPOUND_TYPE]->list->ItemAt(i);
					#pragma warn_possunwant reset
					i++)
			{
				saveCompound = (Compound *)node->data;
				if (!(saveCompound->Save(file)))
				{
					warning(noSave);
					return false;
				}
			}
		}
		else {
			warning(nothingToSave[COMPOUND_TYPE]);
		}
		Mine * saveMine;
		if (!PutFileHeader(MINE_TYPE, thingNum[MINE_TYPE], file))
		{
			warning(noSave);
			return false;
		}
		if (thingNum[MINE_TYPE])
		{
			for (	int32 i = 0;
					#pragma warn_possunwant off
					node = (DataNode *)dataListGlobal[MINE_TYPE]->list->ItemAt(i);
					#pragma warn_possunwant reset
					i++)
			{
				saveMine = (Mine *)node->data;
				if (!(saveMine->Save(file)))
				{
					warning(noSave);
					return false;
				}
			}
		}
		else {
			warning(nothingToSave[MINE_TYPE]);
		}
		Factory * saveFactory;
		if (!PutFileHeader(FACTORY_TYPE, thingNum[FACTORY_TYPE], file))
		{
			warning(noSave);
			return false;
		}
		if (thingNum[FACTORY_TYPE])
		{
			for (	int32 i = 0;
					#pragma warn_possunwant off
					node = (DataNode *)dataListGlobal[FACTORY_TYPE]->list->ItemAt(i);
					#pragma warn_possunwant reset
					i++)
			{
				saveFactory = (Factory *)node->data;
				if (!(saveFactory->Save(file)))
				{
					warning(noSave);
					return false;
				}
			}
		}
		else {
			warning(nothingToSave[FACTORY_TYPE]);
		}
		Engine * saveEngine;
		if (!PutFileHeader(ENGINE_TYPE, thingNum[ENGINE_TYPE], file))
		{
			warning(noSave);
			return false;
		}
		if (thingNum[ENGINE_TYPE])
		{
			for (	int32 i = 0;
					#pragma warn_possunwant off
					node = (DataNode *)dataListGlobal[ENGINE_TYPE]->list->ItemAt(i);
					#pragma warn_possunwant reset
					i++)
			{
				saveEngine = (Engine *)node->data;
				if (!(saveEngine->Save(file)))
				{
					warning(noSave);
					return false;
				}
			}
		}
		else {
			warning(nothingToSave[ENGINE_TYPE]);
		}
		Ship * saveShip;
		if (!PutFileHeader(SHIP_TYPE, thingNum[SHIP_TYPE], file))
		{
			warning(noSave);
			return false;
		}
		if (thingNum[SHIP_TYPE])
		{
			for (	int32 i = 0;
					#pragma warn_possunwant off
					node = (DataNode *)dataListGlobal[SHIP_TYPE]->list->ItemAt(i);
					#pragma warn_possunwant reset
					i++)
			{
				saveShip = (Ship *)node->data;
				if (!(saveShip->Save(file)))
				{
					warning(noSave);
					return false;
				}
			}
		}
		else {
			warning(nothingToSave[SHIP_TYPE]);
		}
		ShipShield * saveShipShield;
		if (!PutFileHeader(SHIPSHIELD_TYPE, thingNum[SHIPSHIELD_TYPE], file))
		{
			warning(noSave);
			return false;
		}
		if (thingNum[SHIPSHIELD_TYPE])
		{
			for (	int32 i = 0;
					#pragma warn_possunwant off
					node = (DataNode *)dataListGlobal[SHIPSHIELD_TYPE]->list->ItemAt(i);
					#pragma warn_possunwant reset
					i++)
			{
				saveShipShield = (ShipShield *)node->data;
				if (!(saveShipShield->Save(file)))
				{
					warning(noSave);
					return false;
				}
			}
		}
		else {
			warning(nothingToSave[SHIPSHIELD_TYPE]);
		}
		ShipWeapon * saveShipWeapon;
		if (!PutFileHeader(SHIPWEAPON_TYPE, thingNum[SHIPWEAPON_TYPE], file))
		{
			warning(noSave);
			return false;
		}
		if (thingNum[SHIPWEAPON_TYPE])
		{
			for (	int32 i = 0;
					#pragma warn_possunwant off
					node = (DataNode *)dataListGlobal[SHIPWEAPON_TYPE]->list->ItemAt(i);
					#pragma warn_possunwant reset
					i++)
			{
				saveShipWeapon = (ShipWeapon *)node->data;
				if (!(saveShipWeapon->Save(file)))
				{
					warning(noSave);
					return false;
				}
			}
		}
		else {
			warning(nothingToSave[SHIPWEAPON_TYPE]);
		}
		Planet * savePlanet;
		if (!PutFileHeader(PLANET_TYPE, thingNum[PLANET_TYPE], file))
		{
			warning(noSave);
			return false;
		}
		if (thingNum[PLANET_TYPE])
		{
			for (	int32 i = 0;
					#pragma warn_possunwant off
					node = (DataNode *)dataListGlobal[PLANET_TYPE]->list->ItemAt(i);
					#pragma warn_possunwant reset
					i++)
			{
				savePlanet = (Planet *)node->data;
				if (!(savePlanet->Save(file)))
				{
					warning(noSave);
					return false;
				}
			}
		}
		else {
			warning(nothingToSave[PLANET_TYPE]);
		}
		PlanetShield * savePlanetShield;
		if (!PutFileHeader(PLANETSHIELD_TYPE, thingNum[PLANETSHIELD_TYPE], file))
		{
			warning(noSave);
			return false;
		}
		if (thingNum[PLANETSHIELD_TYPE])
		{
			for (	int32 i = 0;
					#pragma warn_possunwant off
					node = (DataNode *)dataListGlobal[PLANETSHIELD_TYPE]->list->ItemAt(i);
					#pragma warn_possunwant reset
					i++)
			{
				savePlanetShield = (PlanetShield *)node->data;
				if (!(savePlanetShield->Save(file)))
				{
					warning(noSave);
					return false;
				}
			}
		}
		else {
			warning(nothingToSave[PLANETSHIELD_TYPE]);
		}
		PlanetWeapon * savePlanetWeapon;
		if (!PutFileHeader(PLANETWEAPON_TYPE, thingNum[PLANETWEAPON_TYPE], file))
		{
			warning(noSave);
			return false;
		}
		if (thingNum[PLANETWEAPON_TYPE])
		{
			for (	int32 i = 0;
					#pragma warn_possunwant off
					node = (DataNode *)dataListGlobal[PLANETWEAPON_TYPE]->list->ItemAt(i);
					#pragma warn_possunwant reset
					i++)
			{
				savePlanetWeapon = (PlanetWeapon *)node->data;
				if (!(savePlanetWeapon->Save(file)))
				{
					warning(noSave);
					return false;
				}
			}
		}
		else {
			warning(nothingToSave[PLANETWEAPON_TYPE]);
		}
		Star * saveStar;
		if (!PutFileHeader(STAR_TYPE, thingNum[STAR_TYPE], file))
		{
			warning(noSave);
			return false;
		}
		if (thingNum[STAR_TYPE])
		{
			for (	int32 i = 0;
					#pragma warn_possunwant off
					node = (DataNode *)dataListGlobal[STAR_TYPE]->list->ItemAt(i);
					#pragma warn_possunwant reset
					i++)
			{
				saveStar = (Star *)node->data;
				if (!(saveStar->Save(file)))
				{
					warning(noSave);
					return false;
				}
			}
		}
		else {
			warning(nothingToSave[STAR_TYPE]);
		}
		Wormhole * saveWormhole;
		if (!PutFileHeader(WORMHOLE_TYPE, thingNum[WORMHOLE_TYPE], file))
		{
			warning(noSave);
			return false;
		}
		if (thingNum[WORMHOLE_TYPE])
		{
			for (	int32 i = 0;
					#pragma warn_possunwant off
					node = (DataNode *)dataListGlobal[WORMHOLE_TYPE]->list->ItemAt(i);
					#pragma warn_possunwant reset
					i++)
			{
				saveWormhole = (Wormhole *)node->data;
				if (!(saveWormhole->Save(file)))
				{
					warning(noSave);
					return false;
				}
			}
		}
		else {
			warning(nothingToSave[WORMHOLE_TYPE]);
		}
		Blackhole * saveBlackhole;
		if (!PutFileHeader(BLACKHOLE_TYPE, thingNum[BLACKHOLE_TYPE], file))
		{
			warning(noSave);
			return false;
		}
		if (thingNum[BLACKHOLE_TYPE])
		{
			for (	int32 i = 0;
					#pragma warn_possunwant off
					node = (DataNode *)dataListGlobal[BLACKHOLE_TYPE]->list->ItemAt(i);
					#pragma warn_possunwant reset
					i++)
			{
				saveBlackhole = (Blackhole *)node->data;
				if (!(saveBlackhole->Save(file)))
				{
					warning(noSave);
					return false;
				}
			}
		}
		else {
			warning(nothingToSave[BLACKHOLE_TYPE]);
		}
		Galaxy * saveGalaxy;
		if (!PutFileHeader(GALAXY_TYPE, thingNum[GALAXY_TYPE], file))
		{
			warning(noSave);
			return false;
		}
		if (thingNum[GALAXY_TYPE])
		{
			for (	int32 i = 0;
					#pragma warn_possunwant off
					node = (DataNode *)dataListGlobal[GALAXY_TYPE]->list->ItemAt(i);
					#pragma warn_possunwant reset
					i++)
			{
				saveGalaxy = (Galaxy *)node->data;
				if (!(saveGalaxy->Save(file)))
				{
					warning(noSave);
					return false;
				}
			}
		}
		else {
			warning(nothingToSave[GALAXY_TYPE]);
		}
		Species * saveSpecies;
		if (!PutFileHeader(SPECIES_TYPE, thingNum[SPECIES_TYPE], file))
		{
			warning(noSave);
			return false;
		}
		if (thingNum[SPECIES_TYPE])
		{
			for (	int32 i = 0;
					#pragma warn_possunwant off
					node = (DataNode *)dataListGlobal[SPECIES_TYPE]->list->ItemAt(i);
					#pragma warn_possunwant reset
					i++)
			{
				saveSpecies = (Species *)node->data;
				if (!(saveSpecies->Save(file)))
				{
					warning(noSave);
					return false;
				}
			}
		}
		else {
			warning(nothingToSave[SPECIES_TYPE]);
		}
		if (!PutFileHeader(UNIVERSE_TYPE, thingNum[UNIVERSE_TYPE], file))
		{
			warning(noSave);
			return false;
		}
				#pragma warn_possunwant off
		for (	int32 i = 0;
				node = (DataNode *)dataListGlobal[UNIVERSE_TYPE]->list->ItemAt(i);
				i++)
		{
				#pragma warn_possunwant reset
			saveUniverse = (Universe *)node->data;
			if (!(saveUniverse->Save(file)))
			{
				warning(noSave);
				return false;
			}
		}
	}
	else 
	{
		warning(nothingToSave[UNIVERSE_TYPE]);
	}
	if (myApp->pTitleWindow)
	{
		if (myApp->pTitleWindow->LockLooper())
		
		{
			myApp->pTitleWindow->pNewButton->SetLabel(editThe[UNIVERSE_TYPE]);
			myApp->pTitleWindow->pRealButton->SetEnabled(true);
			myApp->pTitleWindow->UnlockLooper();
		}
		else
		{
			warning(FailLockLooper);
		}
	}
	return true;
}//end


bool 
Universe	::	LoadUniverse(		BFile * file)

{
	try
	
	{
		MergeListAll * mergeListAll = new MergeListAll;
		int32 thingNum[NUMTHINGS];
		if (!StripFileHeader(ELEMENT_TYPE, file, &thingNum[ELEMENT_TYPE]))
		{
			delete mergeListAll;
			warning(noLoad);
			return false;
		}
		if (thingNum[ELEMENT_TYPE])
		{
			Element itemE;
			for (	int32 i = 0;
					i < thingNum[ELEMENT_TYPE];
					i++)
			{
				if (itemE.Load(file))
				{
					Element * newElement = new Element(	&itemE, mergeListAll->mergeList[ELEMENT_TYPE]);
					if (!newElement)
					{
						warning(FailCreate[ELEMENT_TYPE]);
						i = thingNum[ELEMENT_TYPE];
					}
					else if (err != CREATED)
					{
						i = thingNum[ELEMENT_TYPE];
					}
				}
				else 
				{
					i = thingNum[ELEMENT_TYPE];
				}
			}
			dataListGlobal[ELEMENT_TYPE]->Merge(mergeListAll->mergeList[ELEMENT_TYPE]);
		}
		if (!StripFileHeader(COMPOUND_TYPE, file, &thingNum[COMPOUND_TYPE]))
		{
			delete mergeListAll;
			warning(noLoad);
			return false;
		}
		if (thingNum[COMPOUND_TYPE])
		{
			Compound itemC;
			for (	int32 i = 0;
					i < thingNum[COMPOUND_TYPE];
					i++)
			{
				if (itemC.Load(file))
				{
					Compound * newCompound = new Compound(&itemC, mergeListAll->mergeList[COMPOUND_TYPE]);
					if (!newCompound)
					{
						warning(FailCreate[COMPOUND_TYPE]);
						i = thingNum[COMPOUND_TYPE];
					}
					else if (err != CREATED)
					{
						i = thingNum[COMPOUND_TYPE];		
					}
				}
				else {
					i = thingNum[COMPOUND_TYPE];
				}
			}
			dataListGlobal[COMPOUND_TYPE]->Merge(mergeListAll->mergeList[COMPOUND_TYPE]);
		}
		if (!StripFileHeader(MINE_TYPE, file, &thingNum[MINE_TYPE]))
		{
			delete mergeListAll;
			warning(noLoad);
			return false;
		}
		if (thingNum[MINE_TYPE])
		{
			Mine itemM;
			for (	int32 i = 0;
					i < thingNum[MINE_TYPE];
					i++)
			{
				if (itemM.Load(file))
				{
					Mine * newMine = new Mine(&itemM, mergeListAll->mergeList[MINE_TYPE]);
					if (!newMine)
					{
						warning(FailCreate[MINE_TYPE]);
						i = thingNum[MINE_TYPE];
					}
					else if (err != CREATED)
					{
						i = thingNum[MINE_TYPE];
					}
				}
				else {
					i = thingNum[MINE_TYPE];
				}
			}
			dataListGlobal[MINE_TYPE]->Merge(mergeListAll->mergeList[MINE_TYPE]);
		}
		if (!StripFileHeader(FACTORY_TYPE, file, &thingNum[FACTORY_TYPE]))
		{
			delete mergeListAll;
			warning(noLoad);
			return false;
		}
		if (thingNum[FACTORY_TYPE])
		{
			Factory itemF;
			for (	int32 i = 0;
					i < thingNum[FACTORY_TYPE];
					i++)
			{
				if (itemF.Load(file))
				{
					Factory * newFactory = new Factory(&itemF, mergeListAll->mergeList[FACTORY_TYPE]);
					if (!newFactory)
					{
						warning(FailCreate[FACTORY_TYPE]);
						i = thingNum[FACTORY_TYPE];
					}
					else if (err != CREATED)
					{
						i = thingNum[FACTORY_TYPE];		
					}
				}
				else {
					i = thingNum[FACTORY_TYPE];
				}
			}
			dataListGlobal[FACTORY_TYPE]->Merge(mergeListAll->mergeList[FACTORY_TYPE]);
		}
		if (!StripFileHeader(ENGINE_TYPE, file, &thingNum[ENGINE_TYPE]))
		{
			delete mergeListAll;
			warning(noLoad);
			return false;
		}
		if (thingNum[ENGINE_TYPE])
		{
			Engine itemEN;
			for (	int32 i = 0;
					i < thingNum[ENGINE_TYPE];
					i++)
			{
				if (itemEN.Load(file))
				{
					Engine * newEngine = new Engine(&itemEN, mergeListAll->mergeList[ENGINE_TYPE]);
					if (!newEngine)
					{
						warning(FailCreate[ENGINE_TYPE]);
						i = thingNum[ENGINE_TYPE];
					}
					else if (err != CREATED)
					{
						i = thingNum[ENGINE_TYPE];		
					}
				}
				else {
					i = thingNum[ENGINE_TYPE];
				}
			}
			dataListGlobal[ENGINE_TYPE]->Merge(mergeListAll->mergeList[ENGINE_TYPE]);
		}
		if (!StripFileHeader(SHIP_TYPE, file, &thingNum[SHIP_TYPE]))
		{
			delete mergeListAll;
			warning(noLoad);
			return false;
		}
		if (thingNum[SHIP_TYPE])
		{
			Ship itemSH;
			for (	int32 i = 0;
					i < thingNum[SHIP_TYPE];
					i++)
			{
				if (itemSH.Load(file))
				{
					Ship * newShip = new Ship(&itemSH, mergeListAll->mergeList[SHIP_TYPE]);
					if (!newShip)
					{
						warning(FailCreate[SHIP_TYPE]);
						i = thingNum[SHIP_TYPE];
					}
					else if (err != CREATED)
					{
						i = thingNum[SHIP_TYPE];		
					}
				}
				else {
					i = thingNum[SHIP_TYPE];
				}
			}
			dataListGlobal[SHIP_TYPE]->Merge(mergeListAll->mergeList[SHIP_TYPE]);
		}
		if (!StripFileHeader(SHIPSHIELD_TYPE, file, &thingNum[SHIPSHIELD_TYPE]))
		{
			delete mergeListAll;
			warning(noLoad);
			return false;
		}
		if (thingNum[SHIPSHIELD_TYPE])
		{
			ShipShield itemSS;
			for (	int32 i = 0;
					i < thingNum[SHIPSHIELD_TYPE];
					i++)
			{
				if (itemSS.Load(file))
				{
					ShipShield * newShipShield = new ShipShield(&itemSS, mergeListAll->mergeList[SHIPSHIELD_TYPE]);
					if (!newShipShield)
					{
						warning(FailCreate[SHIPSHIELD_TYPE]);
						i = thingNum[SHIPSHIELD_TYPE];
					}
					else if (err != CREATED)
					{
						i = thingNum[SHIPSHIELD_TYPE];		
					}
				}
				else {
					i = thingNum[SHIPSHIELD_TYPE];
				}
			}
			dataListGlobal[SHIPSHIELD_TYPE]->Merge(mergeListAll->mergeList[SHIPSHIELD_TYPE]);
		}
		if (!StripFileHeader(SHIPWEAPON_TYPE, file, &thingNum[SHIPWEAPON_TYPE]))
		{
			delete mergeListAll;
			warning(noLoad);
			return false;
		}
		if (thingNum[SHIPWEAPON_TYPE])
		{
			ShipWeapon itemSW;
			for (	int32 i = 0;
					i < thingNum[SHIPWEAPON_TYPE];
					i++)
			{
				if (itemSW.Load(file))
				{
					ShipWeapon * newShipWeapon = new ShipWeapon(&itemSW, mergeListAll->mergeList[SHIPWEAPON_TYPE]);
					if (!newShipWeapon)
					{
						warning(FailCreate[SHIPWEAPON_TYPE]);
						i = thingNum[SHIPWEAPON_TYPE];
					}
					else if (err != CREATED)
					{
						i = thingNum[SHIPWEAPON_TYPE];		
					}
				}
				else {
					i = thingNum[SHIPWEAPON_TYPE];
				}
			}
			dataListGlobal[SHIPWEAPON_TYPE]->Merge(mergeListAll->mergeList[SHIPWEAPON_TYPE]);
		}
		if (!StripFileHeader(PLANET_TYPE, file, &thingNum[PLANET_TYPE]))
		{
			delete mergeListAll;
			warning(noLoad);
			return false;
		}
		if (thingNum[PLANET_TYPE])
		{
			Planet itemP;
			for (	int32 i = 0;
					i < thingNum[PLANET_TYPE];
					i++)
			{
				if (itemP.Load(file))
				{
					Planet * newPlanet = new Planet(&itemP, mergeListAll->mergeList[PLANET_TYPE]);
					if (!newPlanet)
					{
						warning(FailCreate[PLANET_TYPE]);
						i = thingNum[PLANET_TYPE];
					}
					else if (err != CREATED)
					{
						i = thingNum[PLANET_TYPE];		
					}
				}
				else {
					i = thingNum[PLANET_TYPE];
				}
			}
			dataListGlobal[PLANET_TYPE]->Merge(mergeListAll->mergeList[PLANET_TYPE]);
		}
		if (!StripFileHeader(PLANETSHIELD_TYPE, file, &thingNum[PLANETSHIELD_TYPE]))
		{
			delete mergeListAll;
			warning(noLoad);
			return false;
		}
		if (thingNum[PLANETSHIELD_TYPE])
		{
			PlanetShield itemPS;
			for (	int32 i = 0;
					i < thingNum[PLANETSHIELD_TYPE];
					i++)
			{
				if (itemPS.Load(file))
				{
					PlanetShield * newPlanetShield = new PlanetShield(&itemPS, mergeListAll->mergeList[PLANETSHIELD_TYPE]);
					if (!newPlanetShield)
					{
						warning(FailCreate[PLANETSHIELD_TYPE]);
						i = thingNum[PLANETSHIELD_TYPE];
					}
					else if (err != CREATED)
					{
						i = thingNum[PLANETSHIELD_TYPE];		
					}
				}
				else {
					i = thingNum[PLANETSHIELD_TYPE];
				}
			}
			dataListGlobal[PLANETSHIELD_TYPE]->Merge(mergeListAll->mergeList[PLANETSHIELD_TYPE]);
		}
		if (!StripFileHeader(PLANETWEAPON_TYPE, file, &thingNum[PLANETWEAPON_TYPE]))
		{
			delete mergeListAll;
			warning(noLoad);
			return false;
		}
		if (thingNum[PLANETWEAPON_TYPE])
		{
			PlanetWeapon itemPW;
			for (	int32 i = 0;
					i < thingNum[PLANETWEAPON_TYPE];
					i++)
			{
				if (itemPW.Load(file))
				{
					PlanetWeapon * newPlanetWeapon = new PlanetWeapon(&itemPW, mergeListAll->mergeList[PLANETWEAPON_TYPE]);
					if (!newPlanetWeapon)
					{
						warning(FailCreate[PLANETWEAPON_TYPE]);
						i = thingNum[PLANETWEAPON_TYPE];
					}
					else if (err != CREATED)
					{
						i = thingNum[PLANETWEAPON_TYPE];		
					}
				}
				else {
					i = thingNum[PLANETWEAPON_TYPE];
				}
			}
			dataListGlobal[PLANETWEAPON_TYPE]->Merge(mergeListAll->mergeList[PLANETWEAPON_TYPE]);
		}
		if (!StripFileHeader(STAR_TYPE, file, &thingNum[STAR_TYPE]))
		{
			delete mergeListAll;
			warning(noLoad);
			return false;
		}
		if (thingNum[STAR_TYPE])
		{
			Star itemST;
			for (	int32 i = 0;
					i < thingNum[STAR_TYPE];
					i++)
			{
				if (itemST.Load(file))
				{
					Star * newStar = new Star(&itemST, mergeListAll->mergeList[STAR_TYPE]);
					if (!newStar)
					{
						warning(FailCreate[STAR_TYPE]);
						i = thingNum[STAR_TYPE];
					}
					else if (err != CREATED)
					{
						i = thingNum[STAR_TYPE];		
					}
				}
				else {
					i = thingNum[STAR_TYPE];
				}
			}
			dataListGlobal[STAR_TYPE]->Merge(mergeListAll->mergeList[STAR_TYPE]);
		}
		if (!StripFileHeader(WORMHOLE_TYPE, file, &thingNum[WORMHOLE_TYPE]))
		{
			delete mergeListAll;
			warning(noLoad);
			return false;
		}
		if (thingNum[WORMHOLE_TYPE])
		{
			Wormhole itemW;
			for (	int32 i = 0;
					i < thingNum[WORMHOLE_TYPE];
					i++)
			{
				if (itemW.Load(file))
				{
					Wormhole * newWormhole = new Wormhole(&itemW, mergeListAll->mergeList[WORMHOLE_TYPE]);
					if (!newWormhole)
					{
						warning(FailCreate[WORMHOLE_TYPE]);
						i = thingNum[WORMHOLE_TYPE];
					}
					else if (err != CREATED)
					{
						i = thingNum[WORMHOLE_TYPE];		
					}
				}
				else {
					i = thingNum[WORMHOLE_TYPE];
				}
			}
			dataListGlobal[WORMHOLE_TYPE]->Merge(mergeListAll->mergeList[WORMHOLE_TYPE]);
		}
		if (!StripFileHeader(BLACKHOLE_TYPE, file, &thingNum[BLACKHOLE_TYPE]))
		{
			delete mergeListAll;
			warning(noLoad);
			return false;
		}
		if (thingNum[BLACKHOLE_TYPE])
		{
			Blackhole itemB;
			for (	int32 i = 0;
					i < thingNum[BLACKHOLE_TYPE];
					i++)
			{
				if (itemB.Load(file))
				{
					Blackhole * newBlackhole = new Blackhole(&itemB, mergeListAll->mergeList[BLACKHOLE_TYPE]);
					if (!newBlackhole)
					{
						warning(FailCreate[BLACKHOLE_TYPE]);
						i = thingNum[BLACKHOLE_TYPE];
					}
					else if (err != CREATED)
					{
						i = thingNum[BLACKHOLE_TYPE];		
					}
				}
				else {
					i = thingNum[BLACKHOLE_TYPE];
				}
			}
			dataListGlobal[BLACKHOLE_TYPE]->Merge(mergeListAll->mergeList[BLACKHOLE_TYPE]);
		}
		if (!StripFileHeader(GALAXY_TYPE, file, &thingNum[GALAXY_TYPE]))
		{
			delete mergeListAll;
			warning(noLoad);
			return false;
		}
		if (thingNum[GALAXY_TYPE])
		{
			Galaxy itemG;
			for (	int32 i = 0;
					i < thingNum[GALAXY_TYPE];
					i++)
			{
				if (itemG.Load(file))
				{
					Galaxy * newGalaxy = new Galaxy(&itemG, mergeListAll->mergeList[GALAXY_TYPE]);
					if (!newGalaxy)
					{
						warning(FailCreate[GALAXY_TYPE]);
						i = thingNum[GALAXY_TYPE];
					}
					else if (err != CREATED)
					{
						i = thingNum[GALAXY_TYPE];		
					}
				}
				else {
					i = thingNum[GALAXY_TYPE];
				}
			}
			dataListGlobal[GALAXY_TYPE]->Merge(mergeListAll->mergeList[GALAXY_TYPE]);
		}
		if (!StripFileHeader(SPECIES_TYPE, file, &thingNum[SPECIES_TYPE]))
		{
			delete mergeListAll;
			warning(noLoad);
			return false;
		}
		if (thingNum[SPECIES_TYPE])
		{
			Species itemSP;
			for (	int32 i = 0;
					i < thingNum[SPECIES_TYPE];
					i++)
			{
				if (itemSP.Load(file))
				{
					Species * newSpecies = new Species(&itemSP, mergeListAll->mergeList[SPECIES_TYPE]);
					if (!newSpecies)
					{
						warning(FailCreate[SPECIES_TYPE]);
						i = thingNum[SPECIES_TYPE];
					}
					else if (err != CREATED)
					{
						i = thingNum[SPECIES_TYPE];		
					}
				}
				else {
					i = thingNum[SPECIES_TYPE];
				}
			}
			dataListGlobal[SPECIES_TYPE]->Merge(mergeListAll->mergeList[SPECIES_TYPE]);
		}
		if (!StripFileHeader(UNIVERSE_TYPE, file, &thingNum[UNIVERSE_TYPE]))
		{
			delete mergeListAll;
			warning(noLoad);
			return false;
		}
		//there BETTER be an universe
		Universe itemU;
		for (	int32 i = 0;
				i < thingNum[UNIVERSE_TYPE];
				i++)
		{
			if (itemU.Load(file))
			{
				Universe * newUniverse = new Universe(&itemU, mergeListAll->mergeList[UNIVERSE_TYPE]);
				if (!newUniverse)
				{
					warning(FailCreate[UNIVERSE_TYPE]);
					i = thingNum[UNIVERSE_TYPE];
				}
				else if (err != CREATED)
				{
					i = thingNum[UNIVERSE_TYPE];
				}
			}
			else {
				i = thingNum[UNIVERSE_TYPE];
			}
		}
		dataListGlobal[UNIVERSE_TYPE]->Merge(mergeListAll->mergeList[UNIVERSE_TYPE]);
		int32 numMerged = mergeListAll->mergeList[COMPOUND_TYPE]->list->CountItems();
		for (	int32 i = 0;
				i < numMerged;
				i++)
		{
			MergeNode * mergeNode = (MergeNode *)mergeListAll->mergeList[COMPOUND_TYPE]->list->ItemAt(i);
			if (mergeNode->howMerged != MERGEDCUT)
			{
				Compound * compound = (Compound *)mergeNode->ItemMerged(dataListGlobal[COMPOUND_TYPE]);
				int32 listNum = compound->eList->list->CountItems();
				for (	int32 j = 0;
					j < listNum;
					j++)
				{
					MPtrNode * mPtrNode = (MPtrNode *)compound->eList->list->ItemAt(j);
					UIntPtrNode * uIntPtrNode = new UIntPtrNode(mPtrNode->FindData(dataListGlobal[ELEMENT_TYPE], mergeListAll->mergeList[ELEMENT_TYPE]), mPtrNode->number);
					if (!uIntPtrNode)
					{
						delete mergeListAll;
						warning(FailUIntPtrNode);
						return false;
					}
					compound->eList->list->RemoveItem(j);
					compound->eList->list->AddItem(uIntPtrNode, j);
					delete mPtrNode;
				}
				listNum = compound->cList->list->CountItems();
				for (	int32 j = 0;
					j < listNum;
					j++)
				{
					MPtrNode * mPtrNode = (MPtrNode *)compound->cList->list->ItemAt(j);
					UIntPtrNode * uIntPtrNode = new UIntPtrNode(mPtrNode->FindData(dataListGlobal[COMPOUND_TYPE], mergeListAll->mergeList[COMPOUND_TYPE]), mPtrNode->number);
					if (!uIntPtrNode)
					{
						delete mergeListAll;
						warning(FailUIntPtrNode);
						return false;
					}
					compound->cList->list->RemoveItem(j);
					compound->cList->list->AddItem(uIntPtrNode, j);
					delete mPtrNode;
				}
			}
			
		}
		numMerged = mergeListAll->mergeList[MINE_TYPE]->list->CountItems();
		for (	int32 i = 0;
				i < numMerged;
				i++)
		{
			MergeNode * mergeNode = (MergeNode *)mergeListAll->mergeList[MINE_TYPE]->list->ItemAt(i);
			if (mergeNode->howMerged != MERGEDCUT)
			{
				Mine * thing = (Mine *)mergeNode->ItemMerged(dataListGlobal[MINE_TYPE]);
				if (!thing->doable->FixPtrs(mergeListAll))
				{
					delete mergeListAll;
					return false;
				}
				if (!thing->buildable->FixPtrs(mergeListAll))
				{
					delete mergeListAll;
					return false;
				}
				if (!thing->maintainable->FixPtrs(mergeListAll))
				{
					delete mergeListAll;
					return false;
				}
			}
		}
		numMerged = mergeListAll->mergeList[FACTORY_TYPE]->list->CountItems();
		for (	int32 i = 0;
				i < numMerged;
				i++)
		{
			MergeNode * mergeNode = (MergeNode *)mergeListAll->mergeList[FACTORY_TYPE]->list->ItemAt(i);
			if (mergeNode->howMerged != MERGEDCUT)
			{
				Factory * thing = (Factory *)mergeNode->ItemMerged(dataListGlobal[FACTORY_TYPE]);
				if (!thing->doable->FixPtrs(mergeListAll))
				{
					delete mergeListAll;
					return false;
				}
				if (!thing->buildable->FixPtrs(mergeListAll))
				{
					delete mergeListAll;
					return false;
				}
				if (!thing->maintainable->FixPtrs(mergeListAll))
				{
					delete mergeListAll;
					return false;
				}
			}
		}
		numMerged = mergeListAll->mergeList[ENGINE_TYPE]->list->CountItems();
		for (	int32 i = 0;
				i < numMerged;
				i++)
		{
			MergeNode * mergeNode = (MergeNode *)mergeListAll->mergeList[ENGINE_TYPE]->list->ItemAt(i);
			if (mergeNode->howMerged != MERGEDCUT)
			{
				Engine * thing = (Engine *)mergeNode->ItemMerged(dataListGlobal[ENGINE_TYPE]);
				if (!thing->doable->FixPtrs(mergeListAll))
				{
					delete mergeListAll;
					return false;
				}
				if (!thing->buildable->FixPtrs(mergeListAll))
				{
					delete mergeListAll;
					return false;
				}
				if (!thing->maintainable->FixPtrs(mergeListAll))
				{
					delete mergeListAll;
					return false;
				}
			}
		}
		numMerged = mergeListAll->mergeList[SHIP_TYPE]->list->CountItems();
		for (	int32 i = 0;
				i < numMerged;
				i++)
		{
			MergeNode * mergeNode = (MergeNode *)mergeListAll->mergeList[SHIP_TYPE]->list->ItemAt(i);
			if (mergeNode->howMerged != MERGEDCUT)
			{
				Ship * thing = (Ship *)mergeNode->ItemMerged(dataListGlobal[SHIP_TYPE]);
				if (!thing->doable->FixPtrs(mergeListAll))
				{
					delete mergeListAll;
					return false;
				}
				if (!thing->buildable->FixPtrs(mergeListAll))
				{
					delete mergeListAll;
					return false;
				}
				if (!thing->maintainable->FixPtrs(mergeListAll))
				{
					delete mergeListAll;
					return false;
				}
			}
		}
		numMerged = mergeListAll->mergeList[SHIPSHIELD_TYPE]->list->CountItems();
		for (	int32 i = 0;
				i < numMerged;
				i++)
		{
			MergeNode * mergeNode = (MergeNode *)mergeListAll->mergeList[SHIPSHIELD_TYPE]->list->ItemAt(i);
			if (mergeNode->howMerged != MERGEDCUT)
			{
				ShipShield * thing = (ShipShield *)mergeNode->ItemMerged(dataListGlobal[SHIPSHIELD_TYPE]);
				if (!thing->doable->FixPtrs(mergeListAll))
				{
					delete mergeListAll;
					return false;
				}
				if (!thing->buildable->FixPtrs(mergeListAll))
				{
					delete mergeListAll;
					return false;
				}
				if (!thing->maintainable->FixPtrs(mergeListAll))
				{
					delete mergeListAll;
					return false;
				}
			}
		}
		numMerged = mergeListAll->mergeList[SHIPWEAPON_TYPE]->list->CountItems();
		for (	int32 i = 0;
				i < numMerged;
				i++)
		{
			MergeNode * mergeNode = (MergeNode *)mergeListAll->mergeList[SHIPWEAPON_TYPE]->list->ItemAt(i);
			if (mergeNode->howMerged != MERGEDCUT)
			{
				ShipWeapon * thing = (ShipWeapon *)mergeNode->ItemMerged(dataListGlobal[SHIPWEAPON_TYPE]);
				if (!thing->doable->FixPtrs(mergeListAll))
				{
					delete mergeListAll;
					return false;
				}
				if (!thing->buildable->FixPtrs(mergeListAll))
				{
					delete mergeListAll;
					return false;
				}
				if (!thing->maintainable->FixPtrs(mergeListAll))
				{
					delete mergeListAll;
					return false;
				}
			}
		}
		numMerged = mergeListAll->mergeList[PLANETSHIELD_TYPE]->list->CountItems();
		for (	int32 i = 0;
				i < numMerged;
				i++)
		{
			MergeNode * mergeNode = (MergeNode *)mergeListAll->mergeList[PLANETSHIELD_TYPE]->list->ItemAt(i);
			if (mergeNode->howMerged != MERGEDCUT)
			{
				PlanetShield * thing = (PlanetShield *)mergeNode->ItemMerged(dataListGlobal[PLANETSHIELD_TYPE]);
				if (!thing->doable->FixPtrs(mergeListAll))
				{
					delete mergeListAll;
					return false;
				}
				if (!thing->buildable->FixPtrs(mergeListAll))
				{
					delete mergeListAll;
					return false;
				}
				if (!thing->maintainable->FixPtrs(mergeListAll))
				{
					delete mergeListAll;
					return false;
				}
			}
		}
		numMerged = mergeListAll->mergeList[PLANETWEAPON_TYPE]->list->CountItems();
		for (	int32 i = 0;
				i < numMerged;
				i++)
		{
			MergeNode * mergeNode = (MergeNode *)mergeListAll->mergeList[PLANETWEAPON_TYPE]->list->ItemAt(i);
			
			if (mergeNode->howMerged != MERGEDCUT)
			{
				PlanetWeapon * thing = (PlanetWeapon *)mergeNode->ItemMerged(dataListGlobal[PLANETWEAPON_TYPE]);
				
					
				if (!thing->doable->FixPtrs(mergeListAll))
				{
					delete mergeListAll;
					
					return false;
					
				}
				if (!thing->buildable->FixPtrs(mergeListAll))
				{
					delete mergeListAll;
					return false;
				}
				if (!thing->maintainable->FixPtrs(mergeListAll))
				{
					delete mergeListAll;
					return false;
				}
			}
		}
		delete mergeListAll;
		if (universeCurrent)
		{
			if (universalConstantsCurrent)
			{
				if (!universalConstantsCurrent->Copy(universalConstants))
				{
					return false;
				}
			}
			if (universalConstants)
			{
				universalConstants->MinWidth = universe->MinWidth;
				universalConstants->MinHeight = universe->MinHeight;
				universalConstants->MinDepth = universe->MinDepth;
				universalConstants->MinSofL = universe->MinSofL;
				universalConstants->MinPropFuelUse = universe->MinPropFuelUse;
				universalConstants->MinFTLFuelUse = universe->MinFTLFuelUse;
				universalConstants->MinInstFuelUse = universe->MinInstFuelUse;
				universalConstants->MinElectronMass = universe->MinElectronMass;
				universalConstants->MinNeutronMass = universe->MinNeutronMass;
				universalConstants->MinProtonMass = universe->MinProtonMass;
				universalConstants->MinPropAccel = universe->MinPropAccel;
				universalConstants->MinFTLAccel = universe->MinFTLAccel;
				universalConstants->MinNumGalaxy = universe->MinNumGalaxy;
				universalConstants->MaxWidth = universe->MaxWidth;
				universalConstants->MaxHeight = universe->MaxHeight;
				universalConstants->MaxDepth = universe->MaxDepth;
				universalConstants->MaxSofL = universe->MaxSofL;
				universalConstants->MaxPropFuelUse = universe->MaxPropFuelUse;
				universalConstants->MaxFTLFuelUse = universe->MaxFTLFuelUse;
				universalConstants->MaxInstFuelUse = universe->MaxInstFuelUse;
				universalConstants->MaxElectronMass = universe->MaxElectronMass;
				universalConstants->MaxNeutronMass = universe->MaxNeutronMass;
				universalConstants->MaxProtonMass = universe->MaxProtonMass;
				universalConstants->MaxPropAccel = universe->MaxPropAccel;
				universalConstants->MaxFTLAccel = universe->MaxFTLAccel;
				universalConstants->MaxNumGalaxy = universe->MaxNumGalaxy;
			}
		}
		if (myApp->pTitleWindow->LockLooper())
		{
			myApp->pTitleWindow->pNewButton->SetLabel(editThe[UNIVERSE_TYPE]);
			myApp->pTitleWindow->pRealButton->SetEnabled(true);
			myApp->pTitleWindow->UnlockLooper();
		}
		else
		{
			warning(FailLockLooper);
		}
	}
	catch (...)
	{
		warning(FailMemory);
		throw;
	}
	return true;
}//end

