//floatGadget.cpp

#include "layoutMatrixItem.h"
#include "layoutMatrix.h"
#include "XfloatGadget.h"
#include "floatGadget.h"
#include "preferences.h"
#include "myroColour.h"
#include "myPreferences.h"
#include "myApp.h"

FloatGadget	::	~FloatGadget() 
{
	//left blank
};//end


//ctor
FloatGadget	::	FloatGadget(	float fparamInitValue,
						const char * paramName, 
						const char * paramLabel, 
						uint32 ui32paramMsg, 
						uint32 ui32paramMode, 
						uint32 ui32paramFlags,
						float fparamPixWidth,
						LayoutMatrix * lpparamLayoutMatrix,
						bool bparamMakeFocus) 
		: 	BTextControl(	BRect(0, 0, 32, 32), 
							paramName, 
							paramLabel, 
							NULL, 
							new BMessage(ui32paramMsg), 
							ui32paramMode, 
							ui32paramFlags),
			 bmMakeFocus(	bparamMakeFocus)
{
	lpparamLayoutMatrix->AddToChildren(this);
	SetFont(myPrefs->GetPreferredFont());
	char buf[64];
	sprintf(buf, "%f", fparamInitValue);
	SetText(buf);
	if (fparamPixWidth)
	{
		mfPixWidth = fparamPixWidth;
	}
	else
	{
		BView bv(BRect(0, 0, 32, 32), NoShowView, B_FOLLOW_NONE, NULL);
		bv.SetFont(myPrefs->GetPreferredFont());
		mfPixWidth = bv.StringWidth(paramLabel);
	}
}//end


void 
FloatGadget	::	AttachedToWindow(	void)
{
	SetDrawingMode(B_OP_ADD);
	BTextControl::AttachedToWindow();
	rgb_color tempRgbColor;
	myPrefs->GetPreferredFloatGadgetHighColor(&tempRgbColor);
	SetHighColor(tempRgbColor);
	myPrefs->GetPreferredFloatGadgetLowColor(&tempRgbColor);
	SetLowColor(tempRgbColor);
	myPrefs->GetPreferredFloatGadgetViewColor(&tempRgbColor);
	SetViewColor(tempRgbColor);
	if (bmMakeFocus) 
	{
		MakeFocus();
	}
}//end
