//myPreferences.cpp

#include "beGUI_Version.h"
#include "preferences.h"
#include "myroColour.h"
#include "myPreferences.h"
#include "XmyPreferences.h"
#include "DmenuMsg.h"
#include "myApp.h"
#include "myButton.h"
#include "stringGadget.h"
#include "uInt32Gadget.h"
#include "Xwarning.h"
#include "fontData.h"
#include "layoutMatrix.h"
#include "colorWell.h"
#include "myColorControl.h"
#include "myTextView.h"
#include "myListView.h"
#include "windowGuts.h"
#include "myCheckBox.h"
#include "prefPanelWindow.h"
#include "specificColorWindow.h"
#include <memory>

MyPreferences	::	MyPreferences()
				:	preferredFont(new BFont()),
					bPrefChangesMade(false),
					pPrefPanelWindow(NULL)
{
	FillGlobalsFromResources();
	Preferences appsPreferences(PrefSignature);
	PreferenceSet appsPreferenceSet(	appsPreferences,  
										"hierarchical/extendable/settings", 
										true);
	if (appsPreferences.InitCheck())
	{
		puts(PrefFailInit);
		exit(1);
	}
	if (appsPreferenceSet.InitCheck())
	{
		puts(PrefFailGetSettings);
		exit(2);
	}
	//following is a bunch of prefs stuff set to default if file not found:
	const void * prefData;
	ssize_t prefDataSize;
	uint32 prefDataType = '    ';
//	if (	appsPreferenceSet.GetData(	"FONTDATAPREFERENCE_TYPE", 
//										prefData, 
//										prefDataSize, 
//										prefDataType) 
//			|| 
//			(prefDataType != FONTDATAPREFERENCE_TYPE))
//	{
//		//use the default font
//	}
//	else
//	{
//		memcpy(	&fontData, 
//				prefData, 
//				prefDataSize);
//		SetPreferredFontFromData(&fontData);
//	}
	FontData fontData;
	float floatData;
	if (	appsPreferenceSet.GetData(	"FONTDATA_SIZE_TYPE", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != FONTDATA_SIZE_TYPE))
	{
		//fontData.size = use default;
	}
	else
	{
		memcpy(	&floatData, 
				prefData, 
				prefDataSize);
		fontData.size = floatData;
	}
	if (	appsPreferenceSet.GetData(	"FONTDATA_SHEAR_TYPE", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != FONTDATA_SHEAR_TYPE))
	{
		//fontData.shear = use default;
	}
	else
	{
		memcpy(	&floatData, 
				prefData, 
				prefDataSize);
		fontData.shear = floatData;
	}
	if (	appsPreferenceSet.GetData(	"FONTDATA_ROTATION_TYPE", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != FONTDATA_ROTATION_TYPE))
	{
		//fontData.rotation = use default;
	}
	else
	{
		memcpy(	&floatData, 
				prefData, 
				prefDataSize);
		fontData.rotation = floatData;
	}
	uint32 ui32Data;
	if (	appsPreferenceSet.GetData(	"FONTDATA_FLAGS_TYPE", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != FONTDATA_FLAGS_TYPE))
	{
		//fontData.flags = use default;
	}
	else
	{
		memcpy(	&ui32Data, 
				prefData, 
				prefDataSize);
		fontData.flags = ui32Data;
	}
	if (	appsPreferenceSet.GetData(	"FONTDATA_FANDS_TYPE", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != FONTDATA_FANDS_TYPE))
	{
		//fontData.familyAndStyle = use default;
	}
	else
	{
		memcpy(	&ui32Data, 
				prefData, 
				prefDataSize);
		fontData.familyAndStyle = ui32Data;
	}
	uint16 ui16Data;
	if (	appsPreferenceSet.GetData(	"FONTDATA_FACE_TYPE", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != FONTDATA_FACE_TYPE))
	{
		//fontData.face = use default;
	}
	else
	{
		memcpy(	&ui16Data, 
				prefData, 
				prefDataSize);
		fontData.face = ui16Data;
	}
	uint8 ui8Data;
	if (	appsPreferenceSet.GetData(	"FONTDATA_SPACING_TYPE", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != FONTDATA_SPACING_TYPE))
	{
		//fontData.face = use default;
	}
	else
	{
		memcpy(	&ui8Data, 
				prefData, 
				prefDataSize);
		fontData.spacing = ui8Data;
	}
	if (	appsPreferenceSet.GetData(	"FONTDATA_ENOCDING_TYPE", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != FONTDATA_ENOCDING_TYPE))
	{
		//fontData.encoding = use default;
	}
	else
	{
		memcpy(	&ui8Data, 
				prefData, 
				prefDataSize);
		fontData.encoding = ui8Data;
	}
	SetPreferredFontFromData(&fontData);
	if (	appsPreferenceSet.GetData(	"BARHEIGHT", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != BARHEIGHT))
	{
		SetPreferredBarHeight(20);
	}
	else
	{
		memcpy(	&floatData, 
				prefData, 
				prefDataSize);
		SetPreferredBarHeight(floatData);
	}
	bool boolData;
	if (	appsPreferenceSet.GetData(	"OPENFONTDISPLAY_TYPE", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != OPENFONTDISPLAY_TYPE))
	{
		bOpenFontDisplay = true;
	}
	else
	{
		memcpy(	&boolData, 
				prefData, 
				prefDataSize);
		bOpenFontDisplay = boolData;
	}
	if (	appsPreferenceSet.GetData(	"ANTIALIASFONT_TYPE", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != ANTIALIASFONT_TYPE))
	{
		bAntiAliasFont = true;
	}
	else
	{
		memcpy(	&boolData, 
				prefData, 
				prefDataSize);
		bAntiAliasFont = boolData;
	}
	if (	appsPreferenceSet.GetData(	"USECOLORWELL", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != USECOLORWELL))
	{
		bUseColorWell = true;
	}
	else
	{
		memcpy(	&boolData, 
				prefData, 
				prefDataSize);
		bUseColorWell = boolData;
	}
	if (	appsPreferenceSet.GetData(	"USECOLORCONTROL", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != USECOLORCONTROL))
	{
		bUseColorControl = true;
	}
	else
	{
		memcpy(	&boolData, 
				prefData, 
				prefDataSize);
		bUseColorControl = boolData;
	}
	rgb_color prefsColor;
	if (	appsPreferenceSet.GetData(	"PreferredHighColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 4;
		prefsColor.green = 28;
		prefsColor.blue = 98;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredHighColor(&prefsColor);
	if (	appsPreferenceSet.GetData(	"PreferredLowColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 133;
		prefsColor.green = 180;
		prefsColor.blue = 255;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredLowColor(&prefsColor);
	if (	appsPreferenceSet.GetData(	"PreferredViewColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{

		prefsColor.red = 4;
		prefsColor.green = 28;
		prefsColor.blue = 98;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredViewColor(&prefsColor);
	if (	appsPreferenceSet.GetData(	"PreferredColorWellHighColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 20;
		prefsColor.green = 70;
		prefsColor.blue = 225;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredColorWellHighColor(&prefsColor);
	if (	appsPreferenceSet.GetData(	"PreferredColorWellLowColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 15;
		prefsColor.green = 241;
		prefsColor.blue = 22;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredColorWellLowColor(&prefsColor);
	if (	appsPreferenceSet.GetData(	"PreferredColorWellViewColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 221;
		prefsColor.green = 28;
		prefsColor.blue = 28;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredColorWellViewColor(&prefsColor);
	if (	appsPreferenceSet.GetData(	"PreferredUInt32GadgetHighColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 250;
		prefsColor.green = 0;
		prefsColor.blue = 43;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredUInt32GadgetHighColor(&prefsColor);
	if (	appsPreferenceSet.GetData(	"PreferredUInt32GadgetLowColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 250;
		prefsColor.green = 215;
		prefsColor.blue = 250;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredUInt32GadgetLowColor(&prefsColor);
	if (	appsPreferenceSet.GetData(	"PreferredUInt32GadgetViewColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 0;
		prefsColor.green = 0;
		prefsColor.blue = 79;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredUInt32GadgetViewColor(&prefsColor);
	if (	appsPreferenceSet.GetData(	"PreferredFloatGadgetHighColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 250;
		prefsColor.green = 0;
		prefsColor.blue = 43;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredFloatGadgetHighColor(&prefsColor);
	if (	appsPreferenceSet.GetData(	"PreferredFloatGadgetLowColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 250;
		prefsColor.green = 215;
		prefsColor.blue = 250;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredFloatGadgetLowColor(&prefsColor);
	if (	appsPreferenceSet.GetData(	"PreferredFloatGadgetViewColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 0;
		prefsColor.green = 0;
		prefsColor.blue = 79;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredFloatGadgetViewColor(&prefsColor);
	if (	appsPreferenceSet.GetData(	"PreferredStringGadgetHighColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 250;
		prefsColor.green = 0;
		prefsColor.blue = 43;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredStringGadgetHighColor(&prefsColor);
	if (	appsPreferenceSet.GetData(	"PreferredStringGadgetLowColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 250;
		prefsColor.green = 215;
		prefsColor.blue = 250;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredStringGadgetLowColor(&prefsColor);
	if (	appsPreferenceSet.GetData(	"PreferredStringGadgetViewColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 0;
		prefsColor.green = 0;
		prefsColor.blue = 79;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredStringGadgetViewColor(&prefsColor);
	if (	appsPreferenceSet.GetData(	"PreferredColorWellHighColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 0;
		prefsColor.green = 243;
		prefsColor.blue = 0;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredColorWellHighColor(&prefsColor);
	if (	appsPreferenceSet.GetData(	"PreferredColorWellLowColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 0;
		prefsColor.green = 0;
		prefsColor.blue = 250;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredColorWellLowColor(&prefsColor);
	if (	appsPreferenceSet.GetData(	"PreferredColorWellViewColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 223;
		prefsColor.green = 0;
		prefsColor.blue = 0;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredColorWellViewColor(&prefsColor);
	if (	appsPreferenceSet.GetData(	"PreferredMyButtonHighColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 0;
		prefsColor.green = 250;
		prefsColor.blue = 0;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredMyButtonHighColor(&prefsColor);
	if (	appsPreferenceSet.GetData(	"PreferredMyButtonLowColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 221;
		prefsColor.green = 0;
		prefsColor.blue = 0;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredMyButtonLowColor(&prefsColor);
	if (	appsPreferenceSet.GetData(	"PreferredMyButtonViewColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 232;
		prefsColor.green = 232;
		prefsColor.blue = 232;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredMyButtonViewColor(&prefsColor);
	if (	appsPreferenceSet.GetData(	"PreferredMyPictureButtonHighColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 209;
		prefsColor.green = 209;
		prefsColor.blue = 250;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredMyPictureButtonHighColor(&prefsColor);
	if (	appsPreferenceSet.GetData(	"PreferredMyPictureButtonLowColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 0;
		prefsColor.green = 0;
		prefsColor.blue = 250;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredMyPictureButtonLowColor(&prefsColor);
	if (	appsPreferenceSet.GetData(	"PreferredMyPictureButtonViewColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 223;
		prefsColor.green = 0;
		prefsColor.blue = 0;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredMyPictureButtonViewColor(&prefsColor);
	if (	appsPreferenceSet.GetData(	"PreferredMyCheckBoxHighColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 180;
		prefsColor.green = 221;
		prefsColor.blue = 122;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredMyCheckBoxHighColor(&prefsColor);
	if (	appsPreferenceSet.GetData(	"PreferredMyCheckBoxLowColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 34;
		prefsColor.green = 81;
		prefsColor.blue = 23;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredMyCheckBoxLowColor(&prefsColor);
	if (	appsPreferenceSet.GetData(	"PreferredMyCheckBoxViewColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 4;
		prefsColor.green = 7;
		prefsColor.blue = 38;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredMyCheckBoxViewColor(&prefsColor);
	if (	appsPreferenceSet.GetData(	"PreferredMyStatusBarHighColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 240;
		prefsColor.green = 230;
		prefsColor.blue = 0;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredMyStatusBarHighColor(&prefsColor);
	if (	appsPreferenceSet.GetData(	"PreferredMyStatusBarLowColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 200;
		prefsColor.green = 164;
		prefsColor.blue = 11;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredMyStatusBarLowColor(&prefsColor);
	if (	appsPreferenceSet.GetData(	"PreferredMyStatusBarViewColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 230;
		prefsColor.green = 120;
		prefsColor.blue = 44;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredMyStatusBarViewColor(&prefsColor);
	if (	appsPreferenceSet.GetData(	"PreferredMyBarColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 23;
		prefsColor.green = 12;
		prefsColor.blue = 164;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredMyBarColor(&prefsColor);
	if (	appsPreferenceSet.GetData(	"PreferredMyColorControlHighColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 212;
		prefsColor.green = 192;
		prefsColor.blue = 223;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredMyColorControlHighColor(&prefsColor);
	if (	appsPreferenceSet.GetData(	"PreferredMyColorControlLowColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 143;
		prefsColor.green = 243;
		prefsColor.blue = 43;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredMyColorControlLowColor(&prefsColor);
	if (	appsPreferenceSet.GetData(	"PreferredMyColorControlViewColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 192;
		prefsColor.green = 192;
		prefsColor.blue = 113;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredMyColorControlViewColor(&prefsColor);
	if (	appsPreferenceSet.GetData(	"PreferredMyStringDrawerHighColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 209;
		prefsColor.green = 23;
		prefsColor.blue = 209;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredMyStringDrawerHighColor(&prefsColor);
	if (	appsPreferenceSet.GetData(	"PreferredMyStringDrawerLowColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{

		prefsColor.red = 143;
		prefsColor.green = 0;
		prefsColor.blue = 145;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredMyStringDrawerLowColor(&prefsColor);
	if (	appsPreferenceSet.GetData(	"PreferredMyStringDrawerViewColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 143;
		prefsColor.green = 0;
		prefsColor.blue = 145;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredMyStringDrawerViewColor(&prefsColor);
	if (	appsPreferenceSet.GetData(	"PreferredMyRadioViewHighColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 0;
		prefsColor.green = 0;
		prefsColor.blue = 0;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredMyRadioViewHighColor(&prefsColor);
	if (	appsPreferenceSet.GetData(	"PreferredMyRadioViewLowColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{

		prefsColor.red = 0;
		prefsColor.green = 0;
		prefsColor.blue = 0;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredMyRadioViewLowColor(&prefsColor);
	if (	appsPreferenceSet.GetData(	"PreferredMyRadioViewViewColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 122;
		prefsColor.green = 23;
		prefsColor.blue = 110;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredMyRadioViewViewColor(&prefsColor);
	if (	appsPreferenceSet.GetData(	"PreferredMyTextViewHighColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{

		prefsColor.red = 250;
		prefsColor.green = 250;
		prefsColor.blue = 250;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredMyTextViewHighColor(&prefsColor);
	if (	appsPreferenceSet.GetData(	"PreferredMyTextViewLowColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{

		prefsColor.red = 25;
		prefsColor.green = 25;
		prefsColor.blue = 25;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredMyTextViewLowColor(&prefsColor);
	if (	appsPreferenceSet.GetData(	"PreferredMyTextViewViewColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 25;
		prefsColor.green = 25;
		prefsColor.blue = 25;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredMyTextViewViewColor(&prefsColor);
	if (	appsPreferenceSet.GetData(	"PreferredMyListViewHighColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{

		prefsColor.red = 0;
		prefsColor.green = 0;
		prefsColor.blue = 0;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredMyListViewHighColor(&prefsColor);
	if (	appsPreferenceSet.GetData(	"PreferredMyListViewLowColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{

		prefsColor.red = 240;
		prefsColor.green = 240;
		prefsColor.blue = 240;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredMyListViewLowColor(&prefsColor);
	if (	appsPreferenceSet.GetData(	"PreferredMyListViewViewColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 255;
		prefsColor.green = 255;
		prefsColor.blue = 255;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredMyListViewViewColor(&prefsColor);
	BRect	screenResolutionRect;
	{//I do screen like this so it goes away fast
		BScreen	screen(B_MAIN_SCREEN_ID);
		if(!screen.IsValid()) 
		{//may not be valid, if not, this is not a critical app--bail out as best we can
			puts(ScreenNotValid);
			exit(4);
		}
		screenResolutionRect = screen.Frame();
	}
	BRect windowPrefArea;
	const void * windowPrefAreaData;
	ssize_t windowPrefAreaSize;
	uint32 windowPrefAreaType = '    ';
	if (	appsPreferenceSet.GetData(	"PrefPanelFrame", 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		windowPrefArea.Set(	5,
							22, 
							screenResolutionRect.right - 17,
							screenResolutionRect.bottom - 37);
					//the - 17 and - 37 were determined based upon trial and error
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredPrefPanelWindowRect(windowPrefArea);
	if (	appsPreferenceSet.GetData(	"FontPrefFrame", 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		windowPrefArea.Set(	5,
							22, 
							screenResolutionRect.right - 17,
							screenResolutionRect.bottom - 37);
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredFontPrefWindowRect(windowPrefArea);
	if (	appsPreferenceSet.GetData(	"FontDisplayWindowFrame", 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		windowPrefArea.Set(	5,
							22, 
							screenResolutionRect.right - 17,
							screenResolutionRect.bottom - 37);
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredFontDisplayWindowRect(windowPrefArea);
	if (	appsPreferenceSet.GetData(	"BasicColorWindowFrame", 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		windowPrefArea.Set(	5,
							22, 
							screenResolutionRect.right - 17,
							screenResolutionRect.bottom - 37);
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredBasicColorWindowRect(windowPrefArea);
	if (	appsPreferenceSet.GetData(	lNamePrefFrame[SPECIFIC_COLOR_BUTTON], 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		windowPrefArea.Set(	5,
							22, 
							screenResolutionRect.right - 17,
							screenResolutionRect.bottom - 37);
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredSpecificColorButtonWindowRect(windowPrefArea);
	if (	appsPreferenceSet.GetData(	lNamePrefFrame[SPECIFIC_COLOR_PICTURE], 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		windowPrefArea.Set(	5,
							22, 
							screenResolutionRect.right - 17,
							screenResolutionRect.bottom - 37);
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredSpecificColorPictureButtonWindowRect(windowPrefArea);
	if (	appsPreferenceSet.GetData(	lNamePrefFrame[SPECIFIC_COLOR_RADIOVIEW], 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		windowPrefArea.Set(	5,
							22, 
							screenResolutionRect.right - 17,
							screenResolutionRect.bottom - 37);
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredSpecificColorRadioButtonWindowRect(windowPrefArea);
	if (	appsPreferenceSet.GetData(	lNamePrefFrame[SPECIFIC_COLOR_CHECKBOX], 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		windowPrefArea.Set(	5,
							22, 
							screenResolutionRect.right - 17,
							screenResolutionRect.bottom - 37);
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredSpecificColorCheckBoxWindowRect(windowPrefArea);
	if (	appsPreferenceSet.GetData(	lNamePrefFrame[SPECIFIC_COLOR_STATUSBAR], 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		windowPrefArea.Set(	5,
							22, 
							screenResolutionRect.right - 17,
							screenResolutionRect.bottom - 37);
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredSpecificColorStatusBarWindowRect(windowPrefArea);
	if (	appsPreferenceSet.GetData(	lNamePrefFrame[SPECIFIC_COLOR_COLORCONTROL], 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		windowPrefArea.Set(	5,
							22, 
							screenResolutionRect.right - 17,
							screenResolutionRect.bottom - 37);
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredSpecificColorColorControlWindowRect(windowPrefArea);
	if (	appsPreferenceSet.GetData(	lNamePrefFrame[SPECIFIC_COLOR_TEXTVIEW], 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		windowPrefArea.Set(	5,
							22, 
							screenResolutionRect.right - 17,
							screenResolutionRect.bottom - 37);
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredSpecificColorTextViewWindowRect(windowPrefArea);
	if (	appsPreferenceSet.GetData(	lNamePrefFrame[SPECIFIC_COLOR_LISTVIEW], 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		windowPrefArea.Set(	5,
							22, 
							screenResolutionRect.right - 17,
							screenResolutionRect.bottom - 37);
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredSpecificColorListViewWindowRect(windowPrefArea);
	if (	appsPreferenceSet.GetData(	lNamePrefFrame[SPECIFIC_COLOR_INTGADG], 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		windowPrefArea.Set(	5,
							22, 
							screenResolutionRect.right - 17,
							screenResolutionRect.bottom - 37);
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredSpecificColorUInt32GadgetWindowRect(windowPrefArea);
	if (	appsPreferenceSet.GetData(	lNamePrefFrame[SPECIFIC_COLOR_FLOATGADG], 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		windowPrefArea.Set(	5,
							22, 
							screenResolutionRect.right - 17,
							screenResolutionRect.bottom - 37);
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredSpecificColorFloatGadgetWindowRect(windowPrefArea);
	if (	appsPreferenceSet.GetData(	lNamePrefFrame[SPECIFIC_COLOR_STRINGGADG], 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		windowPrefArea.Set(	5,
							22, 
							screenResolutionRect.right - 17,
							screenResolutionRect.bottom - 37);
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredSpecificColorStringGadgetWindowRect(windowPrefArea);
	if (	appsPreferenceSet.GetData(	lNamePrefFrame[SPECIFIC_COLOR_COLORWELL], 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		windowPrefArea.Set(	5,
							22, 
							screenResolutionRect.right - 17,
							screenResolutionRect.bottom - 37);
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredSpecificColorColorWellWindowRect(windowPrefArea);
	if (	appsPreferenceSet.GetData(	lNamePrefFrame[SPECIFIC_COLOR_STRINGDRAWER], 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		windowPrefArea.Set(	5,
							22, 
							screenResolutionRect.right - 17,
							screenResolutionRect.bottom - 37);
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredSpecificColorStringDrawerWindowRect(windowPrefArea);
	if (	appsPreferenceSet.GetData(	"UInt32ReqWindowFrame", 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		windowPrefArea.Set(	5,
							22, 
							screenResolutionRect.right - 17,
							screenResolutionRect.bottom - 37);
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredUInt32ReqWindowRect(windowPrefArea);
	if (	appsPreferenceSet.GetData(	"ListViewWindowFrame", 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		windowPrefArea.Set(	5,
							22, 
							screenResolutionRect.right - 17,
							screenResolutionRect.bottom - 37);
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredListViewWindowRect(windowPrefArea);
}//end


MyPreferences	::	~MyPreferences() 
{
	Preferences appsPreferences(PrefSignature);
	PreferenceSet appsPreferenceSet(	appsPreferences,  
										"hierarchical/extendable/settings", 
										true);
	if (appsPreferences.InitCheck())
	{
		puts(PrefFailInit);
		exit(1);
	}
	if (appsPreferenceSet.InitCheck())
	{
		puts(PrefFailSetSettings);
		exit(2);
	}
	bool allSetsOK = true;
	rgb_color tempRgbColor;
	GetPreferredColorWellHighColor(&tempRgbColor);
	if (appsPreferenceSet.SetData(	"PreferredColorWellHighColor", 
									&tempRgbColor, 
									sizeof(tempRgbColor), 
									B_RGB_COLOR_TYPE))
	{
		warning(PrefsNoSetColorWellHighColor);
		allSetsOK = false;
	}
	if (allSetsOK) 
	{
		GetPreferredColorWellLowColor(&tempRgbColor);
		if (appsPreferenceSet.SetData(	"PreferredColorWellLowColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetolorWellLowColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredColorWellViewColor(&tempRgbColor);
		if (appsPreferenceSet.SetData(	"PreferredColorWellViewColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetColorWellViewColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredUInt32GadgetHighColor(&tempRgbColor);
		if (appsPreferenceSet.SetData(	"PreferredUInt32GadgetHighColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetUInt32GadgetHighColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredFloatGadgetHighColor(&tempRgbColor);
		if (appsPreferenceSet.SetData(	"PreferredFloatGadgetHighColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetFloatGadgetHighColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredMyButtonHighColor(&tempRgbColor);
		if (appsPreferenceSet.SetData(	"PreferredMyButtonHighColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetMyButtonHighColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredMyButtonLowColor(&tempRgbColor);
		if (appsPreferenceSet.SetData(	"PreferredMyButtonLowColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetMyButtonLowColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredMyButtonViewColor(&tempRgbColor);
		if (appsPreferenceSet.SetData(	"PreferredMyButtonViewColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetMyButtonViewColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredMyPictureButtonHighColor(&tempRgbColor);
		if (appsPreferenceSet.SetData(	"PreferredMyPictureButtonHighColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetMyPictureButtonHighColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredMyPictureButtonLowColor(&tempRgbColor);
		if (appsPreferenceSet.SetData(	"PreferredMyPictureButtonLowColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetMyPictureButtonLowColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredMyPictureButtonViewColor(&tempRgbColor);
		if (appsPreferenceSet.SetData(	"PreferredMyPictureButtonViewColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetMyPictureButtonViewColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredMyCheckBoxHighColor(&tempRgbColor);
		if (appsPreferenceSet.SetData(	"PreferredMyCheckBoxHighColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetMyCheckBoxHighColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredMyCheckBoxLowColor(&tempRgbColor);
		if (appsPreferenceSet.SetData(	"PreferredMyCheckBoxLowColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetMyCheckBoxLowColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredMyCheckBoxViewColor(&tempRgbColor);
		if (appsPreferenceSet.SetData(	"PreferredMyCheckBoxViewColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetMyCheckBoxViewColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredMyBarColor(&tempRgbColor);
		if (appsPreferenceSet.SetData(	"PreferredMyBarColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetMyBarColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredMyStatusBarHighColor(&tempRgbColor);
		if (appsPreferenceSet.SetData(	"PreferredMyStatusBarHighColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetMyStatusBarHighColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredMyStatusBarLowColor(&tempRgbColor);
		if (appsPreferenceSet.SetData(	"PreferredMyStatusBarLowColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetMyStatusBarLowColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredMyStatusBarViewColor(&tempRgbColor);
		if (appsPreferenceSet.SetData(	"PreferredMyStatusBarViewColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetMyStatusBarViewColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredMyColorControlHighColor(&tempRgbColor);
		if (appsPreferenceSet.SetData(	"PreferredMyColorControlHighColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetMyColorControlHighColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredMyColorControlLowColor(&tempRgbColor);
		if (appsPreferenceSet.SetData(	"PreferredMyColorControlLowColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetMyColorControlLowColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredMyColorControlViewColor(&tempRgbColor);
		if (appsPreferenceSet.SetData(	"PreferredMyColorControlViewColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetMyColorControlViewColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredMyStringDrawerHighColor(&tempRgbColor);
		if (appsPreferenceSet.SetData(	"PreferredMyStringDrawerHighColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetMyStringDrawerHighColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredMyStringDrawerLowColor(&tempRgbColor);
		if (appsPreferenceSet.SetData(	"PreferredMyStringDrawerLowColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetMyStringDrawerLowColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredMyStringDrawerViewColor(&tempRgbColor);
		if (appsPreferenceSet.SetData(	"PreferredMyStringDrawerViewColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetMyStringDrawerViewColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredMyRadioViewHighColor(&tempRgbColor);
		if (appsPreferenceSet.SetData(	"PreferredMyRadioViewHighColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetMyRadioViewHighColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredMyRadioViewLowColor(&tempRgbColor);
		if (appsPreferenceSet.SetData(	"PreferredMyRadioViewLowColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetMyRadioViewLowColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredMyRadioViewViewColor(&tempRgbColor);
		if (appsPreferenceSet.SetData(	"PreferredMyRadioViewViewColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetMyRadioViewViewColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredMyTextViewHighColor(&tempRgbColor);
		if (appsPreferenceSet.SetData(	"PreferredMyTextViewHighColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetMyTextViewHighColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredMyTextViewLowColor(&tempRgbColor);
		if (appsPreferenceSet.SetData(	"PreferredMyTextViewLowColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetMyTextViewLowColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredMyTextViewViewColor(&tempRgbColor);
		if (appsPreferenceSet.SetData(	"PreferredMyTextViewViewColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetMyTextViewViewColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredMyListViewHighColor(&tempRgbColor);
		if (appsPreferenceSet.SetData(	"PreferredMyListViewHighColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetMyListViewHighColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredMyListViewLowColor(&tempRgbColor);
		if (appsPreferenceSet.SetData(	"PreferredMyListViewLowColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetMyListViewLowColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredMyListViewViewColor(&tempRgbColor);
		if (appsPreferenceSet.SetData(	"PreferredMyListViewViewColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetMyListViewViewColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredUInt32GadgetLowColor(&tempRgbColor);
		if (appsPreferenceSet.SetData(	"PreferredUInt32GadgetLowColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetUInt32GadgetLowColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredUInt32GadgetViewColor(&tempRgbColor);
		if (appsPreferenceSet.SetData(	"PreferredUInt32GadgetViewColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetUInt32GadgetViewColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredFloatGadgetLowColor(&tempRgbColor);
		if (appsPreferenceSet.SetData(	"PreferredFloatGadgetLowColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetFloatGadgetLowColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredFloatGadgetViewColor(&tempRgbColor);
		if (appsPreferenceSet.SetData(	"PreferredFloatGadgetViewColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetFloatGadgetViewColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredHighColor(&tempRgbColor);
		if (appsPreferenceSet.SetData(	"PreferredHighColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetHighColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredLowColor(&tempRgbColor);
		if (appsPreferenceSet.SetData(	"PreferredLowColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetLowColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredViewColor(&tempRgbColor);
		if (appsPreferenceSet.SetData(	"PreferredViewColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetViewColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		FontData windowFontData(GetPreferredFont());
//		if (appsPreferenceSet.SetData(	"FONTDATAPREFERENCE_TYPE", 
//										&windowFontData, 
//										sizeof(windowFontData), 
//										FONTDATAPREFERENCE_TYPE))
//		{
//			warning(PrefsNoSetFont);
//			allSetsOK = false;
//		}
		if (appsPreferenceSet.SetData(	"FONTDATA_SIZE_TYPE", 
										&windowFontData.size, 
										sizeof(windowFontData.size), 
										FONTDATA_SIZE_TYPE))
		{
			warning(PrefsNoSetFont);
			allSetsOK = false;
		}
		if (allSetsOK) 
		{
			if (appsPreferenceSet.SetData(	"FONTDATA_SHEAR_TYPE", 
											&windowFontData.shear, 
											sizeof(windowFontData.shear), 
											FONTDATA_SHEAR_TYPE))
			{
				warning(PrefsNoSetFont);
				allSetsOK = false;
			}
		}
		if (allSetsOK) 
		{
			if (appsPreferenceSet.SetData(	"FONTDATA_ROTATION_TYPE", 
											&windowFontData.rotation, 
											sizeof(windowFontData.rotation), 
											FONTDATA_ROTATION_TYPE))
			{
				warning(PrefsNoSetFont);
				allSetsOK = false;
			}
		}
		if (allSetsOK) 
		{
			if (appsPreferenceSet.SetData(	"FONTDATA_FLAGS_TYPE", 
											&windowFontData.flags, 
											sizeof(windowFontData.flags), 
											FONTDATA_FLAGS_TYPE))
			{
				warning(PrefsNoSetFont);
				allSetsOK = false;
			}
		}
		if (allSetsOK) 
		{
			if (appsPreferenceSet.SetData(	"FONTDATA_FACE_TYPE", 
											&windowFontData.face, 
											sizeof(windowFontData.face), 
											FONTDATA_FACE_TYPE))
			{
				warning(PrefsNoSetFont);
				allSetsOK = false;
			}
		}
		if (allSetsOK) 
		{
			if (appsPreferenceSet.SetData(	"FONTDATA_SPACING_TYPE", 
											&windowFontData.spacing, 
											sizeof(windowFontData.spacing), 
											FONTDATA_SPACING_TYPE))
			{
				warning(PrefsNoSetFont);
				allSetsOK = false;
			}
		}
		if (allSetsOK) 
		{
			if (appsPreferenceSet.SetData(	"FONTDATA_ENOCDING_TYPE", 
											&windowFontData.encoding, 
											sizeof(windowFontData.encoding), 
											FONTDATA_ENOCDING_TYPE))
			{
				warning(PrefsNoSetFont);
				allSetsOK = false;
			}
		}
		if (allSetsOK) 
		{
			if (appsPreferenceSet.SetData(	"FONTDATA_FANDS_TYPE", 
											&windowFontData.familyAndStyle, 
											sizeof(windowFontData.familyAndStyle), 
											FONTDATA_FANDS_TYPE))
			{
				warning(PrefsNoSetFont);
				allSetsOK = false;
			}
		}
	}
	if (allSetsOK) 
	{
		if (appsPreferenceSet.SetData(	"OPENFONTDISPLAY_TYPE", 
										&bOpenFontDisplay, 
										sizeof(bOpenFontDisplay), 
										OPENFONTDISPLAY_TYPE))
		{
			warning(PrefsNoSetOpenFontDisplay);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		if (appsPreferenceSet.SetData(	"ANTIALIASFONT_TYPE", 
										&bAntiAliasFont, 
										sizeof(bAntiAliasFont), 
										ANTIALIASFONT_TYPE))
		{
			warning(PrefsNoSetAntiAliasFont);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		float barHeight = GetPreferredBarHeight();
		if (appsPreferenceSet.SetData(	"BARHEIGHT", 
										&barHeight, 
										sizeof(barHeight), 
										BARHEIGHT))
		{
			warning(PrefsNoSetBarHeight);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		if (appsPreferenceSet.SetData(	"USECOLORWELL", 
										&bUseColorWell, 
										sizeof(bUseColorWell), 
										USECOLORWELL))
		{
			warning(PrefsNoSetUseColorWell);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		if (appsPreferenceSet.SetData(	"USECOLORCONTROL", 
										&bUseColorControl, 
										sizeof(bUseColorControl), 
										USECOLORCONTROL))
		{
			warning(PrefsNoSetUseColorControl);
			allSetsOK = false;
		}
	}
	BRect frame;
	if (allSetsOK)
	{
		if (appsPreferenceSet.Save())
		{
			warning(PrefsNoSaveSet);
		}
	}
	if (allSetsOK)
	{
		if (appsPreferenceSet.Save())
		{
			warning(PrefsNoSaveSet);
		}
	}
	delete preferredFont;
	if (pPrefPanelWindow)
	{
		pPrefPanelWindow->PostMessage(B_QUIT_REQUESTED);
	}
	EmptyGlobalsFromResources();
}//end


BFont *	
MyPreferences	::	GetPreferredFont(		void) const
{
	return preferredFont;
}//end


void
MyPreferences	::	SetPreferredFont(		const BFont * pparamFont)
{
	*preferredFont = *pparamFont;
}//end


void
MyPreferences	::	SetToPreferredFont(		BFont * pparamFont)
{
	pparamFont->SetFamilyAndStyle(	preferredFont->FamilyAndStyle());
	pparamFont->SetSize(	preferredFont->Size());
	pparamFont->SetShear(	preferredFont->Shear());
	pparamFont->SetRotation(	preferredFont->Rotation());
	pparamFont->SetSpacing(	preferredFont->Spacing());
	pparamFont->SetEncoding(	preferredFont->Encoding());
	pparamFont->SetFace(	preferredFont->Face());
	pparamFont->SetFlags(	preferredFont->Flags());
	//?? pparamFont->Direction = preferredFont->Direction;
}//end


void
MyPreferences	::	SetPreferredFontFromData(	FontData * pparamFontData)
{
	preferredFont->SetFamilyAndStyle(pparamFontData->familyAndStyle);
	preferredFont->SetSize(pparamFontData->size);
	preferredFont->SetShear(pparamFontData->shear);
	preferredFont->SetRotation(pparamFontData->rotation);
	preferredFont->SetSpacing(pparamFontData->spacing);
	preferredFont->SetFace(pparamFontData->face);
	preferredFont->SetFlags(pparamFontData->flags);
}//end


void
MyPreferences	::	GetPreferredPrefPanelWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredPrefPanelWindowRect;
}//end


void
MyPreferences	::	SetPreferredPrefPanelWindowRect(	const BRect paramWindowRect)
{
	preferredPrefPanelWindowRect = paramWindowRect;
}//end


void
MyPreferences	::	GetPreferredFontPrefWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredFontPrefWindowRect;
}//end


void
MyPreferences	::	SetPreferredFontPrefWindowRect(	const BRect paramWindowRect)
{
	preferredFontPrefWindowRect = paramWindowRect;
}//end


void
MyPreferences	::	GetPreferredFontDisplayWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredFontDisplayWindowRect;
}//end


void
MyPreferences	::	SetPreferredFontDisplayWindowRect(	const BRect paramWindowRect)
{
	preferredFontDisplayWindowRect = paramWindowRect;
}//end


void
MyPreferences	::	GetPreferredBasicColorWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredBasicColorWindowRect;
}//end


void
MyPreferences	::	SetPreferredBasicColorWindowRect(	const BRect paramWindowRect)
{
	preferredBasicColorWindowRect = paramWindowRect;
}//end


void
MyPreferences	::	GetPreferredSpecificColorButtonWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredSpecificColorButtonWindowRect;
}//end


void
MyPreferences	::	SetPreferredSpecificColorButtonWindowRect(	const BRect paramWindowRect)
{
	preferredSpecificColorButtonWindowRect = paramWindowRect;
}//end


void
MyPreferences	::	GetPreferredSpecificColorPictureButtonWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredSpecificColorPictureButtonWindowRect;
}//end


void
MyPreferences	::	SetPreferredSpecificColorPictureButtonWindowRect(	const BRect paramWindowRect)
{
	preferredSpecificColorPictureButtonWindowRect = paramWindowRect;
}//end


void
MyPreferences	::	GetPreferredSpecificColorRadioButtonWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredSpecificColorRadioButtonWindowRect;
}//end


void
MyPreferences	::	SetPreferredSpecificColorRadioButtonWindowRect(	const BRect paramWindowRect)
{
	preferredSpecificColorRadioButtonWindowRect = paramWindowRect;
}//end


void
MyPreferences	::	GetPreferredSpecificColorCheckBoxWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredSpecificColorCheckBoxWindowRect;
}//end


void
MyPreferences	::	SetPreferredSpecificColorCheckBoxWindowRect(	const BRect paramWindowRect)
{
	preferredSpecificColorCheckBoxWindowRect = paramWindowRect;
}//end


void
MyPreferences	::	GetPreferredSpecificColorStringDrawerWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredSpecificColorStringDrawerWindowRect;
}//end


void
MyPreferences	::	SetPreferredSpecificColorStringDrawerWindowRect(	const BRect paramWindowRect)
{
	preferredSpecificColorStringDrawerWindowRect = paramWindowRect;
}//end


void
MyPreferences	::	GetPreferredUInt32ReqWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredUInt32ReqWindowRect;
}//end


void
MyPreferences	::	SetPreferredUInt32ReqWindowRect(	const BRect paramWindowRect)
{
	preferredUInt32ReqWindowRect = paramWindowRect;
}//end


void
MyPreferences	::	GetPreferredListViewWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredListViewWindowRect;
}//end


void
MyPreferences	::	SetPreferredListViewWindowRect(	const BRect paramWindowRect)
{
	preferredListViewWindowRect = paramWindowRect;
}//end


void
MyPreferences	::	GetPreferredSpecificColorStatusBarWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredSpecificColorStatusBarWindowRect;
}//end


void
MyPreferences	::	SetPreferredSpecificColorStatusBarWindowRect(	const BRect paramWindowRect)
{
	preferredSpecificColorStatusBarWindowRect = paramWindowRect;
}//end


void
MyPreferences	::	GetPreferredSpecificColorColorControlWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredSpecificColorColorControlWindowRect;
}//end


void
MyPreferences	::	SetPreferredSpecificColorColorControlWindowRect(	const BRect paramWindowRect)
{
	preferredSpecificColorColorControlWindowRect = paramWindowRect;
}//end


void
MyPreferences	::	GetPreferredSpecificColorTextViewWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredSpecificColorTextViewWindowRect;
}//end


void
MyPreferences	::	SetPreferredSpecificColorTextViewWindowRect(	const BRect paramWindowRect)
{
	preferredSpecificColorTextViewWindowRect = paramWindowRect;
}//end


void
MyPreferences	::	GetPreferredSpecificColorListViewWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredSpecificColorListViewWindowRect;
}//end


void
MyPreferences	::	SetPreferredSpecificColorListViewWindowRect(	const BRect paramWindowRect)
{
	preferredSpecificColorListViewWindowRect = paramWindowRect;
}//end


void
MyPreferences	::	GetPreferredSpecificColorUInt32GadgetWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredSpecificColorUInt32GadgetWindowRect;
}//end


void
MyPreferences	::	SetPreferredSpecificColorUInt32GadgetWindowRect(	const BRect paramWindowRect)
{
	preferredSpecificColorUInt32GadgetWindowRect = paramWindowRect;
}//end


void
MyPreferences	::	GetPreferredSpecificColorFloatGadgetWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredSpecificColorFloatGadgetWindowRect;
}//end


void
MyPreferences	::	SetPreferredSpecificColorFloatGadgetWindowRect(	const BRect paramWindowRect)
{
	preferredSpecificColorFloatGadgetWindowRect = paramWindowRect;
}//end



void
MyPreferences	::	GetPreferredSpecificColorStringGadgetWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredSpecificColorStringGadgetWindowRect;
}//end


void
MyPreferences	::	SetPreferredSpecificColorStringGadgetWindowRect(	const BRect paramWindowRect)
{
	preferredSpecificColorStringGadgetWindowRect = paramWindowRect;
}//end


void
MyPreferences	::	GetPreferredSpecificColorColorWellWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredSpecificColorColorWellWindowRect;
}//end


void
MyPreferences	::	SetPreferredSpecificColorColorWellWindowRect(	const BRect paramWindowRect)
{
	preferredSpecificColorColorWellWindowRect = paramWindowRect;
}//end


void
MyPreferences	::	GetPreferredHighColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredHighColor.red;
	pparamRGBColor->green = preferredHighColor.green;
	pparamRGBColor->blue = preferredHighColor.blue;
	pparamRGBColor->alpha = preferredHighColor.alpha;
}//end


void
MyPreferences	::	SetPreferredHighColor(	const rgb_color * pparamRGBColor)
{
	preferredHighColor.red = pparamRGBColor->red;
	preferredHighColor.green = pparamRGBColor->green;
	preferredHighColor.blue = pparamRGBColor->blue;
	preferredHighColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredLowColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredLowColor.red;
	pparamRGBColor->green = preferredLowColor.green;
	pparamRGBColor->blue = preferredLowColor.blue;
	pparamRGBColor->alpha = preferredLowColor.alpha;
}//end


void
MyPreferences	::	SetPreferredLowColor(	const rgb_color * pparamRGBColor)
{
	preferredLowColor.red = pparamRGBColor->red;
	preferredLowColor.green = pparamRGBColor->green;
	preferredLowColor.blue = pparamRGBColor->blue;
	preferredLowColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredViewColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredViewColor.red;
	pparamRGBColor->green = preferredViewColor.green;
	pparamRGBColor->blue = preferredViewColor.blue;
	pparamRGBColor->alpha = preferredViewColor.alpha;
}//end


void
MyPreferences	::	SetPreferredViewColor(	const rgb_color * pparamRGBColor)
{
	preferredViewColor.red = pparamRGBColor->red;
	preferredViewColor.green = pparamRGBColor->green;
	preferredViewColor.blue = pparamRGBColor->blue;
	preferredViewColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredUInt32GadgetHighColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredUInt32GadgetHighColor.red;
	pparamRGBColor->green = preferredUInt32GadgetHighColor.green;
	pparamRGBColor->blue = preferredUInt32GadgetHighColor.blue;
	pparamRGBColor->alpha = preferredUInt32GadgetHighColor.alpha;
}//end


void
MyPreferences	::	SetPreferredUInt32GadgetHighColor(	const rgb_color * pparamRGBColor)
{
	preferredUInt32GadgetHighColor.red = pparamRGBColor->red;
	preferredUInt32GadgetHighColor.green = pparamRGBColor->green;
	preferredUInt32GadgetHighColor.blue = pparamRGBColor->blue;
	preferredUInt32GadgetHighColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredUInt32GadgetLowColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredUInt32GadgetLowColor.red;
	pparamRGBColor->green = preferredUInt32GadgetLowColor.green;
	pparamRGBColor->blue = preferredUInt32GadgetLowColor.blue;
	pparamRGBColor->alpha = preferredUInt32GadgetLowColor.alpha;
}//end


void
MyPreferences	::	SetPreferredUInt32GadgetLowColor(	const rgb_color * pparamRGBColor)
{
	preferredUInt32GadgetLowColor.red = pparamRGBColor->red;
	preferredUInt32GadgetLowColor.green = pparamRGBColor->green;
	preferredUInt32GadgetLowColor.blue = pparamRGBColor->blue;
	preferredUInt32GadgetLowColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredUInt32GadgetViewColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredUInt32GadgetViewColor.red;
	pparamRGBColor->green = preferredUInt32GadgetViewColor.green;
	pparamRGBColor->blue = preferredUInt32GadgetViewColor.blue;
	pparamRGBColor->alpha = preferredUInt32GadgetViewColor.alpha;
}//end


void
MyPreferences	::	SetPreferredUInt32GadgetViewColor(	const rgb_color * pparamRGBColor)
{
	preferredUInt32GadgetViewColor.red = pparamRGBColor->red;
	preferredUInt32GadgetViewColor.green = pparamRGBColor->green;
	preferredUInt32GadgetViewColor.blue = pparamRGBColor->blue;
	preferredUInt32GadgetViewColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredFloatGadgetHighColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredFloatGadgetHighColor.red;
	pparamRGBColor->green = preferredFloatGadgetHighColor.green;
	pparamRGBColor->blue = preferredFloatGadgetHighColor.blue;
	pparamRGBColor->alpha = preferredFloatGadgetHighColor.alpha;
}//end


void
MyPreferences	::	SetPreferredFloatGadgetHighColor(	const rgb_color * pparamRGBColor)
{
	preferredFloatGadgetHighColor.red = pparamRGBColor->red;
	preferredFloatGadgetHighColor.green = pparamRGBColor->green;
	preferredFloatGadgetHighColor.blue = pparamRGBColor->blue;
	preferredFloatGadgetHighColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredFloatGadgetLowColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredFloatGadgetLowColor.red;
	pparamRGBColor->green = preferredFloatGadgetLowColor.green;
	pparamRGBColor->blue = preferredFloatGadgetLowColor.blue;
	pparamRGBColor->alpha = preferredFloatGadgetLowColor.alpha;
}//end


void
MyPreferences	::	SetPreferredFloatGadgetLowColor(	const rgb_color * pparamRGBColor)
{
	preferredFloatGadgetLowColor.red = pparamRGBColor->red;
	preferredFloatGadgetLowColor.green = pparamRGBColor->green;
	preferredFloatGadgetLowColor.blue = pparamRGBColor->blue;
	preferredFloatGadgetLowColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredFloatGadgetViewColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredFloatGadgetViewColor.red;
	pparamRGBColor->green = preferredFloatGadgetViewColor.green;
	pparamRGBColor->blue = preferredFloatGadgetViewColor.blue;
	pparamRGBColor->alpha = preferredFloatGadgetViewColor.alpha;
}//end


void
MyPreferences	::	SetPreferredFloatGadgetViewColor(	const rgb_color * pparamRGBColor)
{
	preferredFloatGadgetViewColor.red = pparamRGBColor->red;
	preferredFloatGadgetViewColor.green = pparamRGBColor->green;
	preferredFloatGadgetViewColor.blue = pparamRGBColor->blue;
	preferredFloatGadgetViewColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredMyCheckBoxHighColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredMyCheckBoxHighColor.red;
	pparamRGBColor->green = preferredMyCheckBoxHighColor.green;
	pparamRGBColor->blue = preferredMyCheckBoxHighColor.blue;
	pparamRGBColor->alpha = preferredMyCheckBoxHighColor.alpha;
}//end


void
MyPreferences	::	SetPreferredMyCheckBoxHighColor(	const rgb_color * pparamRGBColor)
{
	preferredMyCheckBoxHighColor.red = pparamRGBColor->red;
	preferredMyCheckBoxHighColor.green = pparamRGBColor->green;
	preferredMyCheckBoxHighColor.blue = pparamRGBColor->blue;
	preferredMyCheckBoxHighColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredMyCheckBoxLowColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredMyCheckBoxLowColor.red;
	pparamRGBColor->green = preferredMyCheckBoxLowColor.green;
	pparamRGBColor->blue = preferredMyCheckBoxLowColor.blue;
	pparamRGBColor->alpha = preferredMyCheckBoxLowColor.alpha;
}//end


void
MyPreferences	::	SetPreferredMyCheckBoxLowColor(	const rgb_color * pparamRGBColor)
{
	preferredMyCheckBoxLowColor.red = pparamRGBColor->red;
	preferredMyCheckBoxLowColor.green = pparamRGBColor->green;
	preferredMyCheckBoxLowColor.blue = pparamRGBColor->blue;
	preferredMyCheckBoxLowColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredMyCheckBoxViewColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredMyCheckBoxViewColor.red;
	pparamRGBColor->green = preferredMyCheckBoxViewColor.green;
	pparamRGBColor->blue = preferredMyCheckBoxViewColor.blue;
	pparamRGBColor->alpha = preferredMyCheckBoxViewColor.alpha;
}//end


void
MyPreferences	::	SetPreferredMyCheckBoxViewColor(	const rgb_color * pparamRGBColor)
{
	preferredMyCheckBoxViewColor.red = pparamRGBColor->red;
	preferredMyCheckBoxViewColor.green = pparamRGBColor->green;
	preferredMyCheckBoxViewColor.blue = pparamRGBColor->blue;
	preferredMyCheckBoxViewColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredMyPictureButtonHighColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredMyPictureButtonHighColor.red;
	pparamRGBColor->green = preferredMyPictureButtonHighColor.green;
	pparamRGBColor->blue = preferredMyPictureButtonHighColor.blue;
	pparamRGBColor->alpha = preferredMyPictureButtonHighColor.alpha;
}//end


void
MyPreferences	::	SetPreferredMyPictureButtonHighColor(	const rgb_color * pparamRGBColor)
{
	preferredMyPictureButtonHighColor.red = pparamRGBColor->red;
	preferredMyPictureButtonHighColor.green = pparamRGBColor->green;
	preferredMyPictureButtonHighColor.blue = pparamRGBColor->blue;
	preferredMyPictureButtonHighColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredMyPictureButtonLowColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredMyPictureButtonLowColor.red;
	pparamRGBColor->green = preferredMyPictureButtonLowColor.green;
	pparamRGBColor->blue = preferredMyPictureButtonLowColor.blue;
	pparamRGBColor->alpha = preferredMyPictureButtonLowColor.alpha;
}//end


void
MyPreferences	::	SetPreferredMyPictureButtonLowColor(	const rgb_color * pparamRGBColor)
{
	preferredMyPictureButtonLowColor.red = pparamRGBColor->red;
	preferredMyPictureButtonLowColor.green = pparamRGBColor->green;
	preferredMyPictureButtonLowColor.blue = pparamRGBColor->blue;
	preferredMyPictureButtonLowColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredMyPictureButtonViewColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredMyPictureButtonViewColor.red;
	pparamRGBColor->green = preferredMyPictureButtonViewColor.green;
	pparamRGBColor->blue = preferredMyPictureButtonViewColor.blue;
	pparamRGBColor->alpha = preferredMyPictureButtonViewColor.alpha;
}//end


void
MyPreferences	::	SetPreferredMyPictureButtonViewColor(	const rgb_color * pparamRGBColor)
{
	preferredMyPictureButtonViewColor.red = pparamRGBColor->red;
	preferredMyPictureButtonViewColor.green = pparamRGBColor->green;
	preferredMyPictureButtonViewColor.blue = pparamRGBColor->blue;
	preferredMyPictureButtonViewColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredMyStatusBarHighColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredMyStatusBarHighColor.red;
	pparamRGBColor->green = preferredMyStatusBarHighColor.green;
	pparamRGBColor->blue = preferredMyStatusBarHighColor.blue;
	pparamRGBColor->alpha = preferredMyStatusBarHighColor.alpha;
}//end


void
MyPreferences	::	SetPreferredMyStatusBarHighColor(	const rgb_color * pparamRGBColor)
{
	preferredMyStatusBarHighColor.red = pparamRGBColor->red;
	preferredMyStatusBarHighColor.green = pparamRGBColor->green;
	preferredMyStatusBarHighColor.blue = pparamRGBColor->blue;
	preferredMyStatusBarHighColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredMyStatusBarLowColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredMyStatusBarLowColor.red;
	pparamRGBColor->green = preferredMyStatusBarLowColor.green;
	pparamRGBColor->blue = preferredMyStatusBarLowColor.blue;
	pparamRGBColor->alpha = preferredMyStatusBarLowColor.alpha;
}//end


void
MyPreferences	::	SetPreferredMyStatusBarLowColor(	const rgb_color * pparamRGBColor)
{
	preferredMyStatusBarLowColor.red = pparamRGBColor->red;
	preferredMyStatusBarLowColor.green = pparamRGBColor->green;
	preferredMyStatusBarLowColor.blue = pparamRGBColor->blue;
	preferredMyStatusBarLowColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredMyStatusBarViewColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredMyStatusBarViewColor.red;
	pparamRGBColor->green = preferredMyStatusBarViewColor.green;
	pparamRGBColor->blue = preferredMyStatusBarViewColor.blue;
	pparamRGBColor->alpha = preferredMyStatusBarViewColor.alpha;
}//end


void
MyPreferences	::	SetPreferredMyStatusBarViewColor(	const rgb_color * pparamRGBColor)
{
	preferredMyStatusBarViewColor.red = pparamRGBColor->red;
	preferredMyStatusBarViewColor.green = pparamRGBColor->green;
	preferredMyStatusBarViewColor.blue = pparamRGBColor->blue;
	preferredMyStatusBarViewColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredMyBarColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredMyBarColor.red;
	pparamRGBColor->green = preferredMyBarColor.green;
	pparamRGBColor->blue = preferredMyBarColor.blue;
	pparamRGBColor->alpha = preferredMyBarColor.alpha;
}//end


void
MyPreferences	::	SetPreferredMyBarColor(	const rgb_color * pparamRGBColor)
{
	preferredMyBarColor.red = pparamRGBColor->red;
	preferredMyBarColor.green = pparamRGBColor->green;
	preferredMyBarColor.blue = pparamRGBColor->blue;
	preferredMyBarColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredMyColorControlHighColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredMyColorControlHighColor.red;
	pparamRGBColor->green = preferredMyColorControlHighColor.green;
	pparamRGBColor->blue = preferredMyColorControlHighColor.blue;
	pparamRGBColor->alpha = preferredMyColorControlHighColor.alpha;
}//end


void
MyPreferences	::	SetPreferredMyColorControlHighColor(	const rgb_color * pparamRGBColor)
{
	preferredMyColorControlHighColor.red = pparamRGBColor->red;
	preferredMyColorControlHighColor.green = pparamRGBColor->green;
	preferredMyColorControlHighColor.blue = pparamRGBColor->blue;
	preferredMyColorControlHighColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredMyColorControlLowColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredMyColorControlLowColor.red;
	pparamRGBColor->green = preferredMyColorControlLowColor.green;
	pparamRGBColor->blue = preferredMyColorControlLowColor.blue;
	pparamRGBColor->alpha = preferredMyColorControlLowColor.alpha;
}//end


void
MyPreferences	::	SetPreferredMyColorControlLowColor(	const rgb_color * pparamRGBColor)
{
	preferredMyColorControlLowColor.red = pparamRGBColor->red;
	preferredMyColorControlLowColor.green = pparamRGBColor->green;
	preferredMyColorControlLowColor.blue = pparamRGBColor->blue;
	preferredMyColorControlLowColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredMyColorControlViewColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredMyColorControlViewColor.red;
	pparamRGBColor->green = preferredMyColorControlViewColor.green;
	pparamRGBColor->blue = preferredMyColorControlViewColor.blue;
	pparamRGBColor->alpha = preferredMyColorControlViewColor.alpha;
}//end


void
MyPreferences	::	SetPreferredMyColorControlViewColor(	const rgb_color * pparamRGBColor)
{
	preferredMyColorControlViewColor.red = pparamRGBColor->red;
	preferredMyColorControlViewColor.green = pparamRGBColor->green;
	preferredMyColorControlViewColor.blue = pparamRGBColor->blue;
	preferredMyColorControlViewColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredColorWellHighColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredColorWellHighColor.red;
	pparamRGBColor->green = preferredColorWellHighColor.green;
	pparamRGBColor->blue = preferredColorWellHighColor.blue;
	pparamRGBColor->alpha = preferredColorWellHighColor.alpha;
}//end


void
MyPreferences	::	SetPreferredColorWellHighColor(	const rgb_color * pparamRGBColor)
{
	preferredColorWellHighColor.red = pparamRGBColor->red;
	preferredColorWellHighColor.green = pparamRGBColor->green;
	preferredColorWellHighColor.blue = pparamRGBColor->blue;
	preferredColorWellHighColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredColorWellLowColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredColorWellLowColor.red;
	pparamRGBColor->green = preferredColorWellLowColor.green;
	pparamRGBColor->blue = preferredColorWellLowColor.blue;
	pparamRGBColor->alpha = preferredColorWellLowColor.alpha;
}//end


void
MyPreferences	::	SetPreferredColorWellLowColor(	const rgb_color * pparamRGBColor)
{
	preferredColorWellLowColor.red = pparamRGBColor->red;
	preferredColorWellLowColor.green = pparamRGBColor->green;
	preferredColorWellLowColor.blue = pparamRGBColor->blue;
	preferredColorWellLowColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredColorWellViewColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredColorWellViewColor.red;
	pparamRGBColor->green = preferredColorWellViewColor.green;
	pparamRGBColor->blue = preferredColorWellViewColor.blue;
	pparamRGBColor->alpha = preferredColorWellViewColor.alpha;
}//end


void
MyPreferences	::	SetPreferredColorWellViewColor(	const rgb_color * pparamRGBColor)
{
	preferredColorWellViewColor.red = pparamRGBColor->red;
	preferredColorWellViewColor.green = pparamRGBColor->green;
	preferredColorWellViewColor.blue = pparamRGBColor->blue;
	preferredColorWellViewColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredMyButtonHighColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredMyButtonHighColor.red;
	pparamRGBColor->green = preferredMyButtonHighColor.green;
	pparamRGBColor->blue = preferredMyButtonHighColor.blue;
	pparamRGBColor->alpha = preferredMyButtonHighColor.alpha;
}//end


void
MyPreferences	::	SetPreferredMyButtonHighColor(	const rgb_color * pparamRGBColor)
{
	preferredMyButtonHighColor.red = pparamRGBColor->red;
	preferredMyButtonHighColor.green = pparamRGBColor->green;
	preferredMyButtonHighColor.blue = pparamRGBColor->blue;
	preferredMyButtonHighColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredMyButtonLowColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredMyButtonLowColor.red;
	pparamRGBColor->green = preferredMyButtonLowColor.green;
	pparamRGBColor->blue = preferredMyButtonLowColor.blue;
	pparamRGBColor->alpha = preferredMyButtonLowColor.alpha;
}//end


void
MyPreferences	::	SetPreferredMyButtonLowColor(	const rgb_color * pparamRGBColor)
{
	preferredMyButtonLowColor.red = pparamRGBColor->red;
	preferredMyButtonLowColor.green = pparamRGBColor->green;
	preferredMyButtonLowColor.blue = pparamRGBColor->blue;
	preferredMyButtonLowColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredMyButtonViewColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredMyButtonViewColor.red;
	pparamRGBColor->green = preferredMyButtonViewColor.green;
	pparamRGBColor->blue = preferredMyButtonViewColor.blue;
	pparamRGBColor->alpha = preferredMyButtonViewColor.alpha;
}//end


void
MyPreferences	::	SetPreferredMyButtonViewColor(	const rgb_color * pparamRGBColor)
{
	preferredMyButtonViewColor.red = pparamRGBColor->red;
	preferredMyButtonViewColor.green = pparamRGBColor->green;
	preferredMyButtonViewColor.blue = pparamRGBColor->blue;
	preferredMyButtonViewColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredMyStringDrawerHighColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredMyStringDrawerHighColor.red;
	pparamRGBColor->green = preferredMyStringDrawerHighColor.green;
	pparamRGBColor->blue = preferredMyStringDrawerHighColor.blue;
	pparamRGBColor->alpha = preferredMyStringDrawerHighColor.alpha;
}//end


void
MyPreferences	::	SetPreferredMyStringDrawerHighColor(	const rgb_color * pparamRGBColor)
{
	preferredMyStringDrawerHighColor.red = pparamRGBColor->red;
	preferredMyStringDrawerHighColor.green = pparamRGBColor->green;
	preferredMyStringDrawerHighColor.blue = pparamRGBColor->blue;
	preferredMyStringDrawerHighColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredMyStringDrawerLowColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredMyStringDrawerLowColor.red;
	pparamRGBColor->green = preferredMyStringDrawerLowColor.green;
	pparamRGBColor->blue = preferredMyStringDrawerLowColor.blue;
	pparamRGBColor->alpha = preferredMyStringDrawerLowColor.alpha;
}//end


void
MyPreferences	::	SetPreferredMyStringDrawerLowColor(	const rgb_color * pparamRGBColor)
{
	preferredMyStringDrawerLowColor.red = pparamRGBColor->red;
	preferredMyStringDrawerLowColor.green = pparamRGBColor->green;
	preferredMyStringDrawerLowColor.blue = pparamRGBColor->blue;
	preferredMyStringDrawerLowColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredMyStringDrawerViewColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredMyStringDrawerViewColor.red;
	pparamRGBColor->green = preferredMyStringDrawerViewColor.green;
	pparamRGBColor->blue = preferredMyStringDrawerViewColor.blue;
	pparamRGBColor->alpha = preferredMyStringDrawerViewColor.alpha;
}//end


void
MyPreferences	::	SetPreferredMyStringDrawerViewColor(	const rgb_color * pparamRGBColor)
{
	preferredMyStringDrawerViewColor.red = pparamRGBColor->red;
	preferredMyStringDrawerViewColor.green = pparamRGBColor->green;
	preferredMyStringDrawerViewColor.blue = pparamRGBColor->blue;
	preferredMyStringDrawerViewColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredStringGadgetHighColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredStringGadgetHighColor.red;
	pparamRGBColor->green = preferredStringGadgetHighColor.green;
	pparamRGBColor->blue = preferredStringGadgetHighColor.blue;
	pparamRGBColor->alpha = preferredStringGadgetHighColor.alpha;
}//end


void
MyPreferences	::	SetPreferredStringGadgetHighColor(	const rgb_color * pparamRGBColor)
{
	preferredStringGadgetHighColor.red = pparamRGBColor->red;
	preferredStringGadgetHighColor.green = pparamRGBColor->green;
	preferredStringGadgetHighColor.blue = pparamRGBColor->blue;
	preferredStringGadgetHighColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredStringGadgetLowColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredStringGadgetLowColor.red;
	pparamRGBColor->green = preferredStringGadgetLowColor.green;
	pparamRGBColor->blue = preferredStringGadgetLowColor.blue;
	pparamRGBColor->alpha = preferredStringGadgetLowColor.alpha;
}//end


void
MyPreferences	::	SetPreferredStringGadgetLowColor(	const rgb_color * pparamRGBColor)
{
	preferredStringGadgetLowColor.red = pparamRGBColor->red;
	preferredStringGadgetLowColor.green = pparamRGBColor->green;
	preferredStringGadgetLowColor.blue = pparamRGBColor->blue;
	preferredStringGadgetLowColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredStringGadgetViewColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredStringGadgetViewColor.red;
	pparamRGBColor->green = preferredStringGadgetViewColor.green;
	pparamRGBColor->blue = preferredStringGadgetViewColor.blue;
	pparamRGBColor->alpha = preferredStringGadgetViewColor.alpha;
}//end


void
MyPreferences	::	SetPreferredStringGadgetViewColor(	const rgb_color * pparamRGBColor)
{
	preferredStringGadgetViewColor.red = pparamRGBColor->red;
	preferredStringGadgetViewColor.green = pparamRGBColor->green;
	preferredStringGadgetViewColor.blue = pparamRGBColor->blue;
	preferredStringGadgetViewColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredMyRadioViewHighColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredMyRadioViewHighColor.red;
	pparamRGBColor->green = preferredMyRadioViewHighColor.green;
	pparamRGBColor->blue = preferredMyRadioViewHighColor.blue;
	pparamRGBColor->alpha = preferredMyRadioViewHighColor.alpha;
}//end


void
MyPreferences	::	SetPreferredMyRadioViewHighColor(	const rgb_color * pparamRGBColor)
{
	preferredMyRadioViewHighColor.red = pparamRGBColor->red;
	preferredMyRadioViewHighColor.green = pparamRGBColor->green;
	preferredMyRadioViewHighColor.blue = pparamRGBColor->blue;
	preferredMyRadioViewHighColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredMyRadioViewLowColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredMyRadioViewLowColor.red;
	pparamRGBColor->green = preferredMyRadioViewLowColor.green;
	pparamRGBColor->blue = preferredMyRadioViewLowColor.blue;
	pparamRGBColor->alpha = preferredMyRadioViewLowColor.alpha;
}//end


void
MyPreferences	::	SetPreferredMyRadioViewLowColor(	const rgb_color * pparamRGBColor)
{
	preferredMyRadioViewLowColor.red = pparamRGBColor->red;
	preferredMyRadioViewLowColor.green = pparamRGBColor->green;
	preferredMyRadioViewLowColor.blue = pparamRGBColor->blue;
	preferredMyRadioViewLowColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredMyRadioViewViewColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredMyRadioViewViewColor.red;
	pparamRGBColor->green = preferredMyRadioViewViewColor.green;
	pparamRGBColor->blue = preferredMyRadioViewViewColor.blue;
	pparamRGBColor->alpha = preferredMyRadioViewViewColor.alpha;
}//end


void
MyPreferences	::	SetPreferredMyRadioViewViewColor(	const rgb_color * pparamRGBColor)
{
	preferredMyRadioViewViewColor.red = pparamRGBColor->red;
	preferredMyRadioViewViewColor.green = pparamRGBColor->green;
	preferredMyRadioViewViewColor.blue = pparamRGBColor->blue;
	preferredMyRadioViewViewColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredMyTextViewHighColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredMyTextViewHighColor.red;
	pparamRGBColor->green = preferredMyTextViewHighColor.green;
	pparamRGBColor->blue = preferredMyTextViewHighColor.blue;
	pparamRGBColor->alpha = preferredMyTextViewHighColor.alpha;
}//end


void
MyPreferences	::	SetPreferredMyTextViewHighColor(	const rgb_color * pparamRGBColor)
{
	preferredMyTextViewHighColor.red = pparamRGBColor->red;
	preferredMyTextViewHighColor.green = pparamRGBColor->green;
	preferredMyTextViewHighColor.blue = pparamRGBColor->blue;
	preferredMyTextViewHighColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	SetPreferredMyTextViewLowColor(	const rgb_color * pparamRGBColor)
{
	preferredMyTextViewLowColor.red = pparamRGBColor->red;
	preferredMyTextViewLowColor.green = pparamRGBColor->green;
	preferredMyTextViewLowColor.blue = pparamRGBColor->blue;
	preferredMyTextViewLowColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredMyTextViewLowColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredMyTextViewLowColor.red;
	pparamRGBColor->green = preferredMyTextViewLowColor.green;
	pparamRGBColor->blue = preferredMyTextViewLowColor.blue;
	pparamRGBColor->alpha = preferredMyTextViewLowColor.alpha;
}//end


void
MyPreferences	::	GetPreferredMyTextViewViewColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredMyTextViewViewColor.red;
	pparamRGBColor->green = preferredMyTextViewViewColor.green;
	pparamRGBColor->blue = preferredMyTextViewViewColor.blue;
	pparamRGBColor->alpha = preferredMyTextViewViewColor.alpha;
}//end


void
MyPreferences	::	SetPreferredMyTextViewViewColor(	const rgb_color * pparamRGBColor)
{
	preferredMyTextViewViewColor.red = pparamRGBColor->red;
	preferredMyTextViewViewColor.green = pparamRGBColor->green;
	preferredMyTextViewViewColor.blue = pparamRGBColor->blue;
	preferredMyTextViewViewColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredMyListViewHighColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredMyListViewHighColor.red;
	pparamRGBColor->green = preferredMyListViewHighColor.green;
	pparamRGBColor->blue = preferredMyListViewHighColor.blue;
	pparamRGBColor->alpha = preferredMyListViewHighColor.alpha;
}//end


void
MyPreferences	::	SetPreferredMyListViewHighColor(	const rgb_color * pparamRGBColor)
{
	preferredMyListViewHighColor.red = pparamRGBColor->red;
	preferredMyListViewHighColor.green = pparamRGBColor->green;
	preferredMyListViewHighColor.blue = pparamRGBColor->blue;
	preferredMyListViewHighColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	SetPreferredMyListViewLowColor(	const rgb_color * pparamRGBColor)
{
	preferredMyListViewLowColor.red = pparamRGBColor->red;
	preferredMyListViewLowColor.green = pparamRGBColor->green;
	preferredMyListViewLowColor.blue = pparamRGBColor->blue;
	preferredMyListViewLowColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredMyListViewLowColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredMyListViewLowColor.red;
	pparamRGBColor->green = preferredMyListViewLowColor.green;
	pparamRGBColor->blue = preferredMyListViewLowColor.blue;
	pparamRGBColor->alpha = preferredMyListViewLowColor.alpha;
}//end



void
MyPreferences	::	GetPreferredMyListViewViewColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredMyListViewViewColor.red;
	pparamRGBColor->green = preferredMyListViewViewColor.green;
	pparamRGBColor->blue = preferredMyListViewViewColor.blue;
	pparamRGBColor->alpha = preferredMyListViewViewColor.alpha;
}//end


void
MyPreferences	::	SetPreferredMyListViewViewColor(	const rgb_color * pparamRGBColor)
{
	preferredMyListViewViewColor.red = pparamRGBColor->red;
	preferredMyListViewViewColor.green = pparamRGBColor->green;
	preferredMyListViewViewColor.blue = pparamRGBColor->blue;
	preferredMyListViewViewColor.alpha = pparamRGBColor->alpha;
}//end



float
MyPreferences	::	GetPreferredBarHeight(	void) const
{
	return preferredBarHeight;
}//end

void
MyPreferences	::	SetPreferredBarHeight(	const float fparamBarHeight)
{
	preferredBarHeight = fparamBarHeight;
}//end


void
MyPreferences		::	  OpenPreferencesPanel(	void)
{
	if (pPrefPanelWindow)
	{
		pPrefPanelWindow->Activate(true);
	}
	else
	{
		try 
		{
			BRect holdRect;
			GetPreferredPrefPanelWindowRect(&holdRect);
			pPrefPanelWindow = new PrefPanelWindow(	holdRect,
													PreferencePanelWindowTitle,
													"PrefPanel",
													"PrefPanelFrame");
			pPrefPanelWindow->Initialize();
		}
		catch (...) 
		{
			warning(NoPrefPanelWindow);
			throw;
		}
	}
}//end

