//methods for class Doable

#include "themAll.h"
#include "Xwarning.h"
#include "Xunique.h"
#include "dobj.h"
#include "def.h"
#include "error.h"
#include "mergeHow.h"
#include "mergeNode.h"
#include "mergeList.h"
#include "Xthings.h"
#include "mergeListAll.h"
#include "dataNode.h"
#include "dataList.h"
#include "XuIntPtrNode.h"
#include "uIntPtrNode.h"
#include "ptrList.h"
#include "mPtrNode.h"
#include "XdoableButtons.h"
#include "doableButtons.h"
#include "Xdoable.h"
#include "doable.h"

Doable	::	Doable() 
{
	elementPrimal = new PtrList(ELEMENT_TYPE);
	if (!elementPrimal) warning(FailPtrList);
	compoundPrimal = new PtrList(COMPOUND_TYPE);
	if (!compoundPrimal) warning(FailPtrList);
	elementManufactured = new PtrList(ELEMENT_TYPE);
	if (!elementManufactured) warning(FailPtrList);
	compoundManufactured = new PtrList(COMPOUND_TYPE);
	if (!compoundManufactured) warning(FailPtrList);
	mineManufactured = new PtrList(MINE_TYPE);
	if (!mineManufactured) warning(FailPtrList);
	factoryManufactured = new PtrList(FACTORY_TYPE);
	if (!factoryManufactured) warning(FailPtrList);
	engineManufactured = new PtrList(ENGINE_TYPE);
	if (!engineManufactured) warning(FailPtrList);
	shipManufactured = new PtrList(SHIP_TYPE);
	if (!shipManufactured) warning(FailPtrList);
	shipShieldManufactured = new PtrList(SHIPSHIELD_TYPE);
	if (!shipShieldManufactured) warning(FailPtrList);
	shipWeaponManufactured = new PtrList(SHIPWEAPON_TYPE);
	if (!shipWeaponManufactured) warning(FailPtrList);
	planetShieldManufactured = new PtrList(PLANETSHIELD_TYPE);
	if (!planetShieldManufactured) warning(FailPtrList);
	planetWeaponManufactured = new PtrList(PLANETWEAPON_TYPE);
	if (!planetWeaponManufactured) warning(FailPtrList);
}//end


Doable	::	~Doable() 
{
	if (elementPrimal) 
	{
		delete elementPrimal;
	}
	if (compoundPrimal) 
	{
		delete compoundPrimal;
	}
	if (elementManufactured) delete elementManufactured;
	if (compoundManufactured) delete compoundManufactured;
	if (mineManufactured) delete mineManufactured;
	if (factoryManufactured) delete factoryManufactured;
	if (engineManufactured) delete engineManufactured;
	if (shipManufactured) delete shipManufactured;
	if (shipShieldManufactured) delete shipShieldManufactured;
	if (shipWeaponManufactured) delete shipWeaponManufactured;
	if (planetShieldManufactured) delete planetShieldManufactured;
	if (planetWeaponManufactured) delete planetWeaponManufactured;
}//end


void Doable	::	EmptyList() 
{
	elementPrimal->EmptyList();
	compoundPrimal->EmptyList();
	elementManufactured->EmptyList();
	compoundManufactured->EmptyList();
	mineManufactured->EmptyList();
	factoryManufactured->EmptyList();
	engineManufactured->EmptyList();
	shipManufactured->EmptyList();
	shipShieldManufactured->EmptyList();
	shipWeaponManufactured->EmptyList();
	planetShieldManufactured->EmptyList();
	planetWeaponManufactured->EmptyList();
}//end


bool 
Doable	::	Copy(	Doable * fromDoable) 
{
	if (!elementPrimal->Copy(fromDoable->elementPrimal))
	{
		return false;
	}
	if (!compoundPrimal->Copy(fromDoable->compoundPrimal))
	{
		return false;
	}
	if (!elementManufactured->Copy(fromDoable->elementManufactured))
	{
		return false;
	}
	if (!compoundManufactured->Copy(fromDoable->compoundManufactured))
	{
		return false;
	}
	if (!mineManufactured->Copy(fromDoable->mineManufactured))
	{
		return false;
	}
	if (!factoryManufactured->Copy(fromDoable->factoryManufactured))
	{
		return false;
	}
	if (!engineManufactured->Copy(fromDoable->engineManufactured))
	{
		return false;
	}
	if (!shipManufactured->Copy(fromDoable->shipManufactured))
	{
		return false;
	}
	if (!shipShieldManufactured->Copy(fromDoable->shipShieldManufactured))
	{
		return false;
	}
	if (!shipWeaponManufactured->Copy(fromDoable->shipWeaponManufactured))
	{
		return false;
	}
	if (!planetShieldManufactured->Copy(fromDoable->planetShieldManufactured))
	{
		return false;
	}
	if (!planetWeaponManufactured->Copy(fromDoable->planetWeaponManufactured))
	{
		return false;
	}
	return true;
}//end


bool Doable	::	SaveEm(BFile * file, PtrList * list, int32 kind) 
{
	DataList * dlg = dataListGlobal[kind];
	int32 realItemNumber;
	void * realItemFromName;
	void * pnode;
	UIntPtrNode * cpn;
	int32 len;
	int32 items = list->CountItems();
	len = sizeof(items);
	if (!(file->Write(&items, len) == len)) return false;
	for (	int32 i = 0;
			#pragma warn_possunwant off
			pnode = list->list->ItemAt(i);
			#pragma warn_possunwant reset
			i++) 
	{
		cpn = (UIntPtrNode *)pnode;
		realItemFromName = dlg->RealItemFromName(cpn->MyName(kind), &realItemNumber);
		if (!realItemFromName) 
		{
			warning(notOnDataList);
			return false;
		}
		len = sizeof(realItemNumber);
		if (!(file->Write(&realItemNumber, sizeof(len)) == sizeof(len))) return false;
		len = sizeof(cpn->number);
		if (!(file->Write(&cpn->number, len) == len)) return false;
	}
	return true;
}//end


bool Doable	::	DoableSave(BFile * file) 
{
	if (!SaveEm(file, elementPrimal, ELEMENT_TYPE)) return false;
	if (!SaveEm(file, compoundPrimal, COMPOUND_TYPE)) return false;
	if (!SaveEm(file, elementManufactured, ELEMENT_TYPE)) return false;
	if (!SaveEm(file, compoundManufactured, COMPOUND_TYPE)) return false;
	if (!SaveEm(file, mineManufactured, MINE_TYPE)) return false;
	if (!SaveEm(file, factoryManufactured, FACTORY_TYPE)) return false;
	if (!SaveEm(file, engineManufactured, ENGINE_TYPE)) return false;
	if (!SaveEm(file, shipManufactured, SHIP_TYPE)) return false;
	if (!SaveEm(file, shipShieldManufactured, SHIPSHIELD_TYPE)) return false;
	if (!SaveEm(file, shipWeaponManufactured, SHIPWEAPON_TYPE)) return false;
	if (!SaveEm(file, planetShieldManufactured, PLANETSHIELD_TYPE)) return false;
	if (!SaveEm(file, planetWeaponManufactured, PLANETWEAPON_TYPE)) return false;
	return true;
}//end


bool Doable	::	LoadEm(BFile * file, PtrList * list, int32 kind) 
{
	int32 items = 0;
	int32 realItemNumber;
	int32 number;
	int32 len = sizeof(items);
	if (file->Read(&items, len) == len) 
	{
		for (	int32 i = 0;
				i < items;
				i++) 
		{
			//len = sizeof(realItemNumber);
			if (file->Read(&realItemNumber, len) == len) 
			{
				//len = sizeof(number);
				if (file->Read(&number, len) == len) 
				{
					MPtrNode * mPtrNode = new MPtrNode(realItemNumber, number, MERGEDNOT);
					if (!mPtrNode) 
					{
						warning(FailMPtrNode);
						return false;
					}
					list->AddItem(mPtrNode);
				}
				else {
					warning(badFileLength);
					return false;
				}
			}
			else {
				warning(badFileLength);
				return false;
			}
		}
	}
	else {
		warning(badFileLength);
		return false;
	}
	return true;
}//end


bool Doable	::	DoableLoad(BFile * file) 
{
	if (!LoadEm(file, elementPrimal, ELEMENT_TYPE)) return false;
	if (!LoadEm(file, compoundPrimal, COMPOUND_TYPE)) return false;
	if (!LoadEm(file, elementManufactured, ELEMENT_TYPE)) return false;
	if (!LoadEm(file, compoundManufactured, COMPOUND_TYPE)) return false;
	if (!LoadEm(file, mineManufactured, MINE_TYPE)) return false;
	if (!LoadEm(file, factoryManufactured, FACTORY_TYPE)) return false;
	if (!LoadEm(file, engineManufactured, ENGINE_TYPE)) return false;
	if (!LoadEm(file, shipManufactured, SHIP_TYPE)) return false;
	if (!LoadEm(file, shipShieldManufactured, SHIPSHIELD_TYPE)) return false;
	if (!LoadEm(file, shipWeaponManufactured, SHIPWEAPON_TYPE)) return false;
	if (!LoadEm(file, planetShieldManufactured, PLANETSHIELD_TYPE)) return false;
	if (!LoadEm(file, planetWeaponManufactured, PLANETWEAPON_TYPE)) return false;
	return true;
}//end


bool Doable	::	FixPtrs(MergeListAll * mListAll) 
{
	int32 listNum = elementPrimal->list->CountItems();
	for (	int32 j = 0;
			j < listNum;
			j++) 
	{
		MPtrNode * mPtrNode = (MPtrNode *)elementPrimal->list->ItemAt(j);
		UIntPtrNode * uIntPtrNode = new UIntPtrNode(mPtrNode->FindData(dataListGlobal[ELEMENT_TYPE], mListAll->mergeList[ELEMENT_TYPE]), mPtrNode->number);
		if (!uIntPtrNode) 
		{
			warning(FailUIntPtrNode);
			return false;
		}
		elementPrimal->list->RemoveItem(j);
		elementPrimal->list->AddItem(uIntPtrNode, j);
		delete mPtrNode;
	}
	listNum = compoundPrimal->list->CountItems();
	for (	int32 j = 0;
			j < listNum;
			j++) 
	{
		MPtrNode * mPtrNode = (MPtrNode *)compoundPrimal->list->ItemAt(j);
		UIntPtrNode * uIntPtrNode = new UIntPtrNode(mPtrNode->FindData(dataListGlobal[COMPOUND_TYPE], mListAll->mergeList[COMPOUND_TYPE]), mPtrNode->number);
		if (!uIntPtrNode) 
		{
			warning(FailUIntPtrNode);
			return false;
		}
		compoundPrimal->list->RemoveItem(j);
		compoundPrimal->list->AddItem(uIntPtrNode, j);
		delete mPtrNode;
	}
	listNum = elementManufactured->list->CountItems();
	for (	int32 j = 0;
			j < listNum;
			j++) 
	{
		MPtrNode * mPtrNode = (MPtrNode *)elementManufactured->list->ItemAt(j);
		UIntPtrNode * uIntPtrNode = new UIntPtrNode(mPtrNode->FindData(dataListGlobal[ELEMENT_TYPE], mListAll->mergeList[ELEMENT_TYPE]), mPtrNode->number);
		if (!uIntPtrNode) 
		{
			warning(FailUIntPtrNode);
			return false;
		}
		elementManufactured->list->RemoveItem(j);
		elementManufactured->list->AddItem(uIntPtrNode, j);
		delete mPtrNode;
	}
	listNum = compoundManufactured->list->CountItems();
	for (	int32 j = 0;
			j < listNum;
			j++) 
	{
		MPtrNode * mPtrNode = (MPtrNode *)compoundManufactured->list->ItemAt(j);
		UIntPtrNode * uIntPtrNode = new UIntPtrNode(mPtrNode->FindData(dataListGlobal[COMPOUND_TYPE], mListAll->mergeList[COMPOUND_TYPE]), mPtrNode->number);
		if (!uIntPtrNode) 
		{
			warning(FailUIntPtrNode);
			return false;
		}
		compoundManufactured->list->RemoveItem(j);
		compoundManufactured->list->AddItem(uIntPtrNode, j);
		delete mPtrNode;
	}
	listNum = mineManufactured->list->CountItems();
	for (	int32 j = 0;
			j < listNum;
			j++) 
	{
		MPtrNode * mPtrNode = (MPtrNode *)mineManufactured->list->ItemAt(j);
		UIntPtrNode * uIntPtrNode = new UIntPtrNode(mPtrNode->FindData(dataListGlobal[MINE_TYPE], mListAll->mergeList[MINE_TYPE]), mPtrNode->number);
		if (!uIntPtrNode) 
		{
			warning(FailUIntPtrNode);
			return false;
		}
		mineManufactured->list->RemoveItem(j);
		mineManufactured->list->AddItem(uIntPtrNode, j);
		delete mPtrNode;
	}
	listNum = factoryManufactured->list->CountItems();
	for (	int32 j = 0;
			j < listNum;
			j++) 
	{
		MPtrNode * mPtrNode = (MPtrNode *)factoryManufactured->list->ItemAt(j);
		UIntPtrNode * uIntPtrNode = new UIntPtrNode(mPtrNode->FindData(dataListGlobal[FACTORY_TYPE], mListAll->mergeList[FACTORY_TYPE]), mPtrNode->number);
		if (!uIntPtrNode) 
		{
			warning(FailUIntPtrNode);
			return false;
		}
		factoryManufactured->list->RemoveItem(j);
		factoryManufactured->list->AddItem(uIntPtrNode, j);
		delete mPtrNode;
	}
	listNum = engineManufactured->list->CountItems();
	for (	int32 j = 0;
			j < listNum;
			j++) 
	{
		MPtrNode * mPtrNode = (MPtrNode *)engineManufactured->list->ItemAt(j);
		UIntPtrNode * uIntPtrNode = new UIntPtrNode(mPtrNode->FindData(dataListGlobal[ENGINE_TYPE], mListAll->mergeList[ENGINE_TYPE]), mPtrNode->number);
		if (!uIntPtrNode) 
		{
			warning(FailUIntPtrNode);
			return false;
		}
		engineManufactured->list->RemoveItem(j);
		engineManufactured->list->AddItem(uIntPtrNode, j);
		delete mPtrNode;
	}
	listNum = shipManufactured->list->CountItems();
	for (	int32 j = 0;
			j < listNum;
			j++) 
	{
		MPtrNode * mPtrNode = (MPtrNode *)shipManufactured->list->ItemAt(j);
		UIntPtrNode * uIntPtrNode = new UIntPtrNode(mPtrNode->FindData(dataListGlobal[SHIP_TYPE], mListAll->mergeList[SHIP_TYPE]), mPtrNode->number);
		if (!uIntPtrNode) 
		{
			warning(FailUIntPtrNode);
			return false;
		}
		shipManufactured->list->RemoveItem(j);
		shipManufactured->list->AddItem(uIntPtrNode, j);
		delete mPtrNode;
	}
	listNum = shipShieldManufactured->list->CountItems();
	for (	int32 j = 0;
			j < listNum;
			j++) 
	{
		MPtrNode * mPtrNode = (MPtrNode *)shipShieldManufactured->list->ItemAt(j);
		UIntPtrNode * uIntPtrNode = new UIntPtrNode(mPtrNode->FindData(dataListGlobal[SHIPSHIELD_TYPE], mListAll->mergeList[SHIPSHIELD_TYPE]), mPtrNode->number);
		if (!uIntPtrNode) 
		{
			warning(FailUIntPtrNode);
			return false;
		}
		shipShieldManufactured->list->RemoveItem(j);
		shipShieldManufactured->list->AddItem(uIntPtrNode, j);
		delete mPtrNode;
	}
	listNum = shipWeaponManufactured->list->CountItems();
	for (	int32 j = 0;
			j < listNum;
			j++) 
	{
		MPtrNode * mPtrNode = (MPtrNode *)shipWeaponManufactured->list->ItemAt(j);
		UIntPtrNode * uIntPtrNode = new UIntPtrNode(mPtrNode->FindData(dataListGlobal[SHIPWEAPON_TYPE], mListAll->mergeList[SHIPWEAPON_TYPE]), mPtrNode->number);
		if (!uIntPtrNode) 
		{
			warning(FailUIntPtrNode);
			return false;
		}
		shipWeaponManufactured->list->RemoveItem(j);
		shipWeaponManufactured->list->AddItem(uIntPtrNode, j);
		delete mPtrNode;
	}
	listNum = planetShieldManufactured->list->CountItems();
	for (	int32 j = 0;
			j < listNum;
			j++) 
	{
		MPtrNode * mPtrNode = (MPtrNode *)planetShieldManufactured->list->ItemAt(j);
		UIntPtrNode * uIntPtrNode = new UIntPtrNode(mPtrNode->FindData(dataListGlobal[PLANETSHIELD_TYPE], mListAll->mergeList[PLANETSHIELD_TYPE]), mPtrNode->number);
		if (!uIntPtrNode) 
		{
			warning(FailUIntPtrNode);
			return false;
		}
		planetShieldManufactured->list->RemoveItem(j);
		planetShieldManufactured->list->AddItem(uIntPtrNode, j);
		delete mPtrNode;
	}
	listNum = planetWeaponManufactured->list->CountItems();
	for (	int32 j = 0;
			j < listNum;
			j++) 
	{
		MPtrNode * mPtrNode = (MPtrNode *)planetWeaponManufactured->list->ItemAt(j);
		UIntPtrNode * uIntPtrNode = new UIntPtrNode(mPtrNode->FindData(dataListGlobal[PLANETWEAPON_TYPE], mListAll->mergeList[PLANETWEAPON_TYPE]), mPtrNode->number);
		if (!uIntPtrNode) 
		{
			warning(FailUIntPtrNode);
			return false;
		}
		planetWeaponManufactured->list->RemoveItem(j);
		planetWeaponManufactured->list->AddItem(uIntPtrNode, j);
		delete mPtrNode;
	}
	return true;
}//end
