//ptrList.cpp

#include "def.h"
#include "Xwarning.h"
#include "XuIntPtrNode.h"
#include "uIntPtrNode.h"
#include "XptrList.h"
#include "ptrList.h"

PtrList	::	PtrList(int32 k) 
{
	list = new BList(LIST_BLOCK_SIZE);
	if (!list) warning(FailMemory);
	kind = k;
}//end


PtrList	::	~PtrList() 
{
	void * pnode = list->ItemAt(0);
	if (pnode) 
	{
		do {
			list->RemoveItem(pnode);
			delete (UIntPtrNode *)pnode;
		} while 
		#pragma warn_possunwant off
		(pnode = list->ItemAt(0));
		#pragma warn_possunwant reset
	}
	delete list;
	list = NULL;
}//end


void PtrList	::	EmptyList(void) 
{
	void * pnode = list->ItemAt(0);
	if (pnode) 
	{
		do {
			list->RemoveItem(pnode);
			delete (UIntPtrNode *)pnode;
		} while 
		#pragma warn_possunwant off
		(pnode = list->ItemAt(0));
		#pragma warn_possunwant reset
	}
}//end


bool PtrList	::	AddItem(void *item) 
{
	int32 at = list->IndexOf(list->LastItem());
	return(list->AddItem(item, ++at));
}//end


int32 PtrList	::	Has(const char * name) 
{
	UIntPtrNode * uIntPtrNode;
	for (	int32 i = 0;
			#pragma warn_possunwant off
			uIntPtrNode = (UIntPtrNode *)list->ItemAt(i);
			#pragma warn_possunwant reset
			i++) 
	{
		if (!strcmp(uIntPtrNode->MyName(kind), name)) 
		{
			return uIntPtrNode->number;
		}
	}
	return 0;
}//end


bool 
PtrList	::	Copy(	PtrList * fromList) 
{
	EmptyList();
	UIntPtrNode * newUIntPtrNode;
	UIntPtrNode * uIntPtrNode;
	for (	int32 i = 0;
			#pragma warn_possunwant off
			uIntPtrNode = (UIntPtrNode *)fromList->list->ItemAt(i);
			#pragma warn_possunwant reset
			i++) 
	{
		newUIntPtrNode = new UIntPtrNode(uIntPtrNode);
		if (newUIntPtrNode) 
		{
			AddItem(newUIntPtrNode);
		}
		else {
			warning(FailUIntPtrNode);
			uIntPtrNode = NULL;
			return false;
		}
	}
	return true;
}//end
