//uInt32ReqWindow.cpp

#include "DmenuMsg.h"
#include "windowGuts.h"
#include "uInt32Gadget.h"
#include "XuIntPtrNode.h"
#include "uIntPtrNode.h"
#include "Xs2uint32.h"
#include "Xwarning.h"
#include "Xthings.h"
#include "masterList.h"
#include "XuInt32ReqWindow.h"
#include "uInt32ReqWindow.h"
#include "DlayoutMatrix.h"
#include "XlayoutMatrixItem.h"
#include "layoutMatrixItem.h"
#include "layoutMatrix.h"
#include "myPreferences.h"
#include "myApp.h"
#include <memory>
#include "Xverify.h"

UInt32ReqWindow	::	UInt32ReqWindow(	BRect paramBound,
									const char * paramWindowTitle,
									const char * paramScrollViewName,
									const char * paramNamePrefFrame, 
									UIntPtrNode * pparamUIntPtrNode,
									const char * paramGadgetLable,
									WindowGuts * pparamOwnerWindow)
				: 
					WindowGuts(	paramBound, 
								paramWindowTitle, 
								paramScrollViewName,
								paramNamePrefFrame),
					mpUIntPtrNode(pparamUIntPtrNode),
					mpOwnerWindow(pparamOwnerWindow),
					mpUInt32Gadget(NULL)
{
	SetFeel(B_FLOATING_SUBSET_WINDOW_FEEL);
	SetFeel(B_FLOATING_SUBSET_WINDOW_FEEL);
	AddToSubset(mpOwnerWindow);
	sem_id calc_sem;
	if ((calc_sem = create_sem(1, "calc_sem")) < B_NO_ERROR)
	{
		warning(FailCreateSemaphore);
		return;
	}
	acquire_sem(calc_sem);
	try 
	{
		LayoutMatrix *	pLayoutMatrix = new LayoutMatrix(BESTSIZE, 1, 1, this);//rows,columns
////////////////////////////////////////////////////////////////////////////////////////////
		mpUInt32Gadget = new UInt32Gadget(	mpUIntPtrNode->number,
										"uInt32Gadget", 
										paramGadgetLable, 
										UINT32GADGETMSG, 
										B_FOLLOW_NONE, 
										B_WILL_DRAW | B_NAVIGABLE,
										0,
										pLayoutMatrix);
		auto_ptr<LayoutMatrixItem> apLayoutMatrixItem(new LayoutMatrixItem(	(void *)mpUInt32Gadget, 
																			pLayoutMatrix->itemsList,
																			KIND_INTGADG));
		release_sem(calc_sem);
		pLayoutMatrix->Calc(MATRIXHORIZONTALOFFSET, MATRIXVERTICALOFFSET, calc_sem);
	}	
	catch (...)
	{
		warning(CaughtUInt32ReqWindowCTOR);
		release_sem(calc_sem);
		throw;
	}
	try 
	{
		BMenuItem *	menuItem;
		BMenu * APPMenu = new BMenu(AppMenuLable);
		menuItem = new BMenuItem(	AboutMenuLable, 
									new BMessage(ABOUT_INTREQWINDOW));
		APPMenu->AddItem(menuItem);
		menuItem = new BMenuItem(	PreferenceMenuLable, 
									new BMessage(PREFSMSG));
		APPMenu->AddItem(menuItem);
		menuItem = new BMenuItem(	CloseWindow, 
									new BMessage(B_QUIT_REQUESTED));
		APPMenu->AddItem(menuItem);
		menuItem = new BMenuItem(	QuitMenuLable, 
									new BMessage(QUIT_APP));
		APPMenu->AddItem(menuItem);
		pMenuBar->AddItem(APPMenu);
	}
	catch(...) 
	{
		warning(CaughtUInt32ReqWindowCTOR);
		throw;
	}
}//end


void 
UInt32ReqWindow	::	MessageReceived(	BMessage *message) 
{
	switch (message->what) 
	{
		case ABOUT_INTREQWINDOW:
			warning(AboutUInt32ReqWindow);
		break;
		case PREFSMSG:
			myPrefs->OpenPreferencesPanel();
		break;
		case QUIT_APP:
			if (Verify(ReallyQuitApp))
			{
				myApp->PostMessage(B_QUIT_REQUESTED);
			}
		break;
		default:
			WindowGuts::MessageReceived(message);
		break;
	}
}//end


UInt32ReqWindow	::	~UInt32ReqWindow() 
{
	BRect frame = Frame();
	myPrefs->SetPreferredUInt32ReqWindowRect(frame);
	if (mpUInt32Gadget) 
	{
		int32 i = s2uint32(mpUInt32Gadget->Text());
		if (S2UIERR == err) 
		{
			warning(IRWerr);
		}
		else {
			mpUIntPtrNode->number = i;
		}
		mpUInt32Gadget->RemoveSelf();
		delete mpUInt32Gadget;
	}
}//end
