//unique.cpp

#include "Dstar.h"
#include "Xthings.h"
#include "themAll.h"
#include "Xunique.h"
#include "Xwarning.h"
#include "Xunique.h"
#include "unique.h"
#include "dobj.h"
#include "def.h"
#include "error.h"
#include "mergeHow.h"
#include "mergeNode.h"
#include "mergeList.h"
#include "dataNode.h"
#include "dataList.h"
#include "XuIntPtrNode.h"
#include "uIntPtrNode.h"
#include "ptrList.h"
#include "mPtrNode.h"

bool UniqueName(DataList * list, const char * name) 
{
	err = NO_ERR;
	if (list->list->IsEmpty()) 
	{
		return true;
	}
	switch (list->kind) 
	{
		case UNIVERSALCONSTANTS_TYPE:
			if (universalConstantsCurrent) 
			{
				if (!strcmp(name, universalConstantsCurrent->name)) return false;
			}
			else return true;
		break;
		case UNIVERSE_TYPE:
			if (universeCurrent) 
			{
				if (!strcmp(name, universeCurrent->name)) return true;
			}
			else return true;
		break;
		case SPECIES_TYPE:
			if (speciesCurrent) 
			{
				if (!strcmp(name, speciesCurrent->name)) return true;
			}
			else return true;
		break;
		case GALAXY_TYPE:
			if (galaxyCurrent) 
			{
				if (!strcmp(name, galaxyCurrent->name)) return true;
			}
			else return true;
		break;
		case WORMHOLE_TYPE:
			if (wormholeCurrent) 
			{
				if (!strcmp(name, wormholeCurrent->name)) return true;
			}
			else return true;
		break;
		case BLACKHOLE_TYPE:
			if (blackholeCurrent) 
			{
				if (!strcmp(name, blackholeCurrent->name)) return true;
			}
			else return true;
		break;
		case STAR_TYPE:
			if (starCurrent) 
			{
				if (!strcmp(name, starCurrent->name)) return true;
			}
			else return true;
		break;
		case SHIP_TYPE:
			if (shipCurrent) 
			{
				if (!strcmp(name, shipCurrent->name)) return true;
			}
			else return true;
		break;
		case ENGINE_TYPE:
			if (engineCurrent) 
			{
				if (!strcmp(name, engineCurrent->name)) return true;
			}
			else return true;
		break;
		case SHIPWEAPON_TYPE:
			if (shipWeaponCurrent) 
			{
				if (!strcmp(name, shipWeaponCurrent->name)) return true;
			}
			else return true;
		break;
		case SHIPSHIELD_TYPE:
			if (shipShieldCurrent) 
			{
				if (!strcmp(name, shipShieldCurrent->name)) return true;
			}
			else return true;
		break;
		case PLANET_TYPE:
			if (planetCurrent) 
			{
				if (!strcmp(name, planetCurrent->name)) return true;
			}
			else return true;
		break;
		case PLANETWEAPON_TYPE:
			if (planetWeaponCurrent) 
			{
				if (!strcmp(name, planetWeaponCurrent->name)) return true;
			}
			else return true;
		break;
		case PLANETSHIELD_TYPE:
			if (planetShieldCurrent) 
			{
				if (!strcmp(name, planetShieldCurrent->name)) return true;
			}
			else return true;
		break;
		case FACTORY_TYPE:
			if (factoryCurrent) 
			{
				if (!strcmp(name, factoryCurrent->name)) return true;
			}
			else return true;
		break;
		case MINE_TYPE:
			if (mineCurrent) 
			{
				if (!strcmp(name, mineCurrent->name)) return true;
			}
			else return true;
		break;
		case COMPOUND_TYPE:
			if (compoundCurrent) 
			{
				if (!strcmp(name, compoundCurrent->name)) return true;
			}
			else return true;
		break;
		case ELEMENT_TYPE:
			if (elementCurrent) 
			{
				if (!strcmp(name, elementCurrent->name)) return true;
			}
			else return true;
		break;
		default:
			warning(FailNameUniqueDefault);
			return false;
		break;
	}
	DataNode * node;
	for (	int32 i = 0;
			#pragma warn_possunwant off
			node = (DataNode *)list->list->ItemAt(i);
			#pragma warn_possunwant reset
			i++) 
	{
		if (!strcmp(node->MyName(list->kind), name)) 
		{
			warning(FailNameUnique[list->kind]);
			err = NO_NAME;
			return false;
		}
	}
	return true;
}//end
