//methods for the Galaxy class

#include "constants.h"
#include "Xwarning.h"
#include "Xunique.h"
#include "dobj.h"
#include "def.h"
#include "error.h"
#include "mergeHow.h"
#include "mergeNode.h"
#include "mergeList.h"
#include "XdataNode.h"
#include "XdataList.h"
#include "dataNode.h"
#include "dataList.h"
#include "universalConstants.h"
#include "XuIntPtrNode.h"
#include "uIntPtrNode.h"
#include "ptrList.h"
#include "mPtrNode.h"
#include "doable.h"
#include "galaxy.h"

Galaxy	::	Galaxy() 
{
	err = NO_ERR;
}//end


Galaxy	::	Galaxy(Galaxy * fromItem, const char * n) 
{
	err = NO_ERR;
	name = (char *)malloc(strlen(n) + 1);
	if (name) 
	{
		DataNode * node = new DataNode(this);
		if (node) 
		{
			strcpy(name, n);
			width = fromItem->width;
			height = fromItem->height;
			depth = fromItem->depth;
			if (!Unique()) 
			{
				err = CREATEDNOTADDED;
				return;
			}
			if (dataListGlobal[GALAXY_TYPE]->AddItem(node)) 
			{
				galaxyCurrent = this;
				err = CREATED;
				return;
			}
			err = NO_ADDITEM;
		}
		err = NO_DATANODE;
	}
	err = NO_NAME;
}//end


Galaxy	::	Galaxy(Galaxy * fromItem, MergeList * list) 
{
	err = NO_ERR;
	name = (char *)malloc(strlen(fromItem->name) + 1);
	if (name) 
	{
		MergeNode * node = new MergeNode(this, MERGEDNOT);
		if (node) 
		{
			strcpy(name, fromItem->name);
			width = fromItem->width;
			height = fromItem->height;
			depth = fromItem->depth;
			if (list->AddItem(node)) 
			{
				node->placedAt = list->list->IndexOf(list->list->LastItem());
				err = CREATED;
				return;
			}
			err = NO_ADDITEM;
		}
		err = NO_DATANODE;
	}
	err = NO_NAME;
}//end


Galaxy	::	~Galaxy() 
{
	//left blank
}//end


bool Galaxy	::	Unique() 
{
	DataNode * node;
	err = NO_UNIQUE;
	for (	int32 i = 0;
			#pragma warn_possunwant off
			node = (DataNode * )dataListGlobal[GALAXY_TYPE]->list->ItemAt(i);
			#pragma warn_possunwant reset
			i++) 
	{
		if (!strcmp(name, node->MyName(GALAXY_TYPE))) 
		{
			warning(FailCreate[GALAXY_TYPE]);
			warning(FailCreateName);
			return false;
		}
	}
	err = NO_ERR;
	return true;
}//end


bool Galaxy	::	Save(BFile * file) 
{
	if (!BuildConstantsSave(file)) return false;
	int32 len = sizeof(width);
	if (!(file->Write(&width, len) == len)) return false;
	//len = sizeof(height);
	if (!(file->Write(&height, len) == len)) return false;
	//len = sizeof(depth);
	if (file->Write(&depth, len) == len) return true;
	return false;
}//end


bool Galaxy	::	Load(BFile * file) 
{
	if (!BuildConstantsLoad(file)) 
	{
		return false;
	}
	int32 len = sizeof(width);
	if (file->Read(&width, len) == len) 
	{
		//len = sizeof(height);
		if (file->Read(&height, len) == len) 
		{
			//len = sizeof(depth);
			if (file->Read(&depth, len) == len) 
			{
				return true;
			}
		}
	}
	warning(badFileLength);
	return false;
}//end


bool 
Galaxy	::	Copy(	Galaxy * fromItem) 
{
	if (name && fromItem->name) 
	{
		if (strcmp(name, fromItem->name)) 
		{
			if (name) 
			{
				free(name);
			}
			name = (char *)malloc(strlen(fromItem->name) + 1);
			if (name) strcpy(name, fromItem->name);
			else 
			{
				err = NO_NAME;
				warning(FailName);
				return false;
			}
		}
	}
	//debug must do object as well
	return true;
}//end
